/*
 * Decompiled with CFR 0.152.
 */
package FinaEracun;

import ConfigRelated.LoadIni;
import UTIL.EnhProperies;
import UTIL.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import fiskalizacija.HrFiskalizator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class FinaConfig {
    private static JsonObject providersConfig = null;
    private static UblSignatureProfile ublSigProfile = null;
    private static UblSignatureProfile ublSigProfileOverride = null;
    private static WsseSigAlg wsseSigAlgOverride = null;

    private static EnhProperies getGlobalProps() {
        try {
            return HrFiskalizator.p;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static boolean isTrue(String string) {
        return string != null && ("true".equalsIgnoreCase(string) || "1".equals(string) || "yes".equalsIgnoreCase(string));
    }

    private static String getProp(String string, String string2) {
        try {
            EnhProperies enhProperies = FinaConfig.getGlobalProps();
            if (enhProperies != null) {
                return enhProperies.getProperty(string, string2);
            }
            return string2;
        }
        catch (Exception exception) {
            return string2;
        }
    }

    private static void loadProvidersConfig() {
        if (providersConfig == null) {
            try {
                Object object;
                Object object2;
                try {
                    block16: {
                        block17: {
                            object2 = FinaConfig.class.getResourceAsStream("/FinaEracun/FinaProviders.json");
                            object = null;
                            try {
                                int n2;
                                if (object2 == null) break block16;
                                Object object3 = new ByteArrayOutputStream();
                                byte[] byArray = new byte[1024];
                                while ((n2 = ((InputStream)object2).read(byArray)) != -1) {
                                    ((ByteArrayOutputStream)object3).write(byArray, 0, n2);
                                }
                                object3 = new String(((ByteArrayOutputStream)object3).toByteArray(), StandardCharsets.UTF_8);
                                providersConfig = new Gson().fromJson((String)object3, JsonObject.class);
                                HrFiskalizator.logger.log(Level.INFO, "FINA providers configuration loaded from JAR");
                                if (object2 == null) break block17;
                            }
                            catch (Throwable throwable) {
                                try {
                                    Throwable throwable2 = throwable;
                                    object = throwable;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (object2 != null) {
                                        if (object != null) {
                                            try {
                                                ((InputStream)object2).close();
                                            }
                                            catch (Throwable throwable4) {
                                                ((Throwable)object).addSuppressed(throwable4);
                                            }
                                        } else {
                                            ((InputStream)object2).close();
                                        }
                                    }
                                    throw throwable3;
                                }
                            }
                            ((InputStream)object2).close();
                        }
                        return;
                    }
                    if (object2 != null) {
                        ((InputStream)object2).close();
                    }
                }
                catch (Exception exception) {}
                object2 = "fiskalizacija20/finaeracun/FinaProviders.json";
                object = new String(Files.readAllBytes(Paths.get((String)object2, new String[0])));
                providersConfig = new Gson().fromJson((String)object, JsonObject.class);
                HrFiskalizator.logger.log(Level.INFO, "FINA providers configuration loaded from filesystem");
                return;
            }
            catch (IOException iOException) {
                HrFiskalizator.logger.log(Level.SEVERE, "Failed to load FINA providers config", iOException);
            }
        }
    }

    public static boolean isDebugMode() {
        try {
            EnhProperies enhProperies = FinaConfig.getGlobalProps();
            return StringUtils.isValTrue(enhProperies.getProperty("DEBUGMODE", "True"));
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean isTemplatesOnly() {
        return true;
    }

    public static UblSignatureProfile getUblSignatureProfile() {
        if (ublSigProfileOverride != null) {
            return ublSigProfileOverride;
        }
        if (ublSigProfile != null) {
            return ublSigProfile;
        }
        String string = "XMLDSIG";
        try {
            String string2 = System.getProperty("FINA_UBL_SIGNATURE_PROFILE");
            String string3 = string = string2 != null && !string2.isEmpty() ? string2 : FinaConfig.getProp("FINA_UBL_SIGNATURE_PROFILE", string);
            ublSigProfile = "XADES_BES".equalsIgnoreCase(string) ? UblSignatureProfile.XADES_BES : UblSignatureProfile.XMLDSIG;
        }
        catch (Exception exception) {
            ublSigProfile = UblSignatureProfile.XMLDSIG;
        }
        return ublSigProfile;
    }

    public static void setUblSignatureProfileForTesting(UblSignatureProfile ublSignatureProfile) {
        ublSigProfileOverride = ublSignatureProfile;
    }

    public static WsseSigAlg getWsseSignatureAlg() {
        if (wsseSigAlgOverride != null) {
            return wsseSigAlgOverride;
        }
        String string = System.getProperty("FINA_WSSEC_SIGALG", "SHA1");
        if ("SHA256".equalsIgnoreCase(string)) {
            return WsseSigAlg.SHA256;
        }
        return WsseSigAlg.SHA1;
    }

    public static void setWsseSignatureAlgForTesting(WsseSigAlg wsseSigAlg) {
        wsseSigAlgOverride = wsseSigAlg;
    }

    public static boolean useStandardSoapSigner() {
        String string = System.getProperty("FINA_SOAP_USE_STANDARD_SIGNER", "false");
        return FinaConfig.isTrue(string);
    }

    public static ServiceType getDefaultServiceType() {
        String string = FinaConfig.getProp("FINASERVICETYPE", "B2G");
        if ("B2B".equalsIgnoreCase(string)) {
            return ServiceType.B2B;
        }
        return ServiceType.B2G;
    }

    private static JsonObject getServiceRoot(ServiceType object) {
        FinaConfig.loadProvidersConfig();
        if (providersConfig == null) {
            return null;
        }
        object = "FINA" + object.name();
        try {
            return providersConfig.getAsJsonObject((String)object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getIwscNamespace(ServiceType serviceType) {
        return FinaConfig.getNamespace(serviceType, "iwsc", "http://fina.hr/eracun/b2b/invoicewebservicecomponents/v0.1", "http://fina.hr/eracun/b2g/invoicewebservicecomponents/v0.1");
    }

    public static String getEchoNamespace(ServiceType serviceType) {
        return FinaConfig.getNamespace(serviceType, "echo", "http://fina.hr/eracun/b2b/pki/Echo/v0.1", "http://fina.hr/eracun/b2g/pki/Echo/v0.1");
    }

    public static String getGetReceiverListNamespace(ServiceType serviceType) {
        return FinaConfig.getNamespace(serviceType, "grl", "http://fina.hr/eracun/b2b/GetReceiverList/v0.1", "http://fina.hr/eracun/b2g/GetReceiverList/v0.1");
    }

    public static String getSendOutgoingInvoiceNamespace(ServiceType serviceType) {
        return FinaConfig.getNamespace(serviceType, "soi", "http://fina.hr/eracun/b2b/pki/SendB2BOutgoingInvoice/v0.1", "http://fina.hr/eracun/b2g/pki/SendB2GOutgoingInvoice/v0.1");
    }

    public static String getGetOutgoingInvoiceStatusNamespace(ServiceType serviceType) {
        return FinaConfig.getNamespace(serviceType, "status", "http://fina.hr/eracun/b2b/pki/GetB2BOutgoingInvoiceStatus/v0.1", "http://fina.hr/eracun/b2g/pki/GetB2GOutgoingInvoiceStatus/v0.1");
    }

    private static String getNamespace(ServiceType serviceType, String string, String string2, String string3) {
        JsonObject jsonObject = FinaConfig.getServiceRoot(serviceType);
        try {
            if (jsonObject != null && jsonObject.has("namespaces") && (jsonObject = jsonObject.getAsJsonObject("namespaces")) != null && jsonObject.has(string) && (string = jsonObject.get(string).getAsString()) != null && !string.isEmpty()) {
                return string;
            }
        }
        catch (Exception exception) {}
        if (serviceType == ServiceType.B2B) {
            return string2;
        }
        return string3;
    }

    private static String getMessageType(ServiceType object, String string, String string2) {
        FinaConfig.loadProvidersConfig();
        if (providersConfig == null) {
            return string2;
        }
        object = "FINA" + ((Enum)object).name();
        try {
            object = providersConfig.getAsJsonObject((String)object);
            if (object != null && ((JsonObject)object).has("messageTypes") && (object = ((JsonObject)object).getAsJsonObject("messageTypes")) != null && ((JsonObject)object).has(string)) {
                return ((JsonObject)object).get(string).getAsString();
            }
        }
        catch (Exception exception) {}
        return string2;
    }

    public static String getMessageTypeEcho(ServiceType serviceType) {
        return FinaConfig.getMessageType(serviceType, "echo", "9999");
    }

    public static String getMessageTypeGetReceiverList(ServiceType serviceType) {
        return FinaConfig.getMessageType(serviceType, "getReceiverList", "50041");
    }

    public static String getMessageTypeSend(ServiceType serviceType) {
        return FinaConfig.getMessageType(serviceType, "send", "9001");
    }

    public static String getMessageTypeGetStatus(ServiceType serviceType) {
        return FinaConfig.getMessageType(serviceType, "getStatus", serviceType == ServiceType.B2B ? "50021" : "50011");
    }

    public static String getEndpointAddress(ServiceType serviceType, Environment environment) {
        FinaConfig.loadProvidersConfig();
        if (providersConfig == null) {
            return null;
        }
        Object object = "FINA" + serviceType.name();
        String string = environment.name();
        try {
            object = providersConfig.getAsJsonObject((String)object);
            object = ((JsonObject)object).getAsJsonObject(string);
            return ((JsonObject)object).get("endpointAddress").getAsString();
        }
        catch (Exception exception) {
            HrFiskalizator.logger.log(Level.WARNING, "Failed to get endpoint for " + (Object)((Object)serviceType) + "/" + (Object)((Object)environment), exception);
            return null;
        }
    }

    public static String getDnsIdentity(ServiceType serviceType, Environment environment) {
        FinaConfig.loadProvidersConfig();
        if (providersConfig == null) {
            return null;
        }
        Object object = "FINA" + serviceType.name();
        String string = environment.name();
        try {
            object = providersConfig.getAsJsonObject((String)object);
            object = ((JsonObject)object).getAsJsonObject(string);
            return ((JsonObject)object).get("dnsIdentity").getAsString();
        }
        catch (Exception exception) {
            HrFiskalizator.logger.log(Level.WARNING, "Failed to get DNS identity for " + (Object)((Object)serviceType) + "/" + (Object)((Object)environment), exception);
            return null;
        }
    }

    public static Environment getCurrentEnvironment() {
        String string = FinaConfig.getProp("DEBUGMODE", "true");
        System.setProperty("FINA_DEBUG_SAVE_REQUEST", string);
        System.setProperty("FINA_DEBUG_SAVE_RESPONSE", string);
        if (FinaConfig.getProp("FINAERACUNISERVER", "Testni").equals("Produkcijski")) {
            return Environment.PRODUCTION;
        }
        return Environment.DEMO;
    }

    public static String getFinaCertificate() {
        Environment environment = FinaConfig.getCurrentEnvironment();
        if (environment == Environment.DEMO) {
            return FinaConfig.getProp("PRIVATEKEYFINAERACUNTESTNI", "78158722615.p12");
        }
        return FinaConfig.getProp("PRIVATEKEYFINAERACUN", "");
    }

    public static String getFinaCertPassword() {
        Environment environment = FinaConfig.getCurrentEnvironment();
        if (environment == Environment.DEMO) {
            return FinaConfig.getProp("LOZINKAKEYFINAERACUNTESTNI", "!ieracuni2024#");
        }
        return FinaConfig.getProp("LOZINKAKEYFINAERACUN", "");
    }

    public static String getP12Path() {
        return "D:\\PROJEKTI_NETBEANS\\HrFiskalizator\\certifikati\\78158722615.p12";
    }

    public static String getUserOib() {
        return FinaConfig.getProp("FINACLIENTOIB", "");
    }

    public static String getJksPassword() {
        return FinaConfig.getProp("LOZINKAJKS", "changeme");
    }

    public static String getEracunServerMode() {
        return FinaConfig.getProp("FINARACUNISERVER", "Testni");
    }

    public static boolean isEracunTest() {
        String string = FinaConfig.getEracunServerMode();
        return string != null && string.equalsIgnoreCase("Testni");
    }

    public static String getSigningAlias() {
        String string = FinaConfig.isEracunTest() ? FinaConfig.getProp("PRIVATEKEYFINAERACUNTESTNI", "") : FinaConfig.getProp("PRIVATEKEYFINAERACUN", "");
        if (string == null || string.isEmpty()) {
            string = FinaConfig.getFinaCertificate();
        }
        return string;
    }

    public static String getSigningKeyPassword() {
        String string = FinaConfig.isEracunTest() ? FinaConfig.getProp("LOZINKAKEYFINAERACUNTESTNI", "") : FinaConfig.getProp("LOZINKAKEYFINAERACUN", "");
        if (string == null || string.isEmpty()) {
            string = FinaConfig.getFinaCertPassword();
        }
        return string;
    }

    public static String getServerCertAlias() {
        String string = FinaConfig.isEracunTest() ? "e-invoice.cer" : "e-ra\u010dun.cer";
        return string;
    }

    private static Set<String> parseListProp(String stringArray) {
        stringArray = FinaConfig.getProp((String)stringArray, "");
        HashSet<String> hashSet = new HashSet<String>();
        if (stringArray == null || stringArray.trim().isEmpty()) {
            return hashSet;
        }
        for (String string : stringArray.split("[;,]\\s*")) {
            if ((string = string.trim()).isEmpty()) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public static Set<String> getTrustOnlyAliases() {
        return FinaConfig.parseListProp("FINA_TRUST_ONLY");
    }

    public static Set<String> getTrustBlockAliases() {
        return FinaConfig.parseListProp("FINA_TRUST_BLOCK");
    }

    public static boolean testConfiguration() {
        try {
            FinaConfig.loadProvidersConfig();
            if (providersConfig == null) {
                HrFiskalizator.logger.log(Level.SEVERE, "FINA providers config not loaded");
                return false;
            }
            String string = FinaConfig.getEndpointAddress(ServiceType.B2G, FinaConfig.getCurrentEnvironment());
            String string2 = FinaConfig.getEndpointAddress(ServiceType.B2B, FinaConfig.getCurrentEnvironment());
            if (string == null || string2 == null) {
                HrFiskalizator.logger.log(Level.SEVERE, "FINA endpoints not configured properly");
                return false;
            }
            string = FinaConfig.getFinaCertificate();
            string2 = FinaConfig.getFinaCertPassword();
            if (string == null || string.isEmpty() || string2 == null || string2.isEmpty()) {
                HrFiskalizator.logger.log(Level.SEVERE, "FINA certificate not configured properly");
                return false;
            }
            if (!FinaConfig.templateExists("fiskalizacija20/finaeracun/templates/EchoMsg.xml", "")) {
                HrFiskalizator.logger.log(Level.SEVERE, "Missing template: EchoMsg.xml");
                return false;
            }
            if (!FinaConfig.templateExists("fiskalizacija20/finaeracun/templates/GetReceiverListMsg.xml", "")) {
                HrFiskalizator.logger.log(Level.SEVERE, "Missing template: GetReceiverListMsg.xml");
                return false;
            }
            if (!FinaConfig.templateExists("fiskalizacija20/finaeracun/templates/SendOutgoingInvoiceMsg.xml", "")) {
                HrFiskalizator.logger.log(Level.SEVERE, "Missing template: SendOutgoingInvoiceMsg.xml");
                return false;
            }
            if (!FinaConfig.templateExists("fiskalizacija20/finaeracun/templates/GetOutgoingInvoiceStatusMsg.xml", "")) {
                HrFiskalizator.logger.log(Level.SEVERE, "Missing template: GetOutgoingInvoiceStatusMsg.xml");
                return false;
            }
            HrFiskalizator.logger.log(Level.INFO, "FINA configuration test passed");
            return true;
        }
        catch (Exception exception) {
            HrFiskalizator.logger.log(Level.SEVERE, "FINA configuration test failed", exception);
            return false;
        }
    }

    private static boolean templateExists(String object, String string) {
        block7: {
            try {
                object = FinaConfig.class.getResourceAsStream((String)object);
                if (object == null) break block7;
                if (object != null) {
                    ((InputStream)object).close();
                }
                return true;
            }
            catch (Exception exception) {}
        }
        if (object != null) {
            ((InputStream)object).close();
        }
        try {
            return Files.exists(Paths.get(string, new String[0]), new LinkOption[0]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static EnhProperies loadConfigFromIni() {
        return FinaConfig.loadConfigFromIni("HrFiskalizator.ini");
    }

    public static EnhProperies loadConfigFromIni(String string) {
        try {
            EnhProperies enhProperies = new LoadIni(string, 2).run("UTF-8");
            if (enhProperies != null && !enhProperies.isEmpty()) {
                HrFiskalizator.p = enhProperies;
                HrFiskalizator.logger.log(Level.INFO, "INI loaded: {0} ({1} keys)", new Object[]{string, enhProperies.size()});
                return enhProperies;
            }
            HrFiskalizator.logger.log(Level.WARNING, "INI not loaded or empty: {0}", string);
            return enhProperies;
        }
        catch (Exception exception) {
            HrFiskalizator.logger.log(Level.SEVERE, "Failed to load INI: " + string, exception);
            return null;
        }
    }

    public static enum WsseSigAlg {
        SHA1,
        SHA256;

    }

    public static enum UblSignatureProfile {
        XADES_BES,
        XMLDSIG;

    }

    public static enum Environment {
        DEMO,
        PRODUCTION;

    }

    public static enum ServiceType {
        B2G,
        B2B;

    }
}

