/*
 * Decompiled with CFR 0.152.
 */
package FinaEracun;

import FinaEracun.FinaAckParser;
import FinaEracun.FinaConfig;
import FinaEracun.FinaEchoCreator;
import FinaEracun.FinaHandler;
import FinaEracun.FinaSoapClient;
import FinaEracun.XmlDsigEnveloped;
import UTIL.EnhProperies;
import UTIL.XMLrelated;
import fiskalizacija.HrFiskalizator;
import fiskalizacija.SysUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FinaEracuni {
    public boolean returnOnly = false;
    public FinaConfig.ServiceType serviceType = FinaConfig.ServiceType.B2G;
    public FinaConfig.Environment environment = FinaConfig.getCurrentEnvironment();
    public EnhProperies p = null;
    public String GetReceiverListsearchField = "ALL";
    public String GetReceiverListsearchValue = "ALL";
    private FinaSoapClient soapClient = new FinaSoapClient();
    private String lastResponse = "";
    private String lastError = "";

    public static void main(String[] stringArray) {
        SysUtil.vdevout("FinaEracuni library loaded. Use Send(action, content) from application code.");
    }

    private static String readFile(String object) {
        StringBuilder stringBuilder = new StringBuilder();
        object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((String)object), StandardCharsets.UTF_8));
        Throwable throwable = null;
        try {
            String string;
            while ((string = ((BufferedReader)object).readLine()) != null) {
                stringBuilder.append(string).append("\n");
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (throwable != null) {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    ((BufferedReader)object).close();
                }
                throw throwable4;
            }
        }
        ((BufferedReader)object).close();
        return stringBuilder.toString();
    }

    private static Document parseXml(String string) {
        return XMLrelated.parseXml(string);
    }

    private static boolean isSoapEnvelope(Document document) {
        return XMLrelated.isSoapEnvelope(document);
    }

    private static Element findSoapBodyFirstChild(Document document) {
        return XMLrelated.findSoapBodyFirstChild(document);
    }

    private static String mapSoapAction(String string, String string2) {
        string = string != null && string.contains("/b2b/") ? "b2b" : "b2g";
        int n2 = -1;
        switch (string2.hashCode()) {
            case -253038852: {
                if (!string2.equals("EchoMsg")) break;
                n2 = 0;
                break;
            }
            case -670115059: {
                if (!string2.equals("Invoice")) break;
                n2 = 1;
                break;
            }
            case 1428981419: {
                if (!string2.equals("CreditNote")) break;
                n2 = 2;
                break;
            }
            case 53367151: {
                if (!string2.equals("SendB2GOutgoingInvoiceMsg")) break;
                n2 = 3;
                break;
            }
            case -19240790: {
                if (!string2.equals("SendB2BOutgoingInvoiceMsg")) break;
                n2 = 4;
                break;
            }
            case 1601987919: {
                if (!string2.equals("GetB2GOutgoingInvoiceStatusMsg")) break;
                n2 = 5;
                break;
            }
            case -896867254: {
                if (!string2.equals("GetB2BOutgoingInvoiceStatusMsg")) break;
                n2 = 6;
                break;
            }
            case -1826925826: {
                if (!string2.equals("GetReceiverListMsg")) break;
                n2 = 7;
            }
        }
        switch (n2) {
            case 0: {
                string2 = "Echo";
                break;
            }
            case 1: 
            case 2: {
                string2 = "b2b".equals(string) ? "SendB2BOutgoingInvoice" : "SendB2GOutgoingInvoice";
                break;
            }
            case 3: {
                string2 = "SendB2GOutgoingInvoice";
                break;
            }
            case 4: {
                string2 = "SendB2BOutgoingInvoice";
                break;
            }
            case 5: {
                string2 = "GetB2GOutgoingInvoiceStatus";
                break;
            }
            case 6: {
                string2 = "GetB2BOutgoingInvoiceStatus";
                break;
            }
            case 7: {
                string2 = "GetReceiverList";
                break;
            }
            default: {
                return null;
            }
        }
        return "http://fina.hr/eracun/" + string + "/" + string2;
    }

    private static String wrapInSoapEnvelope(String string) {
        string = string == null ? "" : string.replace("\ufeff", "");
        string = XMLrelated.removeXmlRemarks(string);
        string = string.replaceFirst("(?s)^\\s*<\\?xml[^>]*\\?>", "").trim();
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">\n  <soapenv:Header></soapenv:Header>\n  <soapenv:Body>\n" + string + "\n  </soapenv:Body>\n</soapenv:Envelope>\n";
    }

    private static void assertNoPlaceholders(String string, String string2) {
        if (string == null) {
            return;
        }
        if (string.contains("${")) {
            throw new IllegalStateException("Unresolved template placeholders detected in " + string2 + ". Please ensure all variables are replaced.");
        }
    }

    private static boolean isErrorResponse(String string) {
        return string != null && string.startsWith("ERROR:");
    }

    public String Send(String string, String string2) {
        try {
            this.clearLastResults();
            if (string == null || string.trim().isEmpty()) {
                return this.handleError("Action is required");
            }
            if (!FinaConfig.testConfiguration()) {
                return this.handleError("FINA configuration test failed");
            }
            switch (string.toUpperCase()) {
                case "ECHO": {
                    return this.handleEcho();
                }
                case "SENDINVOICE": 
                case "SENDRACUN": {
                    return this.signAndSendInvoice(string2);
                }
                case "GETINVOICESTATUS": 
                case "STATUSRACUNA": {
                    return this.handleGetInvoiceStatus(string2);
                }
                case "GETRECEIVERLIST": 
                case "LISTAPRIMATELJA": {
                    return this.handleGetReceiverList();
                }
            }
            return this.handleError("Unknown action: " + string);
        }
        catch (Exception exception) {
            HrFiskalizator.logger.log(Level.SEVERE, "FINA service error", exception);
            return this.handleError("Service error: " + exception.getMessage());
        }
    }

    private String handleEcho() {
        try {
            HrFiskalizator.logger.log(Level.INFO, "FINA Echo test started for " + (Object)((Object)this.serviceType) + "/" + (Object)((Object)this.environment));
            String string = FinaConfig.getEndpointAddress(this.serviceType, this.environment);
            if (string == null) {
                return this.handleError("Endpoint not configured for " + (Object)((Object)this.serviceType) + "/" + (Object)((Object)this.environment));
            }
            Object object = new FinaEchoCreator("fiskalizacija20/finaeracun/templates/EchoMsg.xml");
            object = ((FinaEchoCreator)object).buildEchoSoap(FinaConfig.getUserOib(), "Hello world @ " + new Date(), this.serviceType);
            if (this.returnOnly) {
                HrFiskalizator.logger.log(Level.INFO, "FINA returnOnly mode - returning unsigned Echo SOAP");
                return object;
            }
            String string2 = "http://fina.hr/eracun/" + (this.serviceType == FinaConfig.ServiceType.B2B ? "b2b" : "b2g") + "/Echo";
            FinaEracuni.assertNoPlaceholders((String)object, "Echo SOAP");
            string = this.soapClient.signAndSend(string, string2, (String)object);
            if (string != null && !string.isEmpty() && !FinaEracuni.isErrorResponse(string)) {
                this.lastResponse = string;
                HrFiskalizator.logger.log(Level.INFO, "FINA Echo successful");
                return string;
            }
            return this.handleError(FinaEracuni.isErrorResponse(string) ? string : "Echo failed - no response");
        }
        catch (Exception exception) {
            HrFiskalizator.logger.log(Level.SEVERE, "FINA Echo failed", exception);
            return this.handleError("Echo error: " + exception.getMessage());
        }
    }

    private String signAndSendInvoice(String object) {
        try {
            KeyStore keyStore = FinaHandler.FKS;
            String string = FinaConfig.getSigningAlias();
            if (string == null || string.isEmpty() || !keyStore.isKeyEntry(string)) {
                throw new RuntimeException("Configured signing alias '" + string + "' not found in JKS keystore");
            }
            PrivateKey privateKey = null;
            X509Certificate x509Certificate = null;
            Object object2 = FinaConfig.getFinaCertPassword().toCharArray();
            try {
                Key key = keyStore.getKey(string, (char[])object2);
                object2 = key;
                if (key instanceof PrivateKey) {
                    privateKey = (PrivateKey)object2;
                    x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                }
            }
            catch (Exception exception) {
                HrFiskalizator.logger.log(Level.SEVERE, "Error extracting private key from JKS for alias '" + string + "'", exception);
            }
            if (privateKey == null) {
                throw new RuntimeException("Cannot extract private key for alias '" + string + "' from JKS (P12 container)");
            }
            if (x509Certificate == null) {
                x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            }
            SysUtil.vdevout("[Runner] Certificate subject: " + (x509Certificate != null ? x509Certificate.getSubjectDN().getName() : "null"));
            SysUtil.vdevout("[Runner] Signing invoice with keystore alias: " + string);
            XmlDsigEnveloped xmlDsigEnveloped = new XmlDsigEnveloped(privateKey, x509Certificate);
            object2 = xmlDsigEnveloped;
            object = xmlDsigEnveloped.sign(((String)object).getBytes(StandardCharsets.UTF_8));
            FinaEracuni.saveToFile("IZLAZNIXML/Generated_Invoice_XMLDSIG.xml", new String((byte[])object, StandardCharsets.UTF_8));
            SysUtil.vdevout("[Local] XMLDSIG signature valid? " + FinaEracuni.validateSignature((byte[])object));
            return this.handleSendInvoice(new String((byte[])object, StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            HrFiskalizator.logger.log(Level.SEVERE, null, exception);
            return exception.getMessage();
        }
    }

    private String handleSendInvoice(String string) {
        try {
            String string2;
            Object object;
            Object object2;
            Object object3;
            HrFiskalizator.logger.log(Level.INFO, "FINA SendInvoice started for " + (Object)((Object)this.serviceType));
            try {
                string = FinaEracuni.addUuidIfMissing(string);
            }
            catch (Exception exception) {
                HrFiskalizator.logger.log(Level.WARNING, "Skipping UUID enrichment: " + exception.getMessage());
            }
            Object object4 = FinaEracuni.parseXml(string);
            if (object4 == null) {
                return this.handleError("Cannot parse invoice XML");
            }
            boolean bl2 = FinaEracuni.isSoapEnvelope((Document)object4);
            if ((object4 = bl2 ? FinaEracuni.findSoapBodyFirstChild((Document)object4) : object4.getDocumentElement()) == null) {
                return this.handleError("Cannot locate SOAP Body content element in invoice");
            }
            Object object5 = object4.getNamespaceURI() != null ? object4.getNamespaceURI() : "";
            object4 = object4.getLocalName() != null ? object4.getLocalName() : object4.getNodeName();
            String string3 = string;
            if (!bl2 && ("urn:oasis:names:specification:ubl:schema:xsd:Invoice-2".equals(object5) && "Invoice".equals(object4) || "urn:oasis:names:specification:ubl:schema:xsd:CreditNote-2".equals(object5) && "CreditNote".equals(object4))) {
                string3 = FinaEracuni.buildSendOutgoingInvoiceFromUBL(string, this.serviceType);
                object3 = this.getServiceType();
                object2 = FinaConfig.getSendOutgoingInvoiceNamespace((FinaConfig.ServiceType)((Object)object3));
                object = object3 == FinaConfig.ServiceType.B2B ? "SendB2BOutgoingInvoiceMsg" : "SendB2GOutgoingInvoiceMsg";
                object5 = object2;
                object4 = object;
            }
            if (bl2) {
                string2 = string;
            } else {
                object2 = FinaEracuni.parseXml(string3);
                boolean bl3 = object2 != null && FinaEracuni.isSoapEnvelope((Document)object2);
                string2 = bl3 ? string3 : FinaEracuni.wrapInSoapEnvelope(string3);
            }
            object3 = string2;
            object2 = FinaEracuni.mapSoapAction((String)object5, (String)object4);
            if (object2 == null) {
                return this.handleError("Cannot map SOAPAction for message: {" + (String)object5 + "}" + (String)object4);
            }
            if (this.returnOnly) {
                HrFiskalizator.logger.log(Level.INFO, "FINA returnOnly mode - returning unsigned SOAP for invoice");
                return object3;
            }
            FinaEracuni.assertNoPlaceholders(object3, "SendInvoice SOAP");
            object = this.serviceType != null ? this.serviceType : FinaConfig.getDefaultServiceType();
            string = FinaConfig.getEndpointAddress(object, this.environment);
            if (string == null) {
                return this.handleError("Endpoint not configured for " + (Object)object + "/" + (Object)((Object)this.environment));
            }
            if ((string = this.soapClient.signAndSend(string, (String)object2, (String)object3)) != null) {
                this.lastResponse = string;
                try {
                    object4 = FinaAckParser.parse(string);
                    if (object4 != null) {
                        SysUtil.vdevout("[Ack] " + ((FinaAckParser.AckInfo)object4).toString());
                    }
                }
                catch (Exception exception) {}
                HrFiskalizator.logger.log(Level.INFO, "FINA SendInvoice successful");
                return string;
            }
            return this.handleError("SendInvoice failed - no response");
        }
        catch (Exception exception) {
            HrFiskalizator.logger.log(Level.SEVERE, "FINA SendInvoice failed", exception);
            return this.handleError("SendInvoice error: " + exception.getMessage());
        }
    }

    private static void saveToFile(String string, String string2) {
        try {
            Path path = Paths.get(string, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, string2.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return;
        }
        catch (Exception exception) {
            System.err.println("WARN: cannot save to " + string + ": " + exception.getMessage());
            return;
        }
    }

    private static boolean validateSignature(byte[] object) {
        try {
            Object object2;
            Object object3 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object3).setNamespaceAware(true);
            Document document = ((DocumentBuilderFactory)object3).newDocumentBuilder().parse(new ByteArrayInputStream((byte[])object));
            object = document;
            object3 = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (object3 == null || object3.getLength() == 0) {
                return false;
            }
            object = object.getElementsByTagName("*");
            for (int i2 = 0; i2 < object.getLength(); ++i2) {
                object2 = (Element)object.item(i2);
                if (!object2.hasAttribute("Id")) continue;
                try {
                    object2.setIdAttribute("Id", true);
                    continue;
                }
                catch (Exception exception) {}
            }
            XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM");
            object = xMLSignatureFactory.unmarshalXMLSignature((XMLValidateContext)(object2 = new DOMValidateContext(new KeySelector(){

                @Override
                public final KeySelectorResult select(KeyInfo object, KeySelector.Purpose iterator, AlgorithmMethod algorithmMethod2, XMLCryptoContext xMLCryptoContext) {
                    try {
                        object = object.getContent().iterator();
                        while (object.hasNext()) {
                            iterator = object.next();
                            if (!(iterator instanceof XMLStructure) || !((iterator = (XMLStructure)((Object)iterator)) instanceof X509Data)) continue;
                            iterator = (X509Data)((Object)iterator);
                            for (AlgorithmMethod algorithmMethod2 : iterator.getContent()) {
                                if (!(algorithmMethod2 instanceof X509Certificate)) continue;
                                object = ((X509Certificate)((Object)algorithmMethod2)).getPublicKey();
                                return () -> 1.lambda$select$0((PublicKey)object);
                            }
                        }
                    }
                    catch (Exception exception) {}
                    return null;
                }

                private static /* synthetic */ Key lambda$select$0(PublicKey publicKey) {
                    return publicKey;
                }
            }, object3.item(0))));
            boolean bl2 = object.validate((XMLValidateContext)object2);
            if (!bl2) {
                try {
                    object = object.getSignedInfo();
                    for (int i3 = 0; i3 < object.getReferences().size(); ++i3) {
                        Reference reference = object.getReferences().get(i3);
                        boolean bl3 = reference.validate((XMLValidateContext)object2);
                        SysUtil.vdevout("[Local] Ref[" + i3 + "] uri=" + reference.getURI() + " valid? " + bl3);
                    }
                }
                catch (Exception exception) {}
            }
            return bl2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String addUuidIfMissing(String string) {
        Document document = FinaEracuni.parseXml(string);
        if (document == null) {
            return string;
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            return string;
        }
        Object object = "urn:oasis:names:specification:ubl:schema:xsd:Invoice-2";
        String string2 = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2";
        if (!"Invoice".equals(element.getLocalName()) || !((String)object).equals(element.getNamespaceURI())) {
            return string;
        }
        try {
            if (document.getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonSignatureComponents-2", "UBLDocumentSignatures").getLength() > 0) {
                return string;
            }
            if (document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").getLength() > 0) {
                return string;
            }
        }
        catch (Exception exception) {}
        if (document.getElementsByTagNameNS(string2, "UUID").getLength() > 0) {
            return string;
        }
        object = document.createElementNS(string2, "cbc:UUID");
        object.setTextContent(UUID.randomUUID().toString());
        Element element2 = null;
        Node node = null;
        for (Node node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Element element3;
            if (node2.getNodeType() != 1 || !string2.equals((element3 = (Element)node2).getNamespaceURI())) continue;
            String string3 = element3.getLocalName();
            if ("IssueDate".equals(string3)) {
                element2 = element3;
                break;
            }
            if (!"ID".equals(string3)) continue;
            node = element3;
        }
        if (element2 != null) {
            element.insertBefore((Node)object, element2);
        } else if (node != null) {
            element.insertBefore((Node)object, node.getNextSibling());
        } else {
            element.appendChild((Node)object);
        }
        try {
            return XMLrelated.serializeDocument(document);
        }
        catch (Exception exception) {
            return string;
        }
    }

    private static String buildSendOutgoingInvoiceFromUBL(String string, FinaConfig.ServiceType object) {
        String string2;
        Object object2;
        Object object3;
        boolean bl2;
        Object object4 = FinaEracuni.parseXml(string);
        if (object4 == null) {
            return string;
        }
        Element element = object4.getDocumentElement();
        if (element == null) {
            return string;
        }
        Object object5 = "urn:oasis:names:specification:ubl:schema:xsd:Invoice-2";
        Object object6 = "urn:oasis:names:specification:ubl:schema:xsd:CreditNote-2";
        String string3 = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2";
        Object object7 = "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2";
        Object object8 = element.getNamespaceURI();
        final boolean bl3 = ((String)object5).equals(object8) && "Invoice".equals(element.getLocalName());
        boolean bl4 = bl2 = ((String)object6).equals(object8) && "CreditNote".equals(element.getLocalName());
        if (!bl3 && !bl2) {
            return string;
        }
        if (bl2) {
            bl2 = true;
            try {
                object8 = HrFiskalizator.p;
                object3 = object8 != null ? ((Properties)object8).getProperty("FINA_CREDITNOTE_AS_INVOICE381", "true") : "true";
                bl2 = "true".equalsIgnoreCase((String)object3) || "1".equals(object3);
            }
            catch (Exception exception) {}
            if (bl2) {
                try {
                    object4 = FinaEracuni.convertCreditNoteToInvoice((Document)object4);
                    Element element2 = object4.getDocumentElement();
                    object8 = element2.getNamespaceURI();
                    bl3 = ((String)object5).equals(object8) && "Invoice".equals(element2.getLocalName());
                }
                catch (Exception exception) {}
            }
        }
        String string4 = null;
        try {
            object8 = XPathFactory.newInstance();
            object3 = ((XPathFactory)object8).newXPath();
            object3.setNamespaceContext(new NamespaceContext((String)object5, (String)object6){
                final /* synthetic */ String val$fInvNS;
                final /* synthetic */ String val$fCnNS;
                {
                    this.val$fInvNS = string;
                    this.val$fCnNS = string2;
                }

                @Override
                public final String getNamespaceURI(String string) {
                    if ("doc".equals(string)) {
                        if (bl3) {
                            return this.val$fInvNS;
                        }
                        return this.val$fCnNS;
                    }
                    if ("cbc".equals(string)) {
                        return "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2";
                    }
                    return "";
                }

                @Override
                public final String getPrefix(String string) {
                    return null;
                }

                public final Iterator getPrefixes(String string) {
                    return null;
                }
            });
            object2 = bl3 ? "/doc:Invoice/cbc:ID" : "/doc:CreditNote/cbc:ID";
            object5 = (Node)object3.evaluate((String)object2, object4, XPathConstants.NODE);
            if (object5 != null) {
                string4 = object5.getTextContent();
            }
        }
        catch (Exception exception) {}
        object8 = null;
        try {
            object3 = XPathFactory.newInstance();
            XPath xPath = ((XPathFactory)object3).newXPath();
            xPath.setNamespaceContext(new NamespaceContext(){

                @Override
                public final String getNamespaceURI(String string) {
                    if ("cac".equals(string)) {
                        return "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2";
                    }
                    if ("cbc".equals(string)) {
                        return "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2";
                    }
                    return "";
                }

                @Override
                public final String getPrefix(String string) {
                    return null;
                }

                public final Iterator getPrefixes(String string) {
                    return null;
                }
            });
            object5 = "//cac:AccountingCustomerParty//cbc:EndpointID[@schemeID='9934']";
            object6 = (Node)xPath.evaluate((String)object5, object4, XPathConstants.NODE);
            if (object6 != null && (object2 = object6.getTextContent()) != null && !((String)object2).trim().isEmpty()) {
                object8 = ((String)object2).trim();
            }
            if ((object8 == null || ((String)object8).isEmpty()) && (object5 = (Node)xPath.evaluate((String)(object2 = "//cac:AccountingCustomerParty//cac:PartyIdentification/cbc:ID"), object4, XPathConstants.NODE)) != null && (object3 = object5.getTextContent()) != null && !((String)object3).trim().isEmpty()) {
                object8 = ((String)object3).trim();
            }
            if ((object8 == null || ((String)object8).isEmpty()) && (object5 = (Node)xPath.evaluate((String)(object2 = "//cac:AccountingCustomerParty//cac:PartyTaxScheme/cbc:CompanyID"), object4, XPathConstants.NODE)) != null && (object3 = object5.getTextContent()) != null && !((String)object3).trim().isEmpty()) {
                object8 = ((String)object3).trim();
            }
        }
        catch (Exception exception) {}
        if (object8 != null) {
            object3 = ((String)object8).trim();
            Matcher matcher = Pattern.compile("^HR(\\d{11})$").matcher((CharSequence)object3);
            object5 = Pattern.compile("^9934:\\s*(\\d{11})$").matcher((CharSequence)object3);
            object6 = Pattern.compile("^(\\d{11})$").matcher((CharSequence)object3);
            if (matcher.find()) {
                object8 = "9934:" + matcher.group(1);
            } else if (((Matcher)object5).find()) {
                object8 = "9934:" + ((Matcher)object5).group(1);
            } else if (((Matcher)object6).find()) {
                object8 = "9934:" + ((Matcher)object6).group(1);
            }
        }
        if (object8 == null || ((String)object8).isEmpty()) {
            try {
                object3 = HrFiskalizator.p;
                String string5 = object3 != null ? ((Properties)object3).getProperty("FINA_DEFAULT_BUYER_OIB", "") : "";
                if (string5 != null && !string5.trim().isEmpty()) {
                    object5 = string5.trim();
                    object6 = Pattern.compile("^HR(\\d{11})$").matcher((CharSequence)object5);
                    object2 = Pattern.compile("^(\\d{11})$").matcher((CharSequence)object5);
                    object8 = ((Matcher)object6).find() ? "9934:" + ((Matcher)object6).group(1) : (((Matcher)object2).find() ? "9934:" + ((Matcher)object2).group(1) : (!((String)object5).startsWith("9934:") ? "9934:" + (String)object5 : object5));
                }
            }
            catch (Exception exception) {}
        }
        if (object8 == null || ((String)object8).isEmpty()) {
            object8 = "9934:00000000000";
        }
        try {
            NodeList nodeList = object4.getElementsByTagNameNS((String)object7, "AccountingCustomerParty");
            if (nodeList != null && nodeList.getLength() > 0) {
                object5 = (Element)nodeList.item(0);
                object6 = object5.getElementsByTagNameNS((String)object7, "PartyIdentification");
                for (int i2 = 0; i2 < object6.getLength() && ((object3 = (object5 = (Element)object6.item(i2)).getElementsByTagNameNS(string3, "ID")) == null || object3.getLength() <= 0 || (object7 = object3.item(0).getTextContent()) == null || ((String)object7).trim().isEmpty() || (string2 = object8 != null ? ((String)object8).replaceFirst("^9934:\\s*", "").trim() : null) != null && ((String)object7).trim().equals(string2)); ++i2) {
                }
            }
        }
        catch (Exception exception) {}
        String string6 = null;
        try {
            object5 = XPathFactory.newInstance();
            object6 = ((XPathFactory)object5).newXPath();
            object6.setNamespaceContext(new NamespaceContext(){

                @Override
                public final String getNamespaceURI(String string) {
                    if ("cac".equals(string)) {
                        return "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2";
                    }
                    if ("cbc".equals(string)) {
                        return "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2";
                    }
                    return "";
                }

                @Override
                public final String getPrefix(String string) {
                    return null;
                }

                public final Iterator getPrefixes(String string) {
                    return null;
                }
            });
            String string7 = "//cac:AccountingSupplierParty//cbc:EndpointID[@schemeID='9934']";
            object5 = (Node)object6.evaluate(string7, object4, XPathConstants.NODE);
            if (object5 != null && (object3 = object5.getTextContent()) != null && !((String)object3).trim().isEmpty()) {
                string6 = "9934:" + ((String)object3).trim();
            }
            if (string6 == null && (object7 = (Node)object6.evaluate((String)(object3 = "//cac:AccountingSupplierParty//cac:PartyIdentification/cbc:ID"), object4, XPathConstants.NODE)) != null && (string2 = object7.getTextContent()) != null && !string2.trim().isEmpty()) {
                string6 = string2.trim().startsWith("9934:") ? string2.trim() : "9934:" + string2.trim();
            }
        }
        catch (Exception exception) {}
        if (string6 == null) {
            try {
                object5 = null;
                object6 = HrFiskalizator.p;
                if (object6 != null) {
                    object5 = FinaConfig.getUserOib();
                }
                if (object5 != null && !((String)object5).trim().isEmpty()) {
                    string6 = "9934:" + ((String)object5).trim();
                }
            }
            catch (Exception exception) {}
        }
        if (string6 == null) {
            string6 = "9934:00000000000";
        }
        try {
            object5 = XMLrelated.serializeDocument((Document)object4);
        }
        catch (Exception exception) {
            object5 = string;
        }
        byte[] byArray = ((String)object5).getBytes(StandardCharsets.UTF_8);
        object6 = byArray;
        Object object9 = FinaEracuni.ensureUblSigned(byArray);
        object5 = Base64.getEncoder().encodeToString((byte[])(object9 != null ? object9 : (byte[])object6));
        object3 = UUID.randomUUID().toString();
        object7 = object;
        string2 = "urn:cen.eu:en16931:2017";
        string = FinaConfig.getSendOutgoingInvoiceNamespace((FinaConfig.ServiceType)((Object)object7));
        object = FinaConfig.getIwscNamespace((FinaConfig.ServiceType)((Object)object7));
        object4 = object7 == FinaConfig.ServiceType.B2B ? "SendB2BOutgoingInvoiceMsg" : "SendB2GOutgoingInvoiceMsg";
        object6 = object7 == FinaConfig.ServiceType.B2B ? "B2BOutgoingInvoiceEnvelope" : "B2GOutgoingInvoiceEnvelope";
        string3 = FinaEracuni.readFile("fiskalizacija20/finaeracun/templates/SendOutgoingInvoiceMsg.xml");
        if (string3 != null && !string3.trim().isEmpty()) {
            string4 = string4 != null ? "<soi:SupplierInvoiceID>" + FinaEracuni.escapeXml(string4) + "</soi:SupplierInvoiceID>" : "";
            object8 = "<soi:BuyerID>" + FinaEracuni.escapeXml((String)object8) + "</soi:BuyerID>";
            object9 = "";
            object7 = FinaConfig.getMessageTypeSend((FinaConfig.ServiceType)((Object)object7));
            return string3.replace("${SOI_NS}", string).replace("${IWSC_NS}", (CharSequence)object).replace("${MSG_ROOT}", (CharSequence)object4).replace("${ENVELOPE_ELEM}", (CharSequence)object6).replace("${MESSAGE_ID}", FinaEracuni.escapeXml((String)object3)).replace("${SUPPLIER_ID}", FinaEracuni.escapeXml(string6)).replace("${MESSAGE_TYPE}", (CharSequence)object7).replace("${SPEC_ID}", string2).replace("${SUPPLIER_INVOICE_ID_ELEM}", string4).replace("${BUYER_ID_ELEM}", (CharSequence)object8).replace("${ADDITIONAL_BUYER_ID_ELEM}", (CharSequence)object9).replace("${INVOICE_BASE64}", (CharSequence)object5);
        }
        throw new RuntimeException("Template SendOutgoingInvoiceMsg.xml not found (template-only mode)");
    }

    private static Document convertCreditNoteToInvoice(Document document) {
        Object object;
        Object object2;
        Node node;
        Object object3;
        Object object4;
        if (document == null) {
            return null;
        }
        Object object5 = document.getDocumentElement();
        if (object5 == null || !"urn:oasis:names:specification:ubl:schema:xsd:CreditNote-2".equals(object5.getNamespaceURI()) || !"CreditNote".equals(object5.getLocalName())) {
            return document;
        }
        document.renameNode((Node)object5, "urn:oasis:names:specification:ubl:schema:xsd:Invoice-2", "Invoice");
        try {
            object4 = object5.getAttributes();
            object3 = new ArrayList<Attr>();
            for (int i2 = 0; i2 < object4.getLength(); ++i2) {
                node = object4.item(i2);
                if (!"http://www.w3.org/2000/xmlns/".equals(node.getNamespaceURI())) continue;
                object3.add((Attr)node);
            }
            object2 = object3.iterator();
            while (object2.hasNext()) {
                node = (Attr)object2.next();
                object5.removeAttributeNode((Attr)node);
            }
            object5.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:specification:ubl:schema:xsd:Invoice-2");
        }
        catch (Exception exception) {}
        if (!object5.hasAttribute("xmlns:cbc")) {
            object5.setAttribute("xmlns:cbc", "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2");
        }
        if (!object5.hasAttribute("xmlns:cac")) {
            object5.setAttribute("xmlns:cac", "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2");
        }
        if ((object4 = document.getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "CreditNoteTypeCode")) != null && object4.getLength() > 0) {
            for (int i3 = 0; i3 < object4.getLength(); ++i3) {
                object2 = (Element)object4.item(i3);
                document.renameNode((Node)object2, "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "InvoiceTypeCode");
            }
        } else {
            object3 = document.createElementNS("urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "cbc:InvoiceTypeCode");
            object3.setTextContent("381");
            object2 = null;
            for (node = object5.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1 || !"urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2".equals((object4 = (Element)node).getNamespaceURI())) continue;
                object = object4.getLocalName();
                if ("IssueDate".equals(object)) {
                    object2 = object4;
                    break;
                }
                if (!"ID".equals(object)) continue;
                object2 = object4;
            }
            if (object2 != null) {
                object5.insertBefore((Node)object3, object2.getNextSibling());
            } else {
                object5.insertBefore((Node)object3, object5.getFirstChild());
            }
        }
        Object object6 = document.getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2", "CreditNoteLine");
        object2 = new ArrayList<Element>();
        for (int i4 = 0; i4 < object6.getLength(); ++i4) {
            object2.add((Element)object6.item(i4));
        }
        Object object7 = object2.iterator();
        while (object7.hasNext()) {
            object4 = (Element)object7.next();
            document.renameNode((Node)object4, "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2", "InvoiceLine");
            object = object4.getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "CreditedQuantity");
            for (int i5 = 0; i5 < object.getLength(); ++i5) {
                object6 = (Element)object.item(i5);
                document.renameNode((Node)object6, "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "InvoicedQuantity");
            }
        }
        object7 = document.getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "CustomizationID");
        if (object7 != null && object7.getLength() > 0) {
            ((Element)object7.item(0)).setTextContent("urn:cen.eu:en16931:2017#compliant#urn:mfin.gov.hr:cius-2025:1.0#conformant#urn:mfin.gov.hr:ext-2025:1.0");
        }
        if ((object4 = document.getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "ProfileID")) != null && object4.getLength() > 0) {
            ((Element)object4.item(0)).setTextContent("P1");
        }
        if ((object = document.getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2", "AccountingSupplierParty")) != null && object.getLength() > 0 && (object6 = (object4 = (Element)object.item(0)).getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2", "Party")) != null && object6.getLength() > 0 && ((object2 = (object4 = (Element)object6.item(0)).getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "EndpointID")) == null || object2.getLength() == 0)) {
            object6 = document.createElementNS("urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "cbc:EndpointID");
            object6.setAttribute("schemeID", "EM");
            object6.setTextContent("supplier@example.com");
            object4.insertBefore((Node)object6, object4.getFirstChild());
        }
        if ((object4 = document.getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2", "AccountingCustomerParty")) != null && object4.getLength() > 0 && (object4 = (object6 = (Element)object4.item(0)).getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2", "Party")) != null && object4.getLength() > 0 && ((object6 = (object2 = (Element)object4.item(0)).getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "EndpointID")) == null || object6.getLength() == 0)) {
            object4 = document.createElementNS("urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "cbc:EndpointID");
            object4.setAttribute("schemeID", "EM");
            object4.setTextContent("customer@example.com");
            object2.insertBefore((Node)object4, object2.getFirstChild());
        }
        object6 = document.createElementNS("urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "cbc:AccountingCost");
        object6.setTextContent("14285729085");
        object4 = null;
        object2 = document.getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "ID");
        if (object2 != null && object2.getLength() > 0) {
            object4 = (Element)object2.item(0);
        }
        if (object4 != null) {
            object5.insertBefore((Node)object6, object4.getNextSibling());
        }
        object6 = document.getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2", "CommodityClassification");
        for (int i6 = 0; i6 < object6.getLength(); ++i6) {
            object5 = (Element)object6.item(i6);
            if ((object5 = object5.getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "ItemClassificationCode")) == null || object5.getLength() <= 0) continue;
            object5 = (Element)object5.item(0);
            object5.setAttribute("listID", "CG");
        }
        return document;
    }

    private static byte[] ensureUblSigned(byte[] byArray) {
        block16: {
            try {
                Object object;
                Object object2;
                Document document = FinaEracuni.parseXml(new String(byArray, StandardCharsets.UTF_8));
                if (document == null) break block16;
                Object object3 = document.getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonSignatureComponents-2", "UBLDocumentSignatures");
                if (object3 != null && object3.getLength() > 0) {
                    return byArray;
                }
                object3 = document.getDocumentElement();
                if (object3 != null && object3.hasAttribute("Id") && ("Invoice".equals(object2 = object3.getLocalName()) || "CreditNote".equals(object2))) {
                    object3.removeAttribute("Id");
                    try {
                        object2 = TransformerFactory.newInstance().newTransformer();
                        ((Transformer)object2).setOutputProperty("omit-xml-declaration", "no");
                        ((Transformer)object2).setOutputProperty("encoding", "UTF-8");
                        object = new ByteArrayOutputStream();
                        ((Transformer)object2).transform(new DOMSource(document), new StreamResult((OutputStream)object));
                        byArray = ((ByteArrayOutputStream)object).toByteArray();
                        document = FinaEracuni.parseXml(new String(byArray, StandardCharsets.UTF_8));
                    }
                    catch (Exception exception) {}
                }
                try {
                    Matcher matcher;
                    Object object4;
                    String string;
                    Object object5;
                    object = document.getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2", "PartyIdentification");
                    for (int i2 = 0; i2 < object.getLength(); ++i2) {
                        Object object6 = (Element)object.item(i2);
                        object5 = object6.getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "ID");
                        if (object5 == null || object5.getLength() <= 0 || (string = (object4 = (Element)object5.item(0)).getTextContent() != null ? object4.getTextContent().trim() : "").isEmpty()) continue;
                        matcher = Pattern.compile("^HR(\\d{11})$").matcher(string);
                        object6 = Pattern.compile("^(\\d{11})$").matcher(string);
                        if (matcher.find()) {
                            object4.setTextContent("9934:" + matcher.group(1));
                            continue;
                        }
                        if (!((Matcher)object6).find()) continue;
                        object4.setTextContent("9934:" + ((Matcher)object6).group(1));
                    }
                    NodeList nodeList = document.getElementsByTagNameNS("urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "EndpointID");
                    for (int i3 = 0; i3 < nodeList.getLength(); ++i3) {
                        object5 = (Element)nodeList.item(i3);
                        object4 = object5.getAttribute("schemeID");
                        if (!"9934".equals(object4)) continue;
                        string = object5.getTextContent() != null ? object5.getTextContent().trim() : "";
                        matcher = Pattern.compile("^HR(\\d{11})$").matcher(string);
                        if (!matcher.find()) continue;
                        object5.setTextContent(matcher.group(1));
                    }
                    if (object3 != null) {
                        if (!object3.hasAttribute("xmlns:sig")) {
                            object3.setAttribute("xmlns:sig", "urn:oasis:names:specification:ubl:schema:xsd:CommonSignatureComponents-2");
                        }
                        if (!object3.hasAttribute("xmlns:sac")) {
                            object3.setAttribute("xmlns:sac", "urn:oasis:names:specification:ubl:schema:xsd:SignatureAggregateComponents-2");
                        }
                    }
                    try {
                        Transformer transformer = TransformerFactory.newInstance().newTransformer();
                        transformer.setOutputProperty("omit-xml-declaration", "no");
                        transformer.setOutputProperty("encoding", "UTF-8");
                        object5 = new ByteArrayOutputStream();
                        transformer.transform(new DOMSource(document), new StreamResult((OutputStream)object5));
                        byArray = ((ByteArrayOutputStream)object5).toByteArray();
                    }
                    catch (IllegalArgumentException | TransformerException exception) {
                    }
                }
                catch (DOMException dOMException) {}
            }
            catch (DOMException dOMException) {
                System.err.println("WARN: UBL signing failed: " + dOMException.getMessage());
                return byArray;
            }
        }
        return byArray;
    }

    private static String escapeXml(String string) {
        if (string == null) {
            return null;
        }
        return XMLrelated.escapeXml(string);
    }

    private static String buildGetReceiverListXml(String string, String string2, FinaConfig.ServiceType object) {
        String string3;
        String string4 = FinaConfig.getFinaCertificate();
        string4 = string4 != null && !string4.isEmpty() ? "9934:" + string4 : "9934:00000000000";
        String string5 = UUID.randomUUID().toString();
        if (string == null || string.isEmpty()) {
            string = "ALL";
        }
        if (string2 == null || string2.isEmpty()) {
            string2 = "ALL";
        }
        if ((string3 = FinaEracuni.readFile("fiskalizacija20/finaeracun/templates/GetReceiverListMsg.xml")) != null && !string3.trim().isEmpty()) {
            String string6 = FinaConfig.getIwscNamespace(object);
            String string7 = FinaConfig.getEchoNamespace(object);
            String string8 = FinaConfig.getGetReceiverListNamespace(object);
            object = FinaConfig.getMessageTypeGetReceiverList(object);
            string3 = string3.replace("${MESSAGE_ID}", FinaEracuni.escapeXml(string5)).replace("${SUPPLIER_ID}", FinaEracuni.escapeXml(string4)).replace("${SEARCH_FIELD}", FinaEracuni.escapeXml(string)).replace("${SEARCH_VALUE}", FinaEracuni.escapeXml(string2)).replace("${IWSC_NS}", string6).replace("${ECHO_NS}", string7).replace("${GRL_NS}", string8).replace("${MESSAGE_TYPE}", (CharSequence)object);
            return string3;
        }
        throw new RuntimeException("Template GetReceiverListMsg.xml not found (template-only mode)");
    }

    /*
     * Exception decompiling
     */
    private static String loadTextResource(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String handleGetInvoiceStatus(String string) {
        try {
            HrFiskalizator.logger.log(Level.INFO, "FINA GetInvoiceStatus for ID: " + string);
            if (string == null || string.trim().isEmpty()) {
                return this.handleError("Invoice ID is required");
            }
            if ((string = FinaEracuni.buildGetOutgoingInvoiceStatusXml(string, this.serviceType)) == null || string.isEmpty()) {
                return this.handleError("Failed to build GetOutgoingInvoiceStatus request");
            }
            Object object = this.serviceType != null ? this.serviceType : FinaConfig.getDefaultServiceType();
            String string2 = object == FinaConfig.ServiceType.B2B ? "GetB2BOutgoingInvoiceStatus" : "GetB2GOutgoingInvoiceStatus";
            string2 = "http://fina.hr/eracun/" + (object == FinaConfig.ServiceType.B2B ? "b2b" : "b2g") + "/" + string2;
            String string3 = FinaConfig.getEndpointAddress((FinaConfig.ServiceType)((Object)object), this.environment);
            if (string3 == null) {
                return this.handleError("Endpoint not configured for " + object + "/" + (Object)((Object)this.environment));
            }
            FinaEracuni.assertNoPlaceholders(string, "GetInvoiceStatus SOAP");
            string = this.soapClient.signAndSend(string3, string2, string);
            if (string != null) {
                this.lastResponse = string;
                try {
                    object = FinaAckParser.parse(string);
                    if (object != null) {
                        SysUtil.vdevout("[Ack] " + ((FinaAckParser.AckInfo)object).toString());
                    }
                }
                catch (Exception exception) {}
                return string;
            }
            return this.handleError("GetInvoiceStatus failed - no response");
        }
        catch (Exception exception) {
            HrFiskalizator.logger.log(Level.SEVERE, "FINA GetInvoiceStatus failed", exception);
            return this.handleError("GetInvoiceStatus error: " + exception.getMessage());
        }
    }

    private static String buildGetOutgoingInvoiceStatusXml(String string) {
        return FinaEracuni.buildGetOutgoingInvoiceStatusXml(string, FinaConfig.getDefaultServiceType());
    }

    private static String buildGetOutgoingInvoiceStatusXml(String string, FinaConfig.ServiceType object) {
        try {
            String string2 = FinaEracuni.readFile("fiskalizacija20/finaeracun/templates/GetOutgoingInvoiceStatusMsg.xml");
            if (string2 == null || string2.trim().isEmpty()) {
                throw new RuntimeException("Template GetOutgoingInvoiceStatusMsg.xml not found (template-only mode)");
            }
            String string3 = FinaConfig.getFinaCertificate();
            string3 = string3 != null && !string3.isEmpty() ? "9934:" + string3 : "9934:00000000000";
            String string4 = UUID.randomUUID().toString();
            String string5 = System.getProperty("FINA_STATUS_INVOICE_YEAR");
            if (string5 == null || !string5.matches("^\\d{4}$")) {
                string5 = String.valueOf(LocalDate.now().getYear());
            }
            String string6 = FinaConfig.getGetOutgoingInvoiceStatusNamespace(object);
            String string7 = FinaConfig.getIwscNamespace(object);
            String string8 = object == FinaConfig.ServiceType.B2B ? "GetB2BOutgoingInvoiceStatusMsg" : "GetB2GOutgoingInvoiceStatusMsg";
            String string9 = object == FinaConfig.ServiceType.B2B ? "B2BOutgoingInvoiceStatus" : "B2GOutgoingInvoiceStatus";
            object = FinaConfig.getMessageTypeGetStatus(object);
            return string2.replace("${STATUS_NS}", string6).replace("${IWSC_NS}", string7).replace("${MSG_ROOT}", string8).replace("${STATUS_ELEM}", string9).replace("${MESSAGE_ID}", FinaEracuni.escapeXml(string4)).replace("${SUPPLIER_ID}", FinaEracuni.escapeXml(string3)).replace("${MESSAGE_TYPE}", (CharSequence)object).replace("${INVOICE_ID}", FinaEracuni.escapeXml(string)).replace("${INVOICE_YEAR}", FinaEracuni.escapeXml(string5));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String handleGetReceiverList() {
        try {
            HrFiskalizator.logger.log(Level.INFO, "FINA GetReceiverList started");
            Object object = this.serviceType != null ? this.serviceType : FinaConfig.getDefaultServiceType();
            Object object2 = FinaConfig.ServiceType.B2G;
            String string = FinaEracuni.buildGetReceiverListXml(this.GetReceiverListsearchField, this.GetReceiverListsearchValue, (FinaConfig.ServiceType)((Object)object2));
            if (string == null || string.trim().isEmpty()) {
                return this.handleError("Failed to build GetReceiverList request");
            }
            String string2 = "http://fina.hr/eracun/" + (object2 == FinaConfig.ServiceType.B2B ? "b2b" : "b2g") + "/GetReceiverList";
            if ((object2 = FinaConfig.getEndpointAddress((FinaConfig.ServiceType)((Object)object2), this.environment)) == null) {
                return this.handleError("Endpoint not configured for " + (Object)object + "/" + (Object)((Object)this.environment));
            }
            FinaEracuni.assertNoPlaceholders(string, "GetReceiverList SOAP");
            object = this.soapClient.signAndSend((String)object2, string2, string);
            if (object != null) {
                this.lastResponse = object;
                try {
                    object2 = FinaAckParser.parse((String)object);
                    if (object2 != null) {
                        SysUtil.vdevout("[Ack] " + ((FinaAckParser.AckInfo)object2).toString());
                    }
                }
                catch (Exception exception) {}
                return object;
            }
            return this.handleError("GetReceiverList failed - no response");
        }
        catch (Exception exception) {
            HrFiskalizator.logger.log(Level.SEVERE, "FINA GetReceiverList failed", exception);
            return this.handleError("GetReceiverList error: " + exception.getMessage());
        }
    }

    private String handleError(String string) {
        this.lastError = string;
        HrFiskalizator.logger.log(Level.WARNING, "FINA Error: " + string);
        return "ERROR: " + string;
    }

    private void clearLastResults() {
        this.lastResponse = "";
        this.lastError = "";
    }

    public String getLastResponse() {
        return this.lastResponse;
    }

    public String getLastError() {
        return this.lastError;
    }

    public FinaConfig.ServiceType getServiceType() {
        return this.serviceType;
    }

    public boolean hasError() {
        return !this.lastError.isEmpty();
    }

    public void setServiceType(FinaConfig.ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public void setEnvironment(FinaConfig.Environment environment) {
        this.environment = environment;
    }

    public void setReturnOnly(boolean bl2) {
        this.returnOnly = bl2;
    }
}

