/*
 * Decompiled with CFR 0.152.
 */
package FinaEracun;

import FinaEracun.FinaConfig;
import FinaEracun.FinaEracuni;
import SYSTEM.LicenseManager;
import UTIL.KeyStoreUtil;
import UTIL.XMLrelated;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import fiskalizacija.Cfg;
import fiskalizacija.HrFiskalizator;
import fiskalizacija.ReqParser;
import fiskalizacija.SS;
import fiskalizacija.SysUtil;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;

public class FinaHandler
implements HttpHandler {
    private static volatile boolean configInitialized = false;
    public static KeyStore FKS;

    public FinaHandler() {
        KeyStoreUtil keyStoreUtil = new KeyStoreUtil();
        FKS = keyStoreUtil.loadKeystore(HrFiskalizator.p.getProperty("PUTANJAJKS"), HrFiskalizator.p.getProperty("LOZINKAJKS"));
    }

    @Override
    public void handle(HttpExchange object) {
        ReqParser reqParser = new ReqParser((HttpExchange)object);
        if (SS.is401(6, reqParser).booleanValue()) {
            return;
        }
        boolean bl2 = LicenseManager.isLicenceValid("FinaHandler");
        if (!bl2) {
            reqParser.response[1] = Cfg.LNV;
            SS.respond(reqParser);
        }
        String string = "";
        String string2 = null;
        long l2 = new Date().getTime();
        try {
            Map<String, Object> map = reqParser.parameters;
            String string3 = reqParser.requestPath.replace("/finaapi/", "").replace("finaapi/", "");
            String[] stringArray = string3.split("/");
            if ("".equals(stringArray[0])) {
                stringArray = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            }
            if (FinaConfig.isDebugMode()) {
                HrFiskalizator.logger.log(Level.INFO, "FINA Handler: zadatak = {0}, from {1}", new Object[]{string3, ((HttpExchange)object).getRemoteAddress()});
            }
            FinaEracuni finaEracuni = new FinaEracuni();
            object = (String)map.get("servis");
            Object object2 = FinaConfig.getDefaultServiceType();
            if ("B2B".equalsIgnoreCase((String)object)) {
                finaEracuni.setServiceType(FinaConfig.ServiceType.B2B);
            } else if ("B2G".equalsIgnoreCase((String)object)) {
                finaEracuni.setServiceType(FinaConfig.ServiceType.B2G);
            } else {
                finaEracuni.setServiceType((FinaConfig.ServiceType)((Object)object2));
            }
            finaEracuni.setEnvironment(FinaConfig.getCurrentEnvironment());
            object = (String)map.get("returnonly");
            if ("true".equalsIgnoreCase((String)object)) {
                finaEracuni.setReturnOnly(true);
            }
            object = "";
            if (reqParser.queryPOST != null && !reqParser.queryPOST.trim().isEmpty()) {
                object = reqParser.queryPOST;
            }
            switch (stringArray[0].toUpperCase()) {
                case "TEST": 
                case "ECHO": {
                    string = finaEracuni.Send("ECHO", "");
                    string = XMLrelated.formatXML(string);
                    break;
                }
                case "SENDRACUN": 
                case "SENDINVOICE": 
                case "POSALJIRACUN": {
                    if (((String)object).trim().isEmpty()) {
                        string2 = "Content (UBL XML) is required for sending invoice";
                        break;
                    }
                    object = URLDecoder.decode(reqParser.queryPOST, "UTF-8");
                    string = finaEracuni.Send("SENDINVOICE", (String)object);
                    string = XMLrelated.formatXML(string);
                    break;
                }
                case "STATUSRACUNA": 
                case "GETINVOICESTATUS": {
                    object = (String)map.get("invoiceid");
                    if (object == null || ((String)object).trim().isEmpty()) {
                        string2 = "Parameter 'invoiceid' is required for status check";
                        break;
                    }
                    object2 = (String)map.get("godina");
                    if (object2 == null) {
                        object2 = (String)map.get("year");
                    }
                    if (object2 != null && !((String)object2).trim().isEmpty()) {
                        System.setProperty("FINA_STATUS_INVOICE_YEAR", ((String)object2).trim());
                    }
                    string = XMLrelated.formatXML(finaEracuni.Send("GETINVOICESTATUS", (String)object));
                    break;
                }
                case "LISTAPRIMATELJA": 
                case "GETRECEIVERLIST": {
                    if (finaEracuni.serviceType == FinaConfig.ServiceType.B2B) {
                        string = "GETRECEIVERLIST je dostupan samo za B2G servis, ne za B2B.";
                        break;
                    }
                    if (map.containsKey("field")) {
                        finaEracuni.GetReceiverListsearchField = (String)map.get("field");
                    }
                    if (map.containsKey("value")) {
                        finaEracuni.GetReceiverListsearchValue = (String)map.get("value");
                    }
                    string = XMLrelated.formatXML(finaEracuni.Send("GETRECEIVERLIST", ""));
                    break;
                }
                case "TESTKONFIGURACIJE": 
                case "TESTCONFIG": {
                    boolean bl3 = FinaConfig.testConfiguration();
                    String string4 = string = bl3 ? "FINA configuration OK" : "FINA configuration ERROR";
                    if (bl3) break;
                    string2 = "FINA configuration test failed";
                    break;
                }
                case "GETCONFIG": 
                case "CONFIG": {
                    string = this.getFinaConfigInfo();
                    break;
                }
                default: {
                    string = "Unknown FINA task: " + stringArray[0].toUpperCase();
                }
            }
            if (finaEracuni.hasError() && string2 == null) {
                string2 = finaEracuni.getLastError();
            }
        }
        catch (Exception exception) {
            HrFiskalizator.logger.log(Level.SEVERE, "FINA Handler exception", exception);
            string2 = "FINA service error: " + exception.getMessage();
        }
        if (string2 != null) {
            HrFiskalizator.logger.log(Level.WARNING, "FINA Error: {0}", string2);
            reqParser.response[0] = 500;
            reqParser.response[1] = "ERROR: " + string2;
            SysUtil.playError();
        } else {
            reqParser.response[0] = 200;
            reqParser.response[1] = string;
        }
        reqParser.response[2] = "text/plain; charset=utf-8";
        if (FinaConfig.isDebugMode()) {
            long l3 = new Date().getTime();
            long l4 = l3 - l2;
            HrFiskalizator.logger.log(Level.INFO, "FINA Handler execution time: {0} ms", l4);
        }
        SS.respond(reqParser);
    }

    private String getFinaConfigInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            FinaConfig.Environment environment = FinaConfig.getCurrentEnvironment();
            stringBuilder.append("FINA eRa\u010duni Configuration:\n");
            stringBuilder.append("=========================\n");
            stringBuilder.append("Environment: ").append((Object)environment).append("\n");
            stringBuilder.append("Certificate: ").append(FinaConfig.getFinaCertificate()).append("\n");
            stringBuilder.append("\nEndpoints:\n");
            stringBuilder.append("B2G: ").append(FinaConfig.getEndpointAddress(FinaConfig.ServiceType.B2G, environment)).append("\n");
            stringBuilder.append("B2B: ").append(FinaConfig.getEndpointAddress(FinaConfig.ServiceType.B2B, environment)).append("\n");
            stringBuilder.append("\nDNS Identity: ").append(FinaConfig.getDnsIdentity(FinaConfig.ServiceType.B2G, environment)).append("\n");
            boolean bl2 = FinaConfig.testConfiguration();
            stringBuilder.append("\nConfiguration Status: ").append(bl2 ? "OK" : "ERROR");
        }
        catch (Exception exception) {
            stringBuilder.append("Error getting FINA config: ").append(exception.getMessage());
        }
        return stringBuilder.toString();
    }
}

