/*
 * Decompiled with CFR 0.152.
 */
package FinaEracun;

import FinaEracun.FinaConfig;
import FinaEracun.FinaHandler;
import FinaEracun.StandardSoapSigner;
import fiskalizacija.SysUtil;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class FinaSoapClient {
    private static char[] jksPassword() {
        return FinaConfig.getJksPassword().toCharArray();
    }

    private static char[] certPassword() {
        return FinaConfig.getFinaCertPassword().toCharArray();
    }

    public String signAndSend(String string, String string2, String string3) {
        try {
            Object object;
            if (string3 == null || string3.isEmpty()) {
                throw new IllegalArgumentException("unsignedSoap is empty");
            }
            if (FinaConfig.useStandardSoapSigner()) {
                SysUtil.vdevout("INFO: FINA_SOAP_USE_STANDARD_SIGNER enabled -> signing SOAP body with enveloped XMLDSIG (no WS-Security)");
                try {
                    String string4 = StandardSoapSigner.signSoapBodyWithEnvelopedDsig(string3);
                    return this.sendSoapRequest(string, string4, string2);
                }
                catch (Exception exception) {
                    System.err.println("WARN: StandardSoapSigner failed (" + exception.getMessage() + "), falling back to WS-Security");
                }
            }
            try {
                object = DocumentBuilderFactory.newInstance();
                ((DocumentBuilderFactory)object).setNamespaceAware(true);
                object = ((DocumentBuilderFactory)object).newDocumentBuilder().parse(new InputSource(new StringReader(string3)));
                object = (Element)object.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header").item(0);
                boolean bl2 = false;
                boolean bl3 = false;
                if (object != null && (object = object.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security")) != null && object.getLength() > 0) {
                    bl2 = true;
                    object = (Element)object.item(0);
                    if ((object = object.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature")) != null && object.getLength() > 0) {
                        bl3 = true;
                    }
                }
                if (bl2 && bl3) {
                    SysUtil.vdevout("OK: Detected existing WS-Security signature; sending as-is without re-signing.");
                    return this.sendSoapRequest(string, string3, string2);
                }
            }
            catch (Exception exception) {}
            object = this.signSoapMessage(string3);
            return this.sendSoapRequest(string, (String)object, string2);
        }
        catch (Exception exception) {
            System.err.println("ERROR signAndSend: " + exception.getMessage());
            exception.printStackTrace();
            return "ERROR: " + exception.getMessage();
        }
    }

    private String signSoapMessage(String string) {
        try {
            KeyMaterial keyMaterial = this.loadKeyFromJKS();
            if (keyMaterial != null && keyMaterial.privateKey != null && keyMaterial.certificate != null) {
                SysUtil.vdevout("OK JKS certifikat ucitan: " + keyMaterial.certificate.getSubjectDN());
                SysUtil.vdevout("   Alias: " + keyMaterial.alias);
                return this.addWSSecurity(string, keyMaterial.privateKey, keyMaterial.certificate);
            }
        }
        catch (Exception exception) {
            System.err.println("ERROR Greska potpisivanja: " + exception.getMessage());
            return string;
        }
        return string;
    }

    private static String getEnvOrProp(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null || string2.trim().isEmpty()) {
            string2 = System.getenv(string);
        }
        return string2;
    }

    private static Set<String> parseCsvList(String stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        if (stringArray == null) {
            return hashSet;
        }
        for (String string : stringArray.split(",")) {
            if ((string = string.trim()).isEmpty()) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private KeyMaterial loadKeyFromJKS() {
        try {
            Object object;
            Object object2 = FinaHandler.FKS;
            Object object3 = FinaConfig.getSigningAlias();
            if (object3 != null && !((String)object3).isEmpty()) {
                ((KeyStore)object2).isKeyEntry((String)object3);
            }
            if (object3 != null && !((String)object3).isEmpty() && ((KeyStore)object2).isKeyEntry((String)object3)) {
                object = this.tryRecoverKey((KeyStore)object2, (String)object3);
                if (object != null) {
                    X509Certificate x509Certificate = (X509Certificate)((KeyStore)object2).getCertificate((String)object3);
                    return new KeyMaterial((String)object3, (PrivateKey)object, x509Certificate);
                }
                System.err.println("Nije mogu\u0107e dohvatiti privatni klju\u010d za alias '" + (String)object3 + "' s lozinkom iz konfiguracije.");
            } else {
                System.err.println("Konfigurirani alias nije prona\u0111en u JKS-u: '" + (String)object3 + "'. Poku\u0161avam pretragu po svim aliasima...");
            }
            object = ((KeyStore)object2).aliases();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                if (!((KeyStore)object2).isKeyEntry(string)) continue;
                object3 = this.tryRecoverKey((KeyStore)object2, string);
                if (object3 == null) {
                    object3 = this.tryRecoverKey((KeyStore)object2, string);
                }
                if (object3 == null) continue;
                object2 = (X509Certificate)((KeyStore)object2).getCertificate(string);
                return new KeyMaterial(string, (PrivateKey)object3, (X509Certificate)object2);
            }
            System.err.println("U JKS-u nema dostupnog key entry-ja s privatnim klju\u010dem (ili lozinke nisu ispravne).");
            return null;
        }
        catch (Exception exception) {
            System.err.println("Gre\u0161ka pri u\u010ditavanju JKS klju\u010da: " + exception.getMessage());
            return null;
        }
    }

    private PrivateKey tryRecoverKey(KeyStore keyStore, String string) {
        char[][] cArrayArray = new char[][]{FinaSoapClient.jksPassword(), FinaSoapClient.certPassword()};
        char[][] cArrayArray2 = cArrayArray;
        cArrayArray2 = cArrayArray;
        int cfr_ignored_0 = cArrayArray.length;
        for (int i2 = 0; i2 < 2; ++i2) {
            Object object = cArrayArray2[i2];
            try {
                Key key = keyStore.getKey(string, (char[])object);
                object = key;
                if (!(key instanceof PrivateKey)) continue;
                SysUtil.vdevout("JKS key recovered for alias '" + string + "'");
                return (PrivateKey)object;
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                continue;
            }
            catch (Exception exception) {
                System.err.println("Gre\u0161ka pri \u010ditanju klju\u010da za alias '" + string + "': " + exception.getMessage());
            }
        }
        return null;
    }

    private String addWSSecurity(String object, PrivateKey object2, X509Certificate object3) {
        Object object4 = DocumentBuilderFactory.newInstance();
        ((DocumentBuilderFactory)object4).setNamespaceAware(true);
        object = ((DocumentBuilderFactory)object4).newDocumentBuilder().parse(new InputSource(new StringReader((String)object)));
        object.setXmlStandalone(true);
        object4 = "X509-" + UUID.randomUUID().toString();
        Object object5 = "TS-" + UUID.randomUUID().toString();
        Object object6 = "id-" + UUID.randomUUID().toString();
        String string = "SIG-" + UUID.randomUUID().toString();
        String string2 = "KI-" + UUID.randomUUID().toString();
        Object object7 = "STR-" + UUID.randomUUID().toString();
        Object object8 = (Element)object.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header").item(0);
        Object object9 = (Element)object.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body").item(0);
        Element element = (Element)object.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Envelope").item(0);
        if (element != null) {
            if (!element.hasAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soapenc")) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
            }
            if (!element.hasAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd")) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            }
            if (!element.hasAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi")) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        element = object.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
        element.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "soapenv:mustUnderstand", "1");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        object8.appendChild(element);
        object8 = object.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:BinarySecurityToken");
        object8.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", (String)object4);
        object8.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        object8.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        object8.setTextContent(Base64.getEncoder().encodeToString(((Certificate)object3).getEncoded()));
        element.appendChild((Node)object8);
        object3 = object.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        object3.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", (String)object5);
        object8 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        ((DateFormat)object8).setTimeZone(TimeZone.getTimeZone("UTC"));
        Object object10 = new Date();
        Date date = new Date(((Date)object10).getTime() + 300000L);
        Element element2 = object.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        element2.setTextContent(((DateFormat)object8).format((Date)object10));
        object3.appendChild(element2);
        object10 = object.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
        object10.setTextContent(((DateFormat)object8).format(date));
        object3.appendChild((Node)object10);
        element.appendChild((Node)object3);
        object9.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        object9.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", (String)object6);
        object9.setIdAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id", true);
        object3.setIdAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id", true);
        object3 = XMLSignatureFactory.getInstance("DOM");
        object8 = Arrays.asList("soapenc", "soapenv", "xsd", "xsi");
        object8 = new ExcC14NParameterSpec((List<String>)object8);
        object8 = ((XMLSignatureFactory)object3).newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)object8);
        object9 = FinaConfig.getWsseSignatureAlg() == FinaConfig.WsseSigAlg.SHA256 ? ((XMLSignatureFactory)object3).newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null) : ((XMLSignatureFactory)object3).newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
        object10 = Arrays.asList("soapenc", "xsd", "xsi");
        object10 = ((XMLSignatureFactory)object3).newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", new ExcC14NParameterSpec((List<String>)object10));
        object6 = ((XMLSignatureFactory)object3).newReference("#" + (String)object6, ((XMLSignatureFactory)object3).newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(object10), null, null);
        object10 = Arrays.asList("wsse", "soapenc", "soapenv", "xsd", "xsi");
        object10 = ((XMLSignatureFactory)object3).newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", new ExcC14NParameterSpec((List<String>)object10));
        object5 = ((XMLSignatureFactory)object3).newReference("#" + (String)object5, ((XMLSignatureFactory)object3).newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(object10), null, null);
        object5 = ((XMLSignatureFactory)object3).newSignedInfo((CanonicalizationMethod)object8, (SignatureMethod)object9, Arrays.asList(object6, object5));
        object6 = ((XMLSignatureFactory)object3).getKeyInfoFactory();
        object4 = new DOMStructure(this.createSecurityTokenReference((Document)object, (String)object4, (String)object7));
        object7 = new ArrayList<Object>();
        object7.add(object4);
        object4 = ((KeyInfoFactory)object6).newKeyInfo((List<? extends XMLStructure>)object7, string2);
        object3 = ((XMLSignatureFactory)object3).newXMLSignature((SignedInfo)object5, (KeyInfo)object4, null, string, null);
        object2 = new DOMSignContext((Key)object2, (Node)element);
        object3.sign((XMLSignContext)object2);
        object2 = new StringWriter();
        object3 = TransformerFactory.newInstance().newTransformer();
        try {
            ((Transformer)object3).setOutputProperty("omit-xml-declaration", "no");
            ((Transformer)object3).setOutputProperty("encoding", "UTF-8");
        }
        catch (Exception exception) {}
        ((Transformer)object3).transform(new DOMSource((Node)object), new StreamResult((Writer)object2));
        SysUtil.vdevout("OK XML DSig API potpis kao u .NET kodu");
        return ((StringWriter)object2).toString();
    }

    private Element createSecurityTokenReference(Document node, String string, String string2) {
        Element element = node.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference");
        element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", string2);
        node = node.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
        node.setAttribute("URI", "#" + string);
        node.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        element.appendChild(node);
        return element;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String sendSoapRequest(String object, String object2, String object3) {
        Serializable serializable;
        block43: {
            block42: {
                SysUtil.vdevout("==> Salje na: " + (String)object);
                this.setupSSLFromJKS();
                object = new URL((String)object);
                object = (HttpsURLConnection)((URL)object).openConnection();
                int n2 = 2000;
                String string = FinaSoapClient.getEnvOrProp("VOSCONNECTIONTIMEOUT");
                if (string != null && !string.trim().isEmpty()) {
                    try {
                        n2 = Integer.parseInt(string.trim());
                    }
                    catch (Exception exception) {}
                }
                int n3 = 10000;
                String string2 = FinaSoapClient.getEnvOrProp("VOSREADTIMEOUT");
                if (string2 != null && !string2.trim().isEmpty()) {
                    try {
                        n3 = Integer.parseInt(string2.trim());
                    }
                    catch (Exception exception) {}
                }
                ((URLConnection)object).setConnectTimeout(n2);
                ((URLConnection)object).setReadTimeout(n3);
                ((HttpURLConnection)object).setRequestMethod("POST");
                ((URLConnection)object).setRequestProperty("Content-Type", "text/xml; charset=utf-8");
                if (object3 != null && !((String)object3).isEmpty()) {
                    ((URLConnection)object).setRequestProperty("SOAPAction", (String)object3);
                }
                ((URLConnection)object).setRequestProperty("Accept-Encoding", "gzip,deflate");
                object3 = FinaSoapClient.getEnvOrProp("FINA_USER_AGENT");
                ((URLConnection)object).setRequestProperty("User-Agent", (String)(object3 != null && !((String)object3).trim().isEmpty() ? object3 : "HrFiskalizator/1.0"));
                ((URLConnection)object).setRequestProperty("Connection", "close");
                ((URLConnection)object).setDoOutput(true);
                ((URLConnection)object).setDoInput(true);
                SysUtil.vdevout("   \u0160alje SOAP (" + ((String)object2).length() + " bytes)...");
                object3 = ((URLConnection)object).getOutputStream();
                serializable = null;
                try {
                    ((OutputStream)object3).write(((String)object2).getBytes("UTF-8"));
                    ((OutputStream)object3).flush();
                    if (object3 == null) break block42;
                }
                catch (Throwable throwable) {
                    try {
                        object = throwable;
                        serializable = throwable;
                        throw object;
                    }
                    catch (Throwable throwable2) {
                        if (object3 == null) throw throwable2;
                        if (serializable == null) {
                            ((OutputStream)object3).close();
                            throw throwable2;
                        }
                        try {
                            ((OutputStream)object3).close();
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            ((Throwable)serializable).addSuppressed(throwable3);
                            throw throwable2;
                        }
                    }
                }
                ((OutputStream)object3).close();
            }
            if (FinaConfig.isEracunTest()) {
                object3 = new FileOutputStream("fina_request.xml");
                serializable = null;
                try {
                    ((OutputStream)object3).write(((String)object2).getBytes("UTF-8"));
                }
                catch (Throwable throwable) {
                    try {
                        object = throwable;
                        serializable = throwable;
                        throw object;
                    }
                    catch (Throwable throwable4) {
                        if (serializable == null) {
                            ((OutputStream)object3).close();
                            throw throwable4;
                        }
                        try {
                            ((OutputStream)object3).close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            ((Throwable)serializable).addSuppressed(throwable5);
                            throw throwable4;
                        }
                    }
                }
                ((OutputStream)object3).close();
            }
            int n4 = ((HttpURLConnection)object).getResponseCode();
            SysUtil.vdevout("==> HTTP odgovor: " + n4);
            serializable = new StringBuilder();
            try {
                if (n4 >= 400) {
                    object = ((HttpURLConnection)object).getErrorStream();
                    SysUtil.vdevout("   \u010citam error stream...");
                } else {
                    object = ((URLConnection)object).getInputStream();
                    SysUtil.vdevout("   \u010citam input stream...");
                }
                if (object != null) {
                    object = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
                    object2 = null;
                    try {
                        String string;
                        n4 = 0;
                        while ((string = ((BufferedReader)object).readLine()) != null) {
                            ((StringBuilder)serializable).append(string).append("\n");
                            ++n4;
                        }
                        SysUtil.vdevout("   Pro\u010ditano " + n4 + " linija");
                    }
                    catch (Throwable throwable) {
                        try {
                            Throwable throwable6 = throwable;
                            object2 = throwable;
                            throw throwable6;
                        }
                        catch (Throwable throwable7) {
                            if (object2 == null) {
                                ((BufferedReader)object).close();
                                throw throwable7;
                            }
                            try {
                                ((BufferedReader)object).close();
                                throw throwable7;
                            }
                            catch (Throwable throwable8) {
                                ((Throwable)object2).addSuppressed(throwable8);
                                throw throwable7;
                            }
                        }
                    }
                    ((BufferedReader)object).close();
                    break block43;
                }
                SysUtil.vdevout("   Input stream je null!");
            }
            catch (Exception exception) {
                System.err.println("   Gre\u0161ka \u010ditanja: " + exception.getMessage());
            }
        }
        object = ((StringBuilder)serializable).toString();
        SysUtil.vdevout("   Response length: " + ((String)object).length() + " characters");
        if (!FinaConfig.isEracunTest()) return object;
        object2 = new FileOutputStream("fina_response.xml");
        Throwable throwable = null;
        try {
            ((OutputStream)object2).write(((String)object).getBytes("UTF-8"));
            SysUtil.vdevout("==> Odgovor spremljen u: fina_response.xml");
        }
        catch (Throwable throwable9) {
            try {
                Throwable throwable10 = throwable9;
                throwable = throwable9;
                throw throwable10;
            }
            catch (Throwable throwable11) {
                if (throwable == null) {
                    ((OutputStream)object2).close();
                    throw throwable11;
                }
                try {
                    ((OutputStream)object2).close();
                    throw throwable11;
                }
                catch (Throwable throwable12) {
                    throwable.addSuppressed(throwable12);
                    throw throwable11;
                }
            }
        }
        ((OutputStream)object2).close();
        return object;
    }

    private boolean setupSSLFromJKS() {
        try {
            Object object;
            Certificate[] certificateArray;
            String string2;
            String string3;
            Set<String> set;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            TrustManager[] trustManagerArray;
            block22: {
                trustManagerArray = FinaHandler.FKS;
                object5 = FinaConfig.getSigningAlias();
                if (object5 == null || ((String)object5).isEmpty() || !trustManagerArray.isKeyEntry((String)object5)) {
                    System.err.println("SSL: Neispravan ili nepostoje\u0107i alias u JKS: '" + (String)object5 + "'");
                    return false;
                }
                object4 = FinaConfig.getSigningKeyPassword() != null && !FinaConfig.getSigningKeyPassword().isEmpty() ? FinaConfig.getSigningKeyPassword().toCharArray() : FinaSoapClient.jksPassword();
                try {
                    object3 = trustManagerArray.getKey((String)object5, (char[])object4);
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    System.err.println("SSL: Cannot recover key for alias '" + (String)object5 + "' using configured password.");
                    return false;
                }
                if (!(object3 instanceof PrivateKey)) {
                    System.err.println("SSL: Alias '" + (String)object5 + "' does not contain a PrivateKey.");
                    return false;
                }
                object3 = (PrivateKey)object3;
                object2 = trustManagerArray.getCertificateChain((String)object5);
                if ((object2 == null || ((Certificate[])object2).length == 0) && (set = trustManagerArray.getCertificate((String)object5)) != null) {
                    object2 = new Certificate[]{set};
                }
                set = KeyStore.getInstance("JKS");
                ((KeyStore)((Object)set)).load(null, null);
                ((KeyStore)((Object)set)).setKeyEntry((String)object5, (Key)object3, (char[])object4, (Certificate[])object2);
                object5 = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                ((KeyManagerFactory)object5).init((KeyStore)((Object)set), (char[])object4);
                object4 = SSLContext.getInstance("TLSv1.2");
                object3 = KeyStore.getInstance("JKS");
                ((KeyStore)object3).load(null, null);
                object2 = FinaConfig.getTrustOnlyAliases();
                set = FinaConfig.getTrustBlockAliases();
                string3 = FinaConfig.getServerCertAlias();
                string2 = FinaConfig.getSigningAlias();
                try {
                    Certificate certificate;
                    certificateArray = string3;
                    if (certificateArray != null && trustManagerArray.containsAlias((String)certificateArray) && (certificate = trustManagerArray.getCertificate((String)certificateArray)) != null) {
                        ((KeyStore)object3).setCertificateEntry((String)certificateArray, certificate);
                        if (FinaConfig.isDebugMode()) {
                            SysUtil.vdevout("Trust: dodan serverski cert iz JKS: " + (String)certificateArray + " (obavezan)");
                        }
                    }
                }
                catch (Exception exception) {}
                try {
                    if (string2 != null && trustManagerArray.isKeyEntry(string2) && (certificateArray = trustManagerArray.getCertificateChain(string2)) != null && certificateArray.length > 0) {
                        for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                            Certificate certificate = certificateArray[i2];
                            object = string2 + "-chain-" + i2;
                            if (((KeyStore)object3).getCertificate((String)object) != null) continue;
                            ((KeyStore)object3).setCertificateEntry((String)object, certificate);
                        }
                        if (FinaConfig.isDebugMode()) {
                            SysUtil.vdevout("Trust: dodan potpisni chain iz JKS za alias: " + string2);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!FinaConfig.isDebugMode()) break block22;
                    SysUtil.vdevout("Trust: problem dodavanja potpisnog chain-a: " + exception.getMessage());
                }
            }
            certificateArray = trustManagerArray.aliases();
            if (FinaConfig.isDebugMode()) {
                SysUtil.vdevout("Trust: sastavljam trust store iz JKS (allowOnly=" + object2 + ", block=" + set + ")");
            }
            while (certificateArray.hasMoreElements()) {
                String string4 = (String)certificateArray.nextElement();
                try {
                    boolean bl2;
                    if (!trustManagerArray.isCertificateEntry(string4)) continue;
                    boolean bl3 = bl2 = string4.equalsIgnoreCase(string3) || string4.equalsIgnoreCase(string2);
                    if (!(object2.isEmpty() || object2.contains(string4) || bl2)) {
                        if (!FinaConfig.isDebugMode()) continue;
                        SysUtil.vdevout("Trust: SKIP (not in FINA_TRUST_ONLY): " + string4);
                        continue;
                    }
                    if (set.contains(string4) && !bl2) {
                        if (!FinaConfig.isDebugMode()) continue;
                        SysUtil.vdevout("Trust: BLOKIRAN (FINA_TRUST_BLOCK): " + string4);
                        continue;
                    }
                    object = trustManagerArray.getCertificate(string4);
                    if (object == null || ((KeyStore)object3).getCertificate(string4) != null) continue;
                    ((KeyStore)object3).setCertificateEntry(string4, (Certificate)object);
                    if (!FinaConfig.isDebugMode()) continue;
                    SysUtil.vdevout("Trust: dodan iz JKS: " + string4);
                }
                catch (Exception exception) {
                    if (!FinaConfig.isDebugMode()) continue;
                    SysUtil.vdevout("Trust: skip alias " + string4 + " -> " + exception.getMessage());
                }
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            TrustManagerFactory trustManagerFactory2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory2.init((KeyStore)object3);
            object = FinaSoapClient.pickX509(trustManagerFactory.getTrustManagers());
            trustManagerArray = FinaSoapClient.pickX509(trustManagerFactory2.getTrustManagers());
            trustManagerArray = new TrustManager[]{FinaSoapClient.combine((X509TrustManager)object, (X509TrustManager)trustManagerArray)};
            ((SSLContext)object4).init(((KeyManagerFactory)object5).getKeyManagers(), trustManagerArray, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(((SSLContext)object4).getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier((string, sSLSession) -> string.contains("fina.hr"));
            SysUtil.vdevout("OK SSL iz keystore.jks (client + trust)");
            return true;
        }
        catch (Exception exception) {
            System.err.println("Gre\u0161ka pri SSL setup-u iz JKS: " + exception.getMessage());
            return false;
        }
    }

    private static X509TrustManager pickX509(TrustManager[] trustManagerArray) {
        for (TrustManager trustManager : trustManagerArray) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        return new X509TrustManager(){

            @Override
            public final X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public final void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public final void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        };
    }

    private static X509TrustManager combine(final X509TrustManager x509TrustManager, final X509TrustManager x509TrustManager2) {
        return new X509TrustManager(){

            @Override
            public final X509Certificate[] getAcceptedIssuers() {
                X509Certificate[] x509CertificateArray = x509TrustManager.getAcceptedIssuers();
                X509Certificate[] x509CertificateArray2 = x509TrustManager2.getAcceptedIssuers();
                X509Certificate[] x509CertificateArray3 = new X509Certificate[x509CertificateArray.length + x509CertificateArray2.length];
                System.arraycopy(x509CertificateArray, 0, x509CertificateArray3, 0, x509CertificateArray.length);
                System.arraycopy(x509CertificateArray2, 0, x509CertificateArray3, x509CertificateArray.length, x509CertificateArray2.length);
                return x509CertificateArray3;
            }

            @Override
            public final void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                try {
                    x509TrustManager.checkClientTrusted(x509CertificateArray, string);
                    return;
                }
                catch (CertificateException certificateException) {
                    try {
                        x509TrustManager2.checkClientTrusted(x509CertificateArray, string);
                        return;
                    }
                    catch (CertificateException certificateException2) {
                        if (FinaConfig.isDebugMode()) {
                            System.err.println("SSL trust (client) failed. Primary: " + certificateException.getMessage() + "; Secondary: " + certificateException2.getMessage());
                        }
                        throw certificateException2;
                    }
                }
            }

            @Override
            public final void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                try {
                    x509TrustManager.checkServerTrusted(x509CertificateArray, string);
                    return;
                }
                catch (CertificateException certificateException) {
                    try {
                        if (FinaConfig.isDebugMode()) {
                            if (x509CertificateArray != null && x509CertificateArray.length > 0) {
                                System.err.println("Server cert chain (subjects -> issuers):");
                                for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
                                    X509Certificate x509Certificate = x509CertificateArray[i2];
                                    System.err.println("  [" + i2 + "] Subject=" + x509Certificate.getSubjectX500Principal() + ", Issuer=" + x509Certificate.getIssuerX500Principal());
                                }
                            } else {
                                System.err.println("Server cert chain is empty/null during trust check.");
                            }
                        }
                    }
                    catch (Throwable throwable) {}
                    try {
                        x509TrustManager2.checkServerTrusted(x509CertificateArray, string);
                        return;
                    }
                    catch (CertificateException certificateException2) {
                        if (FinaConfig.isDebugMode()) {
                            System.err.println("SSL trust (server) failed. Primary: " + certificateException.getMessage() + "; Secondary: " + certificateException2.getMessage());
                        }
                        throw certificateException2;
                    }
                }
            }
        };
    }

    private static class KeyMaterial {
        final String alias;
        final PrivateKey privateKey;
        final X509Certificate certificate;

        KeyMaterial(String string, PrivateKey privateKey, X509Certificate x509Certificate) {
            this.alias = string;
            this.privateKey = privateKey;
            this.certificate = x509Certificate;
        }
    }
}

