/*
 * Decompiled with CFR 0.152.
 */
package SYSTEM;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HardwareIdentifier {
    private static final String SALT = "HrFiskalizator2025";
    private static final String[] COMPONENTS = new String[]{"cpu", "bios", "disk", "mac"};

    public static HardwareID getUniqueID() {
        Object object = COMPONENTS;
        int n2 = COMPONENTS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = object[i2];
            String string2 = HardwareIdentifier.getComponentValue(string);
            if (string2 == null || string2.trim().isEmpty()) continue;
            object = HardwareIdentifier.generateHash(string + ":" + string2);
            return new HardwareID((String)object, string);
        }
        try {
            object = InetAddress.getLocalHost().getHostName();
            String string = HardwareIdentifier.generateHash("hostname:" + (String)object);
            return new HardwareID(string, "hostname");
        }
        catch (Exception exception) {
            String string = String.valueOf(System.nanoTime());
            String string3 = HardwareIdentifier.generateHash("random:" + string);
            return new HardwareID(string3, "random");
        }
    }

    public static String recreateHash(String string) {
        String string2 = HardwareIdentifier.getComponentValue(string);
        if (string2 != null && !string2.trim().isEmpty()) {
            return HardwareIdentifier.generateHash(string + ":" + string2);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getComponentValue(String string) {
        try {
            int n2 = -1;
            switch (string.hashCode()) {
                case 98728: {
                    if (!string.equals("cpu")) break;
                    n2 = 0;
                    break;
                }
                case 3023979: {
                    if (!string.equals("bios")) break;
                    n2 = 1;
                    break;
                }
                case 3083677: {
                    if (!string.equals("disk")) break;
                    n2 = 2;
                    break;
                }
                case 107855: {
                    if (!string.equals("mac")) break;
                    n2 = 3;
                    break;
                }
            }
            switch (n2) {
                case 0: {
                    return System.getenv("PROCESSOR_IDENTIFIER");
                }
                case 1: {
                    return HardwareIdentifier.getBIOSInfo();
                }
                case 2: {
                    return null;
                }
                case 3: {
                    return HardwareIdentifier.getMACAddress();
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getBIOSInfo() {
        String string = System.getProperty("java.vm.vendor") + System.getProperty("os.arch");
        if (string != null) {
            return string;
        }
        return null;
    }

    private static String getMACAddress() {
        try {
            Object object = NetworkInterface.getNetworkInterfaces();
            while (object.hasMoreElements()) {
                Object object2 = object.nextElement();
                byte[] byArray = ((NetworkInterface)object2).getHardwareAddress();
                if (byArray == null || byArray.length <= 0 || ((NetworkInterface)object2).isLoopback()) continue;
                object = new StringBuilder();
                object2 = byArray;
                int n2 = byArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object3 = object2[i2];
                    ((StringBuilder)object).append(String.format("%02X", (byte)object3));
                }
                return ((StringBuilder)object).toString();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private static String generateHash(String string) {
        try {
            Object object = MessageDigest.getInstance("SHA-256");
            ((MessageDigest)object).update(SALT.getBytes());
            object = ((MessageDigest)object).digest(string.getBytes());
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object2 : object) {
                stringBuilder.append(String.format("%02x", (byte)object2));
            }
            return stringBuilder.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return string;
        }
    }

    public static class HardwareID {
        public final String id;
        public final String componentType;

        public HardwareID(String string, String string2) {
            this.id = string;
            this.componentType = string2;
        }
    }
}

