/*
 * Decompiled with CFR 0.152.
 */
package SYSTEM;

import SYSTEM.HardwareIdentifier;
import SYSTEM.LocalLicense;
import SYSTEM.OnlineLicense;
import com.google.gson.JsonObject;
import fiskalizacija.HrFiskalizator;
import fiskalizacija.SysUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.time.ZoneId;
import java.util.Base64;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class LicenseManager {
    private static final long CHECK_INTERVAL_MINUTES = 1L;
    private static Timer checkTimer;
    private static boolean isValid;

    private static String generateUniqueId(String string, String string2) {
        try {
            Object object = string + ":" + string2;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            object = messageDigest.digest(((String)object).getBytes());
            return Base64.getEncoder().encodeToString((byte[])object).substring(0, 32);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Base64.getEncoder().encodeToString((string + ":" + string2).getBytes()).substring(0, 32);
        }
    }

    public static String getUniqueIdForComponent(String string) {
        try {
            Object object = HardwareIdentifier.getUniqueID();
            object = ((HardwareIdentifier.HardwareID)object).id;
            return LicenseManager.generateUniqueId((String)object, string);
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    public static boolean isLicenceValid(String string) {
        if (HrFiskalizator.licenceList.has(string)) {
            Object object = HrFiskalizator.licenceList.get(string).getAsJsonObject();
            object = ((JsonObject)object).get("expiry").getAsString();
            try {
                object = SysUtil.sdf.parse((String)object);
                long l2 = ((Date)object).getTime();
                long l3 = System.currentTimeMillis();
                return l2 >= l3;
            }
            catch (ParseException parseException) {
                System.err.println("Gre\u0161ka pri parsiranju datuma za " + string + ": " + parseException.getMessage());
                return false;
            }
        }
        return false;
    }

    public static void addLicenceToList(String string, String string2, long l2) {
        JsonObject jsonObject = new JsonObject();
        Date date = new Date(l2);
        jsonObject.addProperty("componentname", string);
        jsonObject.addProperty("uniqueid", string2);
        jsonObject.addProperty("expiry", SysUtil.sdf.format(date));
        HrFiskalizator.licenceList.add(string, jsonObject);
    }

    public static boolean validateLicense(String string, String string2) {
        SysUtil.vdevout("=== LICENSE VALIDATION START for " + string + " ===");
        try {
            Object object = HardwareIdentifier.getUniqueID();
            if (object == null) {
                System.err.println("ERROR: Cannot identify hardware!");
                return false;
            }
            object = ((HardwareIdentifier.HardwareID)object).id;
            String string3 = LicenseManager.generateUniqueId((String)object, string);
            SysUtil.vdevout("Hardware ID: " + (String)object);
            SysUtil.vdevout("Unique ID for " + string + ": " + string3);
            SysUtil.vdevout("Calling online check (always)...");
            object = OnlineLicense.checkLicense(string3, string, string2, null);
            SysUtil.vdevout("Online check response: " + (object != null ? "success=" + ((OnlineLicense.LicenseResponse)object).success + ", message=" + ((OnlineLicense.LicenseResponse)object).message : "null"));
            if (object != null && ((OnlineLicense.LicenseResponse)object).success) {
                long l2 = ((OnlineLicense.LicenseResponse)object).expiryDate.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                SysUtil.vdevout("Server expiry: " + l2 + " (" + new Date(l2) + ")");
                LicenseManager.addLicenceToList(string, string3, l2);
                if (l2 < System.currentTimeMillis()) {
                    SysUtil.vdevout("License EXPIRED (server check) - user must activate with password");
                    System.err.println("License expired. Please activate with password using activateWithPassword().");
                    LicenseManager.addLicenceToList(string, string3, System.currentTimeMillis() - 86400000L);
                    return false;
                }
                SysUtil.vdevout("License valid from server");
                isValid = true;
                return true;
            }
            if (object != null && ((OnlineLicense.LicenseResponse)object).message != null && ((OnlineLicense.LicenseResponse)object).message.contains("Not found")) {
                SysUtil.vdevout("Server returned 'Not found' - attempting to register...");
                OnlineLicense.LicenseResponse licenseResponse = OnlineLicense.registerLicense(string3, string, string2);
                if (licenseResponse != null && licenseResponse.success) {
                    long l3 = licenseResponse.expiryDate.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                    SysUtil.vdevout("Registration successful, expiry: " + l3 + " (" + new Date(l3) + ")");
                    LicenseManager.addLicenceToList(string, string3, l3);
                    SysUtil.vdevout("License registered from server");
                    isValid = true;
                    return true;
                }
                System.err.println("Registration failed: " + (licenseResponse != null ? licenseResponse.message : "null"));
                if ("HrFiskalizator".equals(string)) {
                    SysUtil.vdevout("Registration failed for main component, allowing operation (proxy server needs internet)");
                    isValid = true;
                    return true;
                }
                System.err.println("Registration failed for " + string);
                return false;
            }
            if (object != null && ((OnlineLicense.LicenseResponse)object).message != null && ((OnlineLicense.LicenseResponse)object).message.contains("License expired")) {
                SysUtil.vdevout("Licence expired for " + string);
                isValid = false;
                if (string.equals("HrFiskalizator")) {
                    LicenseManager.addLicenceToList(string, string3, SysUtil.tomorrowDate());
                }
                return false;
            }
            SysUtil.vdevout("Server unavailable (" + (object != null ? ((OnlineLicense.LicenseResponse)object).message : "null") + "), OFFLINE MODE: allowing operation");
            SysUtil.vdevout("Proxy server requires internet connection - assuming license is valid");
            isValid = true;
            LicenseManager.addLicenceToList(string, string3, System.currentTimeMillis() + 86400000L);
            return true;
        }
        catch (Exception exception) {
            SysUtil.vdevout("Exception during license check: " + exception.getMessage());
            SysUtil.vdevout("OFFLINE MODE: allowing operation (proxy server needs internet)");
            isValid = true;
            try {
                Object object = HardwareIdentifier.getUniqueID();
                if (object != null) {
                    String string4 = ((HardwareIdentifier.HardwareID)object).id;
                    object = LicenseManager.generateUniqueId(string4, string);
                    LicenseManager.addLicenceToList(string, (String)object, System.currentTimeMillis() + 86400000L);
                }
            }
            catch (Exception exception2) {
                System.err.println("Error generating unique ID: " + exception2.getMessage());
            }
            return true;
        }
    }

    public static void stopChecks() {
        if (checkTimer != null) {
            checkTimer.cancel();
            checkTimer = null;
        }
    }

    private static void startPeriodicChecks(final String string, final String string2, final String string3) {
        checkTimer = new Timer(true);
        checkTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public final void run() {
                try {
                    Object object = new LocalLicense(string2);
                    object = OnlineLicense.checkLicense(string, string2, string3, (LocalLicense)object);
                    if (!((OnlineLicense.LicenseResponse)object).success) {
                        System.err.println("Periodic license check failed: " + ((OnlineLicense.LicenseResponse)object).message);
                        return;
                    }
                    SysUtil.vdevout("License check OK, expiry: " + ((OnlineLicense.LicenseResponse)object).expiryDate);
                    LocalLicense localLicense = new LocalLicense(string2);
                    localLicense.setExpiryTime(((OnlineLicense.LicenseResponse)object).expiryDate.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
                    LicenseManager.stopChecks();
                }
                catch (Exception exception) {
                    System.err.println("Periodic check error: " + exception.getMessage());
                }
            }
        }, 60000L, 60000L);
    }

    public static boolean isLicenseValid() {
        return isValid;
    }

    public static String activateWithPassword(String object, String string, String string2, String string3, String string4) {
        try {
            SysUtil.vdevout("=== LICENSE ACTIVATION START for " + string + " ===");
            object = OnlineLicense.activateLicense((String)object, string, string2, string3, string4);
            if (((OnlineLicense.LicenseResponse)object).success) {
                SysUtil.vdevout("Activation successful for " + string + ". Expiry: " + ((OnlineLicense.LicenseResponse)object).expiryDate);
                return ((OnlineLicense.LicenseResponse)object).message;
            }
            System.err.println("Activation failed for " + string + ": " + ((OnlineLicense.LicenseResponse)object).message);
            return ((OnlineLicense.LicenseResponse)object).message;
        }
        catch (Exception exception) {
            System.err.println("Activation error for " + string + ": " + exception.getMessage());
            return exception.getMessage();
        }
    }

    public static void setVersion(String string, String string2) {
        SysUtil.vdevout("=== SET VERSION START for " + string + " to " + string2 + " ===");
        LocalLicense localLicense = new LocalLicense(string);
        if (localLicense.isInitialized()) {
            int n2;
            Object object = localLicense.getVersion();
            boolean bl2 = false;
            if (object == null) {
                n2 = 1;
            } else {
                try {
                    n2 = Integer.parseInt((String)object);
                    int n3 = Integer.parseInt(string2.replaceAll("[^0-9]", ""));
                    if ((n2 = n3 > n2 ? 1 : 0) != 0 && n3 >= 79) {
                        bl2 = true;
                        SysUtil.vdevout("New version " + n3 + " requires license reset");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    int n4 = n2 = !string2.equals(object) ? 1 : 0;
                }
            }
            if (n2 != 0) {
                String string3 = localLicense.getHardwareId();
                if (string3 != null) {
                    String string4 = LicenseManager.generateUniqueId(string3, string);
                    if (bl2) {
                        SysUtil.vdevout("Resetting license for version upgrade...");
                        long l2 = System.currentTimeMillis() + 5184000000L;
                        localLicense.setExpiryTime(l2);
                        SysUtil.vdevout("License reset to " + new Date(l2));
                        try {
                            object = OnlineLicense.updateVersion(string4, string, string2 + "_RESET");
                            if (((OnlineLicense.LicenseResponse)object).success) {
                                SysUtil.vdevout("License reset notified to server");
                            }
                        }
                        catch (Exception exception) {
                            SysUtil.vdevout("Server notification failed, but local reset done");
                        }
                    }
                    OnlineLicense.LicenseResponse licenseResponse = OnlineLicense.updateVersion(string4, string, string2);
                    if (licenseResponse.success) {
                        SysUtil.vdevout("Version updated to " + string2 + " for " + string);
                        localLicense.updateVersion(string2.replaceAll("[^0-9]", ""));
                    } else {
                        System.err.println("Version update failed for " + string + ": " + licenseResponse.message);
                    }
                }
            } else {
                SysUtil.vdevout("Version " + string2 + " is not newer than current " + (String)object + ", skipping update");
            }
        } else {
            SysUtil.vdevout("License not initialized for " + string + ", skipping version update");
        }
        SysUtil.vdevout("=== SET VERSION END ===");
    }

    static {
        isValid = false;
    }
}

