/*
 * Decompiled with CFR 0.152.
 */
package SYSTEM;

import UTIL.EnhProperies;
import fiskalizacija.Cfg;
import fiskalizacija.HrFiskalizator;
import fiskalizacija.SysUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class LocalLicense {
    private static final String LICENSE_DATA_SUFFIX = "_LICENSE_DATA";
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final int KEY_LENGTH = 256;
    private EnhProperies props;
    private String componentName;
    private String licenseKey;
    private LicenseData cachedData = null;

    public LocalLicense(String string) {
        this.componentName = string;
        this.licenseKey = string + LICENSE_DATA_SUFFIX;
        this.props = HrFiskalizator.p;
        if (this.props == null) {
            this.props = new EnhProperies();
        }
    }

    private static byte[] generateKey() {
        Object object = Cfg.getPass(2);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] byArray = messageDigest.digest(((String)object).getBytes(StandardCharsets.UTF_8));
        object = byArray;
        return Arrays.copyOf(byArray, 32);
    }

    private static String encrypt(String object) {
        Object object2 = LocalLicense.generateKey();
        object2 = new SecretKeySpec((byte[])object2, "AES");
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        Object object3 = new SecureRandom();
        byte[] byArray = new byte[16];
        ((SecureRandom)object3).nextBytes(byArray);
        object3 = new IvParameterSpec(byArray);
        cipher.init(1, (Key)object2, (AlgorithmParameterSpec)object3);
        object = cipher.doFinal(((String)object).getBytes(StandardCharsets.UTF_8));
        object2 = new byte[byArray.length + ((Object)object).length];
        System.arraycopy(byArray, 0, object2, 0, byArray.length);
        System.arraycopy(object, 0, object2, byArray.length, ((Object)object).length);
        return Base64.getEncoder().encodeToString((byte[])object2);
    }

    private static String decrypt(String object) {
        Object object2 = LocalLicense.generateKey();
        object2 = new SecretKeySpec((byte[])object2, "AES");
        byte[] byArray = Base64.getDecoder().decode((String)object);
        object = byArray;
        Object object3 = Arrays.copyOfRange(byArray, 0, 16);
        object = Arrays.copyOfRange((byte[])object, 16, ((Object)object).length);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        object3 = new IvParameterSpec((byte[])object3);
        cipher.init(2, (Key)object2, (AlgorithmParameterSpec)object3);
        object = cipher.doFinal((byte[])object);
        return new String((byte[])object, StandardCharsets.UTF_8);
    }

    public void initializeLicense(String object) {
        if (!this.isInitialized()) {
            object = new LicenseData((String)object, 0L, Cfg.getVERSION());
            this.saveLicenseData((LicenseData)object);
        }
    }

    public boolean isInitialized() {
        return this.getLicenseData() != null;
    }

    public String getHardwareId() {
        LicenseData licenseData = this.getLicenseData();
        if (licenseData != null) {
            return licenseData.hardwareId;
        }
        return null;
    }

    public long getExpiryTime() {
        LicenseData licenseData = this.getLicenseData();
        if (licenseData != null) {
            return licenseData.expiryTime;
        }
        return 0L;
    }

    public void setExpiryTime(long l2) {
        LicenseData licenseData = this.getLicenseData();
        if (licenseData != null) {
            licenseData.expiryTime = l2;
            this.saveLicenseData(licenseData);
        }
    }

    public void updateVersion(String string) {
        LicenseData licenseData = this.getLicenseData();
        if (licenseData != null) {
            licenseData.version = string;
            this.saveLicenseData(licenseData);
        }
    }

    public String getVersion() {
        LicenseData licenseData = this.getLicenseData();
        if (licenseData != null) {
            return licenseData.version;
        }
        return null;
    }

    public boolean isExpired() {
        return this.getExpiryTime() < System.currentTimeMillis();
    }

    private LicenseData getLicenseData() {
        if (this.cachedData != null) {
            return this.cachedData;
        }
        try {
            String string = this.props.getProperty(this.licenseKey);
            if (string == null || string.isEmpty()) {
                SysUtil.vdevout("No encrypted data found for " + this.licenseKey);
                return null;
            }
            SysUtil.vdevout("Encrypted data for " + this.licenseKey + ": " + string);
            string = LocalLicense.decrypt(string);
            SysUtil.vdevout("Decrypted JSON for " + this.licenseKey + ": " + string);
            this.cachedData = this.parseJson(string);
            return this.cachedData;
        }
        catch (Exception exception) {
            System.err.println("Error getting license data for " + this.componentName + ": " + exception.getMessage());
            return null;
        }
    }

    private void saveLicenseData(LicenseData licenseData) {
        try {
            String string = this.toJson(licenseData);
            String string2 = LocalLicense.encrypt(string);
            this.props.setProperty(this.licenseKey, string2);
            this.cachedData = licenseData;
            this.saveIniFile();
            SysUtil.vdevout("License data saved to ini for " + this.componentName + ": " + string);
            return;
        }
        catch (Exception exception) {
            System.err.println("Error saving license data for " + this.componentName + ": " + exception.getMessage());
            return;
        }
    }

    private void saveIniFile() {
        try {
            Object object = new File(Cfg.getIniName());
            object = new FileOutputStream((File)object);
            Throwable throwable = null;
            try {
                this.props.store((OutputStream)object, "HrFiskalizator Configuration");
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            ((FileOutputStream)object).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((FileOutputStream)object).close();
                    }
                    throw throwable4;
                }
            }
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {}
    }

    private LicenseData parseJson(String string) {
        try {
            SysUtil.vdevout("Parsing JSON: " + string);
            String string2 = this.extractJsonValue(string, "hardware_id");
            long l2 = 0L;
            String string3 = this.extractJsonValue(string, "expiry_time");
            if (string3 != null) {
                l2 = Long.parseLong(string3);
            }
            if ((string = this.extractJsonValue(string, "version")) == null) {
                string = "75";
            }
            if (string2 != null) {
                return new LicenseData(string2, l2, string);
            }
        }
        catch (Exception exception) {
            System.err.println("Error parsing JSON: " + exception.getMessage());
        }
        return null;
    }

    private String toJson(LicenseData licenseData) {
        return String.format("{\"hardware_id\":\"%s\",\"expiry_time\":%d,\"version\":\"%s\"}", licenseData.hardwareId, licenseData.expiryTime, licenseData.version);
    }

    private String extractJsonValue(String object, String object2) {
        Object object3 = "\"" + (String)object2 + "\":\"([^\"]+)\"";
        object3 = Pattern.compile((String)object3);
        if (((Matcher)(object3 = ((Pattern)object3).matcher((CharSequence)object))).find()) {
            return ((Matcher)object3).group(1);
        }
        object2 = "\"" + (String)object2 + "\":([0-9]+)";
        object = ((Pattern)(object2 = Pattern.compile((String)object2))).matcher((CharSequence)object);
        if (((Matcher)object).find()) {
            return ((Matcher)object).group(1);
        }
        return null;
    }

    private static class LicenseData {
        public final String hardwareId;
        public long expiryTime;
        public String version;

        public LicenseData(String string, long l2, String string2) {
            this.hardwareId = string;
            this.expiryTime = l2;
            this.version = string2;
        }
    }
}

