/*
 * Decompiled with CFR 0.152.
 */
package SYSTEM;

import SYSTEM.LocalLicense;
import UTIL.StringUtils;
import fiskalizacija.Cfg;
import fiskalizacija.HttpsClient;
import fiskalizacija.SysUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLConnection;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;

public class OnlineLicense {
    private static final String SERVER_URL = Cfg.keypath;
    private static final String API_KEY = Cfg.getPass(2);

    public static String registerNewProgramer(String object, String object2, String object3) {
        if (StringUtils.isEmpty((String)object) || StringUtils.isEmpty((String)object2) || StringUtils.isEmpty((String)object3)) {
            return "Name, password and email are required for registration.";
        }
        try {
            object = String.format("registerprogramer|%s|%s|%s|%s", object, object2, object3, LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            object = Base64.getEncoder().encodeToString(object.getBytes("UTF-8"));
            object = "{\"data\":\"" + (String)object + "\"}";
            object2 = new HttpsClient();
            object3 = ((HttpsClient)object2).createHttpsConn(SERVER_URL, "POST", "application/json");
            ((URLConnection)object3).setRequestProperty("X-HrFiskalizator-Key", API_KEY);
            object = new ByteArrayInputStream(object.getBytes("UTF-8"));
            object = ((HttpsClient)object2).httpsProxyReader((HttpsURLConnection)object3, (InputStream)object);
            int n2 = (Integer)object[0];
            object = new String((byte[])object[1]);
            if (n2 == 200) {
                return "Registration status: " + (String)object;
            }
            return "Registration failed: " + n2 + " - " + (String)object;
        }
        catch (Exception exception) {
            return "Registration error: " + exception.getMessage();
        }
    }

    public static LicenseResponse checkLicense(String object, String object2, String object3, LocalLicense localLicense) {
        SysUtil.vdevout("=== ONLINE LICENSE CHECK START ===");
        SysUtil.vdevout("uniqueId: " + (String)object + ", version: " + (String)object3);
        SysUtil.vdevout("SERVER_URL: " + SERVER_URL);
        try {
            object = OnlineLicense.createPayload((String)object, (String)object2, (String)object3);
            object = Base64.getEncoder().encodeToString(object.getBytes("UTF-8"));
            object = "{\"data\":\"" + (String)object + "\"}";
            object2 = new HttpsClient();
            object3 = ((HttpsClient)object2).createHttpsConn(SERVER_URL, "POST", "application/json");
            ((URLConnection)object3).setRequestProperty("X-HrFiskalizator-Key", API_KEY);
            object = new ByteArrayInputStream(object.getBytes("UTF-8"));
            object = ((HttpsClient)object2).httpsProxyReader((HttpsURLConnection)object3, (InputStream)object);
            int n2 = (Integer)object[0];
            object = new String((byte[])object[1]);
            SysUtil.vdevout("Response code: " + n2);
            SysUtil.vdevout("Response body: " + (String)object);
            if (n2 == 200) {
                object = OnlineLicense.parseResponse((String)object);
                SysUtil.vdevout("Parsed response: success=" + object.success + ", message=" + object.message);
                if (object.success && object.expiryDate != null) {
                    object.expiryDate.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                    if (object.expiryDate.getYear() >= 2050) {
                        SysUtil.vdevout("Server returned registration date (2050+), updating local license as REGISTERED");
                        if (localLicense != null) {
                            localLicense.setExpiryTime(2524608000000L);
                        }
                    }
                }
                return object;
            }
            SysUtil.vdevout("Server error response");
            return new LicenseResponse(false, "Server error: " + n2 + " - " + (String)object, null);
        }
        catch (Exception exception) {
            SysUtil.vdevout("Exception in online check: " + exception.getMessage());
            return new LicenseResponse(false, "Connection error: " + exception.getMessage(), null);
        }
    }

    public static LicenseResponse registerLicense(String object, String object2, String object3) {
        try {
            object = OnlineLicense.createRegisterPayload((String)object, (String)object2, (String)object3);
            object = Base64.getEncoder().encodeToString(object.getBytes("UTF-8"));
            object = "{\"data\":\"" + (String)object + "\"}";
            object2 = new HttpsClient();
            object3 = ((HttpsClient)object2).createHttpsConn(SERVER_URL, "POST", "application/json");
            ((URLConnection)object3).setRequestProperty("X-HrFiskalizator-Key", API_KEY);
            object = new ByteArrayInputStream(object.getBytes("UTF-8"));
            object = ((HttpsClient)object2).httpsProxyReader((HttpsURLConnection)object3, (InputStream)object);
            int n2 = (Integer)object[0];
            object = new String((byte[])object[1]);
            if (n2 == 200) {
                return OnlineLicense.parseResponse((String)object);
            }
            return new LicenseResponse(false, "Register failed: " + n2 + " - " + (String)object, null);
        }
        catch (Exception exception) {
            return new LicenseResponse(false, "Register error: " + exception.getMessage(), null);
        }
    }

    private static String createPayload(String string, String string2, String string3) {
        return String.format("check|%s|%s|%s", string, string3, LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
    }

    public static LicenseResponse updateVersion(String object, String object2, String object3) {
        SysUtil.vdevout("=== UPDATE VERSION START ===");
        SysUtil.vdevout("uniqueId: " + (String)object + ", componentName: " + (String)object2 + ", newVersion: " + (String)object3);
        try {
            object = OnlineLicense.createUpdatePayload((String)object, (String)object2, (String)object3);
            SysUtil.vdevout("Update payload: " + (String)object);
            object = Base64.getEncoder().encodeToString(object.getBytes("UTF-8"));
            object = "{\"data\":\"" + (String)object + "\"}";
            SysUtil.vdevout("JSON data: " + (String)object);
            object2 = SERVER_URL;
            SysUtil.vdevout("Update URL: " + (String)object2);
            object3 = new HttpsClient();
            object2 = ((HttpsClient)object3).createHttpsConn((String)object2, "POST", "application/json");
            ((URLConnection)object2).setRequestProperty("X-HrFiskalizator-Key", API_KEY);
            object = new ByteArrayInputStream(object.getBytes("UTF-8"));
            object = ((HttpsClient)object3).httpsProxyReader((HttpsURLConnection)object2, (InputStream)object);
            int n2 = (Integer)object[0];
            object = new String((byte[])object[1]);
            SysUtil.vdevout("Update response code: " + n2);
            SysUtil.vdevout("Update response body: " + (String)object);
            if (n2 == 200) {
                object = OnlineLicense.parseResponse((String)object);
                SysUtil.vdevout("Parsed update response: success=" + object.success + ", message=" + object.message);
                return object;
            }
            object = new LicenseResponse(false, "Update failed: " + n2 + " - " + (String)object, null);
            return object;
        }
        catch (Exception exception) {
            System.err.println("Update exception: " + exception.getMessage());
            LicenseResponse licenseResponse = new LicenseResponse(false, "Update error: " + exception.getMessage(), null);
            return licenseResponse;
        }
        finally {
            SysUtil.vdevout("=== UPDATE VERSION END ===");
        }
    }

    public static LicenseResponse activateLicense(String object, String object2, String object3, String string, String string2) {
        try {
            object = OnlineLicense.createActivationPayload((String)object, (String)object2, string, (String)object3, string2);
            object = Base64.getEncoder().encodeToString(object.getBytes("UTF-8"));
            object = "{\"data\":\"" + (String)object + "\"}";
            object2 = new HttpsClient();
            object3 = ((HttpsClient)object2).createHttpsConn(SERVER_URL.replace("check", "activate"), "POST", "application/json");
            ((URLConnection)object3).setRequestProperty("X-HrFiskalizator-Key", API_KEY);
            object = new ByteArrayInputStream(object.getBytes("UTF-8"));
            object = ((HttpsClient)object2).httpsProxyReader((HttpsURLConnection)object3, (InputStream)object);
            int n2 = (Integer)object[0];
            object = new String((byte[])object[1]);
            if (n2 == 200) {
                return OnlineLicense.parseResponse((String)object);
            }
            return new LicenseResponse(false, "Activation failed: " + n2 + " - " + (String)object, null);
        }
        catch (Exception exception) {
            return new LicenseResponse(false, "Activation error: " + exception.getMessage(), null);
        }
    }

    private static String createRegisterPayload(String string, String string2, String string3) {
        return String.format("register|%s|%s|%s", string, string3, LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
    }

    private static String createActivationPayload(String string, String string2, String string3, String string4, String string5) {
        return String.format("activate|%s|%s|%s|%s|%s", string, string4, string5, string2, string3);
    }

    private static String createUpdatePayload(String string, String string2, String string3) {
        return String.format("update|%s|%s|%s", string, string3, LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
    }

    private static LicenseResponse parseResponse(String string) {
        try {
            if (string.contains("\"status\":\"ok\"")) {
                string = OnlineLicense.extractValue(string, "expiry");
                LocalDateTime localDateTime = null;
                if (string != null) {
                    try {
                        localDateTime = LocalDateTime.parse(string, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    }
                    catch (Exception exception) {
                        try {
                            localDateTime = LocalDateTime.parse(string, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                        }
                        catch (Exception exception2) {
                            System.err.println("Could not parse expiry date: " + string);
                        }
                    }
                }
                return new LicenseResponse(true, "OK", localDateTime);
            }
            return new LicenseResponse(false, (string = OnlineLicense.extractValue(string, "message")) != null ? string : "Unknown error", null);
        }
        catch (Exception exception) {
            return new LicenseResponse(false, "Parse error: " + exception.getMessage(), null);
        }
    }

    private static String extractValue(String object, String object2) {
        object2 = "\"" + (String)object2 + "\":\"([^\"]+)\"";
        object = ((Pattern)(object2 = Pattern.compile((String)object2))).matcher((CharSequence)object);
        if (((Matcher)object).find()) {
            return ((Matcher)object).group(1);
        }
        return null;
    }

    public static class LicenseResponse {
        public final boolean success;
        public final String message;
        public final LocalDateTime expiryDate;

        public LicenseResponse(boolean bl2, String string, LocalDateTime localDateTime) {
            this.success = bl2;
            this.message = string;
            this.expiryDate = localDateTime;
        }
    }
}

