/*
 * Decompiled with CFR 0.152.
 */
package UTIL;

import UTIL.EnhProperies;
import fiskalizacija.HrFiskalizator;
import fiskalizacija.SysUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;

public class StringUtils {
    public static String EnhProperiesToJson(EnhProperies enhProperies) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        boolean bl2 = true;
        for (String string : enhProperies.stringPropertyNames()) {
            if (!bl2) {
                stringBuilder.append(", ");
            }
            bl2 = false;
            String string2 = enhProperies.getProperty(string);
            stringBuilder.append("\"").append(StringUtils.escapeJson(string)).append("\": ");
            if (string2 == null) {
                stringBuilder.append("null");
                continue;
            }
            stringBuilder.append("\"").append(StringUtils.escapeJson(string2)).append("\"");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static String escapeJson(String object) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n2 = cArray.length;
        block9: for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = object[i2];
            switch (object2) {
                case 34: {
                    stringBuilder.append("\\\"");
                    continue block9;
                }
                case 92: {
                    stringBuilder.append("\\\\");
                    continue block9;
                }
                case 8: {
                    stringBuilder.append("\\b");
                    continue block9;
                }
                case 12: {
                    stringBuilder.append("\\f");
                    continue block9;
                }
                case 10: {
                    stringBuilder.append("\\n");
                    continue block9;
                }
                case 13: {
                    stringBuilder.append("\\r");
                    continue block9;
                }
                case 9: {
                    stringBuilder.append("\\t");
                    continue block9;
                }
                default: {
                    if (object2 < 32 || object2 > 126) {
                        stringBuilder.append(String.format("\\u%04x", (int)object2));
                        continue block9;
                    }
                    stringBuilder.append((char)object2);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String convertFromUTF8(String string) {
        try {
            string = new String(string.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        return string;
    }

    public static String convertToUTF8(String string) {
        try {
            string = new String(string.getBytes("UTF-8"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        return string;
    }

    public static String getUrlTxt(String string) {
        return new String(StringUtils.getUrlBytes(string));
    }

    public static String reverseString(String object) {
        object = ((String)object).toCharArray();
        String string = "";
        for (int i2 = ((Object)object).length - 1; i2 >= 0; --i2) {
            string = string + (char)object[i2];
        }
        return string;
    }

    public static String inputStream2String(InputStream inputStream) {
        int n2;
        byte[] byArray = new byte[1024];
        StringBuilder stringBuilder = new StringBuilder(1024);
        while ((n2 = inputStream.read(byArray)) != -1) {
            stringBuilder.append(new String(byArray, 0, n2));
        }
        return stringBuilder.toString();
    }

    public static String currentDate() {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd/mm/yy");
        return localDateTime.format(dateTimeFormatter);
    }

    public static String addToList(String string, String stringArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringArray = stringArray.split(";");
        for (int i2 = 0; i2 < stringArray.length && i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (string2.equals(string)) continue;
            stringBuilder.append(";");
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static byte[] add(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            if (byArray2 == null) {
                return new byte[0];
            }
            return byArray2;
        }
        if (byArray2 == null) {
            return byArray;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte[] is2bytaArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try {
                byte[] byArray = new byte[4096];
                try {
                    int n2;
                    while ((n2 = inputStream.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n2);
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {}
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] getUrlBytes(String object) {
        byte[] byArray = "".getBytes();
        Integer n2 = Integer.valueOf(HrFiskalizator.p.getProperty("CISTIMEOUT"));
        try {
            object = new URL((String)object).openConnection();
            ((URLConnection)object).setConnectTimeout(n2);
            ((URLConnection)object).setReadTimeout(n2);
            object = ((URLConnection)object).getInputStream();
            byArray = StringUtils.is2bytaArray((InputStream)object);
        }
        catch (IOException iOException) {}
        SysUtil.clearMemory();
        return byArray;
    }

    public static String humanReadableByteCount(long l2, boolean bl2) {
        int n2;
        int n3 = n2 = bl2 ? 1000 : 1024;
        if (l2 < (long)n2) {
            return l2 + " B";
        }
        int n4 = (int)(Math.log(l2) / Math.log(n2));
        String string = (bl2 ? "kMGTPE" : "KMGTPE").charAt(n4 - 1) + (bl2 ? "" : "i");
        return String.format("%.1f %sB", (double)l2 / Math.pow(n2, n4), string);
    }

    public static int indexOfStrArray(String[] stringArray, String string) {
        int n2 = -1;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!string.equals(stringArray[i2])) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    public static boolean isBlank(String string) {
        int n2;
        if (string != null && (n2 = string.length()) != 0) {
            --n2;
            while (n2 >= 0) {
                if (!Character.isWhitespace(string.charAt(n2))) {
                    return false;
                }
                --n2;
            }
            return true;
        }
        return true;
    }

    public static boolean isValTrue(String string) {
        return string != null && string != "" && string.toUpperCase().equals("TRUE");
    }

    public static boolean isNotBlank(String string) {
        int n2;
        if (string != null && (n2 = string.length()) != 0) {
            --n2;
            while (n2 >= 0) {
                if (!Character.isWhitespace(string.charAt(n2))) {
                    return true;
                }
                --n2;
            }
            return false;
        }
        return false;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isTrimmed(String string) {
        int n2;
        if (string != null && (n2 = string.length()) != 0) {
            return !Character.isWhitespace(string.charAt(0)) && !Character.isWhitespace(string.charAt(n2 - 1));
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        return string.regionMatches(true, 0, string2, 0, string2.length());
    }

    public static String abbreviateCenter(String string, int n2) {
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        if (n3 <= n2) {
            return string;
        }
        int n4 = n2 / 2;
        n2 = n2 - n4 - 1;
        String string2 = string.substring(0, n4);
        string = string.substring(n3 - n2, n3);
        return string2 + "\u2026" + string;
    }

    public static String get(String string, Object ... objectArray) {
        if (objectArray != null && objectArray.length != 0) {
            return String.format(string, objectArray);
        }
        return string;
    }

    public static String createSHA256Hash(String string) {
        try {
            Object object = MessageDigest.getInstance("SHA-256");
            object = ((MessageDigest)object).digest(string.getBytes());
            return Base64.getEncoder().encodeToString((byte[])object);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Base64.getEncoder().encodeToString(string.getBytes());
        }
    }

    public static String createShortSHA256Hash(String string) {
        return StringUtils.createSHA256Hash(string).substring(0, Math.min(32, StringUtils.createSHA256Hash(string).length()));
    }

    public static String createSHA256HashHex(String string) {
        try {
            Object object = MessageDigest.getInstance("SHA-256");
            object = ((MessageDigest)object).digest(string.getBytes());
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object2 : object) {
                String string2 = Integer.toHexString(0xFF & object2);
                if (string2.length() == 1) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return StringUtils.createSHA256Hash(string);
        }
    }

    public static String reverseUrlencodedBase64String(String string) {
        string = new String(Base64.getDecoder().decode(string));
        return URLDecoder.decode(string, "UTF-8");
    }
}

