/*
 * Decompiled with CFR 0.152.
 */
package UTIL;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public class WinRegistry {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int REG_SUCCESS = 0;
    public static final int REG_NOTFOUND = 2;
    public static final int REG_ACCESSDENIED = 5;
    private static final int KEY_ALL_ACCESS = 983103;
    private static final int KEY_READ = 131097;
    private static Preferences userRoot = Preferences.userRoot();
    private static Preferences systemRoot = Preferences.systemRoot();
    private static Class<? extends Preferences> userClass = userRoot.getClass();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regEnumValue = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;
    private static Method regCreateKeyEx = null;
    private static Method regSetValueEx = null;
    private static Method regDeleteKey = null;
    private static Method regDeleteValue = null;

    private WinRegistry() {
    }

    public static String readString(int n2, String string, String string2) {
        if (n2 == -2147483646) {
            return WinRegistry.readString(systemRoot, n2, string, string2);
        }
        if (n2 == -2147483647) {
            return WinRegistry.readString(userRoot, n2, string, string2);
        }
        throw new IllegalArgumentException("hkey=" + n2);
    }

    public static Map<String, String> readStringValues(int n2, String string) {
        if (n2 == -2147483646) {
            return WinRegistry.readStringValues(systemRoot, n2, string);
        }
        if (n2 == -2147483647) {
            return WinRegistry.readStringValues(userRoot, n2, string);
        }
        throw new IllegalArgumentException("hkey=" + n2);
    }

    public static List<String> readStringSubKeys(int n2, String string) {
        if (n2 == -2147483646) {
            return WinRegistry.readStringSubKeys(systemRoot, n2, string);
        }
        if (n2 == -2147483647) {
            return WinRegistry.readStringSubKeys(userRoot, n2, string);
        }
        throw new IllegalArgumentException("hkey=" + n2);
    }

    public static void createKey(int n2, String string) {
        int[] nArray;
        if (n2 == -2147483646) {
            nArray = WinRegistry.createKey(systemRoot, n2, string);
            regCloseKey.invoke((Object)systemRoot, new Integer(nArray[0]));
        } else if (n2 == -2147483647) {
            nArray = WinRegistry.createKey(userRoot, n2, string);
            regCloseKey.invoke((Object)userRoot, new Integer(nArray[0]));
        } else {
            throw new IllegalArgumentException("hkey=" + n2);
        }
        if (nArray[1] != 0) {
            throw new IllegalArgumentException("rc=" + nArray[1] + "  key=" + string);
        }
    }

    public static void writeStringValue(int n2, String string, String string2, String string3) {
        if (n2 == -2147483646) {
            WinRegistry.writeStringValue(systemRoot, n2, string, string2, string3);
            return;
        }
        if (n2 == -2147483647) {
            WinRegistry.writeStringValue(userRoot, n2, string, string2, string3);
            return;
        }
        throw new IllegalArgumentException("hkey=" + n2);
    }

    public static void deleteKey(int n2, String string) {
        int n3 = -1;
        if (n2 == -2147483646) {
            n3 = WinRegistry.deleteKey(systemRoot, n2, string);
        } else if (n2 == -2147483647) {
            n3 = WinRegistry.deleteKey(userRoot, n2, string);
        }
        if (n3 != 0) {
            throw new IllegalArgumentException("rc=" + n3 + "  key=" + string);
        }
    }

    public static void deleteValue(int n2, String string, String string2) {
        int n3 = -1;
        if (n2 == -2147483646) {
            n3 = WinRegistry.deleteValue(systemRoot, n2, string, string2);
        } else if (n2 == -2147483647) {
            n3 = WinRegistry.deleteValue(userRoot, n2, string, string2);
        }
        if (n3 != 0) {
            throw new IllegalArgumentException("rc=" + n3 + "  key=" + string + "  value=" + string2);
        }
    }

    private static int deleteValue(Preferences preferences, int n2, String string, String string2) {
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, n2, WinRegistry.toCstr(string), 983103);
        if (nArray[1] != 0) {
            return nArray[1];
        }
        int n3 = (Integer)regDeleteValue.invoke((Object)preferences, new Integer(nArray[0]), WinRegistry.toCstr(string2));
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
        return n3;
    }

    private static int deleteKey(Preferences preferences, int n2, String string) {
        int n3 = (Integer)regDeleteKey.invoke((Object)preferences, n2, WinRegistry.toCstr(string));
        return n3;
    }

    private static String readString(Preferences preferences, int n2, String object, String string) {
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, n2, WinRegistry.toCstr((String)object), 131097);
        if (nArray[1] != 0) {
            return null;
        }
        object = (byte[])regQueryValueEx.invoke((Object)preferences, new Integer(nArray[0]), WinRegistry.toCstr(string));
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
        if (object != null) {
            return new String((byte[])object).trim();
        }
        return null;
    }

    private static Map<String, String> readStringValues(Preferences preferences, int n2, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, n2, WinRegistry.toCstr(string), 131097);
        if (nArray[1] != 0) {
            return null;
        }
        int[] nArray2 = (int[])regQueryInfoKey.invoke((Object)preferences, new Integer(nArray[0]));
        int n3 = nArray2[0];
        int n4 = nArray2[3];
        for (int i2 = 0; i2 < n3; ++i2) {
            byte[] byArray = (byte[])regEnumValue.invoke((Object)preferences, new Integer(nArray[0]), i2, new Integer(n4 + 1));
            String string2 = WinRegistry.readString(n2, string, new String(byArray));
            hashMap.put(new String(byArray).trim(), string2);
        }
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
        return hashMap;
    }

    private static List<String> readStringSubKeys(Preferences preferences, int n2, String object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, n2, WinRegistry.toCstr((String)object), 131097);
        if (nArray[1] != 0) {
            return null;
        }
        int[] nArray2 = (int[])regQueryInfoKey.invoke((Object)preferences, new Integer(nArray[0]));
        object = nArray2;
        int n3 = nArray2[0];
        Object object2 = object[3];
        for (int i2 = 0; i2 < n3; ++i2) {
            byte[] byArray = (byte[])regEnumKeyEx.invoke((Object)preferences, new Integer(nArray[0]), i2, new Integer((int)(object2 + true)));
            arrayList.add(new String(byArray).trim());
        }
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
        return arrayList;
    }

    private static int[] createKey(Preferences preferences, int n2, String string) {
        return (int[])regCreateKeyEx.invoke((Object)preferences, n2, WinRegistry.toCstr(string));
    }

    private static void writeStringValue(Preferences preferences, int n2, String string, String string2, String string3) {
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, n2, WinRegistry.toCstr(string), 983103);
        regSetValueEx.invoke((Object)preferences, new Integer(nArray[0]), WinRegistry.toCstr(string2), WinRegistry.toCstr(string3));
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
    }

    private static byte[] toCstr(String string) {
        byte[] byArray = new byte[string.length() + 1];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
        byArray[string.length()] = 0;
        return byArray;
    }

    static {
        try {
            regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            regOpenKey.setAccessible(true);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            regCloseKey.setAccessible(true);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            regQueryValueEx.setAccessible(true);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumValue.setAccessible(true);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Integer.TYPE);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumKeyEx.setAccessible(true);
            regCreateKeyEx = userClass.getDeclaredMethod("WindowsRegCreateKeyEx", Integer.TYPE, byte[].class);
            regCreateKeyEx.setAccessible(true);
            regSetValueEx = userClass.getDeclaredMethod("WindowsRegSetValueEx", Integer.TYPE, byte[].class, byte[].class);
            regSetValueEx.setAccessible(true);
            regDeleteValue = userClass.getDeclaredMethod("WindowsRegDeleteValue", Integer.TYPE, byte[].class);
            regDeleteValue.setAccessible(true);
            regDeleteKey = userClass.getDeclaredMethod("WindowsRegDeleteKey", Integer.TYPE, byte[].class);
            regDeleteKey.setAccessible(true);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
    }
}

