/*
 * Decompiled with CFR 0.152.
 */
package UTIL;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Scanner;

public class WindowsDetails {
    public static void main(String[] stringArray) {
        System.out.println("\n *********************** SYSTEM DETAILS ***********************  ");
        WindowsDetails.systemDetails();
        System.out.println("\n *********************** MEMORY DETAILS ***********************  ");
        WindowsDetails.getMemoryDetails();
        System.out.println("\n *********************** BIOS SERIAL NUMBER ***********************  ");
        WindowsDetails.getBIOSSerialNumber();
        System.out.println("\n *********************** NETWORK DETAILS ***********************  ");
        WindowsDetails.getNetworkDetails();
        System.out.println("\n *********************** HARD DRIVE DETAILS ***********************  ");
        WindowsDetails.getHardDriveDetails();
    }

    public static void systemDetails() {
        System.getProperties().list(System.out);
    }

    private static void getMemoryDetails() {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        for (Method method : operatingSystemMXBean.getClass().getDeclaredMethods()) {
            method.setAccessible(true);
            long l2 = 0L;
            try {
                l2 = method.invoke((Object)operatingSystemMXBean, new Object[0]) != null ? Long.parseLong(method.invoke((Object)operatingSystemMXBean, new Object[0]).toString()) : 0L;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {}
            System.out.println(method.getName() + " : " + l2 + " Bytes");
        }
        System.out.println("No. of processors : " + Runtime.getRuntime().availableProcessors());
    }

    public static String getBIOSSerialNumber() {
        String string = "";
        try {
            Object object = Runtime.getRuntime().exec(new String[]{"wmic", "bios", "get", "serialnumber"});
            ((Process)object).getOutputStream().close();
            object = new Scanner(((Process)object).getInputStream());
            ((Scanner)object).next();
            string = ((Scanner)object).next();
        }
        catch (IOException iOException) {}
        return string;
    }

    public static String getSystemProperty(String string) {
        return System.getProperties().getProperty(string);
    }

    public static void getNetworkDetails() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                System.out.println(networkInterface.getName() + " : " + networkInterface.getDisplayName());
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void getHardDriveDetails() {
        File[] fileArray = File.listRoots();
        File[] fileArray2 = fileArray;
        fileArray2 = fileArray;
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            File file = fileArray2[i2];
            System.out.println("Drive :" + file);
            file = new File(file.toString());
            long l2 = file.getTotalSpace();
            long l3 = file.getFreeSpace();
            l2 = l2 / 1024L / 1024L / 1024L;
            l3 = l3 / 1024L / 1024L / 1024L;
            System.out.println("Total Drive Size : " + l2 + " GB");
            System.out.println("Free Space       : " + l3 + " GB");
            System.out.println("-------------------------------------");
        }
    }
}

