/*
 * Decompiled with CFR 0.152.
 */
package UTIL;

import UTIL.TxtFileWriter;
import fiskalizacija.HrFiskalizator;
import fiskalizacija.Utilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLrelated {
    public static Node getNodeFromDocument(String string, Document document) {
        return document.getElementsByTagName(string).item(0);
    }

    public static String escapeXml(String string) {
        if (string == null) {
            return "";
        }
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    public static String domToString(Document document) {
        Object object = TransformerFactory.newInstance();
        object = ((TransformerFactory)object).newTransformer();
        ((Transformer)object).setOutputProperty("omit-xml-declaration", "yes");
        ((Transformer)object).setOutputProperty("encoding", "UTF-8");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((Transformer)object).transform(new DOMSource(document), new StreamResult(byteArrayOutputStream));
        try {
            return new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static Document parseXml(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            return documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            return null;
        }
    }

    public static String formatXML(String string) {
        try {
            Object object = new InputSource(new StringReader(string));
            object = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((InputSource)object).getDocumentElement();
            Object object2 = DOMImplementationRegistry.newInstance();
            object2 = (DOMImplementationLS)((Object)((DOMImplementationRegistry)object2).getDOMImplementation("LS"));
            object2 = object2.createLSSerializer();
            object2.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            object2.getDomConfig().setParameter("xml-declaration", Boolean.TRUE);
            return object2.writeToString((Node)object);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return string;
        }
    }

    public static String SOAPmessageToXmlString(SOAPMessage sOAPMessage) {
        StringWriter stringWriter = new StringWriter();
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource((Node)sOAPMessage.getSOAPPart()), new StreamResult(stringWriter));
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
        return XMLrelated.formatXML(stringWriter.toString());
    }

    public static void SOAPmessageToXmlFile(String object, SOAPMessage sOAPMessage) {
        object = new TxtFileWriter((String)object, XMLrelated.SOAPmessageToXmlString(sOAPMessage));
        ((TxtFileWriter)object).save();
    }

    public static Document xmlStringToXMLDocument(String string) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.trim().getBytes());
        Utilities.setReceivedString(string);
        return XMLrelated.xmlStreamToXMLDocument(byteArrayInputStream);
    }

    public static boolean isSoapEnvelope(Document object) {
        if ((object = object.getDocumentElement()) == null) {
            return false;
        }
        String string = object.getNamespaceURI();
        return "Envelope".equals(object = object.getLocalName()) && "http://schemas.xmlsoap.org/soap/envelope/".equals(string);
    }

    public static Element findSoapBodyFirstChild(Document object) {
        if ((object = object.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body")).getLength() == 0) {
            return null;
        }
        object = (Element)object.item(0);
        for (object = object.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (object.getNodeType() != 1) continue;
            return (Element)object;
        }
        return null;
    }

    public static Document xmlStreamToXMLDocument(InputStream object) {
        try {
            Object object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setNamespaceAware(true);
            object2 = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            object = ((DocumentBuilder)object2).parse((InputStream)object);
            return object;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            HrFiskalizator.logger.log(Level.SEVERE, "Error pri konverziji xmlStreama u XMLDocument : \n === Received : === \n" + Utilities.getReceivedString() + "\n === End received ===", exception);
            return null;
        }
    }

    public static String serializeDocument(Document document) {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "no");
        transformer.setOutputProperty("encoding", "UTF-8");
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    public static String removeXmlRemarks(String string) {
        if (string == null) {
            return null;
        }
        string = Pattern.compile("<!--.*?-->", 32).matcher(string).replaceAll("");
        string = string.replaceAll("(?m)^\\s*$\\n?", "");
        return string;
    }
}

