/*
 * Decompiled with CFR 0.152.
 */
package UTIL;

import UTIL.SaxonXSLTProcessor;
import fiskalizacija.HrFiskalizator;
import fiskalizacija.SysUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLtester {
    public boolean DEVOUT = false;

    public static void main(String[] stringArray) {
    }

    public String testXmlAgainstXsdString(String string, String object) {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            object = schemaFactory.newSchema(new StreamSource(new StringReader((String)object)));
            string = this.testXmlAgainstShema(string, (Schema)object);
        }
        catch (Exception exception) {
            object = exception;
            string = exception.getMessage();
        }
        return string;
    }

    public String testXmlAgainstXsdFile(String string, String object) {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        object = new File((String)object);
        try {
            object = schemaFactory.newSchema((File)object);
            string = this.testXmlAgainstShema(string, (Schema)object);
        }
        catch (Exception exception) {
            object = exception;
            string = exception.getMessage();
        }
        return string;
    }

    public String testXmlAgainstXsdUrl(String object, String object2) {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            object2 = schemaFactory.newSchema(new URL((String)object2));
            try {
                object = this.testXmlAgainstShema((String)object, (Schema)object2);
            }
            catch (Exception exception) {
                object = exception;
                object = exception.getMessage();
            }
        }
        catch (SAXException sAXException) {
            object2 = sAXException;
            object = sAXException.getMessage();
        }
        catch (MalformedURLException malformedURLException) {
            object = "MalformedURLException " + malformedURLException.getMessage();
        }
        return object;
    }

    public String testXmlAgainstShema(String string, Schema object) {
        String string2 = "";
        object = ((Schema)object).newValidator();
        try {
            ((Validator)object).validate(new StreamSource(new StringReader(string)));
            string2 = "\u2705 XSD validacija je uspje\u0161na ";
        }
        catch (SAXParseException sAXParseException) {
            string2 = string2 + "\u274c XML je neispravan u liniji " + sAXParseException.getLineNumber() + ", column " + sAXParseException.getColumnNumber() + "\n" + sAXParseException.getMessage() + "\n";
        }
        catch (SAXException sAXException) {
            string2 = string2 + "\ud83d\udca5 SAXException : " + sAXException.getMessage() + "\n";
        }
        catch (IOException iOException) {
            string2 = string2 + "\ud83d\udca5 IOException : " + iOException.getMessage() + "\n";
        }
        return string2;
    }

    public SchematronValidationResult validateAgainstSchematron(String string, String string2) {
        return this.validateAgainstSchematron(string, string2, false);
    }

    public SchematronValidationResult validateAgainstSchematron(String string, String string2, boolean bl2) {
        if (bl2) {
            SysUtil.vdevout("\ud83d\udd0d XMLtester: Pokretanje Schematron validacije...");
            SysUtil.vdevout("\ud83d\udd27 Schematron XSL putanja: " + string2);
        }
        SchematronValidationResult schematronValidationResult = new SchematronValidationResult();
        try {
            File file = new File(string2);
            if (!file.exists()) {
                schematronValidationResult.setErrors(1);
                schematronValidationResult.setErrorMessages("Schematron XSL datoteka nije prona\u0111ena: " + string2);
                return schematronValidationResult;
            }
            if (!file.canRead() || file.length() == 0L) {
                schematronValidationResult.setErrors(1);
                schematronValidationResult.setErrorMessages("Schematron XSL datoteka nije \u010ditljiva ili je prazna: " + string2);
                return schematronValidationResult;
            }
            if (bl2) {
                SysUtil.vdevout("\ud83d\udd27 XSL datoteka validna: " + file.length() + " bajtova");
            }
            string = this.performSchematronTransformation(string, string2);
            schematronValidationResult = this.parseSchematronSvrlResult(string, bl2);
        }
        catch (Exception exception) {
            schematronValidationResult.setErrors(1);
            schematronValidationResult.setErrorMessages("Gre\u0161ka pri Schematron validaciji: " + exception.getMessage());
            HrFiskalizator.logger.log(Level.WARNING, "Schematron validacija neuspje\u0161na", exception);
        }
        if (bl2) {
            if (schematronValidationResult.isValid()) {
                SysUtil.vdevout("\u2705 XMLtester: Schematron validacija USPE\u0160NA");
                SysUtil.vdevout("\ud83d\udcc8 Rezultat - Gre\u0161ke: " + schematronValidationResult.getErrors() + ", Upozorenja: " + schematronValidationResult.getWarnings());
            } else {
                SysUtil.vdevout("\u274c XMLtester: Schematron validacija NEUSPE\u0160NA");
                SysUtil.vdevout("\ud83d\udcc8 Rezultat - Gre\u0161ke: " + schematronValidationResult.getErrors());
                SysUtil.vdevout("\ud83d\udcdd Poruke :");
                SysUtil.vdevout(schematronValidationResult.getErrorMessages());
            }
        }
        return schematronValidationResult;
    }

    private String performSchematronTransformation(String string, String string2) {
        SysUtil.vdevout("\ud83d\udd25 XMLtester: Poku\u0161avam Saxon XSLT 2.0 transformaciju...");
        if (!SaxonXSLTProcessor.testSaxonAvailability()) {
            SysUtil.vdevout("\u26a0\ufe0f  Saxon nije dostupan, fallback na default XSLT 1.0...");
            return this.performDefaultTransformation(string, string2);
        }
        try {
            return SaxonXSLTProcessor.performSaxonTransformation(string, string2);
        }
        catch (Exception exception) {
            SysUtil.vdevout("\u26a0\ufe0f  Saxon transformacija neuspe\u0161na: " + exception.getMessage());
            SysUtil.vdevout("\ud83d\udd04 Poku\u0161avam fallback na default transformer...");
            try {
                return this.performDefaultTransformation(string, string2);
            }
            catch (Exception exception2) {
                String string3 = "\n\ud83d\udd25 XSLT TRANSFORMATION FAILED:\n\n";
                string3 = string3 + "Saxon XSLT 2.0 error: " + exception.getMessage() + "\n";
                string3 = string3 + "Default XSLT 1.0 error: " + exception2.getMessage() + "\n";
                string3 = string3 + "\ud83d\udcc2 XSL File: " + string2 + "\n";
                throw new Exception(string3);
            }
        }
    }

    private String performDefaultTransformation(String object, String string) {
        Object object2 = TransformerFactory.newInstance();
        Object object3 = new StreamSource(new File(string));
        try {
            object2 = ((TransformerFactory)object2).newTransformer((Source)object3);
            object = new StringReader((String)object);
            object3 = new StringWriter();
            ((Transformer)object2).transform(new StreamSource((Reader)object), new StreamResult((Writer)object3));
            return ((StringWriter)object3).toString();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            object = "\ud83d\udd25 XSL TRANSFORMER ERROR:\n" + transformerConfigurationException.getMessage();
            object = (String)object + "\n\ud83d\udcc2 XSL File: " + string;
            object = (String)object + "\n\ud83d\udca1 Tip: Proverite XPath sintaksu i XML escape characters";
            throw new Exception((String)object, transformerConfigurationException);
        }
    }

    private SchematronValidationResult parseSchematronSvrlResult(String stringArray, boolean bl2) {
        SchematronValidationResult schematronValidationResult = new SchematronValidationResult();
        try {
            int n2 = this.countOccurrences((String)stringArray, "<svrl:failed-assert");
            int n3 = this.countOccurrences((String)stringArray, "<svrl:successful-report");
            schematronValidationResult.setErrors(n2);
            schematronValidationResult.setWarnings(n3);
            if (n2 > 0) {
                if (bl2) {
                    SysUtil.vdevout("\ud83d\udd0d DEBUG SVRL sadr\u017eaj (prvih 1000 znakova):");
                    SysUtil.vdevout(stringArray.substring(0, Math.min(1000, stringArray.length())));
                    SysUtil.vdevout("\ud83d\udd0d END DEBUG SVRL");
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\n");
                stringArray = stringArray.split("<svrl:failed-assert");
                for (int i2 = 1; i2 < stringArray.length; ++i2) {
                    String string = stringArray[i2];
                    int n4 = string.indexOf("<svrl:text>");
                    int n5 = string.indexOf("</svrl:text>");
                    if (n4 >= 0 && n5 > n4) {
                        string = string.substring(n4 + 11, n5).trim();
                        if (bl2) {
                            SysUtil.vdevout("\ud83d\udd0d DEBUG: Prona\u0111en svrl:text = '" + string + "'");
                        }
                        if (stringBuilder.length() > 1) {
                            stringBuilder.append("\n");
                        }
                        String string2 = this.getErrorIcon(string);
                        stringBuilder.append(string2).append(" ").append(string);
                        continue;
                    }
                    if (!bl2) continue;
                    SysUtil.vdevout("\ud83d\udd0d DEBUG: svrl:text nije prona\u0111en u part " + i2);
                    SysUtil.vdevout("Part sadr\u017eaj (prvih 200 znakova): " + string.substring(0, Math.min(200, string.length())));
                }
                schematronValidationResult.setErrorMessages(stringBuilder.toString());
            }
            schematronValidationResult.setSuccessfulAssertions(Math.max(0, 50 - n2));
        }
        catch (Exception exception) {
            HrFiskalizator.logger.log(Level.WARNING, "Gre\u0161ka pri parsiranju SVRL rezultata", exception);
            schematronValidationResult.setErrors(1);
            schematronValidationResult.setErrorMessages("Gre\u0161ka pri parsiranju SVRL rezultata: " + exception.getMessage());
        }
        return schematronValidationResult;
    }

    private String getErrorIcon(String string) {
        if ((string = string.toLowerCase()).contains("oib") || string.contains("pdv") || string.contains("tax") || string.contains("certifikat") || string.contains("potpis") || string.contains("signature") || string.contains("hr-bt-5") || string.contains("hr-bt-1") || string.contains("hr-bt-3")) {
            return "\ud83d\udd34";
        }
        if (string.contains("mora biti naveden") || string.contains("mora imati") || string.contains("mora sadr\u017eavati") || string.contains("obavezan") || string.contains("specifikacije") || string.contains("identifikator") || string.contains("elektroni\u010dka adresa") || string.contains("vrijeme izdavanja")) {
            return "\ud83d\udfe0";
        }
        if (string.contains("artikl") || string.contains("klasifikacija") || string.contains("kpd") || string.contains("datum dospije\u0107a") || string.contains("pla\u0107anje")) {
            return "\ud83d\udfe1";
        }
        if (string.contains("format") || string.contains("znamenka") || string.contains("to\u010dno") || string.contains("vrijednost")) {
            return "\ud83d\udfe6";
        }
        return "\u26a0\ufe0f";
    }

    private int countOccurrences(String string, String string2) {
        if (string == null || string2 == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(string2, n3)) != -1) {
            ++n2;
            n3 += string2.length();
        }
        return n2;
    }

    private String extractLineInfoFromError(String object) {
        Pattern pattern = Pattern.compile("line (\\d+), column (\\d+)|line (\\d+)|column (\\d+)");
        object = pattern.matcher((CharSequence)object);
        if (((Matcher)object).find()) {
            if (((Matcher)object).group(1) != null && ((Matcher)object).group(2) != null) {
                return "\ud83d\udccd Lokacija gre\u0161ke: linija " + ((Matcher)object).group(1) + ", kolona " + ((Matcher)object).group(2);
            }
            if (((Matcher)object).group(3) != null) {
                return "\ud83d\udccd Lokacija gre\u0161ke: linija " + ((Matcher)object).group(3);
            }
            if (((Matcher)object).group(4) != null) {
                return "\ud83d\udccd Lokacija gre\u0161ke: kolona " + ((Matcher)object).group(4);
            }
        }
        return "";
    }

    private String findProblematicLineInXsl(String string, String string2) {
        try {
            Iterable<Path> iterable = Paths.get(string, new String[0]);
            iterable = Files.readAllLines((Path)iterable, StandardCharsets.UTF_8);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\ud83d\udd25 TRANSFORMER ERROR: ").append(string2);
            stringBuilder.append("\n\ud83d\udcc4 XSL File: ").append(string);
            stringBuilder.append(" (").append(iterable.size()).append(" linija)");
            if (string2.contains("line") || string2.contains("linija")) {
                stringBuilder.append("\n\ud83d\udca1 Poku\u0161ajte prona\u0107i liniju sa gre\u0161kom ru\u010dno ili koristite XSL debugger");
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "\ud83d\udd25 TRANSFORMER ERROR: " + string2 + "\n\u274c Gre\u0161ka pri \u010ditanju XSL datoteke: " + exception.getMessage();
        }
    }

    private String extractSearchTextFromError(String string) {
        return string;
    }

    private String suggestXslFix(String string, String string2) {
        String string3;
        if (string == null || string.isEmpty()) {
            return "";
        }
        string = string.trim();
        String string4 = "";
        if (string.contains("not(not(") && string2.contains("Syntax error")) {
            string3 = string.replaceAll("not\\(not\\((.+?)\\)\\)", "$1");
            string4 = string4 + "Ukloni duplu negaciju: " + this.extractXslContent(string3);
        } else if (string.contains("'") && string.contains("\"") && string2.contains("Syntax error")) {
            string3 = this.fixQuoteEscaping(string);
            if (!string3.equals(string)) {
                string4 = string4 + "Ispravka quote-ova: " + this.extractXslContent(string3);
            }
        } else if (string.contains("(") && string.contains(")") && string2.contains("sequence")) {
            string3 = this.fixXPathSequence(string);
            if (!string3.equals(string)) {
                string4 = string4 + "Ispravka XPath sekvence: " + this.extractXslContent(string3);
            }
        } else if ((string2.contains("namespace") || string2.contains("prefix")) && (string.contains("cac:") || string.contains("cbc:"))) {
            string4 = string4 + "Proveri namespace deklaracije za cac: i cbc: prefixe";
        } else if (string2.contains("function") && string.contains("(")) {
            string3 = this.extractFunctionName(string);
            if (!(string3 = this.suggestSimilarFunction(string3)).isEmpty()) {
                string4 = string4 + "Mo\u017eda ste mislili na funkciju: " + string3;
            }
        } else if (string2.contains("expecting") || string2.contains("unexpected")) {
            string3 = this.balanceBrackets(string);
            if (!string3.equals(string)) {
                string4 = string4 + "Balansiranje zagrada: " + this.extractXslContent(string3);
            }
        } else if (string.contains("=") && string2.contains("Syntax error") && !(string3 = this.fixXPathOperators(string)).equals(string)) {
            string4 = string4 + "XPath operator ispravka: " + this.extractXslContent(string3);
        }
        if (string4.isEmpty() && string2.contains("Syntax error") && !(string3 = this.cleanXPathExpression(string)).equals(string)) {
            string4 = "Formatiranje \u010di\u0161\u0107enje: " + this.extractXslContent(string3);
        }
        return string4;
    }

    private String extractXslContent(String string) {
        int n2;
        int n3;
        if (string.contains("test=\"") && (n3 = string.indexOf("\"", n2 = string.indexOf("test=\"") + 6)) > n2) {
            return string.substring(n2, n3);
        }
        if (string.length() > 80) {
            return string.substring(0, 80) + "...";
        }
        return string;
    }

    private String fixQuoteEscaping(String string) {
        return string.replaceAll("'([^']*)'", "\"$1\"").replaceAll("\\\\\"", "\"").replaceAll("\"\"", "\"");
    }

    private String fixXPathSequence(String string) {
        return string.replaceAll("\\(\\s*([^,)]+)\\s*\\)", "($1)").replaceAll(",\\s*\\)", ")").replaceAll("\\(\\s*,", "(");
    }

    private String extractFunctionName(String object) {
        Pattern pattern = Pattern.compile("(\\w+)\\s*\\(");
        object = pattern.matcher((CharSequence)object);
        if (((Matcher)object).find()) {
            return ((Matcher)object).group(1);
        }
        return "";
    }

    private String suggestSimilarFunction(String string) {
        String[] stringArray = new String[]{"not", "contains", "matches", "normalize-space", "substring", "count", "position", "last", "string-length", "starts-with", "ends-with", "translate", "concat", "sum", "min", "max", "round", "floor", "ceiling"};
        String string2 = "";
        int n2 = Integer.MAX_VALUE;
        int cfr_ignored_0 = stringArray.length;
        for (int i2 = 0; i2 < 19; ++i2) {
            String string3 = stringArray[i2];
            int n3 = this.levenshteinDistance(string.toLowerCase(), string3.toLowerCase());
            if (n3 >= n2 || n3 > 2) continue;
            n2 = n3;
            string2 = string3;
        }
        return string2;
    }

    private String balanceBrackets(String string) {
        long l2;
        long l3 = string.chars().filter(n2 -> n2 == 40).count();
        if (l3 > (l2 = string.chars().filter(n2 -> n2 == 41).count())) {
            StringBuilder stringBuilder = new StringBuilder(string);
            int n3 = 0;
            while ((long)n3 < l3 - l2) {
                stringBuilder.append(")");
                ++n3;
            }
            return stringBuilder.toString();
        }
        if (l2 > l3) {
            StringBuilder stringBuilder = new StringBuilder();
            int n4 = 0;
            while ((long)n4 < l2 - l3) {
                stringBuilder.append("(");
                ++n4;
            }
            stringBuilder.append(string);
            return stringBuilder.toString();
        }
        return string;
    }

    private String fixXPathOperators(String string) {
        return string.replaceAll("\\s*=\\s*", " = ").replaceAll("\\band\\b", " and ").replaceAll("\\bor\\b", " or ").replaceAll("\\s+", " ");
    }

    private String cleanXPathExpression(String string) {
        return string.replaceAll("\\s+", " ").replaceAll("\\s*([()\\[\\]])\\s*", "$1").replaceAll("\\s*([=!<>])\\s*", " $1 ").trim();
    }

    private int levenshteinDistance(String string, String string2) {
        int n2;
        int n3 = string.length();
        int n4 = string2.length();
        int[][] nArray = new int[n3 + 1][n4 + 1];
        for (n2 = 0; n2 <= n3; ++n2) {
            nArray[n2][0] = n2;
        }
        n2 = 0;
        while (n2 <= n4) {
            int n5 = n2++;
            nArray[0][n5] = n5;
        }
        for (n2 = 1; n2 <= n3; ++n2) {
            for (int i2 = 1; i2 <= n4; ++i2) {
                int n6 = string.charAt(n2 - 1) == string2.charAt(i2 - 1) ? 0 : 1;
                nArray[n2][i2] = Math.min(Math.min(nArray[n2 - 1][i2] + 1, nArray[n2][i2 - 1] + 1), nArray[n2 - 1][i2 - 1] + n6);
            }
        }
        return nArray[n3][n4];
    }

    public static class SchematronValidationResult {
        private int errors = 0;
        private int warnings = 0;
        private int successfulAssertions = 0;
        private String errorMessages = "";

        public boolean isValid() {
            return this.errors == 0;
        }

        public int getErrors() {
            return this.errors;
        }

        public void setErrors(int n2) {
            this.errors = n2;
        }

        public int getWarnings() {
            return this.warnings;
        }

        public void setWarnings(int n2) {
            this.warnings = n2;
        }

        public int getSuccessfulAssertions() {
            return this.successfulAssertions;
        }

        public void setSuccessfulAssertions(int n2) {
            this.successfulAssertions = n2;
        }

        public String getErrorMessages() {
            return this.errorMessages;
        }

        public void setErrorMessages(String string) {
            this.errorMessages = string;
        }

        public String toString() {
            if (this.isValid()) {
                return String.format("\u2705 Schematron validacija uspje\u0161na - Pro\u0161lo %d pravila", this.successfulAssertions);
            }
            return String.format("\u274c Schematron validacija neuspje\u0161na - %d : %s", this.errors, this.errorMessages);
        }
    }
}

