/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula;

import com.bulenkov.iconloader.util.ColorUtil;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.Gray;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class DarculaTableHeaderUI
extends BasicTableHeaderUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new DarculaTableHeaderUI();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        graphics = (Graphics2D)graphics;
        GraphicsConfig graphicsConfig = new GraphicsConfig(graphics);
        Color color = jComponent.getBackground();
        ((Graphics2D)graphics).setPaint(new GradientPaint(0.0f, 0.0f, ColorUtil.shift(color, 1.4), 0.0f, jComponent.getHeight(), ColorUtil.shift(color, 0.9)));
        int n2 = jComponent.getHeight();
        int n3 = jComponent.getWidth();
        graphics.fillRect(0, 0, n3, n2);
        ((Graphics2D)graphics).setPaint(ColorUtil.shift(color, 0.75));
        graphics.drawLine(0, n2 - 1, n3, n2 - 1);
        graphics.drawLine(n3 - 1, 0, n3 - 1, n2 - 1);
        Enumeration<TableColumn> enumeration = ((JTableHeader)jComponent).getColumnModel().getColumns();
        color = ColorUtil.shift(color, 0.7);
        Color color2 = Gray._255.withAlpha(30);
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            if (!enumeration.hasMoreElements() || tableColumn.getWidth() <= 0) continue;
            graphics.setColor(color);
            graphics.drawLine((n4 += tableColumn.getWidth()) - 1, 1, n4 - 1, n2 - 3);
            graphics.setColor(color2);
            graphics.drawLine(n4, 1, n4, n2 - 3);
        }
        graphicsConfig.restore();
        super.paint(graphics, jComponent);
    }
}

