/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import sun.swing.SwingUtilities2;

public class DarculaButtonUI
extends BasicButtonUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new DarculaButtonUI();
    }

    public static boolean isSquare(Component component) {
        return component instanceof JButton && "square".equals(((JButton)component).getClientProperty("JButton.buttonType"));
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Object object = jComponent.getBorder();
        GraphicsConfig graphicsConfig = GraphicsUtil.setupAAPainting(graphics);
        boolean bl2 = DarculaButtonUI.isSquare(jComponent);
        if (jComponent.isEnabled() && object != null) {
            object = object.getBorderInsets(jComponent);
            int n2 = (((Insets)object).top + ((Insets)object).bottom) / 4;
            if (!bl2) {
                if (((JButton)jComponent).isDefaultButton()) {
                    ((Graphics2D)graphics).setPaint(new GradientPaint(0.0f, 0.0f, this.getSelectedButtonColor1(), 0.0f, jComponent.getHeight(), this.getSelectedButtonColor2()));
                } else {
                    ((Graphics2D)graphics).setPaint(new GradientPaint(0.0f, 0.0f, this.getButtonColor1(), 0.0f, jComponent.getHeight(), this.getButtonColor2()));
                }
            }
            graphics.fillRoundRect(bl2 ? 2 : 4, n2, jComponent.getWidth() - 8, jComponent.getHeight() - 2 * n2, bl2 ? 3 : 5, bl2 ? 3 : 5);
        }
        graphicsConfig.restore();
        super.paint(graphics, jComponent);
    }

    @Override
    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        Serializable serializable;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Serializable serializable2 = abstractButton.getForeground();
        if (serializable2 instanceof UIResource && abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton() && (serializable = UIManager.getColor("Button.darcula.selectedButtonForeground")) != null) {
            serializable2 = serializable;
        }
        graphics.setColor((Color)serializable2);
        serializable = SwingUtilities2.getFontMetrics(jComponent, graphics);
        int n2 = abstractButton.getDisplayedMnemonicIndex();
        if (buttonModel.isEnabled()) {
            SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics, string, n2, rectangle.x + this.getTextShiftOffset(), rectangle.y + ((FontMetrics)serializable).getAscent() + this.getTextShiftOffset());
            return;
        }
        graphics.setColor(UIManager.getColor("Button.darcula.disabledText.shadow"));
        SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics, string, -1, rectangle.x + this.getTextShiftOffset() + 1, rectangle.y + ((FontMetrics)serializable).getAscent() + this.getTextShiftOffset() + 1);
        graphics.setColor(UIManager.getColor("Button.disabledText"));
        SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics, string, -1, rectangle.x + this.getTextShiftOffset(), rectangle.y + ((FontMetrics)serializable).getAscent() + this.getTextShiftOffset());
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
        if (((JButton)jComponent).isDefaultButton() && !SystemInfo.isMac && !jComponent.getFont().isBold()) {
            JComponent jComponent2 = jComponent;
            jComponent2.setFont(jComponent2.getFont().deriveFont(1));
        }
    }

    protected Color getButtonColor1() {
        return UIManager.getColor("Button.darcula.color1");
    }

    protected Color getButtonColor2() {
        return UIManager.getColor("Button.darcula.color2");
    }

    protected Color getSelectedButtonColor1() {
        return UIManager.getColor("Button.darcula.selection.color1");
    }

    protected Color getSelectedButtonColor2() {
        return UIManager.getColor("Button.darcula.selection.color2");
    }
}

