/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.iconloader.util.EmptyIcon;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.Gray;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.metal.MetalCheckBoxUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarculaCheckBoxUI
extends MetalCheckBoxUI {
    public static ComponentUI createUI(JComponent jComponent) {
        if (UIUtil.getParentOfType(CellRendererPane.class, jComponent) != null) {
            jComponent.setBorder(null);
        }
        return new DarculaCheckBoxUI();
    }

    @Override
    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        graphics = (Graphics2D)graphics;
        JCheckBox jCheckBox = (JCheckBox)jComponent;
        ButtonModel buttonModel = jCheckBox.getModel();
        Object object = jComponent.getSize();
        Serializable serializable = jComponent.getFont();
        graphics.setFont((Font)serializable);
        serializable = SwingUtilities2.getFontMetrics(jComponent, graphics, (Font)serializable);
        Object object2 = new Rectangle((Dimension)object);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Insets insets = jComponent.getInsets();
        ((Rectangle)object2).x += insets.left;
        ((Rectangle)object2).y += insets.top;
        ((Rectangle)object2).width -= insets.right + ((Rectangle)object2).x;
        ((Rectangle)object2).height -= insets.bottom + ((Rectangle)object2).y;
        object2 = SwingUtilities.layoutCompoundLabel(jComponent, (FontMetrics)serializable, jCheckBox.getText(), this.getDefaultIcon(), jCheckBox.getVerticalAlignment(), jCheckBox.getHorizontalAlignment(), jCheckBox.getVerticalTextPosition(), jCheckBox.getHorizontalTextPosition(), (Rectangle)object2, rectangle, rectangle2, jCheckBox.getIconTextGap());
        if (jComponent.isOpaque()) {
            graphics.setColor(jCheckBox.getBackground());
            graphics.fillRect(0, 0, ((Dimension)object).width, ((Dimension)object).height);
        }
        if (jCheckBox.isSelected() && jCheckBox.getSelectedIcon() != null) {
            jCheckBox.getSelectedIcon().paintIcon(jCheckBox, graphics, rectangle.x + 4, rectangle.y + 2);
        } else if (!jCheckBox.isSelected() && jCheckBox.getIcon() != null) {
            jCheckBox.getIcon().paintIcon(jCheckBox, graphics, rectangle.x + 4, rectangle.y + 2);
        } else {
            int n2 = rectangle.x + 3;
            int n3 = rectangle.y + 3;
            int n4 = rectangle.width - 6;
            int n5 = rectangle.height - 6;
            ((Graphics2D)graphics).translate(n2, n3);
            Object object3 = new GradientPaint(n4 / 2, 0.0f, jCheckBox.getBackground().brighter(), n4 / 2, n5, jCheckBox.getBackground());
            ((Graphics2D)graphics).setPaint((Paint)object3);
            graphics.fillRect(1, 1, n4 - 2, n5 - 2);
            object3 = new GraphicsConfig(graphics);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            boolean bl2 = jCheckBox.getModel().isArmed();
            if (jComponent.hasFocus()) {
                ((Graphics2D)graphics).setPaint(new GradientPaint(n4 / 2, 1.0f, this.getFocusedBackgroundColor1(bl2), n4 / 2, n5, this.getFocusedBackgroundColor2(bl2)));
                graphics.fillRoundRect(0, 0, n4 - 2, n5 - 2, 4, 4);
                DarculaUIUtil.paintFocusRing(graphics, 1, 1, n4 - 2, n5 - 2);
            } else {
                ((Graphics2D)graphics).setPaint(new GradientPaint(n4 / 2, 1.0f, this.getBackgroundColor1(), n4 / 2, n5, this.getBackgroundColor2()));
                graphics.fillRoundRect(0, 0, n4, n5 - 1, 4, 4);
                ((Graphics2D)graphics).setPaint(new GradientPaint(n4 / 2, 1.0f, this.getBorderColor1(jCheckBox.isEnabled()), n4 / 2, n5, this.getBorderColor2(jCheckBox.isEnabled())));
                graphics.drawRoundRect(0, UIUtil.isUnderDarcula() ? 1 : 0, n4, n5 - 1, 4, 4);
                ((Graphics2D)graphics).setPaint(this.getInactiveFillColor());
                graphics.drawRoundRect(0, 0, n4, n5 - 1, 4, 4);
            }
            if (jCheckBox.getModel().isSelected()) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                ((Graphics2D)graphics).setStroke(new BasicStroke(2.0f, 1, 1));
                ((Graphics2D)graphics).setPaint(this.getShadowColor(jCheckBox.isEnabled()));
                graphics.drawLine(4, 7, 7, 11);
                graphics.drawLine(7, 11, n4, 2);
                ((Graphics2D)graphics).setPaint(this.getCheckSignColor(jCheckBox.isEnabled()));
                graphics.drawLine(4, 5, 7, 9);
                graphics.drawLine(7, 9, n4, 0);
            }
            ((Graphics2D)graphics).translate(-n2, -n3);
            ((GraphicsConfig)object3).restore();
        }
        if (object2 != null) {
            object = (View)jComponent.getClientProperty("html");
            if (object != null) {
                ((View)object).paint(graphics, rectangle2);
                return;
            }
            graphics.setColor(buttonModel.isEnabled() ? jCheckBox.getForeground() : this.getDisabledTextColor());
            SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics, (String)object2, jCheckBox.getDisplayedMnemonicIndex(), rectangle2.x, rectangle2.y + ((FontMetrics)serializable).getAscent());
        }
    }

    protected Color getInactiveFillColor() {
        return DarculaCheckBoxUI.getColor("inactiveFillColor", Gray._40.withAlpha(180));
    }

    protected Color getBorderColor1(boolean bl2) {
        if (bl2) {
            return DarculaCheckBoxUI.getColor("borderColor1", Gray._120.withAlpha(90));
        }
        return DarculaCheckBoxUI.getColor("disabledBorderColor1", Gray._120.withAlpha(90));
    }

    protected Color getBorderColor2(boolean bl2) {
        if (bl2) {
            return DarculaCheckBoxUI.getColor("borderColor2", Gray._105.withAlpha(90));
        }
        return DarculaCheckBoxUI.getColor("disabledBorderColor2", Gray._105.withAlpha(90));
    }

    protected Color getBackgroundColor1() {
        return DarculaCheckBoxUI.getColor("backgroundColor1", Gray._110);
    }

    protected Color getBackgroundColor2() {
        return DarculaCheckBoxUI.getColor("backgroundColor2", Gray._95);
    }

    protected Color getCheckSignColor(boolean bl2) {
        if (bl2) {
            return DarculaCheckBoxUI.getColor("checkSignColor", Gray._170);
        }
        return DarculaCheckBoxUI.getColor("checkSignColorDisabled", Gray._120);
    }

    protected Color getShadowColor(boolean bl2) {
        if (bl2) {
            return DarculaCheckBoxUI.getColor("shadowColor", Gray._30);
        }
        return DarculaCheckBoxUI.getColor("shadowColorDisabled", Gray._60);
    }

    protected Color getFocusedBackgroundColor1(boolean bl2) {
        if (bl2) {
            return DarculaCheckBoxUI.getColor("focusedArmed.backgroundColor1", Gray._100);
        }
        return DarculaCheckBoxUI.getColor("focused.backgroundColor1", Gray._120);
    }

    protected Color getFocusedBackgroundColor2(boolean bl2) {
        if (bl2) {
            return DarculaCheckBoxUI.getColor("focusedArmed.backgroundColor2", Gray._55);
        }
        return DarculaCheckBoxUI.getColor("focused.backgroundColor2", Gray._75);
    }

    protected static Color getColor(String object, Color color) {
        if ((object = UIManager.getColor("CheckBox.darcula." + (String)object)) == null) {
            return color;
        }
        return object;
    }

    @Override
    public Icon getDefaultIcon() {
        return new IconUIResource(EmptyIcon.create(20));
    }
}

