/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import sun.swing.MenuItemLayoutHelper;
import sun.swing.SwingUtilities2;

public class DarculaMenuItemUIBase
extends BasicMenuItemUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new DarculaMenuItemUIBase();
    }

    public void processMouseEvent(JMenuItem menuElementArray, MouseEvent mouseEvent, MenuElement[] menuElementArray2, MenuSelectionManager menuSelectionManager) {
        Point point = mouseEvent.getPoint();
        if (point.x >= 0 && point.x < menuElementArray.getWidth() && point.y >= 0 && point.y < menuElementArray.getHeight()) {
            if (mouseEvent.getID() == 502) {
                menuSelectionManager.clearSelectedPath();
                menuElementArray.doClick(0);
                menuElementArray.setArmed(false);
                return;
            }
            menuSelectionManager.setSelectedPath(menuElementArray2);
            return;
        }
        if (menuElementArray.getModel().isArmed()) {
            menuElementArray = new MenuElement[menuElementArray2.length - 1];
            int n2 = menuElementArray2.length - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                menuElementArray[i2] = menuElementArray2[i2];
            }
            menuSelectionManager.setSelectedPath(menuElementArray);
        }
    }

    @Override
    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon object, Icon object2, Color color, Color color2, int n2) {
        Font font = graphics.getFont();
        Color color3 = graphics.getColor();
        jComponent = (JMenuItem)jComponent;
        graphics.setFont(jComponent.getFont());
        Rectangle rectangle = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.applyInsets(rectangle, jComponent.getInsets());
        object = new MenuItemLayoutHelper((JMenuItem)jComponent, (Icon)object, (Icon)object2, rectangle, n2, this.acceleratorDelimiter, jComponent.getComponentOrientation().isLeftToRight(), jComponent.getFont(), this.acceleratorFont, MenuItemLayoutHelper.useCheckAndArrow(this.menuItem), this.getPropertyPrefix());
        object2 = ((MenuItemLayoutHelper)object).layoutMenuItem();
        this.paintBackground(graphics, (JMenuItem)jComponent, color);
        this.paintCheckIcon(graphics, (MenuItemLayoutHelper)object, (MenuItemLayoutHelper.LayoutResult)object2, color3, color2);
        this.paintIcon(graphics, (MenuItemLayoutHelper)object, (MenuItemLayoutHelper.LayoutResult)object2, color3);
        graphics.setColor(color2);
        this.paintText(graphics, (MenuItemLayoutHelper)object, (MenuItemLayoutHelper.LayoutResult)object2);
        this.paintAccText(graphics, (MenuItemLayoutHelper)object, (MenuItemLayoutHelper.LayoutResult)object2);
        this.paintArrowIcon(graphics, (MenuItemLayoutHelper)object, (MenuItemLayoutHelper.LayoutResult)object2, color2);
        graphics.setColor(color3);
        graphics.setFont(font);
    }

    protected void paintIcon(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult, Color color) {
        if (menuItemLayoutHelper.getIcon() != null) {
            Object object = menuItemLayoutHelper.getMenuItem().getModel();
            if (!object.isEnabled()) {
                object = menuItemLayoutHelper.getMenuItem().getDisabledIcon();
            } else if (!object.isPressed() || !object.isArmed() || (object = menuItemLayoutHelper.getMenuItem().getPressedIcon()) == null) {
                object = menuItemLayoutHelper.getMenuItem().getIcon();
            }
            if (object != null) {
                object.paintIcon(menuItemLayoutHelper.getMenuItem(), graphics, layoutResult.getIconRect().x, layoutResult.getIconRect().y);
                graphics.setColor(color);
            }
        }
    }

    protected void paintCheckIcon(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult, Color color, Color color2) {
        if (menuItemLayoutHelper.getCheckIcon() != null) {
            ButtonModel buttonModel = menuItemLayoutHelper.getMenuItem().getModel();
            if (buttonModel.isArmed() || menuItemLayoutHelper.getMenuItem() instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color);
            }
            if (menuItemLayoutHelper.useCheckAndArrow()) {
                menuItemLayoutHelper.getCheckIcon().paintIcon(menuItemLayoutHelper.getMenuItem(), graphics, layoutResult.getCheckRect().x, layoutResult.getCheckRect().y);
            }
            graphics.setColor(color);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void paintAccText(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult) {
        if (!menuItemLayoutHelper.getAccText().equals("")) {
            ButtonModel buttonModel = menuItemLayoutHelper.getMenuItem().getModel();
            graphics.setFont(menuItemLayoutHelper.getAccFontMetrics().getFont());
            if (!buttonModel.isEnabled()) {
                if (this.disabledForeground == null) {
                    graphics.setColor(menuItemLayoutHelper.getMenuItem().getBackground().brighter());
                    SwingUtilities2.drawString((JComponent)menuItemLayoutHelper.getMenuItem(), graphics, menuItemLayoutHelper.getAccText(), layoutResult.getAccRect().x, layoutResult.getAccRect().y + menuItemLayoutHelper.getAccFontMetrics().getAscent());
                    graphics.setColor(menuItemLayoutHelper.getMenuItem().getBackground().darker());
                    SwingUtilities2.drawString((JComponent)menuItemLayoutHelper.getMenuItem(), graphics, menuItemLayoutHelper.getAccText(), layoutResult.getAccRect().x - 1, layoutResult.getAccRect().y + menuItemLayoutHelper.getFontMetrics().getAscent() - 1);
                    return;
                }
                graphics.setColor(this.disabledForeground);
            } else if (buttonModel.isArmed() || menuItemLayoutHelper.getMenuItem() instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(this.acceleratorSelectionForeground);
            } else {
                graphics.setColor(this.acceleratorForeground);
            }
            SwingUtilities2.drawString((JComponent)menuItemLayoutHelper.getMenuItem(), graphics, menuItemLayoutHelper.getAccText(), layoutResult.getAccRect().x, layoutResult.getAccRect().y + menuItemLayoutHelper.getAccFontMetrics().getAscent());
        }
    }

    protected void paintText(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult) {
        if (!menuItemLayoutHelper.getText().equals("")) {
            if (menuItemLayoutHelper.getHtmlView() != null) {
                menuItemLayoutHelper.getHtmlView().paint(graphics, layoutResult.getTextRect());
                return;
            }
            this.paintText(graphics, menuItemLayoutHelper.getMenuItem(), layoutResult.getTextRect(), menuItemLayoutHelper.getText());
        }
    }

    protected void paintArrowIcon(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult, Color color) {
        if (menuItemLayoutHelper.getArrowIcon() != null) {
            ButtonModel buttonModel = menuItemLayoutHelper.getMenuItem().getModel();
            if (buttonModel.isArmed() || menuItemLayoutHelper.getMenuItem() instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color);
            }
            if (menuItemLayoutHelper.useCheckAndArrow()) {
                menuItemLayoutHelper.getArrowIcon().paintIcon(menuItemLayoutHelper.getMenuItem(), graphics, layoutResult.getArrowRect().x, layoutResult.getArrowRect().y);
            }
        }
    }

    protected void applyInsets(Rectangle rectangle, Insets insets) {
        if (insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.right + rectangle.x;
            rectangle.height -= insets.bottom + rectangle.y;
        }
    }
}

