/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.iconloader.util.DoubleColor;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.Gray;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import sun.swing.SwingUtilities2;

public class DarculaProgressBarUI
extends BasicProgressBarUI {
    protected volatile int offset = 0;

    public static ComponentUI createUI(JComponent jComponent) {
        jComponent.setBorder(new BorderUIResource(new EmptyBorder(0, 0, 0, 0)));
        return new DarculaProgressBarUI();
    }

    @Override
    protected void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Insets insets = this.progressBar.getInsets();
        int n2 = this.progressBar.getWidth() - (insets.right + insets.left);
        int n3 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        if (n2 <= 0 || n3 <= 0) {
            return;
        }
        graphics.setColor(new DoubleColor(Gray._240, Gray._128));
        int n4 = jComponent.getWidth();
        int n5 = jComponent.getPreferredSize().height;
        graphics.fillRect(0, (jComponent.getHeight() - n5) / 2, n4, n5);
        graphics.setColor(new DoubleColor(Gray._165, Gray._88));
        GraphicsUtil.setupAAPainting(graphics);
        Shape shape = new Path2D.Double();
        int n6 = this.getPeriodLength() / 2;
        graphics.translate(0, (jComponent.getHeight() - n5) / 2);
        ((Path2D.Double)shape).moveTo(0.0, 0.0);
        ((Path2D.Double)shape).lineTo(n6, 0.0);
        ((Path2D.Double)shape).lineTo(n6 - n5 / 2, n5);
        ((Path2D.Double)shape).lineTo(-n5 / 2, n5);
        ((Path2D.Double)shape).lineTo(0.0, 0.0);
        ((Path2D)shape).closePath();
        for (n6 = -this.offset; n6 < Math.max(jComponent.getWidth(), jComponent.getHeight()); n6 += this.getPeriodLength()) {
            graphics.translate(n6, 0);
            ((Graphics2D)graphics).fill(shape);
            graphics.translate(-n6, 0);
        }
        this.offset = (this.offset + 1) % this.getPeriodLength();
        shape = new Area(new Rectangle2D.Double(0.0, 0.0, n4, n5));
        ((Area)shape).subtract(new Area(new RoundRectangle2D.Double(1.0, 1.0, n4 - 2, n5 - 2, 8.0, 8.0)));
        ((Graphics2D)graphics).setPaint(Gray._128);
        ((Graphics2D)graphics).fill(shape);
        ((Area)shape).subtract(new Area(new RoundRectangle2D.Double(0.0, 0.0, n4, n5, 9.0, 9.0)));
        ((Graphics2D)graphics).setPaint(jComponent.getParent().getBackground());
        ((Graphics2D)graphics).fill(shape);
        graphics.drawRoundRect(1, 1, n4 - 3, n5 - 3, 8, 8);
        graphics.translate(0, -(jComponent.getHeight() - n5) / 2);
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.a(graphics, insets.left, insets.top, n2, n3, this.boxRect.x, this.boxRect.width);
                return;
            }
            this.a(graphics, insets.left, insets.top, n2, n3, this.boxRect.y, this.boxRect.height);
        }
    }

    @Override
    protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        if (this.progressBar.getOrientation() != 0 || !jComponent.getComponentOrientation().isLeftToRight()) {
            super.paintDeterminate(graphics, jComponent);
            return;
        }
        GraphicsUtil.setupAAPainting(graphics);
        Insets insets = this.progressBar.getInsets();
        int n2 = this.progressBar.getWidth();
        int n3 = this.progressBar.getPreferredSize().height;
        int n4 = n2 - (insets.right + insets.left);
        int n5 = n3 - (insets.top + insets.bottom);
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        int n6 = this.getAmountFull(insets, n4, n5);
        graphics.setColor(jComponent.getParent().getBackground());
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics.fillRect(0, 0, n2, n3);
        graphics2D.translate(0, (jComponent.getHeight() - n3) / 2);
        graphics2D.setColor(this.progressBar.getForeground());
        graphics2D.fill(new RoundRectangle2D.Double(0.0, 0.0, n2 - 1, n3 - 1, 9.0, 9.0));
        graphics2D.setColor(jComponent.getParent().getBackground());
        graphics2D.fill(new RoundRectangle2D.Double(1.0, 1.0, n2 - 3, n3 - 3, 8.0, 8.0));
        graphics2D.setColor(this.progressBar.getForeground());
        graphics2D.fill(new RoundRectangle2D.Double(2.0, 2.0, n6 - 5, n3 - 5, 7.0, 7.0));
        graphics2D.translate(0, -(jComponent.getHeight() - n3) / 2);
        if (this.progressBar.isStringPainted()) {
            this.paintString(graphics, insets.left, insets.top, n4, n5, n6, insets);
        }
    }

    private void a(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        graphics = (Graphics2D)graphics;
        String string = this.progressBar.getString();
        graphics.setFont(this.progressBar.getFont());
        Cloneable cloneable = this.getStringPlacement(graphics, string, n2, n3, n4, n5);
        Rectangle rectangle = graphics.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            graphics.setColor(this.getSelectionBackground());
            SwingUtilities2.drawString((JComponent)this.progressBar, graphics, string, cloneable.x, cloneable.y);
            graphics.setColor(this.getSelectionForeground());
            graphics.clipRect(n6, n3, n7, n5);
            SwingUtilities2.drawString((JComponent)this.progressBar, graphics, string, cloneable.x, cloneable.y);
        } else {
            graphics.setColor(this.getSelectionBackground());
            cloneable = AffineTransform.getRotateInstance(1.5707963267948966);
            graphics.setFont(this.progressBar.getFont().deriveFont((AffineTransform)cloneable));
            cloneable = this.getStringPlacement(graphics, string, n2, n3, n4, n5);
            SwingUtilities2.drawString((JComponent)this.progressBar, graphics, string, cloneable.x, cloneable.y);
            graphics.setColor(this.getSelectionForeground());
            graphics.clipRect(n2, n6, n4, n7);
            SwingUtilities2.drawString((JComponent)this.progressBar, graphics, string, cloneable.x, cloneable.y);
        }
        graphics.setClip(rectangle);
    }

    @Override
    protected int getBoxLength(int n2, int n3) {
        return n2;
    }

    protected int getPeriodLength() {
        return 16;
    }
}

