/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.iconloader.util.ColorUtil;
import com.bulenkov.iconloader.util.EmptyIcon;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.Gray;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarculaRadioButtonUI
extends MetalRadioButtonUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new DarculaRadioButtonUI();
    }

    @Override
    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        graphics = (Graphics2D)graphics;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Dimension dimension = jComponent.getSize();
        Serializable serializable = jComponent.getFont();
        graphics.setFont((Font)serializable);
        serializable = SwingUtilities2.getFontMetrics(jComponent, graphics, (Font)serializable);
        Object object = new Rectangle(dimension);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Insets insets = jComponent.getInsets();
        ((Rectangle)object).x += insets.left;
        ((Rectangle)object).y += insets.top;
        ((Rectangle)object).width -= insets.right + ((Rectangle)object).x;
        ((Rectangle)object).height -= insets.bottom + ((Rectangle)object).y;
        object = SwingUtilities.layoutCompoundLabel(jComponent, (FontMetrics)serializable, abstractButton.getText(), this.getDefaultIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), (Rectangle)object, rectangle, rectangle2, abstractButton.getIconTextGap());
        if (jComponent.isOpaque()) {
            graphics.setColor(abstractButton.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        int n2 = rectangle.x + 4 / 2;
        int n3 = rectangle.y + 4 / 2;
        int n4 = rectangle.width - 10 / 2;
        int n5 = rectangle.height - 10 / 2;
        ((Graphics2D)graphics).translate(n2, n3);
        GraphicsConfig graphicsConfig = GraphicsUtil.setupAAPainting(graphics);
        boolean bl2 = abstractButton.hasFocus();
        ((Graphics2D)graphics).setPaint(new GradientPaint(0.0f, 0.0f, ColorUtil.shift(jComponent.getBackground(), 1.5), 0.0f, jComponent.getHeight(), ColorUtil.shift(jComponent.getBackground(), 1.2)));
        if (bl2) {
            graphics.fillOval(0, 1, n4, n5);
        } else {
            graphics.fillOval(0, 1, n4 - 1, n5 - 1);
        }
        if (bl2) {
            if (UIUtil.isRetina()) {
                DarculaUIUtil.paintFocusOval(graphics, 1, 2, n4 - 2, n5 - 2);
            } else {
                DarculaUIUtil.paintFocusOval(graphics, 0, 1, n4, n5);
            }
        } else {
            Color color;
            Graphics graphics2;
            if (UIUtil.isUnderDarcula()) {
                ((Graphics2D)graphics).setPaint(new GradientPaint(n4 / 2, 1.0f, Gray._160.withAlpha(90), n4 / 2, n5, Gray._100.withAlpha(90)));
                graphics.drawOval(0, 2, n4 - 1, n5 - 1);
                graphics2 = graphics;
                color = Gray._40.withAlpha(200);
            } else {
                graphics2 = graphics;
                color = abstractButton.isEnabled() ? Gray._30 : Gray._130;
            }
            ((Graphics2D)graphics2).setPaint(color);
            graphics.drawOval(0, 1, n4 - 1, n5 - 1);
        }
        if (abstractButton.isSelected()) {
            bl2 = abstractButton.isEnabled();
            graphics.setColor(UIManager.getColor(bl2 ? "RadioButton.darcula.selectionEnabledShadowColor" : "RadioButton.darcula.selectionDisabledShadowColor"));
            graphics.fillOval(n4 / 2 - 5 / 2, n5 / 2, 5, 5);
            graphics.setColor(UIManager.getColor(bl2 ? "RadioButton.darcula.selectionEnabledColor" : "RadioButton.darcula.selectionDisabledColor"));
            graphics.fillOval(n4 / 2 - 5 / 2, n5 / 2 - 1, 5, 5);
        }
        graphicsConfig.restore();
        ((Graphics2D)graphics).translate(-n2, -n3);
        if (object != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, rectangle2);
                return;
            }
            n2 = abstractButton.getDisplayedMnemonicIndex();
            if (buttonModel.isEnabled()) {
                graphics.setColor(abstractButton.getForeground());
            } else {
                graphics.setColor(this.getDisabledTextColor());
            }
            SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics, (String)object, n2, rectangle2.x, rectangle2.y + ((FontMetrics)serializable).getAscent());
        }
    }

    @Override
    public Icon getDefaultIcon() {
        return new IconUIResource(EmptyIcon.create(20));
    }
}

