/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.iconloader.util.DoubleColor;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.Gray;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class DarculaSpinnerBorder
implements Border,
UIResource {
    @Override
    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        JSpinner jSpinner = (JSpinner)component;
        JFormattedTextField jFormattedTextField = UIUtil.findComponentOfType(jSpinner, JFormattedTextField.class);
        int n6 = n2 + 1;
        int n7 = n3 + 3;
        int n8 = n4 - 2;
        int n9 = n5 - 6;
        boolean bl2 = component.isEnabled() && component.isVisible() && jFormattedTextField != null && jFormattedTextField.hasFocus();
        GraphicsConfig graphicsConfig = GraphicsUtil.setupAAPainting(graphics);
        if (component.isOpaque()) {
            graphics.setColor(UIUtil.getPanelBackground());
            graphics.fillRect(n2, n3, n4, n5);
        }
        graphics.setColor(UIUtil.getTextFieldBackground());
        graphics.fillRoundRect(n6, n7, n8, n9, 5, 5);
        graphics.setColor(UIManager.getColor(jSpinner.isEnabled() ? "Spinner.darcula.enabledButtonColor" : "Spinner.darcula.disabledButtonColor"));
        if (jFormattedTextField != null) {
            n2 = jFormattedTextField.getBounds().x + jFormattedTextField.getWidth() + ((JSpinner)component).getInsets().left + 1;
            Area area = new Area(new RoundRectangle2D.Double(n6, n7, n8, n9, 5.0, 5.0));
            Area area2 = new Area(new Rectangle(n2, n7, 22, n9));
            area.intersect(area2);
            ((Graphics2D)graphics).fill(area);
            if (UIUtil.isUnderDarcula()) {
                graphics.setColor(Gray._100);
                graphics.drawLine(n2, n7, n2, n9 + 2);
            }
        }
        if (!component.isEnabled()) {
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 0.4f));
        }
        if (bl2) {
            DarculaUIUtil.paintFocusRing(graphics, n6 + 2, n7, n8 - 3, n9);
        } else {
            graphics.setColor(new DoubleColor(Gray._149, Gray._100));
            graphics.drawRoundRect(n6, n7, n8, n9, 5, 5);
        }
        graphicsConfig.restore();
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new InsetsUIResource(5, 7, 5, 7);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

