/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.darcula.ui.DarculaTextBorder;
import com.bulenkov.iconloader.IconLoader;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.Gray;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class DarculaTextFieldUI
extends BasicTextFieldUI {
    private final JTextField a;
    protected JLabel myClearIcon;
    protected JLabel myRecentIcon;

    public DarculaTextFieldUI(JTextField jTextField) {
        this.a = jTextField;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        DarculaTextFieldUI darculaTextFieldUI = new DarculaTextFieldUI((JTextField)jComponent);
        jComponent.addFocusListener(new FocusAdapter(jComponent){
            private /* synthetic */ JComponent a;
            {
                this.a = jComponent;
            }

            @Override
            public final void focusGained(FocusEvent focusEvent) {
                this.a.repaint();
            }

            @Override
            public final void focusLost(FocusEvent focusEvent) {
                this.a.repaint();
            }
        });
        jComponent.addMouseMotionListener(new MouseMotionAdapter(darculaTextFieldUI, jComponent){
            private /* synthetic */ DarculaTextFieldUI a;
            private /* synthetic */ JComponent b;
            {
                this.a = darculaTextFieldUI;
                this.b = jComponent;
            }

            @Override
            public final void mouseMoved(MouseEvent mouseEvent) {
                if (this.a.getComponent() != null && DarculaTextFieldUI.isSearchField(this.b)) {
                    if (DarculaTextFieldUI.a(this.a, mouseEvent) != 0) {
                        this.b.setCursor(Cursor.getPredefinedCursor(12));
                        return;
                    }
                    this.b.setCursor(Cursor.getPredefinedCursor(2));
                }
            }
        });
        jComponent.addMouseListener(new MouseAdapter(jComponent, darculaTextFieldUI){
            private /* synthetic */ JComponent a;
            private /* synthetic */ DarculaTextFieldUI b;
            {
                this.a = jComponent;
                this.b = darculaTextFieldUI;
            }

            @Override
            public final void mouseClicked(MouseEvent mouseEvent) {
                int n2;
                if (DarculaTextFieldUI.isSearchField(this.a) && (n2 = DarculaTextFieldUI.a(this.b, mouseEvent)) != 0) {
                    switch (4.a[n2 - 1]) {
                        case 1: {
                            this.b.showSearchPopup();
                            break;
                        }
                        case 2: {
                            ((JTextField)this.a).setText("");
                        }
                    }
                    mouseEvent.consume();
                }
            }
        });
        return darculaTextFieldUI;
    }

    protected void showSearchPopup() {
        Object object = this.getComponent().getClientProperty("JTextField.Search.FindPopup");
        if (object instanceof JPopupMenu) {
            object = (JPopupMenu)object;
            ((JPopupMenu)object).show(this.getComponent(), this.getSearchIconCoord().x, this.getComponent().getHeight());
        }
    }

    protected Rectangle getDrawingRect() {
        JTextField jTextField = this.a;
        Insets insets = jTextField.getInsets();
        int n2 = insets.right - 4 - 16;
        int n3 = insets.top - 3;
        int n4 = jTextField.getWidth() - insets.left - insets.right + 32 + 14 - 5;
        int n5 = jTextField.getBounds().height - insets.top - insets.bottom + 8 - 3;
        if (n5 % 2 == 1) {
            ++n5;
        }
        return new Rectangle(n2, n3, n4, n5);
    }

    protected Point getSearchIconCoord() {
        Rectangle rectangle = this.getDrawingRect();
        return new Point(rectangle.x + 3, rectangle.y + (rectangle.height - 16) / 2 + 1);
    }

    protected Point getClearIconCoord() {
        Rectangle rectangle = this.getDrawingRect();
        return new Point(rectangle.x + rectangle.width - 16 - 1, rectangle.y + (rectangle.height - 16) / 2);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        graphics = (Graphics2D)graphics;
        Object object = this.getComponent();
        Object object2 = ((Component)object).getParent();
        Cloneable cloneable = this.getDrawingRect();
        if (((JComponent)object).isOpaque() && object2 != null) {
            graphics.setColor(((Component)object2).getBackground());
            graphics.fillRect(0, 0, ((JComponent)object).getWidth(), ((JComponent)object).getHeight());
        }
        object2 = new GraphicsConfig(graphics);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        Object object3 = ((JComponent)object).getBorder();
        if (DarculaTextFieldUI.isSearchField((Component)object)) {
            int n2;
            graphics.setColor(((Component)object).getBackground());
            int n3 = n2 = cloneable.height - 1;
            graphics.fillRoundRect(cloneable.x, cloneable.y, cloneable.width, cloneable.height - 1, n3, n3);
            graphics.setColor(((Component)object).isEnabled() ? Gray._100 : new Color(0x535353));
            if (((JComponent)object).getClientProperty("JTextField.Search.noBorderRing") != Boolean.TRUE) {
                if (((Component)object).hasFocus()) {
                    DarculaUIUtil.paintSearchFocusRing((Graphics2D)graphics, cloneable);
                } else {
                    int n4 = n2;
                    graphics.drawRoundRect(cloneable.x, cloneable.y, cloneable.width, cloneable.height - 1, n4, n4);
                }
            }
            cloneable = this.getSearchIconCoord();
            object3 = this.getComponent().getClientProperty("JTextField.Search.FindPopup") instanceof JPopupMenu ? UIManager.getIcon("TextField.darcula.searchWithHistory.icon") : UIManager.getIcon("TextField.darcula.search.icon");
            if (object3 == null) {
                object3 = IconLoader.findIcon("/com/bulenkov/darcula/icons/search.png", DarculaTextFieldUI.class, true);
            }
            object3.paintIcon(null, graphics, ((Point)cloneable).x, ((Point)cloneable).y);
            if (this.getComponent().hasFocus() && this.getComponent().getText().length() > 0) {
                cloneable = this.getClearIconCoord();
                object = UIManager.getIcon("TextField.darcula.clear.icon");
                if (object == null) {
                    object = IconLoader.findIcon("/com/bulenkov/darcula/icons/clear.png", DarculaTextFieldUI.class, true);
                }
                object.paintIcon(null, graphics, ((Point)cloneable).x, ((Point)cloneable).y);
            }
        } else if (object3 instanceof DarculaTextBorder) {
            if (((Component)object).isEnabled() && ((JTextComponent)object).isEditable()) {
                graphics.setColor(((Component)object).getBackground());
            }
            int n5 = ((JComponent)object).getWidth();
            int n6 = ((JComponent)object).getHeight();
            object3 = object3.getBorderInsets((Component)object);
            if (((Component)object).hasFocus()) {
                graphics.fillRoundRect(((Insets)object3).left - 5, ((Insets)object3).top - 2, n5 - ((Insets)object3).right - ((Insets)object3).left + 10, n6 - ((Insets)object3).top - ((Insets)object3).bottom + 6, 5, 5);
            } else {
                graphics.fillRect(((Insets)object3).left - 5, ((Insets)object3).top - 2, n5 - ((Insets)object3).right - ((Insets)object3).left + 12, n6 - ((Insets)object3).top - ((Insets)object3).bottom + 6);
            }
        } else {
            super.paintBackground(graphics);
        }
        ((GraphicsConfig)object2).restore();
    }

    @Override
    protected void paintSafely(Graphics graphics) {
        this.paintBackground(graphics);
        super.paintSafely(graphics);
    }

    public static boolean isSearchField(Component component) {
        return component instanceof JTextField && "search".equals(((JTextField)component).getClientProperty("JTextField.variant"));
    }

    public static boolean isSearchFieldWithHistoryPopup(Component component) {
        return DarculaTextFieldUI.isSearchField(component) && ((JTextField)component).getClientProperty("JTextField.Search.FindPopup") instanceof JPopupMenu;
    }

    static /* synthetic */ int a(DarculaTextFieldUI object, MouseEvent serializable) {
        Point point = ((DarculaTextFieldUI)object).getClearIconCoord();
        object = ((DarculaTextFieldUI)object).getSearchIconCoord();
        point.x += 8;
        point.y += 8;
        ((Point)object).x += 8;
        ((Point)object).y += 8;
        if (point.distance((Point2D)((Object)(serializable = serializable.getPoint()))) <= 8.0) {
            return com.bulenkov.darcula.ui.DarculaTextFieldUI$a.b;
        }
        if (((Point2D)object).distance((Point2D)((Object)serializable)) <= 8.0) {
            return com.bulenkov.darcula.ui.DarculaTextFieldUI$a.a;
        }
        return 0;
    }

    private static final class a
    extends Enum<a> {
        public static final int a = 1;
        public static final int b = 2;
        private static final /* synthetic */ int[] c;

        public static int[] values$28a38999() {
            return (int[])c.clone();
        }

        static {
            c = new int[]{a, b};
        }
    }
}

