/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader;

import com.bulenkov.iconloader.RetinaImage;
import com.bulenkov.iconloader.util.BufferExposingByteArrayOutputStream;
import com.bulenkov.iconloader.util.ConcurrencyUtil;
import com.bulenkov.iconloader.util.Pair;
import com.bulenkov.iconloader.util.ReflectionUtil;
import com.bulenkov.iconloader.util.StringUtil;
import com.bulenkov.iconloader.util.UIUtil;
import com.bulenkov.iconloader.util.URLUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public final class IconLoader {
    public static boolean STRICT = false;
    private static boolean a = UIUtil.isUnderDarcula();
    private static final ConcurrentMap<URL, a> b = new ConcurrentHashMap<URL, a>(100, 0.9f, 2);
    private static final Map<Icon, Icon> c = new WeakHashMap<Icon, Icon>(200);
    private static final 1 d = new ImageIcon(UIUtil.createImage(1, 1, 5)){

        @Override
        public final String toString() {
            return "Empty icon " + super.toString();
        }
    };
    private static AtomicBoolean e = new AtomicBoolean(true);
    private static AtomicBoolean f = new AtomicBoolean(false);
    public static final Component ourComponent = new Component(){};

    private IconLoader() {
    }

    private static boolean a(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediaTracker = new MediaTracker(ourComponent);
        mediaTracker.addImage(image, 1);
        try {
            mediaTracker.waitForID(1, 5000L);
        }
        catch (InterruptedException interruptedException) {}
        return !mediaTracker.isErrorID(1);
    }

    public static Pair<Image, String> loadFromUrl(URL object) {
        for (Pair<String, Integer> pair : IconLoader.getFileNames(((URL)((Object)object)).toString())) {
            try {
                return Pair.create(IconLoader.loadFromStream(URLUtil.openStream(new URL((String)pair.first)), (Integer)pair.second), pair.first);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public static Image loadFromUrl(URL object, boolean bl2, boolean bl3) {
        for (Pair<String, Integer> pair : IconLoader.getFileNames(((URL)((Object)object)).toString(), bl2, bl3)) {
            try {
                return IconLoader.loadFromStream(URLUtil.openStream(new URL((String)pair.first)), (Integer)pair.second);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public static Image loadFromResource(String string) {
        int n2 = 2;
        Class clazz = ReflectionUtil.findCallerClass(2);
        while (clazz != null && clazz.getClassLoader() == null) {
            clazz = ReflectionUtil.findCallerClass(++n2);
        }
        if (clazz == null) {
            clazz = ReflectionUtil.findCallerClass(1);
        }
        if (clazz == null) {
            return null;
        }
        return IconLoader.loadFromResource(string, clazz);
    }

    public static Image loadFromResource(String object, Class clazz) {
        for (Pair<String, Integer> pair : IconLoader.getFileNames((String)((Object)object))) {
            Image image;
            InputStream inputStream = clazz.getResourceAsStream((String)pair.first);
            if (inputStream == null || (image = IconLoader.loadFromStream(inputStream, (Integer)pair.second)) == null) continue;
            return image;
        }
        return null;
    }

    public static List<Pair<String, Integer>> getFileNames(String string) {
        return IconLoader.getFileNames(string, a, UIUtil.isRetina());
    }

    public static List<Pair<String, Integer>> getFileNames(String string, boolean bl2, boolean bl3) {
        if (bl3 || bl2) {
            ArrayList<Pair<String, Integer>> arrayList = new ArrayList<Pair<String, Integer>>(4);
            String string2 = StringUtil.getFileNameWithoutExtension(string);
            String string3 = StringUtil.getFileExtension(string);
            if (bl2 && bl3) {
                arrayList.add(Pair.create(string2 + "@2x_dark." + string3, 2));
            }
            if (bl2) {
                arrayList.add(Pair.create(string2 + "_dark." + string3, 1));
            }
            if (bl3) {
                arrayList.add(Pair.create(string2 + "@2x." + string3, 2));
            }
            arrayList.add(Pair.create(string, 1));
            return arrayList;
        }
        return Collections.singletonList(Pair.create(string, 1));
    }

    public static Image loadFromStream(InputStream inputStream) {
        return IconLoader.loadFromStream(inputStream, 1);
    }

    public static Image loadFromStream(InputStream inputStream, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Scale must 1 or more");
        }
        try {
            Object object;
            BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = new BufferExposingByteArrayOutputStream();
            try {
                int n3;
                object = new byte[1024];
                while ((n3 = inputStream.read((byte[])object)) >= 0) {
                    bufferExposingByteArrayOutputStream.write((byte[])object, 0, n3);
                }
            }
            finally {
                inputStream.close();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(bufferExposingByteArrayOutputStream.getInternalBuffer(), 0, bufferExposingByteArrayOutputStream.size());
            object = image;
            IconLoader.a(image);
            if (UIUtil.isRetina() && n2 > 1) {
                object = RetinaImage.createFrom((Image)object, n2, ourComponent);
            }
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setUseDarkIcons(boolean bl2) {
        a = bl2;
        b.clear();
        c.clear();
    }

    public static Icon getIcon(String string) {
        int n2 = 2;
        Class clazz = ReflectionUtil.findCallerClass(2);
        while (clazz != null && clazz.getClassLoader() == null) {
            clazz = ReflectionUtil.findCallerClass(++n2);
        }
        if (clazz == null) {
            clazz = ReflectionUtil.findCallerClass(1);
        }
        assert (clazz != null) : string;
        return IconLoader.getIcon(string, clazz);
    }

    public static Icon findIcon(String string) {
        int n2 = 2;
        Class clazz = ReflectionUtil.findCallerClass(2);
        while (clazz != null && clazz.getClassLoader() == null) {
            clazz = ReflectionUtil.findCallerClass(++n2);
        }
        if (clazz == null) {
            clazz = ReflectionUtil.findCallerClass(1);
        }
        if (clazz == null) {
            return null;
        }
        return IconLoader.findIcon(string, clazz);
    }

    public static Icon getIcon(String string, Class clazz) {
        Icon icon = IconLoader.findIcon(string, clazz);
        assert (icon != null) : "Icon cannot be found in '" + string + "', aClass='" + clazz + "'";
        return icon;
    }

    public static void activate() {
        e.set(true);
    }

    public static void disable() {
        e.set(false);
    }

    public static boolean isLoaderDisabled() {
        return !e.get();
    }

    public static Icon findIcon(String string, Class clazz) {
        return IconLoader.findIcon(string, clazz, true);
    }

    public static Icon findIcon(String string, Class clazz, boolean bl2) {
        URL uRL = clazz.getResource(string);
        if (uRL == null) {
            if (STRICT) {
                throw new RuntimeException("Can't find icon in '" + string + "' near " + clazz);
            }
            return null;
        }
        return IconLoader.findIcon(uRL);
    }

    public static Icon findIcon(URL uRL) {
        if (uRL == null) {
            return null;
        }
        a a2 = (a)b.get(uRL);
        if (a2 == null) {
            a2 = new a(uRL);
            a2 = ConcurrencyUtil.cacheOrGet(b, uRL, a2);
        }
        return a2;
    }

    public static Icon findIcon(String object, ClassLoader classLoader) {
        if (!StringUtil.startsWithChar((CharSequence)object, '/')) {
            return null;
        }
        object = classLoader.getResource(((String)object).substring(1));
        return IconLoader.findIcon((URL)object);
    }

    public static boolean isGoodSize(Icon icon) {
        return icon.getIconWidth() > 0 && icon.getIconHeight() > 0;
    }

    public static Icon getDisabledIcon(Icon icon) {
        if (icon instanceof LazyIcon) {
            icon = ((LazyIcon)icon).getOrComputeIcon();
        }
        if (icon == null) {
            return null;
        }
        Object object = c.get(icon);
        if (object == null) {
            if (!IconLoader.isGoodSize(icon)) {
                return d;
            }
            int n2 = UIUtil.isRetina() ? 2 : 1;
            Object object2 = new BufferedImage(n2 * icon.getIconWidth(), n2 * icon.getIconHeight(), 2);
            Graphics2D graphics2D = ((BufferedImage)object2).createGraphics();
            graphics2D.setColor(UIUtil.TRANSPARENT_COLOR);
            graphics2D.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
            graphics2D.scale(n2, n2);
            icon.paintIcon(com.bulenkov.iconloader.IconLoader$b.a, graphics2D, 0, 0);
            graphics2D.dispose();
            object = object2;
            object2 = UIUtil.getGrayFilter();
            object = new FilteredImageSource(((BufferedImage)object).getSource(), (ImageFilter)object2);
            object = Toolkit.getDefaultToolkit().createImage((ImageProducer)object);
            if (UIUtil.isRetina()) {
                object = RetinaImage.createFrom((Image)object, 2, ourComponent);
            }
            object = new c((Image)object);
            c.put(icon, (Icon)object);
        }
        return object;
    }

    public static Icon getTransparentIcon(Icon icon) {
        return IconLoader.getTransparentIcon(icon, 0.5f);
    }

    public static Icon getTransparentIcon(Icon icon, float f2) {
        return new Icon(icon, f2){
            private /* synthetic */ Icon a;
            private /* synthetic */ float b;
            {
                this.a = icon;
                this.b = f2;
            }

            @Override
            public final int getIconHeight() {
                return this.a.getIconHeight();
            }

            @Override
            public final int getIconWidth() {
                return this.a.getIconWidth();
            }

            @Override
            public final void paintIcon(Component component, Graphics graphics, int n2, int n3) {
                graphics = (Graphics2D)graphics;
                Composite composite = ((Graphics2D)graphics).getComposite();
                ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(10, this.b));
                this.a.paintIcon(component, graphics, n2, n3);
                ((Graphics2D)graphics).setComposite(composite);
            }
        };
    }

    static /* synthetic */ Icon a(Image object, URL uRL) {
        if (object == null || ((Image)object).getHeight(com.bulenkov.iconloader.IconLoader$b.a) <= 0) {
            return null;
        }
        if (!IconLoader.isGoodSize((Icon)(object = new c((Image)object)))) {
            return d;
        }
        return object;
    }

    private static final class b {
        private static final JComponent a = new JLabel();
    }

    public static abstract class LazyIcon
    implements Icon {
        private boolean a;
        private Icon b;
        private boolean c = IconLoader.a();

        @Override
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Icon icon = this.getOrComputeIcon();
            if (icon != null) {
                icon.paintIcon(component, graphics, n2, n3);
            }
        }

        @Override
        public int getIconWidth() {
            Icon icon = this.getOrComputeIcon();
            if (icon != null) {
                return icon.getIconWidth();
            }
            return 0;
        }

        @Override
        public int getIconHeight() {
            Icon icon = this.getOrComputeIcon();
            if (icon != null) {
                return icon.getIconHeight();
            }
            return 0;
        }

        protected final synchronized Icon getOrComputeIcon() {
            if (!this.a || this.c != a) {
                this.c = a;
                this.a = true;
                this.b = this.compute();
            }
            return this.b;
        }

        public final void load() {
            this.getIconWidth();
        }

        protected abstract Icon compute();
    }

    private static final class c
    extends ImageIcon {
        public c(Image image) {
            super(image);
        }

        @Override
        public final synchronized void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            ImageObserver imageObserver = this.getImageObserver();
            UIUtil.drawImage(graphics, this.getImage(), n2, n3, imageObserver == null ? component : imageObserver);
        }
    }

    static final class a
    implements Icon {
        private Object a;
        private String b;
        private final URL c;
        private boolean d;

        public a(URL uRL) {
            this.c = uRL;
            this.d = a;
        }

        private synchronized Icon a() {
            Icon icon;
            Object object;
            if (IconLoader.isLoaderDisabled()) {
                return d;
            }
            if (this.d != a) {
                this.a = null;
                this.d = a;
            }
            if ((object = this.a) instanceof Icon) {
                return (Icon)object;
            }
            if (object instanceof Reference && (icon = (Icon)((Reference)object).get()) != null) {
                return icon;
            }
            Pair<Image, String> pair = IconLoader.loadFromUrl(this.c);
            icon = IconLoader.a((Image)pair.first, this.c);
            if (icon != null) {
                object = icon.getIconWidth() < 50 && icon.getIconHeight() < 50 ? icon : new SoftReference<Icon>(icon);
                this.a = object;
                if (f.get()) {
                    this.b = (String)pair.second;
                }
            }
            if (icon == null) {
                return d;
            }
            return icon;
        }

        @Override
        public final void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            this.a().paintIcon(component, graphics, n2, n3);
        }

        @Override
        public final int getIconWidth() {
            return this.a().getIconWidth();
        }

        @Override
        public final int getIconHeight() {
            return this.a().getIconHeight();
        }

        public final String toString() {
            return this.c.toString();
        }
    }
}

