/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader;

import com.bulenkov.iconloader.AppleHiDPIScaledImage;
import com.bulenkov.iconloader.JBHiDPIScaledImage;
import com.bulenkov.iconloader.util.SystemInfo;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class RetinaImage {
    public static Image createFrom(Image image, int n2, Component component) {
        int n3 = image.getWidth(component);
        int n4 = image.getHeight(component);
        BufferedImage bufferedImage = RetinaImage.a(image, n3 / n2, n4 / n2, 2);
        if (SystemInfo.isAppleJvm) {
            Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
            graphics2D.scale(1.0f / (float)n2, 1.0f / (float)n2);
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    public static BufferedImage create(int n2, int n3, int n4) {
        return RetinaImage.a(null, n2, n3, n4);
    }

    private static BufferedImage a(Image image, int n2, int n3, int n4) {
        if (SystemInfo.isAppleJvm) {
            return AppleHiDPIScaledImage.create(n2, n3, n4);
        }
        if (image == null) {
            return new JBHiDPIScaledImage(n2, n3, n4);
        }
        return new JBHiDPIScaledImage(image, n2, n3, n4);
    }

    public static boolean isAppleHiDPIScaledImage(Image image) {
        return SystemInfo.isMac && UIUtil.isRetina() && AppleHiDPIScaledImage.is(image);
    }
}

