/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import java.io.OutputStream;
import java.util.Arrays;

public class AsyncByteArrayOutputStream
extends OutputStream {
    protected byte[] myBuffer;
    protected int myCount;

    public AsyncByteArrayOutputStream() {
        this(32);
    }

    public AsyncByteArrayOutputStream(int n2) {
        this.myBuffer = new byte[n2];
    }

    @Override
    public void write(int n2) {
        int n3 = this.myCount + 1;
        if (n3 > this.myBuffer.length) {
            this.myBuffer = Arrays.copyOf(this.myBuffer, Math.max(this.myBuffer.length << 1, n3));
        }
        this.myBuffer[this.myCount] = (byte)n2;
        this.myCount = n3;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.myCount + n3;
        if (n4 > this.myBuffer.length) {
            this.myBuffer = Arrays.copyOf(this.myBuffer, Math.max(this.myBuffer.length << 1, n4));
        }
        System.arraycopy(byArray, n2, this.myBuffer, this.myCount, n3);
        this.myCount = n4;
    }

    public void writeTo(OutputStream outputStream) {
        outputStream.write(this.myBuffer, 0, this.myCount);
    }

    public void reset() {
        this.myCount = 0;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.myBuffer, this.myCount);
    }

    public int size() {
        return this.myCount;
    }

    public String toString() {
        return new String(this.myBuffer, 0, this.myCount);
    }
}

