/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.util.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;

public class ComparingUtils {
    private ComparingUtils() {
    }

    public static <T> boolean equal(T object, T object2) {
        if (object == null || object2 == null) {
            return object == object2;
        }
        if (object instanceof Object[] && object2 instanceof Object[]) {
            object = (Object[])object;
            object2 = (Object[])object2;
            return Arrays.equals(object, object2);
        }
        if (object instanceof CharSequence && object2 instanceof CharSequence) {
            return ComparingUtils.equal((CharSequence)object, (CharSequence)object2, true);
        }
        return object.equals(object2);
    }

    public static <T> boolean equal(T[] TArray, T[] TArray2) {
        if (TArray == null || TArray2 == null) {
            return TArray == TArray2;
        }
        return Arrays.equals(TArray, TArray2);
    }

    public static boolean equal(CharSequence charSequence, CharSequence charSequence2) {
        return ComparingUtils.equal(charSequence, charSequence2, true);
    }

    public static boolean equal(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public static boolean equal(CharSequence charSequence, CharSequence charSequence2, boolean bl2) {
        if (charSequence == charSequence2) {
            return true;
        }
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        if (charSequence.length() != charSequence2.length()) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = charSequence.length();
        while (n4-- > 0) {
            char c2;
            char c3;
            if ((c3 = charSequence.charAt(n2++)) == (c2 = charSequence2.charAt(n3++)) || !bl2 && StringUtil.charsEqualIgnoreCase(c3, c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(String string, String string2, boolean bl2) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        if (bl2) {
            return string.equals(string2);
        }
        return string.equalsIgnoreCase(string2);
    }

    public static boolean strEqual(String string, String string2) {
        return ComparingUtils.strEqual(string, string2, true);
    }

    public static boolean strEqual(String string, String string2, boolean bl2) {
        return ComparingUtils.equal(string == null ? "" : string, string2 == null ? "" : string2, bl2);
    }

    public static <T> boolean haveEqualElements(Collection<T> collection, Collection<T> object) {
        if (collection.size() != object.size()) {
            return false;
        }
        collection = new HashSet<T>(collection);
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (collection.contains(e2)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean haveEqualElements(T[] object, T[] TArray) {
        if (object == null || TArray == null) {
            return object == TArray;
        }
        if (((T[])object).length != TArray.length) {
            return false;
        }
        object = new HashSet<T>(Arrays.asList(object));
        for (T t2 : TArray) {
            if (object.contains(t2)) continue;
            return false;
        }
        return true;
    }

    public static int hashcode(Object object) {
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }

    public static int hashcode(Object object, Object object2) {
        return ComparingUtils.hashcode(object) ^ ComparingUtils.hashcode(object2);
    }

    public static int compare(byte by, byte by2) {
        if (by < by2) {
            return -1;
        }
        if (by == by2) {
            return 0;
        }
        return 1;
    }

    public static int compare(boolean bl2, boolean bl3) {
        if (bl2 == bl3) {
            return 0;
        }
        if (bl2) {
            return 1;
        }
        return -1;
    }

    public static int compare(int n2, int n3) {
        if (n2 < n3) {
            return -1;
        }
        if (n2 == n3) {
            return 0;
        }
        return 1;
    }

    public static int compare(long l2, long l3) {
        if (l2 < l3) {
            return -1;
        }
        if (l2 == l3) {
            return 0;
        }
        return 1;
    }

    public static int compare(double d2, double d3) {
        if (d2 < d3) {
            return -1;
        }
        if (d2 == d3) {
            return 0;
        }
        return 1;
    }

    public static int compare(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return 0;
        }
        if (byArray == null) {
            return 1;
        }
        if (byArray2 == null) {
            return -1;
        }
        if (byArray.length > byArray2.length) {
            return 1;
        }
        if (byArray.length < byArray2.length) {
            return -1;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] > byArray2[i2]) {
                return 1;
            }
            if (byArray[i2] >= byArray2[i2]) continue;
            return -1;
        }
        return 0;
    }

    public static <T extends Comparable<T>> int compare(T t2, T t3) {
        if (t2 == null) {
            if (t3 == null) {
                return 0;
            }
            return -1;
        }
        if (t3 == null) {
            return 1;
        }
        return t2.compareTo(t3);
    }

    public static <T> int compare(T t2, T t3, Comparator<T> comparator) {
        if (t2 == null) {
            if (t3 == null) {
                return 0;
            }
            return -1;
        }
        if (t3 == null) {
            return 1;
        }
        return comparator.compare(t2, t3);
    }
}

