/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConcurrencyUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> List<Future<T>> invokeAll(Collection<Callable<T>> iterator, ExecutorService object) {
        if (object == null) {
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                iterator = (Callable)iterator2.next();
                iterator.call();
            }
            return null;
        }
        Object object2 = new ArrayList(iterator.size());
        try {
            Object object3;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object3 = (Callable)iterator.next();
                object3 = object.submit(object3);
                object2.add(object3);
            }
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object3 = (Future)iterator.next();
                ((Runnable)object3).run();
            }
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object3 = (Future)iterator.next();
                try {
                    object3.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {
                    object3 = executionException;
                    object = executionException.getCause();
                    if (object == null) continue;
                    throw object;
                    return object2;
                }
            }
        }
        catch (Throwable throwable) {
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (Future)object.next();
                object2.cancel(false);
            }
            throw throwable;
        }
    }

    public static <K, V> V cacheOrGet(ConcurrentMap<K, V> concurrentMap, K k2, V v2) {
        Object v3 = concurrentMap.get(k2);
        if (v3 != null) {
            return v3;
        }
        if ((concurrentMap = concurrentMap.putIfAbsent(k2, v2)) == null) {
            return v2;
        }
        return (V)concurrentMap;
    }

    public static ThreadPoolExecutor newSingleThreadExecutor(String string) {
        return ConcurrencyUtil.newSingleThreadExecutor(string, 5);
    }

    public static ThreadPoolExecutor newSingleThreadExecutor(String string, int n2) {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ConcurrencyUtil.newNamedThreadFactory(string, true, n2));
    }

    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(String string) {
        return ConcurrencyUtil.newSingleScheduledThreadExecutor(string, 5);
    }

    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(String object, int n2) {
        object = new ScheduledThreadPoolExecutor(1, ConcurrencyUtil.newNamedThreadFactory((String)object, true, n2));
        ((ScheduledThreadPoolExecutor)object).setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        ((ScheduledThreadPoolExecutor)object).setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return object;
    }

    public static ThreadFactory newNamedThreadFactory(String string, boolean bl2, int n2) {
        return new ThreadFactory(string, bl2, n2){
            private /* synthetic */ String a;
            private /* synthetic */ boolean b;
            private /* synthetic */ int c;
            {
                this.a = string;
                this.b = bl2;
                this.c = n2;
            }

            @Override
            public final Thread newThread(Runnable runnable) {
                runnable = new Thread(runnable, this.a);
                ((Thread)runnable).setDaemon(this.b);
                ((Thread)runnable).setPriority(this.c);
                return runnable;
            }
        };
    }

    public static ThreadFactory newNamedThreadFactory(String string) {
        return new ThreadFactory(string){
            private /* synthetic */ String a;
            {
                this.a = string;
            }

            @Override
            public final Thread newThread(Runnable runnable) {
                return new Thread(runnable, this.a);
            }
        };
    }
}

