/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.util.GraphicsConfig;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.Map;

public class GraphicsUtil {
    public static void setupAntialiasing(Graphics graphics) {
        GraphicsUtil.setupAntialiasing(graphics, true, false);
    }

    public static void setupAntialiasing(Graphics graphics, boolean bl2, boolean bl3) {
        if (graphics instanceof Graphics2D) {
            graphics = (Graphics2D)graphics;
            Object object = Toolkit.getDefaultToolkit();
            if ((object = (Map)((Toolkit)object).getDesktopProperty("awt.font.desktophints")) != null && !bl3) {
                ((Graphics2D)graphics).addRenderingHints((Map<?, ?>)object);
                return;
            }
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, bl2 ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    public static GraphicsConfig setupAAPainting(Graphics graphics) {
        GraphicsConfig graphicsConfig = new GraphicsConfig(graphics);
        graphics = (Graphics2D)graphics;
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        return graphicsConfig;
    }

    public static GraphicsConfig paintWithAlpha(Graphics graphics, float f2) {
        assert (0.0f <= f2 && f2 <= 1.0f) : "alpha should be in range 0.0f .. 1.0f";
        GraphicsConfig graphicsConfig = new GraphicsConfig(graphics);
        graphics = (Graphics2D)graphics;
        ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, f2));
        return graphicsConfig;
    }
}

