/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.util.ArrayUtilRt;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static Type resolveVariable(TypeVariable typeVariable, Class clazz) {
        return ReflectionUtil.resolveVariable(typeVariable, clazz, true);
    }

    public static Type resolveVariable(TypeVariable type, Class clazz, boolean bl2) {
        int n2 = ArrayUtilRt.find((clazz = ReflectionUtil.getRawType(clazz)).getTypeParameters(), type);
        if (n2 >= 0) {
            return type;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        Type[] typeArray = clazz.getGenericInterfaces();
        for (int i2 = 0; i2 <= classArray.length; ++i2) {
            Class<?> clazz2;
            if (i2 < classArray.length) {
                clazz2 = classArray[i2];
            } else {
                clazz2 = clazz.getSuperclass();
                if (bl2 || clazz2 == null) continue;
            }
            Type type2 = ReflectionUtil.resolveVariable((TypeVariable)type, clazz2);
            if (type2 instanceof Class || type2 instanceof ParameterizedType) {
                return type2;
            }
            if (!(type2 instanceof TypeVariable)) continue;
            type = (TypeVariable)type2;
            int n3 = ArrayUtilRt.find(clazz2.getTypeParameters(), type);
            assert (n3 >= 0) : "Cannot resolve type variable:\ntypeVariable = " + type + "\ngenericDeclaration = " + ReflectionUtil.declarationToString(type.getGenericDeclaration()) + "\nsearching in " + ReflectionUtil.declarationToString(clazz2);
            type = i2 < typeArray.length ? typeArray[i2] : clazz.getGenericSuperclass();
            if (type instanceof Class) {
                return Object.class;
            }
            if (type instanceof ParameterizedType) {
                return ReflectionUtil.getActualTypeArguments((ParameterizedType)type)[n3];
            }
            throw new AssertionError((Object)("Invalid type: " + type));
        }
        return null;
    }

    public static String declarationToString(GenericDeclaration genericDeclaration) {
        return genericDeclaration.toString() + Arrays.asList(genericDeclaration.getTypeParameters()) + " loaded by " + ((Class)genericDeclaration).getClassLoader();
    }

    public static Class<?> getRawType(Type type) {
        while (true) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (!(type instanceof ParameterizedType)) break;
            type = ((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ReflectionUtil.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        assert (false) : type;
        return null;
    }

    public static Type[] getActualTypeArguments(ParameterizedType parameterizedType) {
        return parameterizedType.getActualTypeArguments();
    }

    public static Class<?> substituteGenericType(Type type, Type type2) {
        if (type instanceof TypeVariable) {
            int n2;
            Class<?> clazz = ReflectionUtil.getRawType(type2);
            if ((type = ReflectionUtil.resolveVariable((TypeVariable)type, clazz)) instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable && type2 instanceof ParameterizedType && (n2 = ArrayUtilRt.find(clazz.getTypeParameters(), type)) >= 0) {
                return ReflectionUtil.getRawType(ReflectionUtil.getActualTypeArguments((ParameterizedType)type2)[n2]);
            }
        } else {
            return ReflectionUtil.getRawType(type);
        }
        return null;
    }

    public static List<Field> collectFields(Class clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        ReflectionUtil.a(clazz, arrayList);
        return arrayList;
    }

    public static Field findField(Class clazz, Class clazz2, String string) {
        Object object = ReflectionUtil.collectFields(clazz);
        object = object.iterator();
        while (object.hasNext()) {
            Field field = (Field)object.next();
            if (!string.equals(field.getName()) || clazz2 != null && !field.getType().equals(clazz2)) continue;
            return field;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + string + " type: " + clazz2);
    }

    public static Field findAssignableField(Class clazz, Class clazz2, String string) {
        Object object = ReflectionUtil.collectFields(clazz);
        object = object.iterator();
        while (object.hasNext()) {
            Field field = (Field)object.next();
            if (!string.equals(field.getName()) || !clazz2.isAssignableFrom(field.getType())) continue;
            return field;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + string + " type: " + clazz2);
    }

    private static void a(Class classArray, List<Field> list) {
        Object object = classArray.getDeclaredFields();
        list.addAll(Arrays.asList(object));
        object = classArray.getSuperclass();
        if (object != null) {
            ReflectionUtil.a((Class)object, list);
        }
        Class<?>[] classArray2 = classArray.getInterfaces();
        classArray = classArray2;
        classArray = classArray2;
        int n2 = classArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Class<?> clazz = classArray[i2];
            ReflectionUtil.a(clazz, list);
        }
    }

    public static void resetField(Class clazz, Class clazz2, String string) {
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, clazz2, string));
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
    }

    public static void resetField(Object object, Class clazz, String string) {
        try {
            Object object2 = object;
            ReflectionUtil.resetField(object2, ReflectionUtil.findField(object2.getClass(), clazz, string));
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
    }

    public static void resetField(Object object, String string) {
        try {
            Object object2 = object;
            ReflectionUtil.resetField(object2, ReflectionUtil.findField(object2.getClass(), null, string));
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
    }

    public static void resetField(Object object, Field field) {
        block8: {
            field.setAccessible(true);
            Class<?> clazz = field.getType();
            try {
                if (clazz.isPrimitive()) {
                    if (Boolean.TYPE.equals(clazz)) {
                        field.set(object, Boolean.FALSE);
                        break block8;
                    }
                    if (Integer.TYPE.equals(clazz)) {
                        field.set(object, 0);
                        break block8;
                    }
                    if (Double.TYPE.equals(clazz)) {
                        field.set(object, 0.0);
                        break block8;
                    }
                    if (Float.TYPE.equals(clazz)) {
                        field.set(object, Float.valueOf(0.0f));
                        break block8;
                    }
                } else {
                    field.set(object, null);
                }
                return;
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    public static Method findMethod(Method[] methodArray, String string, Class ... classArray) {
        for (Method method : methodArray) {
            if (!string.equals(method.getName()) || !Arrays.equals(classArray, method.getParameterTypes())) continue;
            return method;
        }
        return null;
    }

    public static Method getMethod(Class clazz, String string, Class ... classArray) {
        return ReflectionUtil.findMethod(clazz.getMethods(), string, classArray);
    }

    public static Method getDeclaredMethod(Class clazz, String string, Class ... classArray) {
        return ReflectionUtil.findMethod(clazz.getDeclaredMethods(), string, classArray);
    }

    public static <T> T getField(Class annotatedElement, Object object, Class<T> clazz, String string) {
        try {
            annotatedElement = ReflectionUtil.findAssignableField((Class)annotatedElement, clazz, string);
            ((Field)annotatedElement).setAccessible(true);
            return (T)((Field)annotatedElement).get(object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public static Type resolveVariableInHierarchy(TypeVariable typeVariable, Class clazz) {
        Type type;
        while (true) {
            Class clazz2 = clazz;
            while ((type = ReflectionUtil.resolveVariable(typeVariable, clazz2, false)) == null) {
                if ((clazz2 = clazz2.getSuperclass()) != null) continue;
                return null;
            }
            if (!(type instanceof TypeVariable)) break;
            typeVariable = (TypeVariable)type;
        }
        return type;
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("No default constructor in " + clazz, noSuchMethodException);
        }
    }

    public static <T> T createInstance(Constructor<T> constructor, Object ... objectArray) {
        try {
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void resetThreadLocals() {
        try {
            Field field = Thread.class.getDeclaredField("threadLocals");
            field.setAccessible(true);
            field.set(Thread.currentThread(), null);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public static Class findCallerClass(int n2) {
        try {
            Class[] classArray = com.bulenkov.iconloader.util.ReflectionUtil$a.a.a();
            if (classArray.length > ++n2) {
                return classArray[n2];
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final class a
    extends SecurityManager {
        private static final a a = new a();

        private a() {
        }

        public final Class[] a() {
            return this.getClassContext();
        }
    }
}

