/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.util.StringUtil;

public class SystemInfo {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version").toLowerCase();
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
    protected static final String _OS_NAME = OS_NAME.toLowerCase();
    public static final boolean isWindows = _OS_NAME.startsWith("windows");
    public static final boolean isOS2 = _OS_NAME.startsWith("os/2") || _OS_NAME.startsWith("os2");
    public static final boolean isMac = _OS_NAME.startsWith("mac");
    public static final boolean isLinux = _OS_NAME.startsWith("linux");
    public static final boolean isUnix = !isWindows && !isOS2;
    public static final boolean isFileSystemCaseSensitive;
    public static final boolean isMacOSLion;
    public static final boolean isAppleJvm;
    public static final boolean isOracleJvm;
    public static final boolean isSunJvm;

    public static boolean isOsVersionAtLeast(String string) {
        return SystemInfo.compareVersionNumbers(OS_VERSION, string) >= 0;
    }

    public static int compareVersionNumbers(String stringArray, String stringArray2) {
        int n2;
        if (stringArray == null && stringArray2 == null) {
            return 0;
        }
        if (stringArray == null) {
            return -1;
        }
        if (stringArray2 == null) {
            return 1;
        }
        stringArray = stringArray.split("[\\.\\_\\-]");
        stringArray2 = stringArray2.split("[\\.\\_\\-]");
        for (n2 = 0; n2 < stringArray.length && n2 < stringArray2.length; ++n2) {
            String string = stringArray[n2];
            String string2 = stringArray2[n2];
            int n3 = string.matches("\\d+") && string2.matches("\\d+") ? new Integer(string).compareTo(new Integer(string2)) : stringArray[n2].compareTo(stringArray2[n2]);
            if (n3 == 0) continue;
            return n3;
        }
        if (stringArray.length == stringArray2.length) {
            return 0;
        }
        if (stringArray.length > n2) {
            return 1;
        }
        return -1;
    }

    public static boolean isJavaVersionAtLeast(String string) {
        return StringUtil.compareVersionNumbers(JAVA_RUNTIME_VERSION, string) >= 0;
    }

    public static String getJavaVmVendor() {
        return System.getProperty("java.vm.vendor");
    }

    static {
        boolean bl2 = isFileSystemCaseSensitive = isUnix && !isMac;
        isMacOSLion = isMac && isMac && isMac && isMac && !OS_VERSION.startsWith("10.0") && !OS_VERSION.startsWith("10.1") && !OS_VERSION.startsWith("10.2") && !OS_VERSION.startsWith("10.3") && !OS_VERSION.startsWith("10.4") && !OS_VERSION.startsWith("10.5") && !OS_VERSION.startsWith("10.6");
        String string = SystemInfo.getJavaVmVendor();
        isAppleJvm = string != null && StringUtil.containsIgnoreCase(string, "Apple");
        string = SystemInfo.getJavaVmVendor();
        isOracleJvm = string != null && StringUtil.containsIgnoreCase(string, "Oracle");
        string = SystemInfo.getJavaVmVendor();
        isSunJvm = string != null && StringUtil.containsIgnoreCase(string, "Sun") && StringUtil.containsIgnoreCase(string, "Microsystems");
    }
}

