/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.IconLoader;
import com.bulenkov.iconloader.IsRetina;
import com.bulenkov.iconloader.JBHiDPIScaledImage;
import com.bulenkov.iconloader.RetinaImage;
import com.bulenkov.iconloader.util.CenteredIcon;
import com.bulenkov.iconloader.util.ColorUtil;
import com.bulenkov.iconloader.util.DoubleColor;
import com.bulenkov.iconloader.util.Gray;
import com.bulenkov.iconloader.util.Ref;
import com.bulenkov.iconloader.util.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.lang.reflect.Field;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class UIUtil {
    public static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private static final DoubleColor a = new DoubleColor(new Color(242, 245, 249), new Color(65, 69, 71));
    private static final Ref<Boolean> b = Ref.create(SystemInfo.isMac ? null : Boolean.FALSE);
    private static final GrayFilter c = new GrayFilter(true, 65);
    private static final GrayFilter d = new GrayFilter(true, 30);

    public static <T extends JComponent> T findComponentOfType(JComponent componentArray, Class<T> clazz) {
        if (componentArray == null || clazz.isAssignableFrom(componentArray.getClass())) {
            return (T)componentArray;
        }
        for (Component component : componentArray.getComponents()) {
            if (!(component instanceof JComponent) || (component = UIUtil.findComponentOfType((JComponent)component, clazz)) == null) continue;
            return (T)component;
        }
        return null;
    }

    public static <T> T getParentOfType(Class<? extends T> serializable, Component component) {
        while (component != null) {
            if (serializable.isAssignableFrom(component.getClass())) {
                serializable = component;
                return (T)serializable;
            }
            component = component.getParent();
        }
        return null;
    }

    public static Color getControlColor() {
        return UIManager.getColor("control");
    }

    public static Color getPanelBackground() {
        return UIManager.getColor("Panel.background");
    }

    public static boolean isUnderDarcula() {
        return UIManager.getLookAndFeel().getName().equals("Darcula");
    }

    public static Color getListBackground() {
        return UIManager.getColor("List.background");
    }

    public static Color getListForeground() {
        return UIManager.getColor("List.foreground");
    }

    public static Color getLabelForeground() {
        return UIManager.getColor("Label.foreground");
    }

    public static Color getTextFieldBackground() {
        return UIManager.getColor("TextField.background");
    }

    public static Color getTreeSelectionForeground() {
        return UIManager.getColor("Tree.selectionForeground");
    }

    public static Color getTreeForeground() {
        return UIManager.getColor("Tree.foreground");
    }

    public static Color getDecoratedRowColor() {
        return a;
    }

    public static Color getTreeSelectionBackground(boolean bl2) {
        if (bl2) {
            return UIManager.getColor("Tree.selectionBackground");
        }
        return UIUtil.getTreeUnfocusedSelectionBackground();
    }

    public static Color getTreeUnfocusedSelectionBackground() {
        Color color = UIUtil.getTreeTextBackground();
        if (ColorUtil.isDark(color)) {
            return new DoubleColor(Gray._30, new Color(13, 41, 62));
        }
        return Gray._212;
    }

    public static Color getTreeTextBackground() {
        return UIManager.getColor("Tree.textBackground");
    }

    public static Icon getTreeNodeIcon(boolean bl2, boolean bl3, boolean bl4) {
        bl3 = bl3 && bl4 || UIUtil.isUnderDarcula();
        Icon icon = UIUtil.getTreeSelectedExpandedIcon();
        Icon icon2 = UIUtil.getTreeExpandedIcon();
        int n2 = Math.max(icon.getIconWidth(), icon2.getIconWidth());
        int n3 = Math.max(icon.getIconWidth(), icon2.getIconWidth());
        return new CenteredIcon(bl2 ? (bl3 ? UIUtil.getTreeSelectedExpandedIcon() : UIUtil.getTreeExpandedIcon()) : (bl3 ? UIUtil.getTreeSelectedCollapsedIcon() : UIUtil.getTreeCollapsedIcon()), n2, n3, false);
    }

    public static Icon getTreeCollapsedIcon() {
        return UIManager.getIcon("Tree.collapsedIcon");
    }

    public static Icon getTreeExpandedIcon() {
        return UIManager.getIcon("Tree.expandedIcon");
    }

    public static Icon getTreeSelectedCollapsedIcon() {
        return IconLoader.getIcon("/icons/tree_white_right_arrow.png");
    }

    public static Icon getTreeSelectedExpandedIcon() {
        return IconLoader.getIcon("/icons/tree_white_down_arrow.png");
    }

    public static void drawImage(Graphics graphics, Image image, int n2, int n3, ImageObserver imageObserver) {
        if (image instanceof JBHiDPIScaledImage) {
            graphics = (Graphics2D)graphics.create(n2, n3, image.getWidth(imageObserver), image.getHeight(imageObserver));
            ((Graphics2D)graphics).scale(0.5, 0.5);
            Image image2 = ((JBHiDPIScaledImage)image).getDelegate();
            if (image2 == null) {
                image2 = image;
            }
            graphics.drawImage(image2, 0, 0, imageObserver);
            ((Graphics2D)graphics).scale(1.0, 1.0);
            graphics.dispose();
            return;
        }
        graphics.drawImage(image, n2, n3, imageObserver);
    }

    public static boolean isRetina() {
        Ref<Boolean> ref = b;
        synchronized (ref) {
            if (b.isNull()) {
                b.set(Boolean.FALSE);
                if (SystemInfo.isJavaVersionAtLeast("1.6.0_33") && SystemInfo.isAppleJvm) {
                    if (!"false".equals(System.getProperty("ide.mac.retina"))) {
                        b.set(IsRetina.isRetina());
                        return b.get();
                    }
                } else if (SystemInfo.isJavaVersionAtLeast("1.7.0_40") && SystemInfo.isOracleJvm) {
                    Object object = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    object = ((GraphicsEnvironment)object).getDefaultScreenDevice();
                    try {
                        Field field = object.getClass().getDeclaredField("scale");
                        if (field != null) {
                            field.setAccessible(true);
                            object = field.get(object);
                            if (object instanceof Integer && (Integer)object == 2) {
                                b.set(Boolean.TRUE);
                                return true;
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
                b.set(Boolean.FALSE);
            }
            return b.get();
        }
    }

    public static BufferedImage createImage(int n2, int n3, int n4) {
        if (UIUtil.isRetina()) {
            return RetinaImage.create(n2, n3, n4);
        }
        return new BufferedImage(n2, n3, n4);
    }

    public static GrayFilter getGrayFilter() {
        if (UIUtil.isUnderDarcula()) {
            return d;
        }
        return c;
    }
}

