/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.util.Base64Converter;
import com.bulenkov.iconloader.util.Pair;
import com.bulenkov.iconloader.util.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class URLUtil {
    public static final String SCHEME_SEPARATOR = "://";
    public static final String FILE_PROTOCOL = "file";
    public static final String HTTP_PROTOCOL = "http";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JAR_SEPARATOR = "!/";
    public static final Pattern DATA_URI_PATTERN = Pattern.compile("data:([^,;]+/[^,;]+)(;charset=[^,;]+)?(;base64)?,(.+)");

    private URLUtil() {
    }

    public static InputStream openStream(URL object) {
        Pair<String, String> pair = ((URL)object).getProtocol();
        if (((String)((Object)pair)).equals(JAR_PROTOCOL)) {
            pair = URLUtil.splitJarUrl(((URL)object).getFile());
            if (pair == null) {
                throw new MalformedURLException(((URL)object).getFile());
            }
            object = new ZipFile(URLUtil.unquote((String)pair.first));
            ZipEntry zipEntry = ((ZipFile)object).getEntry((String)pair.second);
            if (zipEntry == null) {
                throw new FileNotFoundException("Entry " + (String)pair.second + " not found in " + (String)pair.first);
            }
            return new FilterInputStream(((ZipFile)object).getInputStream(zipEntry), (ZipFile)object){
                private /* synthetic */ ZipFile a;
                {
                    this.a = zipFile;
                    super(inputStream);
                }

                @Override
                public final void close() {
                    super.close();
                    this.a.close();
                }
            };
        }
        return ((URL)object).openStream();
    }

    public static InputStream openResourceStream(URL uRL) {
        try {
            return URLUtil.openStream(uRL);
        }
        catch (FileNotFoundException fileNotFoundException) {
            int n2;
            Object object = uRL.getProtocol();
            String string = null;
            if (((String)object).equals(FILE_PROTOCOL)) {
                string = uRL.getFile();
            } else if (((String)object).equals(JAR_PROTOCOL) && (n2 = uRL.getFile().indexOf("!")) >= 0) {
                string = uRL.getFile().substring(n2 + 1);
            }
            if (string != null && string.startsWith("/") && (object = URLUtil.class.getResourceAsStream(string)) != null) {
                return object;
            }
            throw fileNotFoundException;
        }
    }

    public static String unquote(String string) {
        string = string.replace('/', File.separatorChar);
        return URLUtil.unescapePercentSequences(string);
    }

    public static Pair<String, String> splitJarUrl(String string) {
        int n2 = string.indexOf(JAR_SEPARATOR);
        if (n2 >= 0) {
            String string2 = string.substring(n2 + 2);
            string = string.substring(0, n2);
            if (StringUtil.startsWithConcatenation(string, FILE_PROTOCOL, ":")) {
                string = string.substring(4 + 1);
                return Pair.create(string, string2);
            }
        }
        return null;
    }

    public static String unescapePercentSequences(String string) {
        if (string.indexOf(37) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 == '%') {
                int n4;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                while (n3 + 2 < n2 && string.charAt(n3) == '%') {
                    int n5 = URLUtil.a(string.charAt(n3 + 1));
                    n4 = URLUtil.a(string.charAt(n3 + 2));
                    if (n5 == -1 || n4 == -1) break;
                    arrayList.add((n5 & 0xF) << 4 | n4 & 0xF);
                    n3 += 3;
                }
                if (!arrayList.isEmpty()) {
                    byte[] byArray = new byte[arrayList.size()];
                    for (n4 = 0; n4 < arrayList.size(); ++n4) {
                        byArray[n4] = ((Integer)arrayList.get(n4)).byteValue();
                    }
                    stringBuilder.append(new String(byArray, Charset.forName("UTF-8")));
                    continue;
                }
            }
            stringBuilder.append(c2);
            ++n3;
        }
        return stringBuilder.toString();
    }

    private static int a(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        return -1;
    }

    public static boolean containsScheme(String string) {
        return string.contains(SCHEME_SEPARATOR);
    }

    public static boolean isDataUri(String string) {
        return !string.isEmpty() && string.startsWith("data:", string.charAt(0) == '\"' || string.charAt(0) == '\'' ? 1 : 0);
    }

    public static byte[] getBytesFromDataUri(String object) {
        if (((Matcher)(object = DATA_URI_PATTERN.matcher(StringUtil.stripQuotesAroundValue((String)object)))).matches()) {
            try {
                Object object2 = ((Matcher)object).group(4);
                Charset charset = Charset.forName("UTF-8");
                object2 = ((String)object2).getBytes(charset);
                if (";base64".equalsIgnoreCase(((Matcher)object).group(3))) {
                    return Base64Converter.decode((byte[])object2);
                }
                return object2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return null;
    }
}

