/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.annotation;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.fasterxml.jackson.annotation.JacksonAnnotationValue;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonAutoDetect {
    public Visibility getterVisibility() default Visibility.DEFAULT;

    public Visibility isGetterVisibility() default Visibility.DEFAULT;

    public Visibility setterVisibility() default Visibility.DEFAULT;

    public Visibility creatorVisibility() default Visibility.DEFAULT;

    public Visibility fieldVisibility() default Visibility.DEFAULT;

    public static class Value
    implements JacksonAnnotationValue<JsonAutoDetect>,
    Serializable {
        private static final Visibility a = Visibility.PUBLIC_ONLY;
        protected static final Value DEFAULT;
        protected static final Value NO_OVERRIDES;
        protected final Visibility _fieldVisibility;
        protected final Visibility _getterVisibility;
        protected final Visibility _isGetterVisibility;
        protected final Visibility _setterVisibility;
        protected final Visibility _creatorVisibility;

        private Value(Visibility visibility, Visibility visibility2, Visibility visibility3, Visibility visibility4, Visibility visibility5) {
            this._fieldVisibility = visibility;
            this._getterVisibility = visibility2;
            this._isGetterVisibility = visibility3;
            this._setterVisibility = visibility4;
            this._creatorVisibility = visibility5;
        }

        public static Value defaultVisibility() {
            return DEFAULT;
        }

        public static Value noOverrides() {
            return NO_OVERRIDES;
        }

        public static Value from(JsonAutoDetect jsonAutoDetect) {
            return Value.construct(jsonAutoDetect.fieldVisibility(), jsonAutoDetect.getterVisibility(), jsonAutoDetect.isGetterVisibility(), jsonAutoDetect.setterVisibility(), jsonAutoDetect.creatorVisibility());
        }

        public static Value construct(PropertyAccessor propertyAccessor, Visibility visibility) {
            Visibility visibility2 = Visibility.DEFAULT;
            Visibility visibility3 = Visibility.DEFAULT;
            Visibility visibility4 = Visibility.DEFAULT;
            Visibility visibility5 = Visibility.DEFAULT;
            Visibility visibility6 = Visibility.DEFAULT;
            switch (propertyAccessor) {
                case CREATOR: {
                    visibility6 = visibility;
                    break;
                }
                case FIELD: {
                    visibility2 = visibility;
                    break;
                }
                case GETTER: {
                    visibility3 = visibility;
                    break;
                }
                case IS_GETTER: {
                    visibility4 = visibility;
                    break;
                }
                case NONE: {
                    break;
                }
                case SETTER: {
                    visibility5 = visibility;
                    break;
                }
                case ALL: {
                    visibility5 = visibility6 = visibility;
                    visibility4 = visibility6;
                    visibility3 = visibility6;
                    visibility2 = visibility6;
                }
            }
            return Value.construct(visibility2, visibility3, visibility4, visibility5, visibility6);
        }

        public static Value construct(Visibility visibility, Visibility visibility2, Visibility visibility3, Visibility visibility4, Visibility visibility5) {
            Value value = Value.a(visibility, visibility2, visibility3, visibility4, visibility5);
            if (value == null) {
                value = new Value(visibility, visibility2, visibility3, visibility4, visibility5);
            }
            return value;
        }

        public Value withFieldVisibility(Visibility visibility) {
            return Value.construct(visibility, this._getterVisibility, this._isGetterVisibility, this._setterVisibility, this._creatorVisibility);
        }

        public Value withGetterVisibility(Visibility visibility) {
            return Value.construct(this._fieldVisibility, visibility, this._isGetterVisibility, this._setterVisibility, this._creatorVisibility);
        }

        public Value withIsGetterVisibility(Visibility visibility) {
            return Value.construct(this._fieldVisibility, this._getterVisibility, visibility, this._setterVisibility, this._creatorVisibility);
        }

        public Value withSetterVisibility(Visibility visibility) {
            return Value.construct(this._fieldVisibility, this._getterVisibility, this._isGetterVisibility, visibility, this._creatorVisibility);
        }

        public Value withCreatorVisibility(Visibility visibility) {
            return Value.construct(this._fieldVisibility, this._getterVisibility, this._isGetterVisibility, this._setterVisibility, visibility);
        }

        public static Value merge(Value value, Value value2) {
            if (value == null) {
                return value2;
            }
            return value.withOverrides(value2);
        }

        public Value withOverrides(Value object) {
            Visibility visibility;
            Visibility visibility2;
            Visibility visibility3;
            if (object == null || object == NO_OVERRIDES || object == this) {
                return this;
            }
            if (Value.a(this, object)) {
                return this;
            }
            Visibility visibility4 = object._fieldVisibility;
            if (visibility4 == Visibility.DEFAULT) {
                visibility4 = this._fieldVisibility;
            }
            if ((visibility3 = object._getterVisibility) == Visibility.DEFAULT) {
                visibility3 = this._getterVisibility;
            }
            if ((visibility2 = object._isGetterVisibility) == Visibility.DEFAULT) {
                visibility2 = this._isGetterVisibility;
            }
            if ((visibility = object._setterVisibility) == Visibility.DEFAULT) {
                visibility = this._setterVisibility;
            }
            if ((object = object._creatorVisibility) == Visibility.DEFAULT) {
                object = this._creatorVisibility;
            }
            return Value.construct(visibility4, visibility3, visibility2, visibility, (Visibility)((Object)object));
        }

        @Override
        public Class<JsonAutoDetect> valueFor() {
            return JsonAutoDetect.class;
        }

        public Visibility getFieldVisibility() {
            return this._fieldVisibility;
        }

        public Visibility getGetterVisibility() {
            return this._getterVisibility;
        }

        public Visibility getIsGetterVisibility() {
            return this._isGetterVisibility;
        }

        public Visibility getSetterVisibility() {
            return this._setterVisibility;
        }

        public Visibility getCreatorVisibility() {
            return this._creatorVisibility;
        }

        protected Object readResolve() {
            Value value = Value.a(this._fieldVisibility, this._getterVisibility, this._isGetterVisibility, this._setterVisibility, this._creatorVisibility);
            if (value == null) {
                return this;
            }
            return value;
        }

        public String toString() {
            return String.format("JsonAutoDetect.Value(fields=%s,getters=%s,isGetters=%s,setters=%s,creators=%s)", new Object[]{this._fieldVisibility, this._getterVisibility, this._isGetterVisibility, this._setterVisibility, this._creatorVisibility});
        }

        public int hashCode() {
            return 1 + this._fieldVisibility.ordinal() ^ 3 * this._getterVisibility.ordinal() - 7 * this._isGetterVisibility.ordinal() + 11 * this._setterVisibility.ordinal() ^ 13 * this._creatorVisibility.ordinal();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return object.getClass() == this.getClass() && Value.a(this, (Value)object);
        }

        private static Value a(Visibility visibility, Visibility visibility2, Visibility visibility3, Visibility visibility4, Visibility visibility5) {
            if (visibility == a) {
                if (visibility2 == Value.DEFAULT._getterVisibility && visibility3 == Value.DEFAULT._isGetterVisibility && visibility4 == Value.DEFAULT._setterVisibility && visibility5 == Value.DEFAULT._creatorVisibility) {
                    return DEFAULT;
                }
            } else if (visibility == Visibility.DEFAULT && visibility2 == Visibility.DEFAULT && visibility3 == Visibility.DEFAULT && visibility4 == Visibility.DEFAULT && visibility5 == Visibility.DEFAULT) {
                return NO_OVERRIDES;
            }
            return null;
        }

        private static boolean a(Value value, Value value2) {
            return value._fieldVisibility == value2._fieldVisibility && value._getterVisibility == value2._getterVisibility && value._isGetterVisibility == value2._isGetterVisibility && value._setterVisibility == value2._setterVisibility && value._creatorVisibility == value2._creatorVisibility;
        }

        static {
            Visibility visibility = Visibility.PUBLIC_ONLY;
            DEFAULT = new Value(a, visibility, visibility, Visibility.ANY, Visibility.PUBLIC_ONLY);
            Visibility visibility2 = Visibility.DEFAULT;
            Visibility visibility3 = Visibility.DEFAULT;
            NO_OVERRIDES = new Value(visibility2, visibility2, visibility3, visibility3, Visibility.DEFAULT);
        }
    }

    public static enum Visibility {
        ANY,
        NON_PRIVATE,
        PROTECTED_AND_PUBLIC,
        PUBLIC_ONLY,
        NONE,
        DEFAULT;


        public final boolean isVisible(Member member) {
            switch (this) {
                case ANY: {
                    return true;
                }
                case NONE: {
                    return false;
                }
                case NON_PRIVATE: {
                    return !Modifier.isPrivate(member.getModifiers());
                }
                case PROTECTED_AND_PUBLIC: {
                    if (Modifier.isProtected(member.getModifiers())) {
                        return true;
                    }
                }
                case PUBLIC_ONLY: {
                    return Modifier.isPublic(member.getModifiers());
                }
            }
            return false;
        }
    }
}

