/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.annotation;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.fasterxml.jackson.annotation.JacksonAnnotationValue;
import com.fasterxml.jackson.annotation.OptBoolean;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;
import java.util.TimeZone;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonFormat {
    public static final String DEFAULT_LOCALE = "##default";
    public static final String DEFAULT_TIMEZONE = "##default";

    public String pattern() default "";

    public Shape shape() default Shape.ANY;

    public String locale() default "##default";

    public String timezone() default "##default";

    public OptBoolean lenient() default OptBoolean.DEFAULT;

    public Feature[] with() default {};

    public Feature[] without() default {};

    public static class Value
    implements JacksonAnnotationValue<JsonFormat>,
    Serializable {
        private static final Value a = new Value();
        private final String b;
        private final Shape c;
        private final Locale d;
        private final String e;
        private final Boolean f;
        private final Features g;
        private transient TimeZone h;

        public Value() {
            this("", Shape.ANY, "", "", Features.empty(), null);
        }

        public Value(JsonFormat jsonFormat) {
            this(jsonFormat.pattern(), jsonFormat.shape(), jsonFormat.locale(), jsonFormat.timezone(), Features.construct(jsonFormat), jsonFormat.lenient().asBoolean());
        }

        public Value(String string, Shape shape, String string2, String string3, Features features, Boolean bl2) {
            this(string, shape, string2 == null || string2.length() == 0 || "##default".equals(string2) ? null : new Locale(string2), string3 == null || string3.length() == 0 || "##default".equals(string3) ? null : string3, null, features, bl2);
        }

        public Value(String string, Shape shape, Locale locale, TimeZone timeZone, Features features, Boolean bl2) {
            this.b = string == null ? "" : string;
            this.c = shape == null ? Shape.ANY : shape;
            this.d = locale;
            this.h = timeZone;
            this.e = null;
            this.g = features == null ? Features.empty() : features;
            this.f = bl2;
        }

        public Value(String string, Shape shape, Locale locale, String string2, TimeZone timeZone, Features features, Boolean bl2) {
            this.b = string == null ? "" : string;
            this.c = shape == null ? Shape.ANY : shape;
            this.d = locale;
            this.h = timeZone;
            this.e = string2;
            this.g = features == null ? Features.empty() : features;
            this.f = bl2;
        }

        @Deprecated
        public Value(String string, Shape shape, Locale locale, String string2, TimeZone timeZone, Features features) {
            this(string, shape, locale, string2, timeZone, features, null);
        }

        @Deprecated
        public Value(String string, Shape shape, String string2, String string3, Features features) {
            this(string, shape, string2, string3, features, null);
        }

        @Deprecated
        public Value(String string, Shape shape, Locale locale, TimeZone timeZone, Features features) {
            this(string, shape, locale, timeZone, features, null);
        }

        public static final Value empty() {
            return a;
        }

        public static Value merge(Value value, Value value2) {
            if (value == null) {
                return value2;
            }
            return value.withOverrides(value2);
        }

        public static Value mergeAll(Value ... valueArray) {
            Value value = null;
            for (Value value2 : valueArray) {
                if (value2 == null) continue;
                value = value == null ? value2 : value.withOverrides(value2);
            }
            return value;
        }

        public static final Value from(JsonFormat jsonFormat) {
            if (jsonFormat == null) {
                return a;
            }
            return new Value(jsonFormat);
        }

        public final Value withOverrides(Value serializable) {
            String string;
            Features features;
            Locale locale;
            Shape shape;
            if (serializable == null || serializable == a || serializable == this) {
                return this;
            }
            if (this == a) {
                return serializable;
            }
            String string2 = serializable.b;
            if (string2 == null || string2.isEmpty()) {
                string2 = this.b;
            }
            if ((shape = serializable.c) == Shape.ANY) {
                shape = this.c;
            }
            if ((locale = serializable.d) == null) {
                locale = this.d;
            }
            features = (features = this.g) == null ? serializable.g : features.withOverrides(serializable.g);
            Boolean bl2 = serializable.f;
            if (bl2 == null) {
                bl2 = this.f;
            }
            if ((string = serializable.e) == null || string.isEmpty()) {
                string = this.e;
                serializable = this.h;
            } else {
                serializable = serializable.h;
            }
            return new Value(string2, shape, locale, string, (TimeZone)serializable, features, bl2);
        }

        public static Value forPattern(String string) {
            return new Value(string, null, null, null, null, Features.empty(), null);
        }

        public static Value forShape(Shape shape) {
            return new Value("", shape, null, null, null, Features.empty(), null);
        }

        public static Value forLeniency(boolean bl2) {
            return new Value("", null, null, null, null, Features.empty(), bl2);
        }

        public Value withPattern(String string) {
            return new Value(string, this.c, this.d, this.e, this.h, this.g, this.f);
        }

        public Value withShape(Shape shape) {
            if (shape == this.c) {
                return this;
            }
            return new Value(this.b, shape, this.d, this.e, this.h, this.g, this.f);
        }

        public Value withLocale(Locale locale) {
            return new Value(this.b, this.c, locale, this.e, this.h, this.g, this.f);
        }

        public Value withTimeZone(TimeZone timeZone) {
            return new Value(this.b, this.c, this.d, null, timeZone, this.g, this.f);
        }

        public Value withLenient(Boolean bl2) {
            if (bl2 == this.f) {
                return this;
            }
            return new Value(this.b, this.c, this.d, this.e, this.h, this.g, bl2);
        }

        public Value withFeature(Feature object) {
            if ((object = this.g.with(new Feature[]{object})) == this.g) {
                return this;
            }
            return new Value(this.b, this.c, this.d, this.e, this.h, (Features)object, this.f);
        }

        public Value withoutFeature(Feature object) {
            if ((object = this.g.without(new Feature[]{object})) == this.g) {
                return this;
            }
            return new Value(this.b, this.c, this.d, this.e, this.h, (Features)object, this.f);
        }

        @Override
        public Class<JsonFormat> valueFor() {
            return JsonFormat.class;
        }

        public String getPattern() {
            return this.b;
        }

        public Shape getShape() {
            return this.c;
        }

        public Locale getLocale() {
            return this.d;
        }

        public Boolean getLenient() {
            return this.f;
        }

        public boolean isLenient() {
            return Boolean.TRUE.equals(this.f);
        }

        public String timeZoneAsString() {
            if (this.h != null) {
                return this.h.getID();
            }
            return this.e;
        }

        public TimeZone getTimeZone() {
            TimeZone timeZone = this.h;
            if (timeZone == null) {
                if (this.e == null) {
                    return null;
                }
                this.h = timeZone = TimeZone.getTimeZone(this.e);
            }
            return timeZone;
        }

        public boolean hasShape() {
            return this.c != Shape.ANY;
        }

        public boolean hasPattern() {
            return this.b != null && this.b.length() > 0;
        }

        public boolean hasLocale() {
            return this.d != null;
        }

        public boolean hasTimeZone() {
            return this.h != null || this.e != null && !this.e.isEmpty();
        }

        public boolean hasLenient() {
            return this.f != null;
        }

        public Boolean getFeature(Feature feature) {
            return this.g.get(feature);
        }

        public Features getFeatures() {
            return this.g;
        }

        public String toString() {
            return String.format("JsonFormat.Value(pattern=%s,shape=%s,lenient=%s,locale=%s,timezone=%s,features=%s)", new Object[]{this.b, this.c, this.f, this.d, this.e, this.g});
        }

        public int hashCode() {
            int n2;
            int n3 = n2 = this.e == null ? 1 : this.e.hashCode();
            if (this.b != null) {
                n2 ^= this.b.hashCode();
            }
            n2 += this.c.hashCode();
            if (this.f != null) {
                n2 ^= this.f.hashCode();
            }
            if (this.d != null) {
                n2 += this.d.hashCode();
            }
            return n2 ^= this.g.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            object = (Value)object;
            if (this.c != ((Value)object).c || !this.g.equals(((Value)object).g)) {
                return false;
            }
            return Value.a(this.f, ((Value)object).f) && Value.a(this.e, ((Value)object).e) && Value.a(this.b, ((Value)object).b) && Value.a(this.h, ((Value)object).h) && Value.a(this.d, ((Value)object).d);
        }

        private static <T> boolean a(T t2, T t3) {
            if (t2 == null) {
                return t3 == null;
            }
            if (t3 == null) {
                return false;
            }
            return t2.equals(t3);
        }
    }

    public static class Features {
        private final int a;
        private final int b;
        private static final Features c = new Features(0, 0);

        private Features(int n2, int n3) {
            this.a = n2;
            this.b = n3;
        }

        public static Features empty() {
            return c;
        }

        public static Features construct(JsonFormat jsonFormat) {
            return Features.construct(jsonFormat.with(), jsonFormat.without());
        }

        public static Features construct(Feature[] featureArray, Feature[] object) {
            int n2 = 0;
            for (Feature feature : featureArray) {
                n2 |= 1 << feature.ordinal();
            }
            int n3 = 0;
            Feature[] featureArray2 = object;
            int n4 = ((Feature[])object).length;
            for (int i2 = 0; i2 < n4; ++i2) {
                object = featureArray2[i2];
                n3 |= 1 << ((Enum)object).ordinal();
            }
            return new Features(n2, n3);
        }

        public Features withOverrides(Features features) {
            if (features == null) {
                return this;
            }
            int n2 = features.b;
            int n3 = features.a;
            if (n2 == 0 && n3 == 0) {
                return this;
            }
            if (this.a == 0 && this.b == 0) {
                return features;
            }
            int n4 = this.a & ~n2 | n3;
            n2 = this.b & ~n3 | n2;
            if (n4 == this.a && n2 == this.b) {
                return this;
            }
            return new Features(n4, n2);
        }

        public Features with(Feature ... featureArray) {
            int n2 = this.a;
            for (Feature feature : featureArray) {
                n2 |= 1 << feature.ordinal();
            }
            if (n2 == this.a) {
                return this;
            }
            return new Features(n2, this.b);
        }

        public Features without(Feature ... featureArray) {
            int n2 = this.b;
            for (Feature feature : featureArray) {
                n2 |= 1 << feature.ordinal();
            }
            if (n2 == this.b) {
                return this;
            }
            return new Features(this.a, n2);
        }

        public Boolean get(Feature feature) {
            int n2 = 1 << feature.ordinal();
            if ((this.b & n2) != 0) {
                return Boolean.FALSE;
            }
            if ((this.a & n2) != 0) {
                return Boolean.TRUE;
            }
            return null;
        }

        public String toString() {
            if (this == c) {
                return "EMPTY";
            }
            return String.format("(enabled=0x%x,disabled=0x%x)", this.a, this.b);
        }

        public int hashCode() {
            return this.b + this.a;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            object = (Features)object;
            return ((Features)object).a == this.a && ((Features)object).b == this.b;
        }
    }

    public static enum Feature {
        ACCEPT_SINGLE_VALUE_AS_ARRAY,
        ACCEPT_CASE_INSENSITIVE_PROPERTIES,
        READ_UNKNOWN_ENUM_VALUES_AS_NULL,
        READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE,
        READ_DATE_TIMESTAMPS_AS_NANOSECONDS,
        ACCEPT_CASE_INSENSITIVE_VALUES,
        WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS,
        WRITE_DATES_WITH_ZONE_ID,
        WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED,
        WRITE_SORTED_MAP_ENTRIES,
        ADJUST_DATES_TO_CONTEXT_TIME_ZONE;

    }

    public static enum Shape {
        ANY,
        NATURAL,
        SCALAR,
        ARRAY,
        OBJECT,
        NUMBER,
        NUMBER_FLOAT,
        NUMBER_INT,
        STRING,
        BOOLEAN,
        BINARY;


        public final boolean isNumeric() {
            return this == NUMBER || this == NUMBER_INT || this == NUMBER_FLOAT;
        }

        public final boolean isStructured() {
            return this == OBJECT || this == ARRAY;
        }
    }
}

