/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.annotation;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.fasterxml.jackson.annotation.JacksonAnnotationValue;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.TYPE, ElementType.METHOD, ElementType.CONSTRUCTOR, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonIgnoreProperties {
    public String[] value() default {};

    public boolean ignoreUnknown() default false;

    public boolean allowGetters() default false;

    public boolean allowSetters() default false;

    public static class Value
    implements JacksonAnnotationValue<JsonIgnoreProperties>,
    Serializable {
        protected static final Value EMPTY = new Value(Collections.<String>emptySet(), false, false, false, true);
        protected final Set<String> _ignored;
        protected final boolean _ignoreUnknown;
        protected final boolean _allowGetters;
        protected final boolean _allowSetters;
        protected final boolean _merge;

        protected Value(Set<String> set, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            this._ignored = set == null ? Collections.emptySet() : set;
            this._ignoreUnknown = bl2;
            this._allowGetters = bl3;
            this._allowSetters = bl4;
            this._merge = bl5;
        }

        public static Value from(JsonIgnoreProperties jsonIgnoreProperties) {
            if (jsonIgnoreProperties == null) {
                return EMPTY;
            }
            return Value.construct(Value.a(jsonIgnoreProperties.value()), jsonIgnoreProperties.ignoreUnknown(), jsonIgnoreProperties.allowGetters(), jsonIgnoreProperties.allowSetters(), false);
        }

        public static Value construct(Set<String> set, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            if (Value.a(set, bl2, bl3, bl4, bl5)) {
                return EMPTY;
            }
            return new Value(set, bl2, bl3, bl4, bl5);
        }

        public static Value empty() {
            return EMPTY;
        }

        public static Value merge(Value value, Value value2) {
            if (value == null) {
                return value2;
            }
            return value.withOverrides(value2);
        }

        public static Value mergeAll(Value ... valueArray) {
            Value value = null;
            for (Value value2 : valueArray) {
                if (value2 == null) continue;
                value = value == null ? value2 : value.withOverrides(value2);
            }
            return value;
        }

        public static Value forIgnoredProperties(Set<String> set) {
            return EMPTY.withIgnored(set);
        }

        public static Value forIgnoredProperties(String ... stringArray) {
            if (stringArray.length == 0) {
                return EMPTY;
            }
            return EMPTY.withIgnored(Value.a(stringArray));
        }

        public static Value forIgnoreUnknown(boolean bl2) {
            if (bl2) {
                return EMPTY.withIgnoreUnknown();
            }
            return EMPTY.withoutIgnoreUnknown();
        }

        public Value withOverrides(Value value) {
            Set<String> set;
            if (value == null || value == EMPTY) {
                return this;
            }
            if (!value._merge) {
                return value;
            }
            if (Value.a(this, value)) {
                return this;
            }
            Set<String> set2 = value._ignored;
            Set<String> set3 = this._ignored;
            if (set3.isEmpty()) {
                set = set2;
            } else if (set2.isEmpty()) {
                set = set3;
            } else {
                HashSet<String> hashSet = new HashSet<String>(set3.size() + set2.size());
                hashSet.addAll(set3);
                hashSet.addAll(set2);
                set = hashSet;
            }
            set3 = set;
            boolean bl2 = this._ignoreUnknown || value._ignoreUnknown;
            boolean bl3 = this._allowGetters || value._allowGetters;
            boolean bl4 = this._allowSetters || value._allowSetters;
            return Value.construct(set3, bl2, bl3, bl4, true);
        }

        public Value withIgnored(Set<String> set) {
            return Value.construct(set, this._ignoreUnknown, this._allowGetters, this._allowSetters, this._merge);
        }

        public Value withIgnored(String ... stringArray) {
            return Value.construct(Value.a(stringArray), this._ignoreUnknown, this._allowGetters, this._allowSetters, this._merge);
        }

        public Value withoutIgnored() {
            return Value.construct(null, this._ignoreUnknown, this._allowGetters, this._allowSetters, this._merge);
        }

        public Value withIgnoreUnknown() {
            if (this._ignoreUnknown) {
                return this;
            }
            return Value.construct(this._ignored, true, this._allowGetters, this._allowSetters, this._merge);
        }

        public Value withoutIgnoreUnknown() {
            if (!this._ignoreUnknown) {
                return this;
            }
            return Value.construct(this._ignored, false, this._allowGetters, this._allowSetters, this._merge);
        }

        public Value withAllowGetters() {
            if (this._allowGetters) {
                return this;
            }
            return Value.construct(this._ignored, this._ignoreUnknown, true, this._allowSetters, this._merge);
        }

        public Value withoutAllowGetters() {
            if (!this._allowGetters) {
                return this;
            }
            return Value.construct(this._ignored, this._ignoreUnknown, false, this._allowSetters, this._merge);
        }

        public Value withAllowSetters() {
            if (this._allowSetters) {
                return this;
            }
            return Value.construct(this._ignored, this._ignoreUnknown, this._allowGetters, true, this._merge);
        }

        public Value withoutAllowSetters() {
            if (!this._allowSetters) {
                return this;
            }
            return Value.construct(this._ignored, this._ignoreUnknown, this._allowGetters, false, this._merge);
        }

        public Value withMerge() {
            if (this._merge) {
                return this;
            }
            return Value.construct(this._ignored, this._ignoreUnknown, this._allowGetters, this._allowSetters, true);
        }

        public Value withoutMerge() {
            if (!this._merge) {
                return this;
            }
            return Value.construct(this._ignored, this._ignoreUnknown, this._allowGetters, this._allowSetters, false);
        }

        @Override
        public Class<JsonIgnoreProperties> valueFor() {
            return JsonIgnoreProperties.class;
        }

        protected Object readResolve() {
            if (Value.a(this._ignored, this._ignoreUnknown, this._allowGetters, this._allowSetters, this._merge)) {
                return EMPTY;
            }
            return this;
        }

        public Set<String> getIgnored() {
            return this._ignored;
        }

        public Set<String> findIgnoredForSerialization() {
            if (this._allowGetters) {
                return Collections.emptySet();
            }
            return this._ignored;
        }

        public Set<String> findIgnoredForDeserialization() {
            if (this._allowSetters) {
                return Collections.emptySet();
            }
            return this._ignored;
        }

        public boolean getIgnoreUnknown() {
            return this._ignoreUnknown;
        }

        public boolean getAllowGetters() {
            return this._allowGetters;
        }

        public boolean getAllowSetters() {
            return this._allowSetters;
        }

        public boolean getMerge() {
            return this._merge;
        }

        public String toString() {
            return String.format("JsonIgnoreProperties.Value(ignored=%s,ignoreUnknown=%s,allowGetters=%s,allowSetters=%s,merge=%s)", this._ignored, this._ignoreUnknown, this._allowGetters, this._allowSetters, this._merge);
        }

        public int hashCode() {
            return this._ignored.size() + (this._ignoreUnknown ? 1 : -3) + (this._allowGetters ? 3 : -7) + (this._allowSetters ? 7 : -11) + (this._merge ? 11 : -13);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return object.getClass() == this.getClass() && Value.a(this, (Value)object);
        }

        private static boolean a(Value value, Value value2) {
            return value._ignoreUnknown == value2._ignoreUnknown && value._merge == value2._merge && value._allowGetters == value2._allowGetters && value._allowSetters == value2._allowSetters && value._ignored.equals(value2._ignored);
        }

        private static Set<String> a(String[] stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                return Collections.emptySet();
            }
            HashSet<String> hashSet = new HashSet<String>(stringArray.length);
            for (String string : stringArray) {
                hashSet.add(string);
            }
            return hashSet;
        }

        private static boolean a(Set<String> set, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            if (bl2 == Value.EMPTY._ignoreUnknown && bl3 == Value.EMPTY._allowGetters && bl4 == Value.EMPTY._allowSetters && bl5 == Value.EMPTY._merge) {
                return set == null || set.size() == 0;
            }
            return false;
        }
    }
}

