/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.annotation;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.fasterxml.jackson.annotation.JacksonAnnotationValue;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.TYPE, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonInclude {
    public Include value() default Include.ALWAYS;

    public Include content() default Include.ALWAYS;

    public Class<?> valueFilter() default Void.class;

    public Class<?> contentFilter() default Void.class;

    public static class Value
    implements JacksonAnnotationValue<JsonInclude>,
    Serializable {
        protected static final Value EMPTY;
        protected final Include _valueInclusion;
        protected final Include _contentInclusion;
        protected final Class<?> _valueFilter;
        protected final Class<?> _contentFilter;

        public Value(JsonInclude jsonInclude) {
            this(jsonInclude.value(), jsonInclude.content(), jsonInclude.valueFilter(), jsonInclude.contentFilter());
        }

        protected Value(Include include, Include include2, Class<?> clazz, Class<?> clazz2) {
            this._valueInclusion = include == null ? Include.USE_DEFAULTS : include;
            this._contentInclusion = include2 == null ? Include.USE_DEFAULTS : include2;
            this._valueFilter = clazz == Void.class ? null : clazz;
            this._contentFilter = clazz2 == Void.class ? null : clazz2;
        }

        public static Value empty() {
            return EMPTY;
        }

        public static Value merge(Value value, Value value2) {
            if (value == null) {
                return value2;
            }
            return value.withOverrides(value2);
        }

        public static Value mergeAll(Value ... valueArray) {
            Value value = null;
            for (Value value2 : valueArray) {
                if (value2 == null) continue;
                value = value == null ? value2 : value.withOverrides(value2);
            }
            return value;
        }

        protected Object readResolve() {
            if (this._valueInclusion == Include.USE_DEFAULTS && this._contentInclusion == Include.USE_DEFAULTS && this._valueFilter == null && this._contentFilter == null) {
                return EMPTY;
            }
            return this;
        }

        public Value withOverrides(Value serializable) {
            boolean bl2;
            if (serializable == null || serializable == EMPTY) {
                return this;
            }
            Include include = serializable._valueInclusion;
            Include include2 = serializable._contentInclusion;
            Class<?> clazz = serializable._valueFilter;
            serializable = serializable._contentFilter;
            boolean bl3 = include != this._valueInclusion && include != Include.USE_DEFAULTS;
            boolean bl4 = include2 != this._contentInclusion && include2 != Include.USE_DEFAULTS;
            boolean bl5 = bl2 = clazz != this._valueFilter || serializable != this._valueFilter;
            if (bl3) {
                if (bl4) {
                    return new Value(include, include2, clazz, (Class<?>)serializable);
                }
                return new Value(include, this._contentInclusion, clazz, (Class<?>)serializable);
            }
            if (bl4) {
                return new Value(this._valueInclusion, include2, clazz, (Class<?>)serializable);
            }
            if (bl2) {
                return new Value(this._valueInclusion, this._contentInclusion, clazz, (Class<?>)serializable);
            }
            return this;
        }

        public static Value construct(Include include, Include include2) {
            if (!(include != Include.USE_DEFAULTS && include != null || include2 != Include.USE_DEFAULTS && include2 != null)) {
                return EMPTY;
            }
            return new Value(include, include2, null, null);
        }

        public static Value construct(Include include, Include include2, Class<?> clazz, Class<?> clazz2) {
            if (clazz == Void.class) {
                clazz = null;
            }
            if (clazz2 == Void.class) {
                clazz2 = null;
            }
            if (!(include != Include.USE_DEFAULTS && include != null || include2 != Include.USE_DEFAULTS && include2 != null || clazz != null || clazz2 != null)) {
                return EMPTY;
            }
            return new Value(include, include2, clazz, clazz2);
        }

        public static Value from(JsonInclude object) {
            if (object == null) {
                return EMPTY;
            }
            Include include = object.value();
            Include include2 = object.content();
            if (include == Include.USE_DEFAULTS && include2 == Include.USE_DEFAULTS) {
                return EMPTY;
            }
            Class<?> clazz = object.valueFilter();
            if (clazz == Void.class) {
                clazz = null;
            }
            if ((object = object.contentFilter()) == Void.class) {
                object = null;
            }
            return new Value(include, include2, clazz, (Class<?>)object);
        }

        public Value withValueInclusion(Include include) {
            if (include == this._valueInclusion) {
                return this;
            }
            return new Value(include, this._contentInclusion, this._valueFilter, this._contentFilter);
        }

        public Value withValueFilter(Class<?> clazz) {
            Include include;
            if (clazz == null || clazz == Void.class) {
                include = Include.USE_DEFAULTS;
                clazz = null;
            } else {
                include = Include.CUSTOM;
            }
            return Value.construct(include, this._contentInclusion, clazz, this._contentFilter);
        }

        public Value withContentFilter(Class<?> clazz) {
            Include include;
            if (clazz == null || clazz == Void.class) {
                include = Include.USE_DEFAULTS;
                clazz = null;
            } else {
                include = Include.CUSTOM;
            }
            return Value.construct(this._valueInclusion, include, this._valueFilter, clazz);
        }

        public Value withContentInclusion(Include include) {
            if (include == this._contentInclusion) {
                return this;
            }
            return new Value(this._valueInclusion, include, this._valueFilter, this._contentFilter);
        }

        @Override
        public Class<JsonInclude> valueFor() {
            return JsonInclude.class;
        }

        public Include getValueInclusion() {
            return this._valueInclusion;
        }

        public Include getContentInclusion() {
            return this._contentInclusion;
        }

        public Class<?> getValueFilter() {
            return this._valueFilter;
        }

        public Class<?> getContentFilter() {
            return this._contentFilter;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(80);
            stringBuilder.append("JsonInclude.Value(value=").append((Object)this._valueInclusion).append(",content=").append((Object)this._contentInclusion);
            if (this._valueFilter != null) {
                stringBuilder.append(",valueFilter=").append(this._valueFilter.getName()).append(".class");
            }
            if (this._contentFilter != null) {
                stringBuilder.append(",contentFilter=").append(this._contentFilter.getName()).append(".class");
            }
            return stringBuilder.append(')').toString();
        }

        public int hashCode() {
            return (this._valueInclusion.hashCode() << 2) + this._contentInclusion.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            object = (Value)object;
            return ((Value)object)._valueInclusion == this._valueInclusion && ((Value)object)._contentInclusion == this._contentInclusion && ((Value)object)._valueFilter == this._valueFilter && ((Value)object)._contentFilter == this._contentFilter;
        }

        static {
            Include include = Include.USE_DEFAULTS;
            EMPTY = new Value(include, include, null, null);
        }
    }

    public static enum Include {
        ALWAYS,
        NON_NULL,
        NON_ABSENT,
        NON_EMPTY,
        NON_DEFAULT,
        CUSTOM,
        USE_DEFAULTS;

    }
}

