/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.annotation;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.fasterxml.jackson.annotation.JacksonAnnotationValue;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.TYPE, ElementType.METHOD, ElementType.CONSTRUCTOR, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonIncludeProperties {
    public String[] value() default {};

    public static class Value
    implements JacksonAnnotationValue<JsonIncludeProperties>,
    Serializable {
        protected static final Value ALL = new Value(null);
        protected final Set<String> _included;

        protected Value(Set<String> set) {
            this._included = set;
        }

        public static Value from(JsonIncludeProperties jsonIncludeProperties) {
            if (jsonIncludeProperties == null) {
                return ALL;
            }
            return new Value(Value.a(jsonIncludeProperties.value()));
        }

        public static Value all() {
            return ALL;
        }

        @Override
        public Class<JsonIncludeProperties> valueFor() {
            return JsonIncludeProperties.class;
        }

        public Set<String> getIncluded() {
            return this._included;
        }

        public Value withOverrides(Value serializable) {
            Object object;
            if (serializable == null || (object = ((Value)serializable).getIncluded()) == null) {
                return this;
            }
            if (this._included == null) {
                return serializable;
            }
            serializable = new HashSet();
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (!this._included.contains(string)) continue;
                ((HashSet)serializable).add(string);
            }
            return new Value((Set<String>)((Object)serializable));
        }

        public String toString() {
            return String.format("JsonIncludeProperties.Value(included=%s)", this._included);
        }

        public int hashCode() {
            if (this._included == null) {
                return 0;
            }
            return this._included.size();
        }

        public boolean equals(Object set) {
            if (set == this) {
                return true;
            }
            if (set == null) {
                return false;
            }
            if (set.getClass() == this.getClass()) {
                Set<String> set2 = ((Value)((Object)set))._included;
                set = this._included;
                boolean bl2 = set == null ? set2 == null : set.equals(set2);
                if (bl2) {
                    return true;
                }
            }
            return false;
        }

        private static Set<String> a(String[] stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                return Collections.emptySet();
            }
            HashSet<String> hashSet = new HashSet<String>(stringArray.length);
            for (String string : stringArray) {
                hashSet.add(string);
            }
            return hashSet;
        }
    }
}

