/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.annotation;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.fasterxml.jackson.annotation.JacksonAnnotationValue;
import com.fasterxml.jackson.annotation.Nulls;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonSetter {
    public String value() default "";

    public Nulls nulls() default Nulls.DEFAULT;

    public Nulls contentNulls() default Nulls.DEFAULT;

    public static class Value
    implements JacksonAnnotationValue<JsonSetter>,
    Serializable {
        private final Nulls a;
        private final Nulls b;
        protected static final Value EMPTY;

        protected Value(Nulls nulls, Nulls nulls2) {
            this.a = nulls;
            this.b = nulls2;
        }

        @Override
        public Class<JsonSetter> valueFor() {
            return JsonSetter.class;
        }

        protected Object readResolve() {
            if (Value.a(this.a, this.b)) {
                return EMPTY;
            }
            return this;
        }

        public static Value from(JsonSetter jsonSetter) {
            if (jsonSetter == null) {
                return EMPTY;
            }
            return Value.construct(jsonSetter.nulls(), jsonSetter.contentNulls());
        }

        public static Value construct(Nulls nulls, Nulls nulls2) {
            if (nulls == null) {
                nulls = Nulls.DEFAULT;
            }
            if (nulls2 == null) {
                nulls2 = Nulls.DEFAULT;
            }
            if (Value.a(nulls, nulls2)) {
                return EMPTY;
            }
            return new Value(nulls, nulls2);
        }

        public static Value empty() {
            return EMPTY;
        }

        public static Value merge(Value value, Value value2) {
            if (value == null) {
                return value2;
            }
            return value.withOverrides(value2);
        }

        public static Value forValueNulls(Nulls nulls) {
            return Value.construct(nulls, Nulls.DEFAULT);
        }

        public static Value forValueNulls(Nulls nulls, Nulls nulls2) {
            return Value.construct(nulls, nulls2);
        }

        public static Value forContentNulls(Nulls nulls) {
            return Value.construct(Nulls.DEFAULT, nulls);
        }

        public Value withOverrides(Value object) {
            if (object == null || object == EMPTY) {
                return this;
            }
            Nulls nulls = object.a;
            object = object.b;
            if (nulls == Nulls.DEFAULT) {
                nulls = this.a;
            }
            if (object == Nulls.DEFAULT) {
                object = this.b;
            }
            if (nulls == this.a && object == this.b) {
                return this;
            }
            return Value.construct(nulls, (Nulls)((Object)object));
        }

        public Value withValueNulls(Nulls nulls) {
            if (nulls == null) {
                nulls = Nulls.DEFAULT;
            }
            if (nulls == this.a) {
                return this;
            }
            return Value.construct(nulls, this.b);
        }

        public Value withValueNulls(Nulls nulls, Nulls nulls2) {
            if (nulls == null) {
                nulls = Nulls.DEFAULT;
            }
            if (nulls2 == null) {
                nulls2 = Nulls.DEFAULT;
            }
            if (nulls == this.a && nulls2 == this.b) {
                return this;
            }
            return Value.construct(nulls, nulls2);
        }

        public Value withContentNulls(Nulls nulls) {
            if (nulls == null) {
                nulls = Nulls.DEFAULT;
            }
            if (nulls == this.b) {
                return this;
            }
            return Value.construct(this.a, nulls);
        }

        public Nulls getValueNulls() {
            return this.a;
        }

        public Nulls getContentNulls() {
            return this.b;
        }

        public Nulls nonDefaultValueNulls() {
            if (this.a == Nulls.DEFAULT) {
                return null;
            }
            return this.a;
        }

        public Nulls nonDefaultContentNulls() {
            if (this.b == Nulls.DEFAULT) {
                return null;
            }
            return this.b;
        }

        public String toString() {
            return String.format("JsonSetter.Value(valueNulls=%s,contentNulls=%s)", new Object[]{this.a, this.b});
        }

        public int hashCode() {
            return this.a.ordinal() + (this.b.ordinal() << 2);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() == this.getClass()) {
                object = (Value)object;
                return ((Value)object).a == this.a && ((Value)object).b == this.b;
            }
            return false;
        }

        private static boolean a(Nulls nulls, Nulls nulls2) {
            return nulls == Nulls.DEFAULT && nulls2 == Nulls.DEFAULT;
        }

        static {
            Nulls nulls = Nulls.DEFAULT;
            EMPTY = new Value(nulls, nulls);
        }
    }
}

