/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.annotation;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.fasterxml.jackson.annotation.JacksonAnnotationValue;
import com.fasterxml.jackson.annotation.OptBoolean;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonTypeInfo {
    public Id use();

    public As include() default As.PROPERTY;

    public String property() default "";

    public Class<?> defaultImpl() default JsonTypeInfo.class;

    public boolean visible() default false;

    public OptBoolean requireTypeIdForSubtypes() default OptBoolean.DEFAULT;

    public static class Value
    implements JacksonAnnotationValue<JsonTypeInfo>,
    Serializable {
        protected static final Value EMPTY = new Value(Id.NONE, As.PROPERTY, null, null, false, null);
        protected final Id _idType;
        protected final As _inclusionType;
        protected final String _propertyName;
        protected final Class<?> _defaultImpl;
        protected final boolean _idVisible;
        protected final Boolean _requireTypeIdForSubtypes;

        protected Value(Id id, As as2, String string, Class<?> clazz, boolean bl2, Boolean bl3) {
            this._defaultImpl = clazz;
            this._idType = id;
            this._inclusionType = as2;
            this._propertyName = string;
            this._idVisible = bl2;
            this._requireTypeIdForSubtypes = bl3;
        }

        public static Value construct(Id id, As as2, String string, Class<?> clazz, boolean bl2, Boolean bl3) {
            if (string == null || string.isEmpty()) {
                string = id != null ? id.getDefaultPropertyName() : "";
            }
            if (clazz == null || clazz.isAnnotation()) {
                clazz = null;
            }
            return new Value(id, as2, string, clazz, bl2, bl3);
        }

        public static Value from(JsonTypeInfo jsonTypeInfo) {
            if (jsonTypeInfo == null) {
                return null;
            }
            return Value.construct(jsonTypeInfo.use(), jsonTypeInfo.include(), jsonTypeInfo.property(), jsonTypeInfo.defaultImpl(), jsonTypeInfo.visible(), jsonTypeInfo.requireTypeIdForSubtypes().asBoolean());
        }

        public Value withDefaultImpl(Class<?> clazz) {
            if (clazz == this._defaultImpl) {
                return this;
            }
            return new Value(this._idType, this._inclusionType, this._propertyName, clazz, this._idVisible, this._requireTypeIdForSubtypes);
        }

        public Value withIdType(Id id) {
            if (id == this._idType) {
                return this;
            }
            return new Value(id, this._inclusionType, this._propertyName, this._defaultImpl, this._idVisible, this._requireTypeIdForSubtypes);
        }

        public Value withInclusionType(As as2) {
            if (as2 == this._inclusionType) {
                return this;
            }
            return new Value(this._idType, as2, this._propertyName, this._defaultImpl, this._idVisible, this._requireTypeIdForSubtypes);
        }

        public Value withPropertyName(String string) {
            if (string == this._propertyName) {
                return this;
            }
            return new Value(this._idType, this._inclusionType, string, this._defaultImpl, this._idVisible, this._requireTypeIdForSubtypes);
        }

        public Value withIdVisible(boolean bl2) {
            if (bl2 == this._idVisible) {
                return this;
            }
            return new Value(this._idType, this._inclusionType, this._propertyName, this._defaultImpl, bl2, this._requireTypeIdForSubtypes);
        }

        public Value withRequireTypeIdForSubtypes(Boolean bl2) {
            if (this._requireTypeIdForSubtypes == bl2) {
                return this;
            }
            return new Value(this._idType, this._inclusionType, this._propertyName, this._defaultImpl, this._idVisible, bl2);
        }

        @Override
        public Class<JsonTypeInfo> valueFor() {
            return JsonTypeInfo.class;
        }

        public Class<?> getDefaultImpl() {
            return this._defaultImpl;
        }

        public Id getIdType() {
            return this._idType;
        }

        public As getInclusionType() {
            return this._inclusionType;
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public boolean getIdVisible() {
            return this._idVisible;
        }

        public Boolean getRequireTypeIdForSubtypes() {
            return this._requireTypeIdForSubtypes;
        }

        public static boolean isEnabled(Value value) {
            return value != null && value._idType != null && value._idType != Id.NONE;
        }

        public String toString() {
            return String.format("JsonTypeInfo.Value(idType=%s,includeAs=%s,propertyName=%s,defaultImpl=%s,idVisible=%s,requireTypeIdForSubtypes=%s)", new Object[]{this._idType, this._inclusionType, this._propertyName, this._defaultImpl == null ? "NULL" : this._defaultImpl.getName(), this._idVisible, this._requireTypeIdForSubtypes});
        }

        public int hashCode() {
            int n2 = 31 + (this._idType != null ? this._idType.hashCode() : 0);
            n2 = n2 * 31 + (this._inclusionType != null ? this._inclusionType.hashCode() : 0);
            n2 = n2 * 31 + (this._propertyName != null ? this._propertyName.hashCode() : 0);
            n2 = n2 * 31 + (this._defaultImpl != null ? this._defaultImpl.hashCode() : 0);
            n2 = n2 * 31 + (this._requireTypeIdForSubtypes != false ? 11 : -17);
            n2 = n2 * 31 + (this._idVisible ? 11 : -17);
            return n2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() == this.getClass()) {
                Value value = (Value)object;
                object = this;
                if (((Value)object)._idType == value._idType && ((Value)object)._inclusionType == value._inclusionType && ((Value)object)._defaultImpl == value._defaultImpl && ((Value)object)._idVisible == value._idVisible && Value.a(((Value)object)._propertyName, value._propertyName) && Value.a(((Value)object)._requireTypeIdForSubtypes, value._requireTypeIdForSubtypes)) {
                    return true;
                }
            }
            return false;
        }

        private static <T> boolean a(T t2, T t3) {
            if (t2 == null) {
                return t3 == null;
            }
            if (t3 == null) {
                return false;
            }
            return t2.equals(t3);
        }
    }

    @Deprecated
    public static abstract class None {
    }

    public static enum As {
        PROPERTY,
        WRAPPER_OBJECT,
        WRAPPER_ARRAY,
        EXTERNAL_PROPERTY,
        EXISTING_PROPERTY;

    }

    public static enum Id {
        NONE(null),
        CLASS("@class"),
        MINIMAL_CLASS("@c"),
        NAME("@type"),
        SIMPLE_NAME("@type"),
        DEDUCTION(null),
        CUSTOM(null);

        private final String a;

        private Id(String string2) {
            this.a = string2;
        }

        public final String getDefaultPropertyName() {
            return this.a;
        }
    }
}

