/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.annotation;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import java.util.UUID;

public class ObjectIdGenerators {

    public static final class StringIdGenerator
    extends a<String> {
        public StringIdGenerator() {
            this(0);
        }

        private StringIdGenerator(byte by) {
            super(Object.class);
        }

        @Override
        public final ObjectIdGenerator<String> forScope(Class<?> clazz) {
            return this;
        }

        @Override
        public final ObjectIdGenerator<String> newForSerialization(Object object) {
            return this;
        }

        @Override
        public final String generateId(Object object) {
            return UUID.randomUUID().toString();
        }

        @Override
        public final ObjectIdGenerator.IdKey key(Object object) {
            if (object == null) {
                return null;
            }
            return new ObjectIdGenerator.IdKey(this.getClass(), null, object);
        }

        @Override
        public final boolean canUseFor(ObjectIdGenerator<?> objectIdGenerator) {
            return objectIdGenerator instanceof StringIdGenerator;
        }
    }

    public static final class UUIDGenerator
    extends a<UUID> {
        public UUIDGenerator() {
            this(0);
        }

        private UUIDGenerator(byte by) {
            super(Object.class);
        }

        @Override
        public final ObjectIdGenerator<UUID> forScope(Class<?> clazz) {
            return this;
        }

        @Override
        public final ObjectIdGenerator<UUID> newForSerialization(Object object) {
            return this;
        }

        @Override
        public final UUID generateId(Object object) {
            return UUID.randomUUID();
        }

        @Override
        public final ObjectIdGenerator.IdKey key(Object object) {
            if (object == null) {
                return null;
            }
            return new ObjectIdGenerator.IdKey(this.getClass(), null, object);
        }

        @Override
        public final boolean canUseFor(ObjectIdGenerator<?> objectIdGenerator) {
            return objectIdGenerator.getClass() == this.getClass();
        }
    }

    public static final class IntSequenceGenerator
    extends a<Integer> {
        protected transient int _nextValue;

        public IntSequenceGenerator() {
            this(Object.class, -1);
        }

        public IntSequenceGenerator(Class<?> clazz, int n2) {
            super(clazz);
            this._nextValue = n2;
        }

        protected final int initialValue() {
            return 1;
        }

        @Override
        public final ObjectIdGenerator<Integer> forScope(Class<?> clazz) {
            if (this._scope == clazz) {
                return this;
            }
            return new IntSequenceGenerator(clazz, this._nextValue);
        }

        @Override
        public final ObjectIdGenerator<Integer> newForSerialization(Object object) {
            return new IntSequenceGenerator(this._scope, this.initialValue());
        }

        @Override
        public final ObjectIdGenerator.IdKey key(Object object) {
            if (object == null) {
                return null;
            }
            return new ObjectIdGenerator.IdKey(this.getClass(), this._scope, object);
        }

        @Override
        public final Integer generateId(Object object) {
            if (object == null) {
                return null;
            }
            int n2 = this._nextValue++;
            return n2;
        }
    }

    public static abstract class PropertyGenerator
    extends a<Object> {
        protected PropertyGenerator(Class<?> clazz) {
            super(clazz);
        }
    }

    public static abstract class None
    extends ObjectIdGenerator<Object> {
    }

    private static abstract class a<T>
    extends ObjectIdGenerator<T> {
        protected final Class<?> _scope;

        protected a(Class<?> clazz) {
            this._scope = clazz;
        }

        @Override
        public final Class<?> getScope() {
            return this._scope;
        }

        @Override
        public boolean canUseFor(ObjectIdGenerator<?> objectIdGenerator) {
            return objectIdGenerator.getClass() == this.getClass() && objectIdGenerator.getScope() == this._scope;
        }

        @Override
        public abstract T generateId(Object var1);
    }
}

