/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.Base64Variant;

public final class Base64Variants {
    public static final Base64Variant MIME = new Base64Variant("MIME", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", true, '=', 76);
    public static final Base64Variant MIME_NO_LINEFEEDS = new Base64Variant(MIME, "MIME-NO-LINEFEEDS", Integer.MAX_VALUE);
    public static final Base64Variant PEM = new Base64Variant(MIME, "PEM", true, '=', 64);
    public static final Base64Variant MODIFIED_FOR_URL;

    public static Base64Variant getDefaultVariant() {
        return MIME_NO_LINEFEEDS;
    }

    public static Base64Variant valueOf(String string) {
        if (Base64Variants.MIME.a.equals(string)) {
            return MIME;
        }
        if (Base64Variants.MIME_NO_LINEFEEDS.a.equals(string)) {
            return MIME_NO_LINEFEEDS;
        }
        if (Base64Variants.PEM.a.equals(string)) {
            return PEM;
        }
        if (Base64Variants.MODIFIED_FOR_URL.a.equals(string)) {
            return MODIFIED_FOR_URL;
        }
        string = string == null ? "<null>" : "'" + string + "'";
        throw new IllegalArgumentException("No Base64Variant with name " + string);
    }

    static {
        StringBuilder stringBuilder = new StringBuilder("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
        stringBuilder.setCharAt(stringBuilder.indexOf("+"), '-');
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.setCharAt(stringBuilder2.indexOf("/"), '_');
        MODIFIED_FOR_URL = new Base64Variant("MODIFIED-FOR-URL", stringBuilder.toString(), false, '\u0000', Integer.MAX_VALUE);
    }
}

