/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.ErrorReportConfiguration;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteConstraints;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.ContentReference;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.InputDecorator;
import com.fasterxml.jackson.core.io.OutputDecorator;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.io.UTF8Writer;
import com.fasterxml.jackson.core.json.ByteSourceJsonBootstrapper;
import com.fasterxml.jackson.core.json.PackageVersion;
import com.fasterxml.jackson.core.json.ReaderBasedJsonParser;
import com.fasterxml.jackson.core.json.UTF8DataInputJsonParser;
import com.fasterxml.jackson.core.json.UTF8JsonGenerator;
import com.fasterxml.jackson.core.json.WriterBasedJsonGenerator;
import com.fasterxml.jackson.core.json.async.NonBlockingByteBufferJsonParser;
import com.fasterxml.jackson.core.json.async.NonBlockingJsonParser;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.JacksonFeature;
import com.fasterxml.jackson.core.util.JsonGeneratorDecorator;
import com.fasterxml.jackson.core.util.JsonRecyclerPools;
import com.fasterxml.jackson.core.util.RecyclerPool;
import java.io.CharArrayReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JsonFactory
extends TokenStreamFactory
implements Serializable {
    public static final String FORMAT_NAME_JSON = "JSON";
    protected static final int DEFAULT_FACTORY_FEATURE_FLAGS = Feature.collectDefaults();
    protected static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser.Feature.collectDefaults();
    protected static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator.Feature.collectDefaults();
    public static final SerializableString DEFAULT_ROOT_VALUE_SEPARATOR = new SerializedString(" ");
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    protected transient CharsToNameCanonicalizer _rootCharSymbols;
    protected final transient ByteQuadsCanonicalizer _byteSymbolCanonicalizer = ByteQuadsCanonicalizer.createRoot();
    protected int _factoryFeatures = DEFAULT_FACTORY_FEATURE_FLAGS;
    protected int _parserFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
    protected int _generatorFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;
    protected RecyclerPool<BufferRecycler> _recyclerPool;
    protected ObjectCodec _objectCodec;
    protected CharacterEscapes _characterEscapes;
    protected StreamReadConstraints _streamReadConstraints;
    protected ErrorReportConfiguration _errorReportConfiguration;
    protected StreamWriteConstraints _streamWriteConstraints;
    protected InputDecorator _inputDecorator;
    protected OutputDecorator _outputDecorator;
    protected final List<JsonGeneratorDecorator> _generatorDecorators;
    protected SerializableString _rootValueSeparator = DEFAULT_ROOT_VALUE_SEPARATOR;
    protected int _maximumNonEscapedChar;
    protected final char _quoteChar;

    public JsonFactory() {
        this((ObjectCodec)null);
    }

    public JsonFactory(ObjectCodec objectCodec) {
        this._recyclerPool = JsonRecyclerPools.defaultPool();
        this._objectCodec = objectCodec;
        this._quoteChar = (char)34;
        this._streamReadConstraints = StreamReadConstraints.defaults();
        this._streamWriteConstraints = StreamWriteConstraints.defaults();
        this._errorReportConfiguration = ErrorReportConfiguration.defaults();
        this._generatorDecorators = null;
        this._rootCharSymbols = CharsToNameCanonicalizer.createRoot(this);
    }

    protected JsonFactory(JsonFactory jsonFactory, ObjectCodec objectCodec) {
        this._recyclerPool = jsonFactory._recyclerPool;
        this._objectCodec = objectCodec;
        this._factoryFeatures = jsonFactory._factoryFeatures;
        this._parserFeatures = jsonFactory._parserFeatures;
        this._generatorFeatures = jsonFactory._generatorFeatures;
        this._inputDecorator = jsonFactory._inputDecorator;
        this._outputDecorator = jsonFactory._outputDecorator;
        this._generatorDecorators = JsonFactory._copy(jsonFactory._generatorDecorators);
        this._streamReadConstraints = Objects.requireNonNull(jsonFactory._streamReadConstraints);
        this._streamWriteConstraints = Objects.requireNonNull(jsonFactory._streamWriteConstraints);
        this._errorReportConfiguration = Objects.requireNonNull(jsonFactory._errorReportConfiguration);
        this._characterEscapes = jsonFactory._characterEscapes;
        this._rootValueSeparator = jsonFactory._rootValueSeparator;
        this._maximumNonEscapedChar = jsonFactory._maximumNonEscapedChar;
        this._quoteChar = jsonFactory._quoteChar;
        this._rootCharSymbols = CharsToNameCanonicalizer.createRoot(this);
    }

    public JsonFactory(JsonFactoryBuilder jsonFactoryBuilder) {
        this._recyclerPool = jsonFactoryBuilder._recyclerPool;
        this._objectCodec = null;
        this._factoryFeatures = jsonFactoryBuilder._factoryFeatures;
        this._parserFeatures = jsonFactoryBuilder._streamReadFeatures;
        this._generatorFeatures = jsonFactoryBuilder._streamWriteFeatures;
        this._inputDecorator = jsonFactoryBuilder._inputDecorator;
        this._outputDecorator = jsonFactoryBuilder._outputDecorator;
        this._generatorDecorators = JsonFactory._copy(jsonFactoryBuilder._generatorDecorators);
        this._streamReadConstraints = Objects.requireNonNull(jsonFactoryBuilder._streamReadConstraints);
        this._streamWriteConstraints = Objects.requireNonNull(jsonFactoryBuilder._streamWriteConstraints);
        this._errorReportConfiguration = Objects.requireNonNull(jsonFactoryBuilder._errorReportConfiguration);
        this._characterEscapes = jsonFactoryBuilder._characterEscapes;
        this._rootValueSeparator = jsonFactoryBuilder._rootValueSeparator;
        this._maximumNonEscapedChar = jsonFactoryBuilder._maximumNonEscapedChar;
        this._quoteChar = jsonFactoryBuilder._quoteChar;
        this._rootCharSymbols = CharsToNameCanonicalizer.createRoot(this);
    }

    protected JsonFactory(TSFBuilder<?, ?> tSFBuilder, boolean bl2) {
        this._recyclerPool = tSFBuilder._recyclerPool;
        this._objectCodec = null;
        this._factoryFeatures = tSFBuilder._factoryFeatures;
        this._parserFeatures = tSFBuilder._streamReadFeatures;
        this._generatorFeatures = tSFBuilder._streamWriteFeatures;
        this._inputDecorator = tSFBuilder._inputDecorator;
        this._outputDecorator = tSFBuilder._outputDecorator;
        this._generatorDecorators = JsonFactory._copy(tSFBuilder._generatorDecorators);
        this._streamReadConstraints = Objects.requireNonNull(tSFBuilder._streamReadConstraints);
        this._streamWriteConstraints = Objects.requireNonNull(tSFBuilder._streamWriteConstraints);
        this._errorReportConfiguration = Objects.requireNonNull(tSFBuilder._errorReportConfiguration);
        this._characterEscapes = null;
        this._rootValueSeparator = null;
        this._maximumNonEscapedChar = 0;
        this._quoteChar = (char)34;
        this._rootCharSymbols = CharsToNameCanonicalizer.createRoot(this);
    }

    public TSFBuilder<?, ?> rebuild() {
        this.a("Factory implementation for format (%s) MUST override `rebuild()` method");
        return new JsonFactoryBuilder(this);
    }

    public static TSFBuilder<?, ?> builder() {
        return new JsonFactoryBuilder();
    }

    public JsonFactory copy() {
        this._checkInvalidCopy(JsonFactory.class);
        return new JsonFactory(this, null);
    }

    protected void _checkInvalidCopy(Class<?> clazz) {
        if (this.getClass() != clazz) {
            throw new IllegalStateException("Failed copy(): " + this.getClass().getName() + " (version: " + this.version() + ") does not override copy(); it has to");
        }
    }

    protected static <T> List<T> _copy(List<T> list) {
        if (list == null) {
            return list;
        }
        return new ArrayList<T>(list);
    }

    protected Object readResolve() {
        JsonFactory jsonFactory = this;
        return new JsonFactory(jsonFactory, jsonFactory._objectCodec);
    }

    @Override
    public boolean requiresPropertyOrdering() {
        return false;
    }

    @Override
    public boolean canHandleBinaryNatively() {
        return false;
    }

    public boolean canUseCharArrays() {
        return true;
    }

    @Override
    public boolean canParseAsync() {
        return this.a();
    }

    @Override
    public Class<? extends FormatFeature> getFormatReadFeatureType() {
        return null;
    }

    @Override
    public Class<? extends FormatFeature> getFormatWriteFeatureType() {
        return null;
    }

    @Override
    public boolean canUseSchema(FormatSchema formatSchema) {
        if (formatSchema == null) {
            return false;
        }
        String string = ((TokenStreamFactory)this).getFormatName();
        return string != null && string.equals(formatSchema.getSchemaType());
    }

    @Override
    public String getFormatName() {
        if (this.getClass() == JsonFactory.class) {
            return FORMAT_NAME_JSON;
        }
        return null;
    }

    public MatchStrength hasFormat(InputAccessor inputAccessor) {
        if (this.getClass() == JsonFactory.class) {
            return this.hasJSONFormat(inputAccessor);
        }
        return null;
    }

    public boolean requiresCustomCodec() {
        return false;
    }

    protected MatchStrength hasJSONFormat(InputAccessor inputAccessor) {
        return ByteSourceJsonBootstrapper.hasJSONFormat(inputAccessor);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Deprecated
    public final JsonFactory configure(Feature feature, boolean bl2) {
        if (bl2) {
            return this.enable(feature);
        }
        return this.disable(feature);
    }

    @Deprecated
    public JsonFactory enable(Feature feature) {
        this._factoryFeatures |= feature.getMask();
        return this;
    }

    @Deprecated
    public JsonFactory disable(Feature feature) {
        this._factoryFeatures &= ~feature.getMask();
        return this;
    }

    @Override
    public final boolean isEnabled(Feature feature) {
        return (this._factoryFeatures & feature.getMask()) != 0;
    }

    @Override
    public final int getFactoryFeatures() {
        return this._factoryFeatures;
    }

    @Override
    public final int getParserFeatures() {
        return this._parserFeatures;
    }

    @Override
    public final int getGeneratorFeatures() {
        return this._generatorFeatures;
    }

    @Override
    public int getFormatParserFeatures() {
        return 0;
    }

    @Override
    public int getFormatGeneratorFeatures() {
        return 0;
    }

    @Override
    public StreamReadConstraints streamReadConstraints() {
        return this._streamReadConstraints;
    }

    @Override
    public StreamWriteConstraints streamWriteConstraints() {
        return this._streamWriteConstraints;
    }

    public JsonFactory setStreamReadConstraints(StreamReadConstraints streamReadConstraints) {
        int n2 = this._streamReadConstraints.getMaxNameLength();
        this._streamReadConstraints = Objects.requireNonNull(streamReadConstraints);
        if (this._streamReadConstraints.getMaxNameLength() != n2) {
            this._rootCharSymbols = CharsToNameCanonicalizer.createRoot(this);
        }
        return this;
    }

    public JsonFactory setErrorReportConfiguration(ErrorReportConfiguration errorReportConfiguration) {
        this._errorReportConfiguration = Objects.requireNonNull(errorReportConfiguration, "Cannot pass null ErrorReportConfiguration");
        return this;
    }

    public JsonFactory setStreamWriteConstraints(StreamWriteConstraints streamWriteConstraints) {
        this._streamWriteConstraints = Objects.requireNonNull(streamWriteConstraints);
        return this;
    }

    public final JsonFactory configure(JsonParser.Feature feature, boolean bl2) {
        if (bl2) {
            return this.enable(feature);
        }
        return this.disable(feature);
    }

    public JsonFactory enable(JsonParser.Feature feature) {
        this._parserFeatures |= feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonParser.Feature feature) {
        this._parserFeatures &= ~feature.getMask();
        return this;
    }

    @Override
    public final boolean isEnabled(JsonParser.Feature feature) {
        return (this._parserFeatures & feature.getMask()) != 0;
    }

    @Override
    public final boolean isEnabled(StreamReadFeature streamReadFeature) {
        return (this._parserFeatures & streamReadFeature.mappedFeature().getMask()) != 0;
    }

    public InputDecorator getInputDecorator() {
        return this._inputDecorator;
    }

    @Deprecated
    public JsonFactory setInputDecorator(InputDecorator inputDecorator) {
        this._inputDecorator = inputDecorator;
        return this;
    }

    public final JsonFactory configure(JsonGenerator.Feature feature, boolean bl2) {
        if (bl2) {
            return this.enable(feature);
        }
        return this.disable(feature);
    }

    public JsonFactory enable(JsonGenerator.Feature feature) {
        this._generatorFeatures |= feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonGenerator.Feature feature) {
        this._generatorFeatures &= ~feature.getMask();
        return this;
    }

    @Override
    public final boolean isEnabled(JsonGenerator.Feature feature) {
        return (this._generatorFeatures & feature.getMask()) != 0;
    }

    @Override
    public final boolean isEnabled(StreamWriteFeature streamWriteFeature) {
        return (this._generatorFeatures & streamWriteFeature.mappedFeature().getMask()) != 0;
    }

    public CharacterEscapes getCharacterEscapes() {
        return this._characterEscapes;
    }

    public JsonFactory setCharacterEscapes(CharacterEscapes characterEscapes) {
        this._characterEscapes = characterEscapes;
        return this;
    }

    public OutputDecorator getOutputDecorator() {
        return this._outputDecorator;
    }

    @Deprecated
    public JsonFactory setOutputDecorator(OutputDecorator outputDecorator) {
        this._outputDecorator = outputDecorator;
        return this;
    }

    public JsonFactory setRootValueSeparator(String string) {
        this._rootValueSeparator = string == null ? null : new SerializedString(string);
        return this;
    }

    public String getRootValueSeparator() {
        if (this._rootValueSeparator == null) {
            return null;
        }
        return this._rootValueSeparator.getValue();
    }

    public JsonFactory setRecyclerPool(RecyclerPool<BufferRecycler> recyclerPool) {
        this._recyclerPool = Objects.requireNonNull(recyclerPool);
        return this;
    }

    public JsonFactory setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public JsonParser createParser(File object) {
        JsonFactory jsonFactory = this;
        IOContext iOContext = jsonFactory._createContext(jsonFactory._createContentReference(object), true);
        object = this._fileInputStream((File)object);
        JsonFactory jsonFactory2 = this;
        return jsonFactory2._createParser(jsonFactory2._decorate((InputStream)object, iOContext), iOContext);
    }

    @Override
    public JsonParser createParser(URL object) {
        JsonFactory jsonFactory = this;
        IOContext iOContext = jsonFactory._createContext(jsonFactory._createContentReference(object), true);
        object = this._optimizedStreamFromURL((URL)object);
        JsonFactory jsonFactory2 = this;
        return jsonFactory2._createParser(jsonFactory2._decorate((InputStream)object, iOContext), iOContext);
    }

    @Override
    public JsonParser createParser(InputStream inputStream) {
        JsonFactory jsonFactory = this;
        IOContext iOContext = jsonFactory._createContext(jsonFactory._createContentReference(inputStream), false);
        JsonFactory jsonFactory2 = this;
        return jsonFactory2._createParser(jsonFactory2._decorate(inputStream, iOContext), iOContext);
    }

    @Override
    public JsonParser createParser(Reader reader) {
        JsonFactory jsonFactory = this;
        IOContext iOContext = jsonFactory._createContext(jsonFactory._createContentReference(reader), false);
        JsonFactory jsonFactory2 = this;
        return jsonFactory2._createParser(jsonFactory2._decorate(reader, iOContext), iOContext);
    }

    @Override
    public JsonParser createParser(byte[] byArray) {
        InputStream inputStream;
        JsonFactory jsonFactory = this;
        IOContext iOContext = jsonFactory._createContext(jsonFactory._createContentReference(byArray), true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, 0, byArray.length)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, 0, byArray.length, iOContext);
    }

    @Override
    public JsonParser createParser(byte[] byArray, int n2, int n3) {
        InputStream inputStream;
        this._checkRangeBoundsForByteArray(byArray, n2, n3);
        JsonFactory jsonFactory = this;
        IOContext iOContext = jsonFactory._createContext(jsonFactory._createContentReference(byArray, n2, n3), true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, n2, n3)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, n2, n3, iOContext);
    }

    @Override
    public JsonParser createParser(String string) {
        int n2 = string.length();
        if (this._inputDecorator != null || n2 > 32768 || !this.canUseCharArrays()) {
            return ((TokenStreamFactory)this).createParser(new StringReader(string));
        }
        JsonFactory jsonFactory = this;
        IOContext iOContext = jsonFactory._createContext(jsonFactory._createContentReference(string), true);
        char[] cArray = iOContext.allocTokenBuffer(n2);
        string.getChars(0, n2, cArray, 0);
        return this._createParser(cArray, 0, n2, iOContext, true);
    }

    @Override
    public JsonParser createParser(char[] cArray) {
        return ((TokenStreamFactory)this).createParser(cArray, 0, cArray.length);
    }

    @Override
    public JsonParser createParser(char[] cArray, int n2, int n3) {
        this._checkRangeBoundsForCharArray(cArray, n2, n3);
        if (this._inputDecorator != null) {
            return ((TokenStreamFactory)this).createParser(new CharArrayReader(cArray, n2, n3));
        }
        JsonFactory jsonFactory = this;
        return this._createParser(cArray, n2, n3, jsonFactory._createContext(jsonFactory._createContentReference(cArray, n2, n3), true), false);
    }

    @Override
    public JsonParser createParser(DataInput dataInput) {
        JsonFactory jsonFactory = this;
        IOContext iOContext = jsonFactory._createContext(jsonFactory._createContentReference(dataInput), false);
        JsonFactory jsonFactory2 = this;
        return jsonFactory2._createParser(jsonFactory2._decorate(dataInput, iOContext), iOContext);
    }

    @Override
    public JsonParser createNonBlockingByteArrayParser() {
        this.a("Non-blocking source not (yet?) supported for this format (%s)");
        IOContext iOContext = this._createNonBlockingContext(null);
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this._byteSymbolCanonicalizer.makeChildOrPlaceholder(this._factoryFeatures);
        return new NonBlockingJsonParser(iOContext, this._parserFeatures, byteQuadsCanonicalizer);
    }

    @Override
    public JsonParser createNonBlockingByteBufferParser() {
        this.a("Non-blocking source not (yet?) supported for this format (%s)");
        IOContext iOContext = this._createNonBlockingContext(null);
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this._byteSymbolCanonicalizer.makeChildOrPlaceholder(this._factoryFeatures);
        return new NonBlockingByteBufferJsonParser(iOContext, this._parserFeatures, byteQuadsCanonicalizer);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream closeable, JsonEncoding jsonEncoding) {
        JsonFactory jsonFactory = this;
        IOContext iOContext = jsonFactory._createContext(jsonFactory._createContentReference(closeable), false);
        iOContext.setEncoding(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            JsonFactory jsonFactory2 = this;
            return jsonFactory2._createUTF8Generator(jsonFactory2._decorate((OutputStream)closeable, iOContext), iOContext);
        }
        closeable = this._createWriter((OutputStream)closeable, jsonEncoding, iOContext);
        JsonFactory jsonFactory3 = this;
        return jsonFactory3._createGenerator(jsonFactory3._decorate((Writer)closeable, iOContext), iOContext);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream outputStream) {
        return ((TokenStreamFactory)this).createGenerator(outputStream, JsonEncoding.UTF8);
    }

    @Override
    public JsonGenerator createGenerator(Writer writer) {
        JsonFactory jsonFactory = this;
        IOContext iOContext = jsonFactory._createContext(jsonFactory._createContentReference(writer), false);
        JsonFactory jsonFactory2 = this;
        return jsonFactory2._createGenerator(jsonFactory2._decorate(writer, iOContext), iOContext);
    }

    @Override
    public JsonGenerator createGenerator(File object, JsonEncoding jsonEncoding) {
        object = this._fileOutputStream((File)object);
        JsonFactory jsonFactory = this;
        IOContext iOContext = jsonFactory._createContext(jsonFactory._createContentReference(object), true);
        iOContext.setEncoding(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            JsonFactory jsonFactory2 = this;
            return jsonFactory2._createUTF8Generator(jsonFactory2._decorate((OutputStream)object, iOContext), iOContext);
        }
        object = this._createWriter((OutputStream)object, jsonEncoding, iOContext);
        JsonFactory jsonFactory3 = this;
        return jsonFactory3._createGenerator(jsonFactory3._decorate((Writer)object, iOContext), iOContext);
    }

    @Override
    public JsonGenerator createGenerator(DataOutput dataOutput, JsonEncoding jsonEncoding) {
        JsonFactory jsonFactory = this;
        return ((TokenStreamFactory)jsonFactory).createGenerator(jsonFactory._createDataOutputWrapper(dataOutput), jsonEncoding);
    }

    @Override
    public JsonGenerator createGenerator(DataOutput dataOutput) {
        JsonFactory jsonFactory = this;
        return ((TokenStreamFactory)jsonFactory).createGenerator(jsonFactory._createDataOutputWrapper(dataOutput), JsonEncoding.UTF8);
    }

    @Deprecated
    public JsonParser createJsonParser(File file) {
        return ((TokenStreamFactory)this).createParser(file);
    }

    @Deprecated
    public JsonParser createJsonParser(URL uRL) {
        return ((TokenStreamFactory)this).createParser(uRL);
    }

    @Deprecated
    public JsonParser createJsonParser(InputStream inputStream) {
        return ((TokenStreamFactory)this).createParser(inputStream);
    }

    @Deprecated
    public JsonParser createJsonParser(Reader reader) {
        return ((TokenStreamFactory)this).createParser(reader);
    }

    @Deprecated
    public JsonParser createJsonParser(byte[] byArray) {
        return ((TokenStreamFactory)this).createParser(byArray);
    }

    @Deprecated
    public JsonParser createJsonParser(byte[] byArray, int n2, int n3) {
        return ((TokenStreamFactory)this).createParser(byArray, n2, n3);
    }

    @Deprecated
    public JsonParser createJsonParser(String string) {
        return ((TokenStreamFactory)this).createParser(string);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) {
        return ((TokenStreamFactory)this).createGenerator(outputStream, jsonEncoding);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(Writer writer) {
        return ((TokenStreamFactory)this).createGenerator(writer);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(OutputStream outputStream) {
        return ((TokenStreamFactory)this).createGenerator(outputStream, JsonEncoding.UTF8);
    }

    protected JsonParser _createParser(InputStream inputStream, IOContext iOContext) {
        try {
            return new ByteSourceJsonBootstrapper(iOContext, inputStream).constructParser(this._parserFeatures, this._objectCodec, this._byteSymbolCanonicalizer, this._rootCharSymbols, this._factoryFeatures);
        }
        catch (IOException | RuntimeException exception) {
            if (iOContext.isResourceManaged()) {
                try {
                    inputStream.close();
                }
                catch (Exception exception2) {
                    exception.addSuppressed(exception2);
                }
            }
            iOContext.close();
            throw exception;
        }
    }

    protected JsonParser _createParser(Reader reader, IOContext iOContext) {
        return new ReaderBasedJsonParser(iOContext, this._parserFeatures, reader, this._objectCodec, this._rootCharSymbols.makeChild());
    }

    protected JsonParser _createParser(char[] cArray, int n2, int n3, IOContext iOContext, boolean bl2) {
        int n4 = n2;
        return new ReaderBasedJsonParser(iOContext, this._parserFeatures, null, this._objectCodec, this._rootCharSymbols.makeChild(), cArray, n4, n4 + n3, bl2);
    }

    protected JsonParser _createParser(byte[] byArray, int n2, int n3, IOContext iOContext) {
        return new ByteSourceJsonBootstrapper(iOContext, byArray, n2, n3).constructParser(this._parserFeatures, this._objectCodec, this._byteSymbolCanonicalizer, this._rootCharSymbols, this._factoryFeatures);
    }

    protected JsonParser _createParser(DataInput dataInput, IOContext iOContext) {
        this.a("InputData source not (yet?) supported for this format (%s)");
        int n2 = ByteSourceJsonBootstrapper.skipUTF8BOM(dataInput);
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this._byteSymbolCanonicalizer.makeChildOrPlaceholder(this._factoryFeatures);
        return new UTF8DataInputJsonParser(iOContext, this._parserFeatures, dataInput, this._objectCodec, byteQuadsCanonicalizer, n2);
    }

    protected JsonGenerator _createGenerator(Writer closeable, IOContext object) {
        closeable = new WriterBasedJsonGenerator((IOContext)object, this._generatorFeatures, this._objectCodec, (Writer)closeable, this._quoteChar);
        if (this._maximumNonEscapedChar > 0) {
            ((JsonGenerator)closeable).setHighestNonEscapedChar(this._maximumNonEscapedChar);
        }
        if (this._characterEscapes != null) {
            ((JsonGenerator)closeable).setCharacterEscapes(this._characterEscapes);
        }
        if ((object = this._rootValueSeparator) != DEFAULT_ROOT_VALUE_SEPARATOR) {
            ((JsonGenerator)closeable).setRootValueSeparator((SerializableString)object);
        }
        return this._decorate((JsonGenerator)closeable);
    }

    protected JsonGenerator _createUTF8Generator(OutputStream closeable, IOContext object) {
        closeable = new UTF8JsonGenerator((IOContext)object, this._generatorFeatures, this._objectCodec, (OutputStream)closeable, this._quoteChar);
        if (this._maximumNonEscapedChar > 0) {
            ((JsonGenerator)closeable).setHighestNonEscapedChar(this._maximumNonEscapedChar);
        }
        if (this._characterEscapes != null) {
            ((JsonGenerator)closeable).setCharacterEscapes(this._characterEscapes);
        }
        if ((object = this._rootValueSeparator) != DEFAULT_ROOT_VALUE_SEPARATOR) {
            ((JsonGenerator)closeable).setRootValueSeparator((SerializableString)object);
        }
        return this._decorate((JsonGenerator)closeable);
    }

    protected Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) {
        if (jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Writer(iOContext, outputStream);
        }
        return new OutputStreamWriter(outputStream, jsonEncoding.getJavaName());
    }

    protected final InputStream _decorate(InputStream inputStream, IOContext autoCloseable) {
        if (this._inputDecorator != null && (autoCloseable = this._inputDecorator.decorate((IOContext)autoCloseable, inputStream)) != null) {
            return autoCloseable;
        }
        return inputStream;
    }

    protected final Reader _decorate(Reader reader, IOContext autoCloseable) {
        if (this._inputDecorator != null && (autoCloseable = this._inputDecorator.decorate((IOContext)autoCloseable, reader)) != null) {
            return autoCloseable;
        }
        return reader;
    }

    protected final DataInput _decorate(DataInput dataInput, IOContext object) {
        if (this._inputDecorator != null && (object = this._inputDecorator.decorate((IOContext)object, dataInput)) != null) {
            return object;
        }
        return dataInput;
    }

    protected final OutputStream _decorate(OutputStream outputStream, IOContext autoCloseable) {
        if (this._outputDecorator != null && (autoCloseable = this._outputDecorator.decorate((IOContext)autoCloseable, outputStream)) != null) {
            return autoCloseable;
        }
        return outputStream;
    }

    protected final Writer _decorate(Writer writer, IOContext autoCloseable) {
        if (this._outputDecorator != null && (autoCloseable = this._outputDecorator.decorate((IOContext)autoCloseable, writer)) != null) {
            return autoCloseable;
        }
        return writer;
    }

    protected JsonGenerator _decorate(JsonGenerator jsonGenerator) {
        if (this._generatorDecorators != null) {
            for (JsonGeneratorDecorator jsonGeneratorDecorator : this._generatorDecorators) {
                jsonGenerator = jsonGeneratorDecorator.decorate(this, jsonGenerator);
            }
        }
        return jsonGenerator;
    }

    public BufferRecycler _getBufferRecycler() {
        return this._getRecyclerPool().acquireAndLinkPooled();
    }

    public RecyclerPool<BufferRecycler> _getRecyclerPool() {
        if (!Feature.USE_THREAD_LOCAL_FOR_BUFFER_RECYCLING.enabledIn(this._factoryFeatures)) {
            return JsonRecyclerPools.nonRecyclingPool();
        }
        return this._recyclerPool;
    }

    protected IOContext _createContext(ContentReference contentReference, boolean bl2) {
        Object object;
        BufferRecycler bufferRecycler = null;
        boolean bl3 = false;
        if (contentReference == null) {
            contentReference = ContentReference.unknown();
        } else {
            object = contentReference.getRawContent();
            if (object instanceof BufferRecycler.Gettable) {
                bufferRecycler = ((BufferRecycler.Gettable)object).bufferRecycler();
                boolean bl4 = bl3 = bufferRecycler != null;
            }
        }
        if (bufferRecycler == null) {
            bufferRecycler = this._getBufferRecycler();
        }
        object = new IOContext(this._streamReadConstraints, this._streamWriteConstraints, this._errorReportConfiguration, bufferRecycler, contentReference, bl2);
        if (bl3) {
            ((IOContext)object).markBufferRecyclerReleased();
        }
        return object;
    }

    @Deprecated
    protected IOContext _createContext(Object object, boolean bl2) {
        return new IOContext(this._streamReadConstraints, this._streamWriteConstraints, this._errorReportConfiguration, this._getBufferRecycler(), this._createContentReference(object), bl2);
    }

    protected IOContext _createNonBlockingContext(Object object) {
        return new IOContext(this._streamReadConstraints, this._streamWriteConstraints, this._errorReportConfiguration, this._getBufferRecycler(), this._createContentReference(object), false);
    }

    protected ContentReference _createContentReference(Object object) {
        return ContentReference.construct(!((TokenStreamFactory)this).canHandleBinaryNatively(), object, this._errorReportConfiguration);
    }

    protected ContentReference _createContentReference(Object object, int n2, int n3) {
        return ContentReference.construct(!((TokenStreamFactory)this).canHandleBinaryNatively(), object, n2, n3, this._errorReportConfiguration);
    }

    private final void a(String string) {
        if (!this.a()) {
            throw new UnsupportedOperationException(String.format(string, ((TokenStreamFactory)this).getFormatName()));
        }
    }

    private final boolean a() {
        return ((TokenStreamFactory)this).getFormatName() == FORMAT_NAME_JSON;
    }

    public static enum Feature implements JacksonFeature
    {
        INTERN_FIELD_NAMES(true),
        CANONICALIZE_FIELD_NAMES(true),
        FAIL_ON_SYMBOL_HASH_OVERFLOW(true),
        USE_THREAD_LOCAL_FOR_BUFFER_RECYCLING(true),
        CHARSET_DETECTION(true);

        private final boolean a;

        public static int collectDefaults() {
            int n2 = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n2 |= feature.getMask();
            }
            return n2;
        }

        private Feature(boolean bl2) {
            this.a = true;
        }

        @Override
        public final boolean enabledByDefault() {
            return this.a;
        }

        @Override
        public final boolean enabledIn(int n2) {
            return (n2 & this.getMask()) != 0;
        }

        @Override
        public final int getMask() {
            return 1 << this.ordinal();
        }
    }
}

