/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.ErrorReportConfiguration;
import com.fasterxml.jackson.core.io.ContentReference;
import java.io.Serializable;

public class JsonLocation
implements Serializable {
    @Deprecated
    public static final int MAX_CONTENT_SNIPPET = 500;
    public static final JsonLocation NA = new JsonLocation(ContentReference.unknown(), -1L, -1L, -1, -1);
    protected final long _totalBytes;
    protected final long _totalChars;
    protected final int _lineNr;
    protected final int _columnNr;
    protected final ContentReference _contentReference;
    protected transient String _sourceDescription;

    public JsonLocation(ContentReference contentReference, long l2, int n2, int n3) {
        this(contentReference, -1L, l2, n2, n3);
    }

    public JsonLocation(ContentReference contentReference, long l2, long l3, int n2, int n3) {
        if (contentReference == null) {
            contentReference = ContentReference.unknown();
        }
        this._contentReference = contentReference;
        this._totalBytes = l2;
        this._totalChars = l3;
        this._lineNr = n2;
        this._columnNr = n3;
    }

    @Deprecated
    public JsonLocation(Object object, long l2, int n2, int n3) {
        this(JsonLocation._wrap(object), l2, n2, n3);
    }

    @Deprecated
    public JsonLocation(Object object, long l2, long l3, int n2, int n3) {
        this(JsonLocation._wrap(object), l2, l3, n2, n3);
    }

    protected static ContentReference _wrap(Object object) {
        if (object instanceof ContentReference) {
            return (ContentReference)object;
        }
        return ContentReference.construct(false, object, ErrorReportConfiguration.defaults());
    }

    public ContentReference contentReference() {
        return this._contentReference;
    }

    @Deprecated
    public Object getSourceRef() {
        return this._contentReference.getRawContent();
    }

    public int getLineNr() {
        return this._lineNr;
    }

    public int getColumnNr() {
        return this._columnNr;
    }

    public long getCharOffset() {
        return this._totalChars;
    }

    public long getByteOffset() {
        return this._totalBytes;
    }

    public String sourceDescription() {
        if (this._sourceDescription == null) {
            this._sourceDescription = this._contentReference.buildSourceDescription();
        }
        return this._sourceDescription;
    }

    public String offsetDescription() {
        return this.appendOffsetDescription(new StringBuilder(40)).toString();
    }

    public StringBuilder appendOffsetDescription(StringBuilder stringBuilder) {
        if (this._contentReference.hasTextualContent()) {
            stringBuilder.append("line: ");
            if (this._lineNr >= 0) {
                stringBuilder.append(this._lineNr);
            } else {
                stringBuilder.append("UNKNOWN");
            }
            stringBuilder.append(", column: ");
            if (this._columnNr >= 0) {
                stringBuilder.append(this._columnNr);
            } else {
                stringBuilder.append("UNKNOWN");
            }
        } else if (this._lineNr > 0) {
            stringBuilder.append("line: ").append(this._lineNr);
            if (this._columnNr > 0) {
                stringBuilder.append(", column: ");
                stringBuilder.append(this._columnNr);
            }
        } else {
            stringBuilder.append("byte offset: #");
            if (this._totalBytes >= 0L) {
                stringBuilder.append(this._totalBytes);
            } else {
                stringBuilder.append("UNKNOWN");
            }
        }
        return stringBuilder;
    }

    public int hashCode() {
        int n2 = this._contentReference == null ? 1 : 2;
        n2 = n2 ^ this._lineNr;
        n2 += this._columnNr;
        n2 ^= (int)this._totalChars;
        return n2 += (int)this._totalBytes;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JsonLocation)) {
            return false;
        }
        object = (JsonLocation)object;
        if (this._contentReference == null ? ((JsonLocation)object)._contentReference != null : !this._contentReference.equals(((JsonLocation)object)._contentReference)) {
            return false;
        }
        return this._lineNr == ((JsonLocation)object)._lineNr && this._columnNr == ((JsonLocation)object)._columnNr && this._totalChars == ((JsonLocation)object)._totalChars && this._totalBytes == ((JsonLocation)object)._totalBytes;
    }

    public String toString() {
        CharSequence charSequence = this.sourceDescription();
        charSequence = new StringBuilder(40 + charSequence.length()).append("[Source: ").append((String)charSequence).append("; ");
        return this.appendOffsetDescription((StringBuilder)charSequence).append(']').toString();
    }
}

