/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

public enum JsonToken {
    NOT_AVAILABLE(null, -1),
    START_OBJECT("{", 1),
    END_OBJECT("}", 2),
    START_ARRAY("[", 3),
    END_ARRAY("]", 4),
    FIELD_NAME(null, 5),
    VALUE_EMBEDDED_OBJECT(null, 12),
    VALUE_STRING(null, 6),
    VALUE_NUMBER_INT(null, 7),
    VALUE_NUMBER_FLOAT(null, 8),
    VALUE_TRUE("true", 9),
    VALUE_FALSE("false", 10),
    VALUE_NULL("null", 11);

    private String a;
    private char[] b;
    private byte[] c;
    private int d;
    private boolean e;
    private boolean f;
    private boolean g;
    private boolean h;
    private boolean i;

    private JsonToken(String string2, int n3) {
        if (string2 == null) {
            this.a = null;
            this.b = null;
            this.c = null;
        } else {
            this.a = string2;
            this.b = string2.toCharArray();
            int n4 = this.b.length;
            this.c = new byte[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                this.c[n2] = (byte)this.b[n2];
            }
        }
        this.d = n3;
        this.h = n3 == 10 || n3 == 9;
        this.g = n3 == 7 || n3 == 8;
        this.e = n3 == 1 || n3 == 3;
        this.f = n3 == 2 || n3 == 4;
        this.i = !this.e && !this.f && n3 != 5 && n3 != -1;
    }

    public final int id() {
        return this.d;
    }

    public final String asString() {
        return this.a;
    }

    public final char[] asCharArray() {
        return this.b;
    }

    public final byte[] asByteArray() {
        return this.c;
    }

    public final boolean isNumeric() {
        return this.g;
    }

    public final boolean isStructStart() {
        return this.e;
    }

    public final boolean isStructEnd() {
        return this.f;
    }

    public final boolean isScalarValue() {
        return this.i;
    }

    public final boolean isBoolean() {
        return this.h;
    }

    public static String valueDescFor(JsonToken jsonToken) {
        if (jsonToken == null) {
            return "<end of input>";
        }
        switch (jsonToken) {
            case START_OBJECT: 
            case END_OBJECT: 
            case FIELD_NAME: {
                return "Object value";
            }
            case START_ARRAY: 
            case END_ARRAY: {
                return "Array value";
            }
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                return "Boolean value";
            }
            case VALUE_EMBEDDED_OBJECT: {
                return "Embedded Object value";
            }
            case VALUE_NUMBER_FLOAT: {
                return "Floating-point value";
            }
            case VALUE_NUMBER_INT: {
                return "Integer value";
            }
            case VALUE_STRING: {
                return "String value";
            }
            case VALUE_NULL: {
                return "Null value";
            }
        }
        return "[Unavailable value]";
    }
}

