/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.exc;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.util.RequestPayload;

public abstract class StreamReadException
extends JsonProcessingException {
    protected transient JsonParser _processor;
    protected RequestPayload _requestPayload;

    protected StreamReadException(String string) {
        this(null, string, null, null);
    }

    protected StreamReadException(JsonParser jsonParser, String string) {
        this(jsonParser, string, StreamReadException._currentLocation(jsonParser), null);
    }

    protected StreamReadException(JsonParser jsonParser, String string, Throwable throwable) {
        this(jsonParser, string, StreamReadException._currentLocation(jsonParser), throwable);
    }

    protected StreamReadException(JsonParser jsonParser, String string, JsonLocation jsonLocation) {
        this(jsonParser, string, jsonLocation, null);
    }

    protected StreamReadException(String string, JsonLocation jsonLocation, Throwable throwable) {
        this(null, string, jsonLocation, throwable);
    }

    protected StreamReadException(JsonParser jsonParser, String string, JsonLocation jsonLocation, Throwable throwable) {
        super(string, jsonLocation, throwable);
        this._processor = jsonParser;
    }

    public abstract StreamReadException withParser(JsonParser var1);

    public abstract StreamReadException withRequestPayload(RequestPayload var1);

    @Override
    public JsonParser getProcessor() {
        return this._processor;
    }

    public RequestPayload getRequestPayload() {
        return this._requestPayload;
    }

    public String getRequestPayloadAsString() {
        if (this._requestPayload != null) {
            return this._requestPayload.toString();
        }
        return null;
    }

    @Override
    public String getMessage() {
        String string = super.getMessage();
        if (this._requestPayload != null) {
            string = string + "\nRequest payload : " + this._requestPayload.toString();
        }
        return string;
    }

    protected static JsonLocation _currentLocation(JsonParser jsonParser) {
        if (jsonParser == null) {
            return null;
        }
        return jsonParser.currentLocation();
    }
}

