/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.filter;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.filter.TokenFilter;
import com.fasterxml.jackson.core.filter.TokenFilterContext;
import com.fasterxml.jackson.core.util.JsonParserDelegate;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class FilteringParserDelegate
extends JsonParserDelegate {
    protected TokenFilter rootFilter;
    protected boolean _allowMultipleMatches;
    protected TokenFilter.Inclusion _inclusion;
    protected JsonToken _currToken;
    protected JsonToken _lastClearedToken;
    protected TokenFilterContext _headContext;
    protected TokenFilterContext _exposedContext;
    protected TokenFilter _itemFilter;
    protected int _matchCount;

    @Deprecated
    public FilteringParserDelegate(JsonParser jsonParser, TokenFilter tokenFilter, boolean bl2, boolean bl3) {
        this(jsonParser, tokenFilter, bl2 ? TokenFilter.Inclusion.INCLUDE_ALL_AND_PATH : TokenFilter.Inclusion.ONLY_INCLUDE_ALL, bl3);
    }

    public FilteringParserDelegate(JsonParser jsonParser, TokenFilter tokenFilter, TokenFilter.Inclusion inclusion, boolean bl2) {
        super(jsonParser);
        this.rootFilter = tokenFilter;
        this._itemFilter = tokenFilter;
        this._headContext = TokenFilterContext.createRootContext(tokenFilter);
        this._inclusion = inclusion;
        this._allowMultipleMatches = bl2;
    }

    public TokenFilter getFilter() {
        return this.rootFilter;
    }

    public int getMatchCount() {
        return this._matchCount;
    }

    @Override
    public JsonToken currentToken() {
        return this._currToken;
    }

    @Override
    @Deprecated
    public JsonToken getCurrentToken() {
        return this._currToken;
    }

    @Override
    public final int currentTokenId() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == null) {
            return 0;
        }
        return jsonToken.id();
    }

    @Override
    @Deprecated
    public final int getCurrentTokenId() {
        return ((JsonParser)this).currentTokenId();
    }

    @Override
    public boolean hasCurrentToken() {
        return this._currToken != null;
    }

    @Override
    public boolean hasTokenId(int n2) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == null) {
            return n2 == 0;
        }
        return jsonToken.id() == n2;
    }

    @Override
    public final boolean hasToken(JsonToken jsonToken) {
        return this._currToken == jsonToken;
    }

    @Override
    public boolean isExpectedStartArrayToken() {
        return this._currToken == JsonToken.START_ARRAY;
    }

    @Override
    public boolean isExpectedStartObjectToken() {
        return this._currToken == JsonToken.START_OBJECT;
    }

    @Override
    public JsonLocation currentLocation() {
        return this.delegate.currentLocation();
    }

    @Override
    @Deprecated
    public JsonLocation getCurrentLocation() {
        return this.delegate.getCurrentLocation();
    }

    @Override
    public JsonLocation currentTokenLocation() {
        return this.delegate.currentTokenLocation();
    }

    @Override
    @Deprecated
    public JsonLocation getTokenLocation() {
        return this.delegate.getTokenLocation();
    }

    @Override
    public JsonStreamContext getParsingContext() {
        return this._filterContext();
    }

    @Override
    @Deprecated
    public String getCurrentName() {
        JsonStreamContext jsonStreamContext = this._filterContext();
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            if ((jsonStreamContext = jsonStreamContext.getParent()) == null) {
                return null;
            }
            return jsonStreamContext.getCurrentName();
        }
        return jsonStreamContext.getCurrentName();
    }

    @Override
    public String currentName() {
        JsonStreamContext jsonStreamContext = this._filterContext();
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            if ((jsonStreamContext = jsonStreamContext.getParent()) == null) {
                return null;
            }
            return jsonStreamContext.getCurrentName();
        }
        return jsonStreamContext.getCurrentName();
    }

    @Override
    public void clearCurrentToken() {
        if (this._currToken != null) {
            this._lastClearedToken = this._currToken;
            this._currToken = null;
        }
    }

    @Override
    public JsonToken getLastClearedToken() {
        return this._lastClearedToken;
    }

    @Override
    public void overrideCurrentName(String string) {
        throw new UnsupportedOperationException("Can not currently override name during filtering read");
    }

    @Override
    public JsonToken nextToken() {
        JsonToken jsonToken;
        Object object;
        block39: {
            if (!this._allowMultipleMatches && this._currToken != null && this._exposedContext == null && this._currToken.isScalarValue() && !this._headContext.isStartHandled() && this._inclusion == TokenFilter.Inclusion.ONLY_INCLUDE_ALL && this._itemFilter == TokenFilter.INCLUDE_ALL) {
                this._currToken = null;
                return null;
            }
            object = this._exposedContext;
            if (object != null) {
                do {
                    if ((jsonToken = ((TokenFilterContext)object).nextTokenToRead()) != null) {
                        this._currToken = jsonToken;
                        return jsonToken;
                    }
                    if (object == this._headContext) {
                        this._exposedContext = null;
                        if (((JsonStreamContext)object).inArray()) {
                            this._currToken = jsonToken = this.delegate.getCurrentToken();
                            if (this._currToken == JsonToken.END_ARRAY) {
                                this._headContext = this._headContext.getParent();
                                this._itemFilter = this._headContext.getFilter();
                            }
                            return jsonToken;
                        }
                        jsonToken = this.delegate.currentToken();
                        if (jsonToken == JsonToken.END_OBJECT) {
                            this._headContext = this._headContext.getParent();
                            this._itemFilter = this._headContext.getFilter();
                        }
                        if (jsonToken != JsonToken.FIELD_NAME) {
                            this._currToken = jsonToken;
                            return jsonToken;
                        }
                        break block39;
                    }
                    this._exposedContext = object = this._headContext.findChildOf((TokenFilterContext)object);
                } while (object != null);
                throw this._constructError("Unexpected problem: chain of filtered context broken");
            }
        }
        if ((jsonToken = this.delegate.nextToken()) == null) {
            this._currToken = jsonToken;
            return jsonToken;
        }
        switch (jsonToken.id()) {
            case 3: {
                object = this._itemFilter;
                if (object == TokenFilter.INCLUDE_ALL) {
                    this._headContext = this._headContext.createChildArrayContext((TokenFilter)object, true);
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                if (object == null) {
                    this.delegate.skipChildren();
                    break;
                }
                if ((object = this._headContext.checkValue((TokenFilter)object)) == null) {
                    this.delegate.skipChildren();
                    break;
                }
                if (object != TokenFilter.INCLUDE_ALL) {
                    object = ((TokenFilter)object).filterStartArray();
                }
                this._itemFilter = object;
                if (object == TokenFilter.INCLUDE_ALL) {
                    this._headContext = this._headContext.createChildArrayContext((TokenFilter)object, true);
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                if (object != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
                    this._headContext = this._headContext.createChildArrayContext((TokenFilter)object, true);
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                this._headContext = this._headContext.createChildArrayContext((TokenFilter)object, false);
                if (this._inclusion != TokenFilter.Inclusion.INCLUDE_ALL_AND_PATH) break;
                FilteringParserDelegate filteringParserDelegate = this;
                jsonToken = filteringParserDelegate._nextTokenWithBuffering(filteringParserDelegate._headContext);
                if (jsonToken == null) break;
                this._currToken = jsonToken;
                return jsonToken;
            }
            case 1: {
                object = this._itemFilter;
                if (object == TokenFilter.INCLUDE_ALL) {
                    this._headContext = this._headContext.createChildObjectContext((TokenFilter)object, true);
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                if (object == null) {
                    this.delegate.skipChildren();
                    break;
                }
                if ((object = this._headContext.checkValue((TokenFilter)object)) == null) {
                    this.delegate.skipChildren();
                    break;
                }
                if (object != TokenFilter.INCLUDE_ALL) {
                    object = ((TokenFilter)object).filterStartObject();
                }
                this._itemFilter = object;
                if (object == TokenFilter.INCLUDE_ALL) {
                    this._headContext = this._headContext.createChildObjectContext((TokenFilter)object, true);
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                if (object != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
                    this._headContext = this._headContext.createChildObjectContext((TokenFilter)object, true);
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                this._headContext = this._headContext.createChildObjectContext((TokenFilter)object, false);
                if (this._inclusion != TokenFilter.Inclusion.INCLUDE_ALL_AND_PATH) break;
                FilteringParserDelegate filteringParserDelegate = this;
                jsonToken = filteringParserDelegate._nextTokenWithBuffering(filteringParserDelegate._headContext);
                if (jsonToken == null) break;
                this._currToken = jsonToken;
                return jsonToken;
            }
            case 2: 
            case 4: {
                boolean bl2 = this._headContext.isStartHandled();
                object = this._headContext.getFilter();
                if (object != null && object != TokenFilter.INCLUDE_ALL) {
                    if (jsonToken.id() == 4) {
                        ((TokenFilter)object).filterFinishArray();
                    } else {
                        ((TokenFilter)object).filterFinishObject();
                    }
                }
                this._headContext = this._headContext.getParent();
                this._itemFilter = this._headContext.getFilter();
                if (!bl2) break;
                this._currToken = jsonToken;
                return this._currToken;
            }
            case 5: {
                String string = this.delegate.currentName();
                object = this._headContext.setFieldName(string);
                if (object == TokenFilter.INCLUDE_ALL) {
                    this._itemFilter = object;
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                if (object == null) {
                    this.delegate.nextToken();
                    this.delegate.skipChildren();
                    break;
                }
                if ((object = ((TokenFilter)object).includeProperty(string)) == null) {
                    this.delegate.nextToken();
                    this.delegate.skipChildren();
                    break;
                }
                this._itemFilter = object;
                if (object == TokenFilter.INCLUDE_ALL) {
                    if (this.a()) {
                        if (this._inclusion == TokenFilter.Inclusion.INCLUDE_ALL_AND_PATH) {
                            this._currToken = jsonToken;
                            return this._currToken;
                        }
                    } else {
                        this.delegate.nextToken();
                        this.delegate.skipChildren();
                    }
                }
                if (this._inclusion == TokenFilter.Inclusion.ONLY_INCLUDE_ALL) break;
                FilteringParserDelegate filteringParserDelegate = this;
                jsonToken = filteringParserDelegate._nextTokenWithBuffering(filteringParserDelegate._headContext);
                if (jsonToken == null) break;
                this._currToken = jsonToken;
                return jsonToken;
            }
            default: {
                object = this._itemFilter;
                if (object == TokenFilter.INCLUDE_ALL) {
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                if (object == null || (object = this._headContext.checkValue((TokenFilter)object)) != TokenFilter.INCLUDE_ALL && (object == null || !((TokenFilter)object).includeValue(this.delegate)) || !this.a()) break;
                this._currToken = jsonToken;
                return this._currToken;
            }
        }
        return this._nextToken2();
    }

    protected final JsonToken _nextToken2() {
        JsonToken jsonToken;
        block7: while (true) {
            TokenFilter tokenFilter;
            if ((jsonToken = this.delegate.nextToken()) == null) {
                this._currToken = jsonToken;
                return jsonToken;
            }
            switch (jsonToken.id()) {
                case 3: {
                    tokenFilter = this._itemFilter;
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildArrayContext(tokenFilter, true);
                        this._currToken = jsonToken;
                        return this._currToken;
                    }
                    if (tokenFilter == null) {
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if ((tokenFilter = this._headContext.checkValue(tokenFilter)) == null) {
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if (tokenFilter != TokenFilter.INCLUDE_ALL) {
                        tokenFilter = tokenFilter.filterStartArray();
                    }
                    this._itemFilter = tokenFilter;
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildArrayContext(tokenFilter, true);
                        this._currToken = jsonToken;
                        return this._currToken;
                    }
                    if (tokenFilter != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
                        this._headContext = this._headContext.createChildArrayContext(tokenFilter, true);
                        this._currToken = jsonToken;
                        return this._currToken;
                    }
                    this._headContext = this._headContext.createChildArrayContext(tokenFilter, false);
                    if (this._inclusion != TokenFilter.Inclusion.INCLUDE_ALL_AND_PATH) continue block7;
                    FilteringParserDelegate filteringParserDelegate = this;
                    jsonToken = filteringParserDelegate._nextTokenWithBuffering(filteringParserDelegate._headContext);
                    if (jsonToken == null) continue block7;
                    this._currToken = jsonToken;
                    return jsonToken;
                }
                case 1: {
                    tokenFilter = this._itemFilter;
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildObjectContext(tokenFilter, true);
                        this._currToken = jsonToken;
                        return this._currToken;
                    }
                    if (tokenFilter == null) {
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if ((tokenFilter = this._headContext.checkValue(tokenFilter)) == null) {
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if (tokenFilter != TokenFilter.INCLUDE_ALL) {
                        tokenFilter = tokenFilter.filterStartObject();
                    }
                    this._itemFilter = tokenFilter;
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildObjectContext(tokenFilter, true);
                        this._currToken = jsonToken;
                        return this._currToken;
                    }
                    if (tokenFilter != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
                        this._headContext = this._headContext.createChildObjectContext(tokenFilter, true);
                        this._currToken = jsonToken;
                        return this._currToken;
                    }
                    this._headContext = this._headContext.createChildObjectContext(tokenFilter, false);
                    if (this._inclusion != TokenFilter.Inclusion.INCLUDE_ALL_AND_PATH) continue block7;
                    FilteringParserDelegate filteringParserDelegate = this;
                    jsonToken = filteringParserDelegate._nextTokenWithBuffering(filteringParserDelegate._headContext);
                    if (jsonToken == null) continue block7;
                    this._currToken = jsonToken;
                    return jsonToken;
                }
                case 4: {
                    boolean bl2;
                    boolean bl3 = this._headContext.isStartHandled();
                    tokenFilter = this._headContext.getFilter();
                    if (tokenFilter != null && tokenFilter != TokenFilter.INCLUDE_ALL) {
                        bl2 = tokenFilter.includeEmptyArray(this._headContext.hasCurrentIndex());
                        tokenFilter.filterFinishArray();
                        if (bl2) {
                            FilteringParserDelegate filteringParserDelegate = this;
                            return filteringParserDelegate.a(filteringParserDelegate._headContext);
                        }
                    }
                    this._headContext = this._headContext.getParent();
                    this._itemFilter = this._headContext.getFilter();
                    if (!bl3) continue block7;
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                case 2: {
                    boolean bl2;
                    boolean bl4 = this._headContext.isStartHandled();
                    tokenFilter = this._headContext.getFilter();
                    if (tokenFilter != null && tokenFilter != TokenFilter.INCLUDE_ALL) {
                        bl2 = tokenFilter.includeEmptyArray(((JsonStreamContext)this._headContext).hasCurrentName());
                        tokenFilter.filterFinishObject();
                        if (bl2) {
                            FilteringParserDelegate filteringParserDelegate = this;
                            return filteringParserDelegate.a(filteringParserDelegate._headContext);
                        }
                    }
                    this._headContext = this._headContext.getParent();
                    this._itemFilter = this._headContext.getFilter();
                    if (!bl4) continue block7;
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                case 5: {
                    String string = this.delegate.currentName();
                    tokenFilter = this._headContext.setFieldName(string);
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._itemFilter = tokenFilter;
                        this._currToken = jsonToken;
                        return this._currToken;
                    }
                    if (tokenFilter == null) {
                        this.delegate.nextToken();
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if ((tokenFilter = tokenFilter.includeProperty(string)) == null) {
                        this.delegate.nextToken();
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    this._itemFilter = tokenFilter;
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        if (this.a()) {
                            if (this._inclusion != TokenFilter.Inclusion.INCLUDE_ALL_AND_PATH) continue block7;
                            this._currToken = jsonToken;
                            return this._currToken;
                        }
                        this.delegate.nextToken();
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if (this._inclusion == TokenFilter.Inclusion.ONLY_INCLUDE_ALL) continue block7;
                    FilteringParserDelegate filteringParserDelegate = this;
                    jsonToken = filteringParserDelegate._nextTokenWithBuffering(filteringParserDelegate._headContext);
                    if (jsonToken == null) continue block7;
                    this._currToken = jsonToken;
                    return jsonToken;
                }
            }
            tokenFilter = this._itemFilter;
            if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                this._currToken = jsonToken;
                return this._currToken;
            }
            if (tokenFilter != null && ((tokenFilter = this._headContext.checkValue(tokenFilter)) == TokenFilter.INCLUDE_ALL || tokenFilter != null && tokenFilter.includeValue(this.delegate)) && this.a()) break;
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    protected final JsonToken _nextTokenWithBuffering(TokenFilterContext tokenFilterContext) {
        block7: while (true) {
            JsonToken jsonToken;
            if ((jsonToken = this.delegate.nextToken()) == null) {
                return jsonToken;
            }
            switch (jsonToken.id()) {
                case 3: {
                    TokenFilter tokenFilter = this._headContext.checkValue(this._itemFilter);
                    if (tokenFilter == null) {
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if (tokenFilter != TokenFilter.INCLUDE_ALL) {
                        tokenFilter = tokenFilter.filterStartArray();
                    }
                    this._itemFilter = tokenFilter;
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildArrayContext(tokenFilter, true);
                        return this.a(tokenFilterContext);
                    }
                    if (tokenFilter != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
                        this._headContext = this._headContext.createChildArrayContext(tokenFilter, true);
                        return this.a(tokenFilterContext);
                    }
                    this._headContext = this._headContext.createChildArrayContext(tokenFilter, false);
                    continue block7;
                }
                case 1: {
                    TokenFilter tokenFilter = this._itemFilter;
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildObjectContext(tokenFilter, true);
                        return jsonToken;
                    }
                    if (tokenFilter == null) {
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if ((tokenFilter = this._headContext.checkValue(tokenFilter)) == null) {
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if (tokenFilter != TokenFilter.INCLUDE_ALL) {
                        tokenFilter = tokenFilter.filterStartObject();
                    }
                    this._itemFilter = tokenFilter;
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildObjectContext(tokenFilter, true);
                        return this.a(tokenFilterContext);
                    }
                    if (tokenFilter != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
                        this._headContext = this._headContext.createChildArrayContext(tokenFilter, true);
                        return this.a(tokenFilterContext);
                    }
                    this._headContext = this._headContext.createChildObjectContext(tokenFilter, false);
                    continue block7;
                }
                case 4: {
                    boolean bl2;
                    TokenFilter tokenFilter = this._headContext.getFilter();
                    if (tokenFilter != null && tokenFilter != TokenFilter.INCLUDE_ALL) {
                        bl2 = tokenFilter.includeEmptyArray(this._headContext.hasCurrentIndex());
                        tokenFilter.filterFinishArray();
                        if (bl2) {
                            return this.a(tokenFilterContext);
                        }
                    }
                    bl2 = this._headContext == tokenFilterContext;
                    boolean bl3 = bl2 && this._headContext.isStartHandled();
                    this._headContext = this._headContext.getParent();
                    this._itemFilter = this._headContext.getFilter();
                    if (bl3) {
                        return jsonToken;
                    }
                    if (!bl2) continue block7;
                    return null;
                }
                case 2: {
                    TokenFilter tokenFilter = this._headContext.getFilter();
                    if (tokenFilter != null && tokenFilter != TokenFilter.INCLUDE_ALL) {
                        boolean bl4 = tokenFilter.includeEmptyObject(((JsonStreamContext)this._headContext).hasCurrentName());
                        tokenFilter.filterFinishObject();
                        if (bl4) {
                            this._headContext._currentName = this._headContext._parent == null ? null : this._headContext._parent._currentName;
                            this._headContext._needToHandleName = false;
                            return this.a(tokenFilterContext);
                        }
                    }
                    boolean bl5 = this._headContext == tokenFilterContext;
                    boolean bl6 = bl5 && this._headContext.isStartHandled();
                    this._headContext = this._headContext.getParent();
                    this._itemFilter = this._headContext.getFilter();
                    if (bl6) {
                        return jsonToken;
                    }
                    if (!bl5) continue block7;
                    return null;
                }
                case 5: {
                    String string = this.delegate.currentName();
                    TokenFilter tokenFilter = this._headContext.setFieldName(string);
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._itemFilter = tokenFilter;
                        return this.a(tokenFilterContext);
                    }
                    if (tokenFilter == null) {
                        this.delegate.nextToken();
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if ((tokenFilter = tokenFilter.includeProperty(string)) == null) {
                        this.delegate.nextToken();
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    this._itemFilter = tokenFilter;
                    if (tokenFilter != TokenFilter.INCLUDE_ALL) continue block7;
                    if (this.a()) {
                        return this.a(tokenFilterContext);
                    }
                    this._itemFilter = this._headContext.setFieldName(string);
                    continue block7;
                }
            }
            TokenFilter tokenFilter = this._itemFilter;
            if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                return this.a(tokenFilterContext);
            }
            if (tokenFilter != null && ((tokenFilter = this._headContext.checkValue(tokenFilter)) == TokenFilter.INCLUDE_ALL || tokenFilter != null && tokenFilter.includeValue(this.delegate)) && this.a()) break;
        }
        return this.a(tokenFilterContext);
    }

    private JsonToken a(TokenFilterContext tokenFilterContext) {
        this._exposedContext = tokenFilterContext;
        JsonToken jsonToken = tokenFilterContext.nextTokenToRead();
        if (jsonToken != null) {
            return jsonToken;
        }
        do {
            if (tokenFilterContext == this._headContext) {
                throw this._constructError("Internal error: failed to locate expected buffered tokens");
            }
            this._exposedContext = tokenFilterContext = this._exposedContext.findChildOf(tokenFilterContext);
            if (tokenFilterContext != null) continue;
            throw this._constructError("Unexpected problem: chain of filtered context broken");
        } while ((jsonToken = this._exposedContext.nextTokenToRead()) == null);
        return jsonToken;
    }

    private final boolean a() {
        if (this._matchCount == 0 || this._allowMultipleMatches) {
            ++this._matchCount;
            return true;
        }
        return false;
    }

    @Override
    public JsonToken nextValue() {
        JsonToken jsonToken = ((JsonParser)this).nextToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            jsonToken = ((JsonParser)this).nextToken();
        }
        return jsonToken;
    }

    @Override
    public JsonParser skipChildren() {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int n2 = 1;
        while (true) {
            JsonToken jsonToken;
            if ((jsonToken = ((JsonParser)this).nextToken()) == null) {
                return this;
            }
            if (jsonToken.isStructStart()) {
                ++n2;
                continue;
            }
            if (jsonToken.isStructEnd() && --n2 == 0) break;
        }
        return this;
    }

    @Override
    public String getText() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return ((JsonParser)this).currentName();
        }
        return this.delegate.getText();
    }

    @Override
    public boolean hasTextCharacters() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return false;
        }
        return this.delegate.hasTextCharacters();
    }

    @Override
    public char[] getTextCharacters() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return ((JsonParser)this).currentName().toCharArray();
        }
        return this.delegate.getTextCharacters();
    }

    @Override
    public int getTextLength() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return ((JsonParser)this).currentName().length();
        }
        return this.delegate.getTextLength();
    }

    @Override
    public int getTextOffset() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return 0;
        }
        return this.delegate.getTextOffset();
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return this.delegate.getBigIntegerValue();
    }

    @Override
    public boolean getBooleanValue() {
        return this.delegate.getBooleanValue();
    }

    @Override
    public byte getByteValue() {
        return this.delegate.getByteValue();
    }

    @Override
    public short getShortValue() {
        return this.delegate.getShortValue();
    }

    @Override
    public BigDecimal getDecimalValue() {
        return this.delegate.getDecimalValue();
    }

    @Override
    public double getDoubleValue() {
        return this.delegate.getDoubleValue();
    }

    @Override
    public float getFloatValue() {
        return this.delegate.getFloatValue();
    }

    @Override
    public int getIntValue() {
        return this.delegate.getIntValue();
    }

    @Override
    public long getLongValue() {
        return this.delegate.getLongValue();
    }

    @Override
    public JsonParser.NumberType getNumberType() {
        return this.delegate.getNumberType();
    }

    @Override
    public Number getNumberValue() {
        return this.delegate.getNumberValue();
    }

    @Override
    public int getValueAsInt() {
        return this.delegate.getValueAsInt();
    }

    @Override
    public int getValueAsInt(int n2) {
        return this.delegate.getValueAsInt(n2);
    }

    @Override
    public long getValueAsLong() {
        return this.delegate.getValueAsLong();
    }

    @Override
    public long getValueAsLong(long l2) {
        return this.delegate.getValueAsLong(l2);
    }

    @Override
    public double getValueAsDouble() {
        return this.delegate.getValueAsDouble();
    }

    @Override
    public double getValueAsDouble(double d2) {
        return this.delegate.getValueAsDouble(d2);
    }

    @Override
    public boolean getValueAsBoolean() {
        return this.delegate.getValueAsBoolean();
    }

    @Override
    public boolean getValueAsBoolean(boolean bl2) {
        return this.delegate.getValueAsBoolean(bl2);
    }

    @Override
    public String getValueAsString() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return ((JsonParser)this).currentName();
        }
        return this.delegate.getValueAsString();
    }

    @Override
    public String getValueAsString(String string) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return ((JsonParser)this).currentName();
        }
        return this.delegate.getValueAsString(string);
    }

    @Override
    public Object getEmbeddedObject() {
        return this.delegate.getEmbeddedObject();
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) {
        return this.delegate.getBinaryValue(base64Variant);
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) {
        return this.delegate.readBinaryValue(base64Variant, outputStream);
    }

    protected JsonStreamContext _filterContext() {
        if (this._exposedContext != null) {
            return this._exposedContext;
        }
        return this._headContext;
    }
}

