/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.doubleparser.JavaBigDecimalParser;
import java.math.BigDecimal;

public final class BigDecimalParser {
    private BigDecimalParser() {
    }

    public static BigDecimal parse(String string) {
        return BigDecimalParser.parse(string.toCharArray());
    }

    public static BigDecimal parse(char[] cArray, int n2, int n3) {
        try {
            if (n3 < 500) {
                return new BigDecimal(cArray, n2, n3);
            }
            return JavaBigDecimalParser.parseBigDecimal(cArray, n2, n3);
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            RuntimeException runtimeException2 = runtimeException;
            throw BigDecimalParser.a(runtimeException, new String(cArray, n2, n3));
        }
    }

    public static BigDecimal parse(char[] cArray) {
        return BigDecimalParser.parse(cArray, 0, cArray.length);
    }

    public static BigDecimal parseWithFastParser(String string) {
        try {
            return JavaBigDecimalParser.parseBigDecimal(string);
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            RuntimeException runtimeException2 = runtimeException;
            throw BigDecimalParser.a(runtimeException, string);
        }
    }

    public static BigDecimal parseWithFastParser(char[] cArray, int n2, int n3) {
        try {
            return JavaBigDecimalParser.parseBigDecimal(cArray, n2, n3);
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            RuntimeException runtimeException2 = runtimeException;
            throw BigDecimalParser.a(runtimeException, new String(cArray, n2, n3));
        }
    }

    private static NumberFormatException a(Exception object, String string) {
        if ((object = ((Throwable)object).getMessage()) == null) {
            object = "Not a valid number representation";
        }
        string = BigDecimalParser.a(string);
        return new NumberFormatException("Value " + string + " can not be deserialized as `java.math.BigDecimal`, reason: " + (String)object);
    }

    private static String a(String string) {
        int n2 = string.length();
        if (n2 <= 1000) {
            return String.format("\"%s\"", string);
        }
        return String.format("\"%s\" (truncated to %d chars (from %d))", string.substring(0, 1000), 1000, n2);
    }
}

