/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import java.util.Arrays;

public final class CharTypes {
    protected static final char[] HC;
    protected static final char[] HClower;
    protected static final byte[] HB;
    protected static final byte[] HBlower;
    protected static final int[] sInputCodes;
    protected static final int[] sInputCodesUTF8;
    protected static final int[] sInputCodesJsNames;
    protected static final int[] sInputCodesUtf8JsNames;
    protected static final int[] sInputCodesComment;
    protected static final int[] sInputCodesWS;
    protected static final int[] sOutputEscapes128;
    protected static final int[] sOutputEscapes128WithSlash;
    protected static final int[] sHexValues;

    public static int[] getInputCodeLatin1() {
        return sInputCodes;
    }

    public static int[] getInputCodeUtf8() {
        return sInputCodesUTF8;
    }

    public static int[] getInputCodeLatin1JsNames() {
        return sInputCodesJsNames;
    }

    public static int[] getInputCodeUtf8JsNames() {
        return sInputCodesUtf8JsNames;
    }

    public static int[] getInputCodeComment() {
        return sInputCodesComment;
    }

    public static int[] getInputCodeWS() {
        return sInputCodesWS;
    }

    public static int[] get7BitOutputEscapes() {
        return sOutputEscapes128;
    }

    public static int[] get7BitOutputEscapes(int n2) {
        if (n2 == 34) {
            return sOutputEscapes128;
        }
        return a.a.a(n2);
    }

    public static int[] get7BitOutputEscapes(int n2, boolean bl2) {
        if (n2 == 34) {
            if (bl2) {
                return sOutputEscapes128WithSlash;
            }
            return sOutputEscapes128;
        }
        return a.a.a(n2, bl2);
    }

    public static int charToHex(int n2) {
        return sHexValues[n2 & 0xFF];
    }

    public static char hexToChar(int n2) {
        return HC[n2];
    }

    public static void appendQuoted(StringBuilder stringBuilder, String string) {
        int[] nArray = sOutputEscapes128;
        int n2 = sOutputEscapes128.length;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= n2 || nArray[c2] == 0) {
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append('\\');
            int n4 = nArray[c2];
            if (n4 < 0) {
                stringBuilder.append('u');
                stringBuilder.append('0');
                stringBuilder.append('0');
                stringBuilder.append(HC[c2 >> 4]);
                stringBuilder.append(HC[c2 & 0xF]);
                continue;
            }
            stringBuilder.append((char)n4);
        }
    }

    @Deprecated
    public static char[] copyHexChars() {
        return CharTypes.copyHexChars(true);
    }

    public static char[] copyHexChars(boolean bl2) {
        if (bl2) {
            return (char[])HC.clone();
        }
        return (char[])HClower.clone();
    }

    @Deprecated
    public static byte[] copyHexBytes() {
        return CharTypes.copyHexBytes(true);
    }

    public static byte[] copyHexBytes(boolean bl2) {
        if (bl2) {
            return (byte[])HB.clone();
        }
        return (byte[])HBlower.clone();
    }

    static {
        int n2;
        int n3;
        HC = "0123456789ABCDEF".toCharArray();
        HClower = "0123456789abcdef".toCharArray();
        int n4 = HC.length;
        HB = new byte[n4];
        HBlower = new byte[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            CharTypes.HB[n3] = (byte)HC[n3];
            CharTypes.HBlower[n3] = (byte)HClower[n3];
        }
        int[] nArray = new int[256];
        for (n3 = 0; n3 < 32; ++n3) {
            nArray[n3] = -1;
        }
        nArray[34] = 1;
        nArray[92] = 1;
        sInputCodes = nArray;
        nArray = new int[nArray.length];
        System.arraycopy(sInputCodes, 0, nArray, 0, nArray.length);
        for (n3 = 128; n3 < 256; ++n3) {
            int n5 = (n3 & 0xE0) == 192 ? 2 : ((n3 & 0xF0) == 224 ? 3 : ((n3 & 0xF8) == 240 ? 4 : -1));
            nArray[n3] = n5;
        }
        sInputCodesUTF8 = nArray;
        nArray = new int[256];
        Arrays.fill(nArray, -1);
        for (n3 = 33; n3 < 256; ++n3) {
            if (!Character.isJavaIdentifierPart((char)n3)) continue;
            nArray[n3] = 0;
        }
        nArray[64] = 0;
        nArray[35] = 0;
        nArray[42] = 0;
        nArray[45] = 0;
        nArray[43] = 0;
        sInputCodesJsNames = nArray;
        nArray = new int[256];
        System.arraycopy(sInputCodesJsNames, 0, nArray, 0, nArray.length);
        Arrays.fill(nArray, 128, 128, 0);
        sInputCodesUtf8JsNames = nArray;
        nArray = new int[256];
        System.arraycopy(sInputCodesUTF8, 128, nArray, 128, 128);
        Arrays.fill(nArray, 0, 32, -1);
        nArray[9] = 0;
        nArray[10] = 10;
        nArray[13] = 13;
        nArray[42] = 42;
        sInputCodesComment = nArray;
        nArray = new int[256];
        System.arraycopy(sInputCodesUTF8, 128, nArray, 128, 128);
        Arrays.fill(nArray, 0, 32, -1);
        nArray[32] = 1;
        nArray[9] = 1;
        nArray[10] = 10;
        nArray[13] = 13;
        nArray[47] = 47;
        nArray[35] = 35;
        sInputCodesWS = nArray;
        nArray = new int[128];
        for (n3 = 0; n3 < 32; ++n3) {
            nArray[n3] = -1;
        }
        nArray[34] = 34;
        nArray[92] = 92;
        nArray[8] = 98;
        nArray[9] = 116;
        nArray[12] = 102;
        nArray[10] = 110;
        nArray[13] = 114;
        sOutputEscapes128 = nArray;
        int[] nArray2 = Arrays.copyOf(nArray, sOutputEscapes128.length);
        sOutputEscapes128WithSlash = nArray2;
        nArray2[47] = 47;
        sHexValues = new int[256];
        Arrays.fill(sHexValues, -1);
        for (n2 = 0; n2 < 10; ++n2) {
            CharTypes.sHexValues[n2 + 48] = n2;
        }
        for (n2 = 0; n2 < 6; ++n2) {
            CharTypes.sHexValues[n2 + 97] = n2 + 10;
            CharTypes.sHexValues[n2 + 65] = n2 + 10;
        }
    }

    private static final class a {
        public static final a a = new a();
        private int[][] b = new int[128][];
        private int[][] c = new int[128][];

        private a() {
        }

        public final int[] a(int n2) {
            int[] nArray = this.b[n2];
            if (nArray == null) {
                nArray = Arrays.copyOf(sOutputEscapes128, 128);
                if (nArray[n2] == 0) {
                    nArray[n2] = -1;
                }
                this.b[n2] = nArray;
            }
            return nArray;
        }

        public final int[] a(int n2, boolean bl2) {
            if (!bl2) {
                return this.a(n2);
            }
            int[] nArray = this.c[n2];
            if (nArray == null) {
                int[] nArray2 = this.a(n2);
                nArray = nArray2;
                nArray2[47] = 47;
                this.c[n2] = nArray;
            }
            return nArray;
        }
    }
}

