/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.IOContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class UTF8Writer
extends Writer {
    public static final int SURROGATE_BASE = -56613888;
    private final IOContext a;
    private OutputStream b;
    private byte[] c;
    private final int d;
    private int e;
    private int f;

    public UTF8Writer(IOContext iOContext, OutputStream outputStream) {
        this.a = iOContext;
        this.b = outputStream;
        this.c = iOContext.allocWriteEncodingBuffer();
        this.d = this.c.length - 4;
        this.e = 0;
    }

    @Override
    public final Writer append(char c2) {
        this.write(c2);
        return this;
    }

    @Override
    public final void close() {
        if (this.b != null) {
            if (this.e > 0) {
                this.b.write(this.c, 0, this.e);
                this.e = 0;
            }
            OutputStream outputStream = this.b;
            this.b = null;
            byte[] byArray = this.c;
            if (this.c != null) {
                this.c = null;
                this.a.releaseWriteEncodingBuffer(byArray);
            }
            outputStream.close();
            int n2 = this.f;
            this.f = 0;
            if (n2 > 0) {
                UTF8Writer.illegalSurrogate(n2);
            }
        }
        this.a.close();
    }

    @Override
    public final void flush() {
        if (this.b != null) {
            if (this.e > 0) {
                this.b.write(this.c, 0, this.e);
                this.e = 0;
            }
            this.b.flush();
        }
    }

    @Override
    public final void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void write(char[] var1_1, int var2_2, int var3_3) {
        if (var3_3 < 2) {
            if (var3_3 == 1) {
                this.write(var1_1[var2_2]);
            }
            return;
        }
        if (this.f > 0) {
            var4_4 = var1_1[var2_2++];
            --var3_3;
            v0 = this;
            v0.write(v0.convertSurrogate(var4_4));
        }
        var4_4 = this.e;
        var5_5 = this.c;
        var6_6 = this.d;
        var3_3 += var2_2;
        block0: while (var2_2 < var3_3) {
            if (var4_4 >= var6_6) {
                this.b.write(var5_5, 0, var4_4);
                var4_4 = 0;
            }
            if ((var7_7 = var1_1[var2_2++]) >= 128) ** GOTO lbl29
            var5_5[var4_4++] = (byte)var7_7;
            var8_8 = var3_3 - var2_2;
            var7_7 = var6_6 - var4_4;
            if (var8_8 > var7_7) {
                var8_8 = var7_7;
            }
            var8_8 += var2_2;
            while (var2_2 < var8_8) {
                if ((var7_7 = var1_1[var2_2++]) < 128) {
                    var5_5[var4_4++] = (byte)var7_7;
                    continue;
                }
lbl29:
                // 3 sources

                if (var7_7 < 2048) {
                    var5_5[var4_4++] = (byte)(192 | var7_7 >> 6);
                    var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                    continue block0;
                }
                if (var7_7 < 55296 || var7_7 > 57343) {
                    var5_5[var4_4++] = (byte)(224 | var7_7 >> 12);
                    var5_5[var4_4++] = (byte)(128 | var7_7 >> 6 & 63);
                    var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                    continue block0;
                }
                if (var7_7 > 56319) {
                    this.e = var4_4;
                    UTF8Writer.illegalSurrogate(var7_7);
                }
                this.f = var7_7;
                if (var2_2 >= var3_3) break block0;
                if ((var7_7 = this.convertSurrogate(var1_1[var2_2++])) > 0x10FFFF) {
                    this.e = var4_4;
                    UTF8Writer.illegalSurrogate(var7_7);
                }
                var5_5[var4_4++] = (byte)(240 | var7_7 >> 18);
                var5_5[var4_4++] = (byte)(128 | var7_7 >> 12 & 63);
                var5_5[var4_4++] = (byte)(128 | var7_7 >> 6 & 63);
                var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                continue block0;
            }
        }
        this.e = var4_4;
    }

    @Override
    public final void write(int n2) {
        if (this.f > 0) {
            n2 = this.convertSurrogate(n2);
        } else if (n2 >= 55296 && n2 <= 57343) {
            if (n2 > 56319) {
                UTF8Writer.illegalSurrogate(n2);
            }
            this.f = n2;
            return;
        }
        if (this.e >= this.d) {
            this.b.write(this.c, 0, this.e);
            this.e = 0;
        }
        if (n2 < 128) {
            this.c[this.e++] = (byte)n2;
            return;
        }
        int n3 = this.e;
        if (n2 < 2048) {
            this.c[n3++] = (byte)(0xC0 | n2 >> 6);
            this.c[n3++] = (byte)(0x80 | n2 & 0x3F);
        } else if (n2 <= 65535) {
            this.c[n3++] = (byte)(0xE0 | n2 >> 12);
            this.c[n3++] = (byte)(0x80 | n2 >> 6 & 0x3F);
            this.c[n3++] = (byte)(0x80 | n2 & 0x3F);
        } else {
            if (n2 > 0x10FFFF) {
                UTF8Writer.illegalSurrogate(n2);
            }
            this.c[n3++] = (byte)(0xF0 | n2 >> 18);
            this.c[n3++] = (byte)(0x80 | n2 >> 12 & 0x3F);
            this.c[n3++] = (byte)(0x80 | n2 >> 6 & 0x3F);
            this.c[n3++] = (byte)(0x80 | n2 & 0x3F);
        }
        this.e = n3;
    }

    @Override
    public final void write(String string) {
        this.write(string, 0, string.length());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void write(String var1_1, int var2_2, int var3_3) {
        if (var3_3 < 2) {
            if (var3_3 == 1) {
                this.write(var1_1.charAt(var2_2));
            }
            return;
        }
        if (this.f > 0) {
            var4_4 = var1_1.charAt(var2_2++);
            --var3_3;
            v0 = this;
            v0.write(v0.convertSurrogate(var4_4));
        }
        var4_4 = this.e;
        var5_5 = this.c;
        var6_6 = this.d;
        var3_3 += var2_2;
        block0: while (var2_2 < var3_3) {
            if (var4_4 >= var6_6) {
                this.b.write(var5_5, 0, var4_4);
                var4_4 = 0;
            }
            if ((var7_7 = var1_1.charAt(var2_2++)) >= 128) ** GOTO lbl31
            var5_5[var4_4++] = (byte)var7_7;
            var8_8 = var3_3 - var2_2;
            var7_7 = var6_6 - var4_4;
            if (var8_8 > var7_7) {
                var8_8 = var7_7;
            }
            var8_8 += var2_2;
            while (var2_2 < var8_8) {
                v1 = var1_1.charAt(var2_2++);
                var7_7 = v1;
                if (v1 < '\u0080') {
                    var5_5[var4_4++] = (byte)var7_7;
                    continue;
                }
lbl31:
                // 3 sources

                if (var7_7 < 2048) {
                    var5_5[var4_4++] = (byte)(192 | var7_7 >> 6);
                    var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                    continue block0;
                }
                if (var7_7 < 55296 || var7_7 > 57343) {
                    var5_5[var4_4++] = (byte)(224 | var7_7 >> 12);
                    var5_5[var4_4++] = (byte)(128 | var7_7 >> 6 & 63);
                    var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                    continue block0;
                }
                if (var7_7 > 56319) {
                    this.e = var4_4;
                    UTF8Writer.illegalSurrogate(var7_7);
                }
                this.f = var7_7;
                if (var2_2 >= var3_3) break block0;
                if ((var7_7 = this.convertSurrogate(var1_1.charAt(var2_2++))) > 0x10FFFF) {
                    this.e = var4_4;
                    UTF8Writer.illegalSurrogate(var7_7);
                }
                var5_5[var4_4++] = (byte)(240 | var7_7 >> 18);
                var5_5[var4_4++] = (byte)(128 | var7_7 >> 12 & 63);
                var5_5[var4_4++] = (byte)(128 | var7_7 >> 6 & 63);
                var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                continue block0;
            }
        }
        this.e = var4_4;
    }

    protected final int convertSurrogate(int n2) {
        int n3 = this.f;
        this.f = 0;
        if (n2 < 56320 || n2 > 57343) {
            throw new IOException("Broken surrogate pair: first char 0x" + Integer.toHexString(n3) + ", second 0x" + Integer.toHexString(n2) + "; illegal combination");
        }
        return (n3 << 10) + n2 + -56613888;
    }

    protected static void illegalSurrogate(int n2) {
        throw new IOException(UTF8Writer.illegalSurrogateDesc(n2));
    }

    protected static String illegalSurrogateDesc(int n2) {
        if (n2 > 0x10FFFF) {
            return "Illegal character point (0x" + Integer.toHexString(n2) + ") to output; max is 0x10FFFF as per RFC 4627";
        }
        if (n2 >= 55296) {
            if (n2 <= 56319) {
                return "Unmatched first part of surrogate pair (0x" + Integer.toHexString(n2) + ")";
            }
            return "Unmatched second part of surrogate pair (0x" + Integer.toHexString(n2) + ")";
        }
        return "Illegal character point (0x" + Integer.toHexString(n2) + ") to output";
    }
}

