/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.io.ContentReference;
import com.fasterxml.jackson.core.json.DupDetector;

public final class JsonReadContext
extends JsonStreamContext {
    protected final JsonReadContext _parent;
    protected DupDetector _dups;
    protected JsonReadContext _child;
    protected String _currentName;
    protected Object _currentValue;
    protected int _lineNr;
    protected int _columnNr;

    public JsonReadContext(JsonReadContext jsonReadContext, int n2, DupDetector dupDetector, int n3, int n4, int n5) {
        this._parent = jsonReadContext;
        this._dups = dupDetector;
        this._type = n3;
        this._lineNr = n4;
        this._columnNr = n5;
        this._index = -1;
        this._nestingDepth = n2;
    }

    @Deprecated
    public JsonReadContext(JsonReadContext jsonReadContext, DupDetector dupDetector, int n2, int n3, int n4) {
        this._parent = jsonReadContext;
        this._dups = dupDetector;
        this._type = n2;
        this._lineNr = n3;
        this._columnNr = n4;
        this._index = -1;
        this._nestingDepth = jsonReadContext == null ? 0 : jsonReadContext._nestingDepth + 1;
    }

    public final void reset(int n2, int n3, int n4) {
        this._type = n2;
        this._index = -1;
        this._lineNr = n3;
        this._columnNr = n4;
        this._currentName = null;
        this._currentValue = null;
        if (this._dups != null) {
            this._dups.reset();
        }
    }

    public final JsonReadContext withDupDetector(DupDetector dupDetector) {
        this._dups = dupDetector;
        return this;
    }

    @Override
    public final Object getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public final void setCurrentValue(Object object) {
        this._currentValue = object;
    }

    public static JsonReadContext createRootContext(int n2, int n3, DupDetector dupDetector) {
        return new JsonReadContext(null, 0, dupDetector, 0, n2, n3);
    }

    public static JsonReadContext createRootContext(DupDetector dupDetector) {
        return new JsonReadContext(null, 0, dupDetector, 0, 1, 0);
    }

    public final JsonReadContext createChildArrayContext(int n2, int n3) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            JsonReadContext jsonReadContext2 = this;
            this._child = jsonReadContext = new JsonReadContext(jsonReadContext2, jsonReadContext2._nestingDepth + 1, this._dups == null ? null : this._dups.child(), 1, n2, n3);
        } else {
            jsonReadContext.reset(1, n2, n3);
        }
        return jsonReadContext;
    }

    public final JsonReadContext createChildObjectContext(int n2, int n3) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            JsonReadContext jsonReadContext2 = this;
            this._child = jsonReadContext = new JsonReadContext(jsonReadContext2, jsonReadContext2._nestingDepth + 1, this._dups == null ? null : this._dups.child(), 2, n2, n3);
            return jsonReadContext;
        }
        jsonReadContext.reset(2, n2, n3);
        return jsonReadContext;
    }

    @Override
    public final String getCurrentName() {
        return this._currentName;
    }

    @Override
    public final boolean hasCurrentName() {
        return this._currentName != null;
    }

    @Override
    public final JsonReadContext getParent() {
        return this._parent;
    }

    @Override
    public final JsonLocation startLocation(ContentReference contentReference) {
        return new JsonLocation(contentReference, -1L, this._lineNr, this._columnNr);
    }

    @Override
    @Deprecated
    public final JsonLocation getStartLocation(Object object) {
        return ((JsonStreamContext)this).startLocation(ContentReference.rawReference(object));
    }

    public final JsonReadContext clearAndGetParent() {
        this._currentValue = null;
        return this._parent;
    }

    public final DupDetector getDupDetector() {
        return this._dups;
    }

    public final boolean expectComma() {
        int n2 = ++this._index;
        return this._type != 0 && n2 > 0;
    }

    public final void setCurrentName(String object) {
        String string;
        this._currentName = object;
        if (this._dups != null && ((DupDetector)(object = this._dups)).isDup(string = object)) {
            throw new JsonParseException((object = ((DupDetector)object).getSource()) instanceof JsonParser ? (JsonParser)object : null, "Duplicate field '" + string + "'");
        }
    }
}

