/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonParserBase;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.TextBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class ReaderBasedJsonParser
extends JsonParserBase {
    protected Reader _reader;
    protected char[] _inputBuffer;
    protected boolean _bufferRecyclable;
    protected ObjectCodec _objectCodec;
    protected final CharsToNameCanonicalizer _symbols;
    protected final int _hashSeed;
    protected boolean _tokenIncomplete;
    protected long _nameStartOffset;
    protected int _nameStartRow;
    protected int _nameStartCol;

    public ReaderBasedJsonParser(IOContext iOContext, int n2, Reader reader, ObjectCodec objectCodec, CharsToNameCanonicalizer charsToNameCanonicalizer, char[] cArray, int n3, int n4, boolean bl2) {
        super(iOContext, n2, objectCodec);
        this._reader = reader;
        this._inputBuffer = cArray;
        this._inputPtr = n3;
        this._inputEnd = n4;
        this._currInputRowStart = n3;
        this._currInputProcessed = -n3;
        this._symbols = charsToNameCanonicalizer;
        this._hashSeed = charsToNameCanonicalizer.hashSeed();
        this._bufferRecyclable = bl2;
    }

    public ReaderBasedJsonParser(IOContext iOContext, int n2, Reader reader, ObjectCodec objectCodec, CharsToNameCanonicalizer charsToNameCanonicalizer) {
        super(iOContext, n2, objectCodec);
        this._reader = reader;
        this._inputBuffer = iOContext.allocTokenBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._symbols = charsToNameCanonicalizer;
        this._hashSeed = charsToNameCanonicalizer.hashSeed();
        this._bufferRecyclable = true;
    }

    @Override
    public int releaseBuffered(Writer writer) {
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 <= 0) {
            return 0;
        }
        int n3 = this._inputPtr;
        this._inputPtr += n2;
        writer.write(this._inputBuffer, n3, n2);
        return n2;
    }

    @Override
    public Object getInputSource() {
        return this._reader;
    }

    @Deprecated
    protected char getNextChar(String string) {
        return this.getNextChar(string, null);
    }

    protected char getNextChar(String string, JsonToken jsonToken) {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(string, jsonToken);
        }
        return this._inputBuffer[this._inputPtr++];
    }

    @Override
    protected void _closeInput() {
        if (this._reader != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._reader.close();
            }
            this._reader = null;
        }
    }

    @Override
    protected void _releaseBuffers() {
        super._releaseBuffers();
        this._symbols.release();
        if (this._bufferRecyclable) {
            char[] cArray = this._inputBuffer;
            if (this._inputBuffer != null) {
                this._inputBuffer = null;
                this._ioContext.releaseTokenBuffer(cArray);
            }
        }
    }

    protected void _loadMoreGuaranteed() {
        if (!this._loadMore()) {
            this._reportInvalidEOF();
        }
    }

    protected boolean _loadMore() {
        if (this._reader != null) {
            int n2 = this._inputEnd;
            this._currInputProcessed += (long)n2;
            this._currInputRowStart -= n2;
            this._streamReadConstraints.validateDocumentLength(this._currInputProcessed);
            int n3 = this._reader.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n3 > 0) {
                this._nameStartOffset -= (long)n2;
                this._inputPtr = 0;
                this._inputEnd = n3;
                return true;
            }
            ReaderBasedJsonParser readerBasedJsonParser = this;
            readerBasedJsonParser._inputEnd = 0;
            readerBasedJsonParser._inputPtr = 0;
            this._closeInput();
            if (n3 == 0) {
                throw new IOException("Reader returned 0 characters when trying to read " + this._inputEnd);
            }
        }
        return false;
    }

    @Override
    public final String getText() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        ReaderBasedJsonParser readerBasedJsonParser = this;
        return readerBasedJsonParser._getText2(readerBasedJsonParser._currToken);
    }

    @Override
    public int getText(Writer writer) {
        Object object = this._currToken;
        if (object == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsToWriter(writer);
        }
        if (object == JsonToken.FIELD_NAME) {
            object = ((JsonStreamContext)this._parsingContext).getCurrentName();
            writer.write((String)object);
            return ((String)object).length();
        }
        if (object != null) {
            if (object.isNumeric()) {
                return this._textBuffer.contentsToWriter(writer);
            }
            object = object.asCharArray();
            writer.write((char[])object);
            return ((JsonToken)object).length;
        }
        return 0;
    }

    @Override
    public final String getValueAsString() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.currentName();
        }
        return super.getValueAsString(null);
    }

    @Override
    public final String getValueAsString(String string) {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.currentName();
        }
        return super.getValueAsString(string);
    }

    protected final String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken.id()) {
            case 5: {
                return ((JsonStreamContext)this._parsingContext).getCurrentName();
            }
            case 6: 
            case 7: 
            case 8: {
                return this._textBuffer.contentsAsString();
            }
        }
        return jsonToken.asString();
    }

    @Override
    public final char[] getTextCharacters() {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    if (!this._nameCopied) {
                        String string = ((JsonStreamContext)this._parsingContext).getCurrentName();
                        int n2 = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n2);
                        } else if (this._nameCopyBuffer.length < n2) {
                            this._nameCopyBuffer = new char[n2];
                        }
                        string.getChars(0, n2, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextBuffer();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public final int getTextLength() {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return ((JsonStreamContext)this._parsingContext).getCurrentName().length();
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.size();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public final int getTextOffset() {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return 0;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT && this._binaryValue != null) {
            return this._binaryValue;
        }
        if (this._currToken != JsonToken.VALUE_STRING) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
            this._tokenIncomplete = false;
        } else if (this._binaryValue == null) {
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            ReaderBasedJsonParser readerBasedJsonParser = this;
            readerBasedJsonParser._decodeBase64(((JsonParser)readerBasedJsonParser).getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) {
        if (!this._tokenIncomplete || this._currToken != JsonToken.VALUE_STRING) {
            byte[] byArray = ((JsonParser)this).getBinaryValue(base64Variant);
            outputStream.write(byArray);
            return byArray.length;
        }
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            int n2 = this._readBinary(base64Variant, outputStream, byArray);
            return n2;
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
    }

    protected int _readBinary(Base64Variant base64Variant, OutputStream outputStream, byte[] byArray) {
        int n2 = 0;
        int n3 = byArray.length - 3;
        int n4 = 0;
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) <= ' ') continue;
            int n5 = base64Variant.decodeBase64Char(c2);
            if (n5 < 0) {
                if (c2 == '\"') break;
                n5 = this._decodeBase64Escape(base64Variant, c2, 0);
                if (n5 < 0) continue;
            }
            if (n2 > n3) {
                n4 += n2;
                outputStream.write(byArray, 0, n2);
                n2 = 0;
            }
            int n6 = n5;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n5 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                n5 = this._decodeBase64Escape(base64Variant, c2, 1);
            }
            n6 = n6 << 6 | n5;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n5 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n5 != -2) {
                    if (c2 == '\"') {
                        byArray[n2++] = (byte)(n6 >>= 4);
                        if (!base64Variant.requiresPaddingOnRead()) break;
                        --this._inputPtr;
                        this._handleBase64MissingPadding(base64Variant);
                        break;
                    }
                    n5 = this._decodeBase64Escape(base64Variant, c2, 2);
                }
                if (n5 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(c2 = this._inputBuffer[this._inputPtr++]) && this._decodeBase64Escape(base64Variant, c2, 3) != -2) {
                        throw this.reportInvalidBase64Char(base64Variant, c2, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byArray[n2++] = (byte)(n6 >>= 4);
                    continue;
                }
            }
            n6 = n6 << 6 | n5;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n5 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n5 != -2) {
                    if (c2 == '\"') {
                        byArray[n2++] = (byte)((n6 >>= 2) >> 8);
                        byArray[n2++] = (byte)n6;
                        if (!base64Variant.requiresPaddingOnRead()) break;
                        --this._inputPtr;
                        this._handleBase64MissingPadding(base64Variant);
                        break;
                    }
                    n5 = this._decodeBase64Escape(base64Variant, c2, 3);
                }
                if (n5 == -2) {
                    byArray[n2++] = (byte)((n6 >>= 2) >> 8);
                    byArray[n2++] = (byte)n6;
                    continue;
                }
            }
            n6 = n6 << 6 | n5;
            byArray[n2++] = (byte)(n6 >> 16);
            byArray[n2++] = (byte)(n6 >> 8);
            byArray[n2++] = (byte)n6;
        }
        this._tokenIncomplete = false;
        if (n2 > 0) {
            n4 += n2;
            outputStream.write(byArray, 0, n2);
        }
        return n4;
    }

    @Override
    public final JsonToken nextToken() {
        JsonToken jsonToken;
        boolean bl2;
        int n2;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.a();
        }
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n2 = this.f()) < 0) {
            ((JsonParser)this).close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        if ((n2 | 0x20) == 125) {
            this.d(n2);
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            n2 = this.c(n2);
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n2 | 0x20) == 125) {
                this.d(n2);
                return this._currToken;
            }
        }
        if (bl2 = this._parsingContext.inObject()) {
            this.p();
            String string = n2 == 34 ? this._parseName() : this._handleOddName(n2);
            this._parsingContext.setCurrentName(string);
            this._currToken = JsonToken.FIELD_NAME;
            n2 = this.d();
        }
        this.o();
        switch (n2) {
            case 34: {
                this._tokenIncomplete = true;
                jsonToken = JsonToken.VALUE_STRING;
                break;
            }
            case 91: {
                if (!bl2) {
                    ReaderBasedJsonParser readerBasedJsonParser = this;
                    readerBasedJsonParser.createChildArrayContext(readerBasedJsonParser._tokenInputRow, this._tokenInputCol);
                }
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                if (!bl2) {
                    ReaderBasedJsonParser readerBasedJsonParser = this;
                    readerBasedJsonParser.createChildObjectContext(readerBasedJsonParser._tokenInputRow, this._tokenInputCol);
                }
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            case 125: {
                this._reportUnexpectedChar(n2, "expected a value");
            }
            case 116: {
                this.l();
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this.m();
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this.n();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 45: {
                jsonToken = this.a(true);
                break;
            }
            case 43: {
                if (this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                    jsonToken = this.a(false);
                    break;
                }
                jsonToken = this._handleOddValue(n2);
                break;
            }
            case 46: {
                jsonToken = this._parseFloatThatStartsWithPeriod(false);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parseUnsignedNumber(n2);
                break;
            }
            default: {
                jsonToken = this._handleOddValue(n2);
            }
        }
        if (bl2) {
            this._nextToken = jsonToken;
            return this._currToken;
        }
        this._currToken = jsonToken;
        return jsonToken;
    }

    private final JsonToken a() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            ReaderBasedJsonParser readerBasedJsonParser = this;
            readerBasedJsonParser.createChildArrayContext(readerBasedJsonParser._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            ReaderBasedJsonParser readerBasedJsonParser = this;
            readerBasedJsonParser.createChildObjectContext(readerBasedJsonParser._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    @Override
    public void finishToken() {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            this._finishString();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean nextFieldName(SerializableString var1_1) {
        block26: {
            this._numTypesValid = 0;
            if (this._currToken == JsonToken.FIELD_NAME) {
                this.a();
                return false;
            }
            if (this._tokenIncomplete) {
                this._skipString();
            }
            if ((var2_2 = this.f()) < 0) {
                this.close();
                this._currToken = null;
                return false;
            }
            this._binaryValue = null;
            if ((var2_2 | 32) == 125) {
                this.d(var2_2);
                return false;
            }
            if (this._parsingContext.expectComma()) {
                var2_2 = this.c(var2_2);
                if ((this._features & ReaderBasedJsonParser.FEAT_MASK_TRAILING_COMMA) != 0 && (var2_2 | 32) == 125) {
                    this.d(var2_2);
                    return false;
                }
            }
            if (!this._parsingContext.inObject()) {
                this.o();
                this.a(var2_2);
                return false;
            }
            this.p();
            if (var2_2 != 34 || this._inputPtr + (var4_5 = (var3_3 = var1_1.asQuotedChars()).length) + 4 >= this._inputEnd || this._inputBuffer[var4_5 = this._inputPtr + var4_5] != '\"') break block26;
            var5_6 = 0;
            var6_7 = this._inputPtr;
            while (true) {
                block27: {
                    block30: {
                        block31: {
                            block28: {
                                block29: {
                                    if (var6_7 != var4_5) break block27;
                                    this._parsingContext.setCurrentName(var1_1.getValue());
                                    v0 = this;
                                    var2_2 = var6_7 + 1;
                                    var1_1 = v0;
                                    var3_4 = v0._inputBuffer[var2_2++];
                                    if (var3_4 != 58) break block28;
                                    if ((var3_4 = var1_1._inputBuffer[var2_2++]) <= 32) break block29;
                                    if (var3_4 == 47 || var3_4 == 35) ** GOTO lbl-1000
                                    var1_1._inputPtr = var2_2;
                                    v1 = var3_4;
                                    break block30;
                                }
                                if ((var3_4 == 32 || var3_4 == 9) && (var3_4 = var1_1._inputBuffer[var2_2++]) > 32 && var3_4 != 47 && var3_4 != 35) {
                                    var1_1._inputPtr = var2_2;
                                    v1 = var3_4;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    var1_1._inputPtr = var2_2 - 1;
                                    v1 = super.b(true);
                                }
                                break block30;
                            }
                            if (var3_4 == 32 || var3_4 == 9) {
                                var3_4 = var1_1._inputBuffer[var2_2++];
                            }
                            if ((var4_5 = var3_4 == 58 ? 1 : 0) == 0) ** GOTO lbl-1000
                            if ((var3_4 = var1_1._inputBuffer[var2_2++]) <= 32) break block31;
                            if (var3_4 == 47 || var3_4 == 35) ** GOTO lbl-1000
                            var1_1._inputPtr = var2_2;
                            v1 = var3_4;
                            break block30;
                        }
                        if ((var3_4 == 32 || var3_4 == 9) && (var3_4 = var1_1._inputBuffer[var2_2++]) > 32 && var3_4 != 47 && var3_4 != 35) {
                            var1_1._inputPtr = var2_2;
                            v1 = var3_4;
                        } else lbl-1000:
                        // 3 sources

                        {
                            var1_1._inputPtr = var2_2 - 1;
                            v1 = super.b((boolean)var4_5);
                        }
                    }
                    var2_2 = v1;
                    var1_1 = v0;
                    v0._currToken = JsonToken.FIELD_NAME;
                    super.o();
                    switch (var2_2) {
                        case 34: {
                            var1_1._tokenIncomplete = true;
                            var1_1._nextToken = JsonToken.VALUE_STRING;
                            break;
                        }
                        case 91: {
                            var1_1._nextToken = JsonToken.START_ARRAY;
                            break;
                        }
                        case 123: {
                            var1_1._nextToken = JsonToken.START_OBJECT;
                            break;
                        }
                        case 116: {
                            var1_1._matchToken("true", 1);
                            var1_1._nextToken = JsonToken.VALUE_TRUE;
                            break;
                        }
                        case 102: {
                            var1_1._matchToken("false", 1);
                            var1_1._nextToken = JsonToken.VALUE_FALSE;
                            break;
                        }
                        case 110: {
                            var1_1._matchToken("null", 1);
                            var1_1._nextToken = JsonToken.VALUE_NULL;
                            break;
                        }
                        case 45: {
                            var1_1._nextToken = super.a(true);
                            break;
                        }
                        case 43: {
                            if (var1_1.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                                var1_1._nextToken = super.a(false);
                                break;
                            }
                            var1_1._nextToken = var1_1._handleOddValue(var2_2);
                            break;
                        }
                        case 46: {
                            var1_1._nextToken = var1_1._parseFloatThatStartsWithPeriod(false);
                            break;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            var1_1._nextToken = var1_1._parseUnsignedNumber(var2_2);
                            break;
                        }
                        default: {
                            var1_1._nextToken = var1_1._handleOddValue(var2_2);
                        }
                    }
                    return true;
                }
                if (var3_3[var5_6] != this._inputBuffer[var6_7]) break;
                ++var5_6;
                ++var6_7;
            }
        }
        return this._isNextTokenNameMaybe(var2_2, var1_1.getValue());
    }

    @Override
    public String nextFieldName() {
        JsonToken jsonToken;
        int n2;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this.a();
            return null;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n2 = this.f()) < 0) {
            ((JsonParser)this).close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        if ((n2 | 0x20) == 125) {
            this.d(n2);
            return null;
        }
        if (this._parsingContext.expectComma()) {
            n2 = this.c(n2);
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n2 | 0x20) == 125) {
                this.d(n2);
                return null;
            }
        }
        if (!this._parsingContext.inObject()) {
            this.o();
            this.a(n2);
            return null;
        }
        this.p();
        String string = n2 == 34 ? this._parseName() : this._handleOddName(n2);
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        n2 = this.d();
        this.o();
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return string;
        }
        switch (n2) {
            case 45: {
                jsonToken = this.a(true);
                break;
            }
            case 43: {
                if (this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                    jsonToken = this.a(false);
                    break;
                }
                jsonToken = this._handleOddValue(n2);
                break;
            }
            case 46: {
                jsonToken = this._parseFloatThatStartsWithPeriod(false);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parseUnsignedNumber(n2);
                break;
            }
            case 102: {
                this.m();
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this.n();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this.l();
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleOddValue(n2);
            }
        }
        this._nextToken = jsonToken;
        return string;
    }

    protected boolean _isNextTokenNameMaybe(int n2, String string) {
        JsonToken jsonToken;
        String string2 = n2 == 34 ? this._parseName() : this._handleOddName(n2);
        this._parsingContext.setCurrentName(string2);
        this._currToken = JsonToken.FIELD_NAME;
        n2 = this.d();
        this.o();
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return string.equals(string2);
        }
        switch (n2) {
            case 45: {
                jsonToken = this.a(true);
                break;
            }
            case 43: {
                if (this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                    jsonToken = this.a(false);
                    break;
                }
                jsonToken = this._handleOddValue(n2);
                break;
            }
            case 46: {
                jsonToken = this._parseFloatThatStartsWithPeriod(false);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parseUnsignedNumber(n2);
                break;
            }
            case 102: {
                this.m();
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this.n();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this.l();
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleOddValue(n2);
            }
        }
        this._nextToken = jsonToken;
        return string.equals(string2);
    }

    private final JsonToken a(int n2) {
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._currToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n2) {
            case 91: {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                readerBasedJsonParser.createChildArrayContext(readerBasedJsonParser._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            case 123: {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                readerBasedJsonParser.createChildObjectContext(readerBasedJsonParser._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            case 116: {
                this._matchToken("true", 1);
                this._currToken = JsonToken.VALUE_TRUE;
                return this._currToken;
            }
            case 102: {
                this._matchToken("false", 1);
                this._currToken = JsonToken.VALUE_FALSE;
                return this._currToken;
            }
            case 110: {
                this._matchToken("null", 1);
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
            case 45: {
                this._currToken = this.a(true);
                return this._currToken;
            }
            case 46: {
                this._currToken = this._parseFloatThatStartsWithPeriod(false);
                return this._currToken;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._currToken = this._parseUnsignedNumber(n2);
                return this._currToken;
            }
            case 44: {
                if (this._parsingContext.inRoot() || (this._features & FEAT_MASK_ALLOW_MISSING) == 0) break;
                --this._inputPtr;
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
        }
        this._currToken = this._handleOddValue(n2);
        return this._currToken;
    }

    @Override
    public final String nextTextValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    this._tokenIncomplete = false;
                    this._finishString();
                }
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                readerBasedJsonParser.createChildArrayContext(readerBasedJsonParser._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                readerBasedJsonParser.createChildObjectContext(readerBasedJsonParser._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        if (((JsonParser)this).nextToken() == JsonToken.VALUE_STRING) {
            return ((JsonParser)this).getText();
        }
        return null;
    }

    @Override
    public final int nextIntValue(int n2) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return ((JsonParser)this).getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                readerBasedJsonParser.createChildArrayContext(readerBasedJsonParser._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                readerBasedJsonParser.createChildObjectContext(readerBasedJsonParser._tokenInputRow, this._tokenInputCol);
            }
            return n2;
        }
        if (((JsonParser)this).nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return ((JsonParser)this).getIntValue();
        }
        return n2;
    }

    @Override
    public final long nextLongValue(long l2) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return ((JsonParser)this).getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                readerBasedJsonParser.createChildArrayContext(readerBasedJsonParser._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                readerBasedJsonParser.createChildObjectContext(readerBasedJsonParser._tokenInputRow, this._tokenInputCol);
            }
            return l2;
        }
        if (((JsonParser)this).nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return ((JsonParser)this).getLongValue();
        }
        return l2;
    }

    @Override
    public final Boolean nextBooleanValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                readerBasedJsonParser.createChildArrayContext(readerBasedJsonParser._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                readerBasedJsonParser.createChildObjectContext(readerBasedJsonParser._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        JsonToken jsonToken = ((JsonParser)this).nextToken();
        if (jsonToken != null) {
            int n2 = jsonToken.id();
            if (n2 == 9) {
                return Boolean.TRUE;
            }
            if (n2 == 10) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Deprecated
    protected final JsonToken _parseFloatThatStartsWithPeriod() {
        return this._parseFloatThatStartsWithPeriod(false);
    }

    protected final JsonToken _parseFloatThatStartsWithPeriod(boolean bl2) {
        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
            return this._handleOddValue(46);
        }
        int n2 = this._inputPtr - 1;
        if (bl2) {
            --n2;
        }
        return this.a(46, n2, this._inputPtr, bl2, 0);
    }

    protected final JsonToken _parseUnsignedNumber(int n2) {
        int n3 = this._inputPtr;
        int n4 = n3 - 1;
        int n5 = this._inputEnd;
        if (n2 == 48) {
            return this.a(false, n4);
        }
        int n6 = 1;
        while (true) {
            if (n3 >= n5) {
                this._inputPtr = n4;
                return this.a(false, n4);
            }
            if ((n2 = this._inputBuffer[n3++]) < 48 || n2 > 57) break;
            ++n6;
        }
        if (n2 == 46 || (n2 | 0x20) == 101) {
            this._inputPtr = n3;
            return this.a(n2, n4, n3, false, n6);
        }
        this._inputPtr = --n3;
        if (this._parsingContext.inRoot()) {
            this.b(n2);
        }
        n2 = n3 - n4;
        this._textBuffer.resetWithShared(this._inputBuffer, n4, n2);
        return this.resetInt(false, n6);
    }

    private final JsonToken a(int n2, int n3, int n4, boolean bl2, int n5) {
        int n6 = this._inputEnd;
        int n7 = 0;
        if (n2 == 46) {
            while (true) {
                if (n4 >= n6) {
                    return this.a(bl2, n3);
                }
                if ((n2 = this._inputBuffer[n4++]) < 48 || n2 > 57) break;
                ++n7;
            }
            if (n7 == 0 && !this.isEnabled(JsonReadFeature.ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
                this._reportUnexpectedNumberChar(n2, "Decimal point not followed by a digit");
            }
        }
        int n8 = 0;
        if ((n2 | 0x20) == 101) {
            if (n4 >= n6) {
                this._inputPtr = n3;
                return this.a(bl2, n3);
            }
            if ((n2 = this._inputBuffer[n4++]) == 45 || n2 == 43) {
                if (n4 >= n6) {
                    this._inputPtr = n3;
                    return this.a(bl2, n3);
                }
                n2 = this._inputBuffer[n4++];
            }
            while (n2 <= 57 && n2 >= 48) {
                ++n8;
                if (n4 >= n6) {
                    this._inputPtr = n3;
                    return this.a(bl2, n3);
                }
                n2 = this._inputBuffer[n4++];
            }
            if (n8 == 0) {
                this._reportUnexpectedNumberChar(n2, "Exponent indicator not followed by a digit");
            }
        }
        this._inputPtr = --n4;
        if (this._parsingContext.inRoot()) {
            this.b(n2);
        }
        n2 = n4 - n3;
        this._textBuffer.resetWithShared(this._inputBuffer, n3, n2);
        return this.resetFloat(bl2, n5, n7, n8);
    }

    private final JsonToken a(boolean bl2) {
        char c2;
        int n2 = this._inputPtr;
        int n3 = bl2 ? n2 - 1 : n2;
        int n4 = this._inputEnd;
        if (n2 >= n4) {
            return this.a(bl2, n3);
        }
        if ((c2 = this._inputBuffer[n2++]) > '9' || c2 < '0') {
            this._inputPtr = n2;
            if (c2 == '.') {
                return this._parseFloatThatStartsWithPeriod(bl2);
            }
            return this._handleInvalidNumberStart(c2, bl2, true);
        }
        if (c2 == '0') {
            return this.a(bl2, n3);
        }
        int n5 = 1;
        while (true) {
            if (n2 >= n4) {
                return this.a(bl2, n3);
            }
            if ((c2 = this._inputBuffer[n2++]) < '0' || c2 > '9') break;
            ++n5;
        }
        if (c2 == '.' || (c2 | 0x20) == 101) {
            this._inputPtr = n2;
            return this.a(c2, n3, n2, bl2, n5);
        }
        this._inputPtr = --n2;
        if (this._parsingContext.inRoot()) {
            this.b(c2);
        }
        this._textBuffer.resetWithShared(this._inputBuffer, n3, n2 -= n3);
        return this.resetInt(bl2, n5);
    }

    private final JsonToken a(boolean bl2, int n2) {
        this._inputPtr = bl2 ? n2 + 1 : n2;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n3 = 0;
        if (bl2) {
            ++n3;
            cArray[0] = 45;
        }
        int n4 = 0;
        char c2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("No digit following sign", JsonToken.VALUE_NUMBER_INT);
        if (c2 == '0') {
            c2 = this.b();
        }
        boolean bl3 = false;
        while (c2 >= '0' && c2 <= '9') {
            ++n4;
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            cArray[n3++] = c2;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                c2 = '\u0000';
                bl3 = true;
                break;
            }
            c2 = this._inputBuffer[this._inputPtr++];
        }
        if (!(n4 != 0 || c2 == '.' && this.isEnabled(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature()))) {
            return this._handleInvalidNumberStart(c2, bl2);
        }
        int n5 = -1;
        if (c2 == '.') {
            n5 = 0;
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            cArray[n3++] = c2;
            while (true) {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    bl3 = true;
                    break;
                }
                if ((c2 = this._inputBuffer[this._inputPtr++]) < '0' || c2 > '9') break;
                ++n5;
                if (n3 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n3 = 0;
                }
                cArray[n3++] = c2;
            }
            if (n5 == 0 && !this.isEnabled(JsonReadFeature.ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
                this._reportUnexpectedNumberChar(c2, "Decimal point not followed by a digit");
            }
        }
        int n6 = -1;
        if ((c2 | 0x20) == 101) {
            char c3;
            n6 = 0;
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            cArray[n3++] = c2;
            c2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("expected a digit for number exponent", JsonToken.VALUE_NUMBER_FLOAT);
            if (c2 == '-' || c2 == '+') {
                if (n3 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n3 = 0;
                }
                cArray[n3++] = c2;
                c3 = c2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("expected a digit for number exponent", JsonToken.VALUE_NUMBER_FLOAT);
            }
            while (c2 <= '9' && c2 >= '0') {
                ++n6;
                if (n3 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n3 = 0;
                }
                cArray[n3++] = c2;
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    bl3 = true;
                    break;
                }
                c3 = this._inputBuffer[this._inputPtr++];
            }
            if (n6 == 0) {
                this._reportUnexpectedNumberChar(c2, "Exponent indicator not followed by a digit");
            }
        }
        if (!bl3) {
            --this._inputPtr;
            if (this._parsingContext.inRoot()) {
                this.b(c2);
            }
        }
        this._textBuffer.setCurrentLength(n3);
        if (n5 < 0 && n6 < 0) {
            return this.resetInt(bl2, n4);
        }
        return this.resetFloat(bl2, n4, n5, n6);
    }

    private final char b() {
        char c2;
        if (this._inputPtr < this._inputEnd && ((c2 = this._inputBuffer[this._inputPtr]) < '0' || c2 > '9')) {
            return '0';
        }
        return this.c();
    }

    private char c() {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return '0';
        }
        char c2 = this._inputBuffer[this._inputPtr];
        if (c2 < '0' || c2 > '9') {
            return '0';
        }
        if ((this._features & FEAT_MASK_LEADING_ZEROS) == 0) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        ++this._inputPtr;
        if (c2 == '0') {
            while (this._inputPtr < this._inputEnd || this._loadMore()) {
                c2 = this._inputBuffer[this._inputPtr];
                if (c2 < '0' || c2 > '9') {
                    return '0';
                }
                ++this._inputPtr;
                if (c2 == '0') continue;
            }
        }
        return c2;
    }

    protected JsonToken _handleInvalidNumberStart(int n2, boolean bl2) {
        return this._handleInvalidNumberStart(n2, bl2, false);
    }

    protected JsonToken _handleInvalidNumberStart(int n2, boolean bl2, boolean bl3) {
        String string;
        if (n2 == 73) {
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOFInValue(JsonToken.VALUE_NUMBER_INT);
            }
            if ((n2 = this._inputBuffer[this._inputPtr++]) == 78) {
                string = bl2 ? "-INF" : "+INF";
                this._matchToken(string, 3);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN(string, bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + string + "': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
            } else if (n2 == 110) {
                string = bl2 ? "-Infinity" : "+Infinity";
                this._matchToken(string, 3);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN(string, bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + string + "': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
            }
        }
        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature()) && bl3 && !bl2) {
            this._reportUnexpectedNumberChar(43, "JSON spec does not allow numbers to have plus signs: enable `JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS` to allow");
        }
        string = bl2 ? "expected digit (0-9) to follow minus sign, for valid numeric value" : "expected digit (0-9) for valid numeric value";
        this._reportUnexpectedNumberChar(n2, string);
        return null;
    }

    private final void b(int n2) {
        ++this._inputPtr;
        switch (n2) {
            case 9: 
            case 32: {
                return;
            }
            case 13: {
                --this._inputPtr;
                return;
            }
            case 10: {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                return;
            }
        }
        this._reportMissingRootWS(n2);
    }

    protected final String _parseName() {
        int n2;
        int n3;
        int n4 = this._hashSeed;
        int[] nArray = INPUT_CODES_LATIN1;
        for (n3 = this._inputPtr; n3 < this._inputEnd; ++n3) {
            n2 = this._inputBuffer[n3];
            if (n2 < nArray.length && nArray[n2] != 0) {
                if (n2 != 34) break;
                int n5 = this._inputPtr;
                this._inputPtr = n3 + 1;
                return this._symbols.findSymbol(this._inputBuffer, n5, n3 - n5, n4);
            }
            n4 = n4 * 33 + n2;
        }
        n2 = this._inputPtr;
        this._inputPtr = n3;
        return this.a(n2, n4, 34);
    }

    private String a(int n2, int n3, int n4) {
        this._textBuffer.resetWithShared(this._inputBuffer, n2, this._inputPtr - n2);
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n5 = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
            }
            char c3 = c2 = this._inputBuffer[this._inputPtr++];
            if (c2 <= '\\') {
                if (c3 == '\\') {
                    c2 = this._decodeEscaped();
                } else if (c3 <= n4) {
                    if (c3 == n4) break;
                    if (c3 < ' ') {
                        this._throwUnquotedSpace(c3, "name");
                    }
                }
            }
            n3 = n3 * 33 + c2;
            cArray[n5++] = c2;
            if (n5 < cArray.length) continue;
            cArray = this._textBuffer.finishCurrentSegment();
            n5 = 0;
        }
        this._textBuffer.setCurrentLength(n5);
        TextBuffer textBuffer = this._textBuffer;
        char[] cArray2 = textBuffer.getTextBuffer();
        int n6 = textBuffer.getTextOffset();
        return this._symbols.findSymbol(cArray2, n6, textBuffer.size(), n3);
    }

    protected String _handleOddName(int n2) {
        int n3;
        int[] nArray;
        int n4;
        int n5;
        if (n2 == 39 && (this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) != 0) {
            return this._parseAposName();
        }
        if ((this._features & FEAT_MASK_ALLOW_UNQUOTED_NAMES) == 0) {
            this._reportUnexpectedChar(n2, "was expecting double-quote to start field name");
        }
        if ((n5 = n2 < (n4 = (nArray = CharTypes.getInputCodeLatin1JsNames()).length) ? (nArray[n2] == 0 ? 1 : 0) : Character.isJavaIdentifierPart((char)n2)) == 0) {
            this._reportUnexpectedChar(n2, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        n2 = this._inputPtr;
        n5 = this._hashSeed;
        int n6 = this._inputEnd;
        if (n2 < n6) {
            do {
                if ((n3 = this._inputBuffer[n2]) < n4) {
                    if (nArray[n3] != 0) {
                        int n7 = this._inputPtr - 1;
                        this._inputPtr = n2;
                        return this._symbols.findSymbol(this._inputBuffer, n7, n2 - n7, n5);
                    }
                } else if (!Character.isJavaIdentifierPart((char)n3)) {
                    int n8 = this._inputPtr - 1;
                    this._inputPtr = n2;
                    return this._symbols.findSymbol(this._inputBuffer, n8, n2 - n8, n5);
                }
                n5 = n5 * 33 + n3;
            } while (++n2 < n6);
        }
        n3 = this._inputPtr - 1;
        this._inputPtr = n2;
        int[] nArray2 = nArray;
        n4 = n5;
        int n9 = n3;
        ReaderBasedJsonParser readerBasedJsonParser = this;
        readerBasedJsonParser._textBuffer.resetWithShared(readerBasedJsonParser._inputBuffer, n9, readerBasedJsonParser._inputPtr - n9);
        char[] cArray = readerBasedJsonParser._textBuffer.getCurrentSegment();
        n6 = readerBasedJsonParser._textBuffer.getCurrentSegmentSize();
        n3 = nArray2.length;
        while (readerBasedJsonParser._inputPtr < readerBasedJsonParser._inputEnd || readerBasedJsonParser._loadMore()) {
            char c2;
            char c3 = c2 = readerBasedJsonParser._inputBuffer[readerBasedJsonParser._inputPtr];
            if (c2 >= n3 ? !Character.isJavaIdentifierPart(c2) : nArray2[c3] != 0) break;
            ++readerBasedJsonParser._inputPtr;
            n4 = n4 * 33 + c3;
            cArray[n6++] = c2;
            if (n6 < cArray.length) continue;
            cArray = readerBasedJsonParser._textBuffer.finishCurrentSegment();
            n6 = 0;
        }
        readerBasedJsonParser._textBuffer.setCurrentLength(n6);
        TextBuffer textBuffer = readerBasedJsonParser._textBuffer;
        char[] cArray2 = textBuffer.getTextBuffer();
        int n10 = textBuffer.getTextOffset();
        return readerBasedJsonParser._symbols.findSymbol(cArray2, n10, textBuffer.size(), n4);
    }

    protected String _parseAposName() {
        int n2 = this._inputPtr;
        int n3 = this._hashSeed;
        int n4 = this._inputEnd;
        if (n2 < n4) {
            int[] nArray = INPUT_CODES_LATIN1;
            int n5 = INPUT_CODES_LATIN1.length;
            do {
                char c2;
                if ((c2 = this._inputBuffer[n2]) == '\'') {
                    n4 = this._inputPtr;
                    this._inputPtr = n2 + 1;
                    return this._symbols.findSymbol(this._inputBuffer, n4, n2 - n4, n3);
                }
                if (c2 < n5 && nArray[c2] != 0) break;
                n3 = n3 * 33 + c2;
            } while (++n2 < n4);
        }
        int n6 = this._inputPtr;
        this._inputPtr = n2;
        return this.a(n6, n3, 39);
    }

    protected JsonToken _handleOddValue(int n2) {
        switch (n2) {
            case 39: {
                if ((this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) == 0) break;
                return this._handleApos();
            }
            case 93: {
                if (!this._parsingContext.inArray()) break;
            }
            case 44: {
                if (this._parsingContext.inRoot() || (this._features & FEAT_MASK_ALLOW_MISSING) == 0) break;
                --this._inputPtr;
                return JsonToken.VALUE_NULL;
            }
            case 78: {
                this._matchToken("NaN", 1);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN("NaN", Double.NaN);
                }
                this._reportError("Non-standard token 'NaN': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
                break;
            }
            case 73: {
                this._matchToken("Infinity", 1);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN("Infinity", Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token 'Infinity': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
                break;
            }
            case 43: {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    this._reportInvalidEOFInValue(JsonToken.VALUE_NUMBER_INT);
                }
                ReaderBasedJsonParser readerBasedJsonParser = this;
                return readerBasedJsonParser._handleInvalidNumberStart(readerBasedJsonParser._inputBuffer[this._inputPtr++], false, true);
            }
        }
        if (Character.isJavaIdentifierStart(n2)) {
            this._reportInvalidToken("" + (char)n2, this._validJsonTokenList());
        }
        this._reportUnexpectedChar(n2, "expected a valid value " + this._validJsonValueList());
        return null;
    }

    protected JsonToken _handleApos() {
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value", JsonToken.VALUE_STRING);
            }
            char c3 = c2 = this._inputBuffer[this._inputPtr++];
            if (c2 <= '\\') {
                if (c3 == '\\') {
                    c2 = this._decodeEscaped();
                } else if (c3 <= '\'') {
                    if (c3 == '\'') break;
                    if (c3 < ' ') {
                        this._throwUnquotedSpace(c3, "string value");
                    }
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = c2;
        }
        this._textBuffer.setCurrentLength(n2);
        return JsonToken.VALUE_STRING;
    }

    @Override
    protected final void _finishString() {
        int n2 = this._inputPtr;
        int n3 = this._inputEnd;
        if (n2 < n3) {
            int[] nArray = INPUT_CODES_LATIN1;
            int n4 = INPUT_CODES_LATIN1.length;
            do {
                char c2;
                if ((c2 = this._inputBuffer[n2]) >= n4 || nArray[c2] == 0) continue;
                if (c2 != '\"') break;
                this._textBuffer.resetWithShared(this._inputBuffer, this._inputPtr, n2 - this._inputPtr);
                this._inputPtr = n2 + 1;
                return;
            } while (++n2 < n3);
        }
        this._textBuffer.resetWithCopy(this._inputBuffer, this._inputPtr, n2 - this._inputPtr);
        this._inputPtr = n2;
        this._finishString2();
    }

    protected void _finishString2() {
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n2 = this._textBuffer.getCurrentSegmentSize();
        int[] nArray = INPUT_CODES_LATIN1;
        int n3 = INPUT_CODES_LATIN1.length;
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value", JsonToken.VALUE_STRING);
            }
            char c3 = c2 = this._inputBuffer[this._inputPtr++];
            if (c2 < n3 && nArray[c3] != 0) {
                if (c3 == '\"') break;
                if (c3 == '\\') {
                    c2 = this._decodeEscaped();
                } else if (c3 < ' ') {
                    this._throwUnquotedSpace(c3, "string value");
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = c2;
        }
        this._textBuffer.setCurrentLength(n2);
    }

    protected final void _skipString() {
        this._tokenIncomplete = false;
        int n2 = this._inputPtr;
        int n3 = this._inputEnd;
        char[] cArray = this._inputBuffer;
        while (true) {
            if (n2 >= n3) {
                this._inputPtr = n2;
                if (!this._loadMore()) {
                    this._reportInvalidEOF(": was expecting closing quote for a string value", JsonToken.VALUE_STRING);
                }
                n2 = this._inputPtr;
                n3 = this._inputEnd;
            }
            char c2 = cArray[n2++];
            char c3 = c2;
            c3 = c2;
            if (c2 > '\\') continue;
            if (c3 == '\\') {
                this._inputPtr = n2;
                this._decodeEscaped();
                n2 = this._inputPtr;
                n3 = this._inputEnd;
                continue;
            }
            if (c3 > '\"') continue;
            if (c3 == '\"') {
                this._inputPtr = n2;
                return;
            }
            if (c3 >= ' ') continue;
            this._inputPtr = n2;
            this._throwUnquotedSpace(c3, "string value");
        }
    }

    protected final void _skipCR() {
        if ((this._inputPtr < this._inputEnd || this._loadMore()) && this._inputBuffer[this._inputPtr] == '\n') {
            ++this._inputPtr;
        }
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    private final int d() {
        if (this._inputPtr + 4 >= this._inputEnd) {
            return this.b(false);
        }
        char c2 = this._inputBuffer[this._inputPtr];
        if (c2 == ':') {
            if ((c2 = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (c2 == '/' || c2 == '#') {
                    return this.b(true);
                }
                ++this._inputPtr;
                return c2;
            }
            if ((c2 == ' ' || c2 == '\t') && (c2 = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (c2 == '/' || c2 == '#') {
                    return this.b(true);
                }
                ++this._inputPtr;
                return c2;
            }
            return this.b(true);
        }
        if (c2 == ' ' || c2 == '\t') {
            c2 = this._inputBuffer[++this._inputPtr];
        }
        if (c2 == ':') {
            if ((c2 = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (c2 == '/' || c2 == '#') {
                    return this.b(true);
                }
                ++this._inputPtr;
                return c2;
            }
            if ((c2 == ' ' || c2 == '\t') && (c2 = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (c2 == '/' || c2 == '#') {
                    return this.b(true);
                }
                ++this._inputPtr;
                return c2;
            }
            return this.b(true);
        }
        return this.b(false);
    }

    private final int b(boolean bl2) {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c2 == '/') {
                    this.h();
                    continue;
                }
                if (c2 == '#' && this.j()) continue;
                if (bl2) {
                    return c2;
                }
                if (c2 != ':') {
                    this._reportUnexpectedChar(c2, "was expecting a colon to separate field name and value");
                }
                bl2 = true;
                continue;
            }
            if (c2 >= ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        this._reportInvalidEOF(" within/between " + this._parsingContext.typeDesc() + " entries", null);
        return -1;
    }

    private final int c(int n2) {
        if (n2 != 44) {
            this._reportUnexpectedChar(n2, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
        }
        while (this._inputPtr < this._inputEnd) {
            if ((n2 = this._inputBuffer[this._inputPtr++]) > 32) {
                if (n2 == 47 || n2 == 35) {
                    --this._inputPtr;
                    return this.e();
                }
                return n2;
            }
            if (n2 >= 32) continue;
            if (n2 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n2 == 13) {
                this._skipCR();
                continue;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        return this.e();
    }

    private final int e() {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c2 == '/') {
                    this.h();
                    continue;
                }
                if (c2 == '#' && this.j()) continue;
                return c2;
            }
            if (c2 >= ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.typeDesc() + " entries");
    }

    private final int f() {
        char c2;
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return this._eofAsNextChar();
        }
        if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
            if (c2 == '/' || c2 == '#') {
                --this._inputPtr;
                return this.g();
            }
            return c2;
        }
        if (c2 != ' ') {
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
            } else if (c2 == '\r') {
                this._skipCR();
            } else if (c2 != '\t') {
                this._throwInvalidSpace(c2);
            }
        }
        while (this._inputPtr < this._inputEnd) {
            if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c2 == '/' || c2 == '#') {
                    --this._inputPtr;
                    return this.g();
                }
                return c2;
            }
            if (c2 == ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        return this.g();
    }

    private int g() {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c2 == '/') {
                    this.h();
                    continue;
                }
                if (c2 == '#' && this.j()) continue;
                return c2;
            }
            if (c2 == ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        return this._eofAsNextChar();
    }

    private void h() {
        char c2;
        if ((this._features & FEAT_MASK_ALLOW_JAVA_COMMENTS) == 0) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(" in a comment", null);
        }
        if ((c2 = this._inputBuffer[this._inputPtr++]) == '/') {
            this.k();
            return;
        }
        if (c2 == '*') {
            this.i();
            return;
        }
        this._reportUnexpectedChar(c2, "was expecting either '*' or '/' for a comment");
    }

    private void i() {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) > '*') continue;
            if (c2 == '*') {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) break;
                if (this._inputBuffer[this._inputPtr] != '/') continue;
                ++this._inputPtr;
                return;
            }
            if (c2 >= ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        this._reportInvalidEOF(" in a comment", null);
    }

    private boolean j() {
        if ((this._features & FEAT_MASK_ALLOW_YAML_COMMENTS) == 0) {
            return false;
        }
        this.k();
        return true;
    }

    private void k() {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) >= ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                return;
            }
            if (c2 == '\r') {
                this._skipCR();
                return;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
    }

    @Override
    protected char _decodeEscaped() {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(" in character escape sequence", JsonToken.VALUE_STRING);
        }
        int n2 = this._inputBuffer[this._inputPtr++];
        switch (n2) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)n2;
            }
            case 117: {
                break;
            }
            default: {
                return this._handleUnrecognizedCharacterEscape((char)n2);
            }
        }
        n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            char c2;
            int n3;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in character escape sequence", JsonToken.VALUE_STRING);
            }
            if ((n3 = CharTypes.charToHex(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                this._reportUnexpectedChar(c2, "expected a hex-digit for character escape sequence");
            }
            n2 = n2 << 4 | n3;
        }
        return (char)n2;
    }

    private final void l() {
        int n2 = this._inputPtr;
        if (n2 + 3 < this._inputEnd) {
            char c2;
            char[] cArray = this._inputBuffer;
            if (this._inputBuffer[n2] == 'r' && cArray[++n2] == 'u' && cArray[++n2] == 'e' && ((c2 = cArray[++n2]) < '0' || c2 == ']' || c2 == '}')) {
                this._inputPtr = n2;
                return;
            }
        }
        this._matchToken("true", 1);
    }

    private final void m() {
        int n2 = this._inputPtr;
        if (n2 + 4 < this._inputEnd) {
            char c2;
            char[] cArray = this._inputBuffer;
            if (this._inputBuffer[n2] == 'a' && cArray[++n2] == 'l' && cArray[++n2] == 's' && cArray[++n2] == 'e' && ((c2 = cArray[++n2]) < '0' || c2 == ']' || c2 == '}')) {
                this._inputPtr = n2;
                return;
            }
        }
        this._matchToken("false", 1);
    }

    private final void n() {
        int n2 = this._inputPtr;
        if (n2 + 3 < this._inputEnd) {
            char c2;
            char[] cArray = this._inputBuffer;
            if (this._inputBuffer[n2] == 'u' && cArray[++n2] == 'l' && cArray[++n2] == 'l' && ((c2 = cArray[++n2]) < '0' || c2 == ']' || c2 == '}')) {
                this._inputPtr = n2;
                return;
            }
        }
        this._matchToken("null", 1);
    }

    protected final void _matchToken(String object, int n2) {
        int n3 = ((String)object).length();
        if (this._inputPtr + n3 >= this._inputEnd) {
            n3 = n2;
            String string = object;
            object = this;
            int n4 = string.length();
            do {
                if (((ParserBase)object)._inputPtr >= ((ParserBase)object)._inputEnd && !((ReaderBasedJsonParser)object)._loadMore() || ((ReaderBasedJsonParser)object)._inputBuffer[((ParserBase)object)._inputPtr] != string.charAt(n3)) {
                    ((ReaderBasedJsonParser)object)._reportInvalidToken(string.substring(0, n3));
                }
                ++((ParserBase)object)._inputPtr;
            } while (++n3 < n4);
            if ((((ParserBase)object)._inputPtr < ((ParserBase)object)._inputEnd || ((ReaderBasedJsonParser)object)._loadMore()) && (n4 = ((ReaderBasedJsonParser)object)._inputBuffer[((ParserBase)object)._inputPtr]) >= 48 && n4 != 93 && n4 != 125) {
                super.a(string, n3, n4);
            }
            return;
        }
        do {
            if (this._inputBuffer[this._inputPtr] != ((String)object).charAt(n2)) {
                this._reportInvalidToken(((String)object).substring(0, n2));
            }
            ++this._inputPtr;
        } while (++n2 < n3);
        n3 = this._inputBuffer[this._inputPtr];
        if (n3 >= 48 && n3 != 93 && n3 != 125) {
            this.a((String)object, n2, n3);
        }
    }

    private final void a(String string, int n2, int n3) {
        char c2 = (char)n3;
        n3 = c2;
        if (Character.isJavaIdentifierPart(c2)) {
            this._reportInvalidToken(string.substring(0, n2));
        }
    }

    protected byte[] _decodeBase64(Base64Variant base64Variant) {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) <= ' ') continue;
            int n2 = base64Variant.decodeBase64Char(c2);
            if (n2 < 0) {
                if (c2 == '\"') {
                    return byteArrayBuilder.toByteArray();
                }
                n2 = this._decodeBase64Escape(base64Variant, c2, 0);
                if (n2 < 0) continue;
            }
            int n3 = n2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                n2 = this._decodeBase64Escape(base64Variant, c2, 1);
            }
            n3 = n3 << 6 | n2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n2 != -2) {
                    if (c2 == '\"') {
                        byteArrayBuilder.append(n3 >>= 4);
                        if (base64Variant.requiresPaddingOnRead()) {
                            --this._inputPtr;
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        return byteArrayBuilder.toByteArray();
                    }
                    n2 = this._decodeBase64Escape(base64Variant, c2, 2);
                }
                if (n2 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(c2 = this._inputBuffer[this._inputPtr++]) && this._decodeBase64Escape(base64Variant, c2, 3) != -2) {
                        throw this.reportInvalidBase64Char(base64Variant, c2, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n3 >>= 4);
                    continue;
                }
            }
            n3 = n3 << 6 | n2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n2 != -2) {
                    if (c2 == '\"') {
                        byteArrayBuilder.appendTwoBytes(n3 >>= 2);
                        if (base64Variant.requiresPaddingOnRead()) {
                            --this._inputPtr;
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        return byteArrayBuilder.toByteArray();
                    }
                    n2 = this._decodeBase64Escape(base64Variant, c2, 3);
                }
                if (n2 == -2) {
                    byteArrayBuilder.appendTwoBytes(n3 >>= 2);
                    continue;
                }
            }
            n3 = n3 << 6 | n2;
            byteArrayBuilder.appendThreeBytes(n3);
        }
    }

    @Override
    public JsonLocation currentLocation() {
        int n2 = this._inputPtr - this._currInputRowStart + 1;
        return new JsonLocation(this._contentReference(), -1L, this._currInputProcessed + (long)this._inputPtr, this._currInputRow, n2);
    }

    @Override
    protected JsonLocation _currentLocationMinusOne() {
        int n2 = this._inputPtr - 1;
        int n3 = n2 - this._currInputRowStart + 1;
        return new JsonLocation(this._contentReference(), -1L, this._currInputProcessed + (long)n2, this._currInputRow, n3);
    }

    @Override
    public JsonLocation currentTokenLocation() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            long l2 = this._currInputProcessed + (this._nameStartOffset - 1L);
            return new JsonLocation(this._contentReference(), -1L, l2, this._nameStartRow, this._nameStartCol);
        }
        return new JsonLocation(this._contentReference(), -1L, this._tokenInputTotal - 1L, this._tokenInputRow, this._tokenInputCol);
    }

    private final void o() {
        int n2 = this._inputPtr;
        this._tokenInputTotal = this._currInputProcessed + (long)n2;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = n2 - this._currInputRowStart;
    }

    private final void p() {
        int n2 = this._inputPtr;
        this._nameStartOffset = n2;
        this._nameStartRow = this._currInputRow;
        this._nameStartCol = n2 - this._currInputRowStart;
    }

    protected void _reportInvalidToken(String string) {
        this._reportInvalidToken(string, this._validJsonTokenList());
    }

    protected void _reportInvalidToken(String charSequence, String string) {
        char c2;
        charSequence = new StringBuilder((String)charSequence);
        while ((this._inputPtr < this._inputEnd || this._loadMore()) && Character.isJavaIdentifierPart(c2 = this._inputBuffer[this._inputPtr])) {
            ++this._inputPtr;
            ((StringBuilder)charSequence).append(c2);
            if (((StringBuilder)charSequence).length() < this._ioContext.errorReportConfiguration().getMaxErrorTokenLength()) continue;
            ((StringBuilder)charSequence).append("...");
            break;
        }
        this._reportError("Unrecognized token '%s': was expecting %s", charSequence, string);
    }

    private void d(int n2) {
        if (n2 == 93) {
            this.o();
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n2, '}');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_ARRAY;
        }
        if (n2 == 125) {
            this.o();
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n2, ']');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_OBJECT;
        }
    }
}

